/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.avro;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.server.avro.NodeEntryRecord;
import org.apache.slider.server.avro.RoleHistoryHeader;

public class LoadedRoleHistory {
    private RoleHistoryHeader header;
    private Path path;
    public final Map<String, Integer> roleMap = new HashMap<String, Integer>();
    public final List<NodeEntryRecord> records = new ArrayList<NodeEntryRecord>();

    public void add(NodeEntryRecord record) {
        this.records.add(record);
    }

    public int size() {
        return this.records.size();
    }

    public RoleHistoryHeader getHeader() {
        return this.header;
    }

    public void setHeader(RoleHistoryHeader header) {
        this.header = header;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public void buildMapping(Map<CharSequence, Integer> source) {
        this.roleMap.clear();
        for (Map.Entry<CharSequence, Integer> entry : source.entrySet()) {
            this.roleMap.put(SliderUtils.sequenceToString(entry.getKey()), entry.getValue());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LoadedRoleHistory{");
        sb.append("path=").append(this.path);
        sb.append("; number of roles=").append(this.roleMap.size());
        sb.append("; size=").append(this.size());
        sb.append('}');
        return sb.toString();
    }
}

