/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.web.rest.agent;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.slider.server.appmaster.web.WebAppApi;
import org.apache.slider.server.appmaster.web.rest.AbstractSliderResource;
import org.apache.slider.server.appmaster.web.rest.agent.AgentRestOperations;
import org.apache.slider.server.appmaster.web.rest.agent.HeartBeat;
import org.apache.slider.server.appmaster.web.rest.agent.HeartBeatResponse;
import org.apache.slider.server.appmaster.web.rest.agent.Register;
import org.apache.slider.server.appmaster.web.rest.agent.RegistrationResponse;
import org.apache.slider.server.services.security.SignCertResponse;
import org.apache.slider.server.services.security.SignMessage;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class AgentResource
extends AbstractSliderResource {
    private String agent_name;

    public AgentResource(WebAppApi slider) {
        super(slider);
    }

    private void init(HttpServletResponse res) {
        res.setContentType(null);
    }

    @GET
    @Path(value="/agent/register")
    public Response endpointAgentRegister() {
        Response response = Response.status((int)200).entity((Object)"/agent/register").build();
        return response;
    }

    @GET
    @Path(value="/agent")
    public Response endpointAgent() {
        Response response = Response.status((int)200).entity((Object)"/agent").build();
        return response;
    }

    @GET
    @Path(value="/")
    public Response endpointRoot() {
        Response response = Response.status((int)200).entity((Object)"/").build();
        return response;
    }

    @POST
    @Path(value="/{agent_name: [a-zA-Z][a-zA-Z0-9_-]*}/register")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public RegistrationResponse register(Register registration, @Context HttpServletResponse res, @PathParam(value="agent_name") String agent_name) {
        this.init(res);
        this.agent_name = agent_name;
        AgentRestOperations ops = this.slider.getAgentRestOperations();
        return ops.handleRegistration(registration);
    }

    @POST
    @Path(value="/{agent_name: [a-zA-Z][a-zA-Z0-9_-]*}/heartbeat")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public HeartBeatResponse heartbeat(HeartBeat message, @Context HttpServletResponse res, @PathParam(value="agent_name") String agent_name) {
        this.init(res);
        AgentRestOperations ops = this.slider.getAgentRestOperations();
        return ops.handleHeartBeat(message);
    }

    @GET
    @Path(value="/cert/ca")
    @Produces(value={"text/plain"})
    public String downloadSrvrCrt() {
        return this.slider.getCertificateManager().getServerCert();
    }

    @Path(value="/certs/{hostName}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "application/xml"})
    public SignCertResponse signAgentCrt(@PathParam(value="hostName") String hostname, SignMessage message, @Context HttpServletRequest req) {
        return this.slider.getCertificateManager().signAgentCrt(hostname, message.getCsr(), message.getPassphrase());
    }
}

