/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster.operations;

import java.util.Collection;
import java.util.List;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.slider.server.appmaster.operations.RMOperationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncRMOperationHandler
extends RMOperationHandler {
    protected static final Logger log = LoggerFactory.getLogger(AsyncRMOperationHandler.class);
    private final AMRMClientAsync client;
    private final Resource maxResources;

    public AsyncRMOperationHandler(AMRMClientAsync client, Resource maxResources) {
        this.client = client;
        this.maxResources = maxResources;
    }

    @Override
    public int cancelContainerRequests(Priority priority1, Priority priority2, int count) {
        int remaining = this.cancelSinglePriorityRequests(priority1, count);
        if (priority2 != null) {
            remaining = this.cancelSinglePriorityRequests(priority2, remaining);
        }
        return remaining;
    }

    protected int cancelSinglePriorityRequests(Priority priority, int count) {
        List requestSets = this.client.getMatchingRequests(priority, "", this.maxResources);
        if (count <= 0) {
            return 0;
        }
        int remaining = count;
        block0: for (Collection requestSet : requestSets) {
            if (remaining == 0) break;
            for (AMRMClient.ContainerRequest request : requestSet) {
                if (remaining == 0) continue block0;
                this.cancelSingleRequest(request);
                --remaining;
            }
        }
        return remaining;
    }

    @Override
    public void cancelSingleRequest(AMRMClient.ContainerRequest request) {
        this.client.removeContainerRequest(request);
    }

    @Override
    public void releaseAssignedContainer(ContainerId containerId) {
        log.debug("Releasing container {}", (Object)containerId);
        this.client.releaseAssignedContainer(containerId);
    }

    @Override
    public void addContainerRequest(AMRMClient.ContainerRequest req) {
        this.client.addContainerRequest(req);
    }

    @Override
    public void updateBlacklist(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        this.client.updateBlacklist(blacklistAdditions, blacklistRemovals);
    }
}

