/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.server.appmaster;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.common.base.Preconditions;
import com.google.protobuf.BlockingService;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.registry.client.api.RegistryOperations;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.registry.server.integration.RMRegistryOperationsService;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.NMClientAsyncImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.InvalidApplicationMasterRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.security.client.ClientToAMTokenSecretManager;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.slider.api.ClusterDescription;
import org.apache.slider.api.RoleKeys;
import org.apache.slider.api.SliderExitReason;
import org.apache.slider.api.proto.SliderClusterAPI;
import org.apache.slider.api.types.ApplicationDiagnostics;
import org.apache.slider.client.SliderYarnClientImpl;
import org.apache.slider.common.SliderExitCodes;
import org.apache.slider.common.SliderKeys;
import org.apache.slider.common.params.AbstractActionArgs;
import org.apache.slider.common.params.SliderAMArgs;
import org.apache.slider.common.params.SliderAMCreateAction;
import org.apache.slider.common.tools.ConfigHelper;
import org.apache.slider.common.tools.MapRSecurityUtil;
import org.apache.slider.common.tools.PortScanner;
import org.apache.slider.common.tools.SliderFileSystem;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.common.tools.SliderVersionInfo;
import org.apache.slider.core.build.InstanceIO;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.ConfTree;
import org.apache.slider.core.conf.ConfTreeOperations;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.exceptions.SliderInternalStateException;
import org.apache.slider.core.exceptions.TriggerClusterTeardownException;
import org.apache.slider.core.launch.CredentialUtils;
import org.apache.slider.core.main.ExitCodeProvider;
import org.apache.slider.core.main.RunService;
import org.apache.slider.core.main.ServiceLauncher;
import org.apache.slider.providers.ProviderCompleted;
import org.apache.slider.providers.ProviderRole;
import org.apache.slider.providers.ProviderService;
import org.apache.slider.providers.SliderProviderFactory;
import org.apache.slider.providers.agent.AgentProviderService;
import org.apache.slider.providers.slideram.SliderAMClientProvider;
import org.apache.slider.providers.slideram.SliderAMProviderService;
import org.apache.slider.server.appmaster.AppMasterActionOperations;
import org.apache.slider.server.appmaster.ProtobufClusterServices;
import org.apache.slider.server.appmaster.RoleLaunchService;
import org.apache.slider.server.appmaster.actions.ActionHalt;
import org.apache.slider.server.appmaster.actions.ActionRegisterServiceInstance;
import org.apache.slider.server.appmaster.actions.ActionStopSlider;
import org.apache.slider.server.appmaster.actions.ActionUpgradeContainers;
import org.apache.slider.server.appmaster.actions.AsyncAction;
import org.apache.slider.server.appmaster.actions.EscalateOutstandingRequests;
import org.apache.slider.server.appmaster.actions.QueueExecutor;
import org.apache.slider.server.appmaster.actions.QueueService;
import org.apache.slider.server.appmaster.actions.RegisterComponentInstance;
import org.apache.slider.server.appmaster.actions.RenewingAction;
import org.apache.slider.server.appmaster.actions.ResetFailureWindow;
import org.apache.slider.server.appmaster.actions.ReviewAndFlexApplicationSize;
import org.apache.slider.server.appmaster.actions.UnregisterComponentInstance;
import org.apache.slider.server.appmaster.management.MetricsAndMonitoring;
import org.apache.slider.server.appmaster.management.YarnServiceHealthCheck;
import org.apache.slider.server.appmaster.monkey.ChaosKillAM;
import org.apache.slider.server.appmaster.monkey.ChaosKillContainer;
import org.apache.slider.server.appmaster.monkey.ChaosMonkeyService;
import org.apache.slider.server.appmaster.operations.AbstractRMOperation;
import org.apache.slider.server.appmaster.operations.AsyncRMOperationHandler;
import org.apache.slider.server.appmaster.operations.ProviderNotifyingOperationHandler;
import org.apache.slider.server.appmaster.operations.RMOperationHandler;
import org.apache.slider.server.appmaster.rpc.RpcBinder;
import org.apache.slider.server.appmaster.rpc.SliderAMPolicyProvider;
import org.apache.slider.server.appmaster.rpc.SliderClusterProtocolPBImpl;
import org.apache.slider.server.appmaster.rpc.SliderIPCService;
import org.apache.slider.server.appmaster.security.SecurityConfiguration;
import org.apache.slider.server.appmaster.state.AppState;
import org.apache.slider.server.appmaster.state.AppStateBindingInfo;
import org.apache.slider.server.appmaster.state.ContainerAssignment;
import org.apache.slider.server.appmaster.state.ProviderAppState;
import org.apache.slider.server.appmaster.state.RMClientAccessForAppState;
import org.apache.slider.server.appmaster.state.RoleInstance;
import org.apache.slider.server.appmaster.web.AgentService;
import org.apache.slider.server.appmaster.web.SliderAMWebApp;
import org.apache.slider.server.appmaster.web.WebAppApi;
import org.apache.slider.server.appmaster.web.WebAppApiImpl;
import org.apache.slider.server.appmaster.web.rest.agent.AgentWebApp;
import org.apache.slider.server.appmaster.web.rest.application.ApplicationResouceContentCacheFactory;
import org.apache.slider.server.appmaster.web.rest.application.resources.ContentCache;
import org.apache.slider.server.services.security.CertificateManager;
import org.apache.slider.server.services.security.SecurityUtils;
import org.apache.slider.server.services.utility.AbstractSliderLaunchedService;
import org.apache.slider.server.services.utility.WebAppService;
import org.apache.slider.server.services.workflow.ServiceThreadFactory;
import org.apache.slider.server.services.workflow.WorkflowExecutorService;
import org.apache.slider.server.services.workflow.WorkflowRpcService;
import org.apache.slider.server.services.yarnregistry.YarnRegistryViewForProviders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliderAppMaster
extends AbstractSliderLaunchedService
implements AMRMClientAsync.CallbackHandler,
NMClientAsync.CallbackHandler,
RunService,
SliderExitCodes,
SliderKeys,
ServiceStateChangeListener,
RoleKeys,
ProviderCompleted,
AppMasterActionOperations {
    protected static final Logger log;
    protected static final Logger LOG_YARN;
    public static final String SERVICE_CLASSNAME_SHORT = "SliderAppMaster";
    public static final String SERVICE_CLASSNAME = "org.apache.slider.server.appmaster.SliderAppMaster";
    public static final int HEARTBEAT_INTERVAL = 1000;
    public static final int NUM_RPC_HANDLERS = 5;
    private final MetricsAndMonitoring metricsAndMonitoring = new MetricsAndMonitoring();
    public MetricRegistry metrics;
    public static final String E_TRIGGERED_LAUNCH_FAILURE = "Chaos monkey triggered launch failure";
    private YarnRPC yarnRPC;
    private AMRMClientAsync asyncRMClient;
    private RMOperationHandler rmOperationHandler;
    private RMOperationHandler providerRMOperationHandler;
    public NMClientAsync nmClientAsync;
    private Credentials containerCredentials;
    private SliderIPCService sliderIPCService;
    private WorkflowRpcService rpcService;
    private ClientToAMTokenSecretManager secretManager;
    private String appMasterHostname = "";
    private int appMasterRpcPort = 0;
    private String appMasterTrackingUrl = "";
    private String appMasterProxiedUrl = "";
    private ApplicationAttemptId appAttemptID;
    protected Map<ApplicationAccessType, String> applicationACLs;
    private final AppState appState = new AppState(new ProtobufClusterServices(), this.metricsAndMonitoring);
    private final ProviderAppState stateForProviders = new ProviderAppState("undefined", this.appState);
    private final ReentrantLock AMExecutionStateLock = new ReentrantLock();
    private final Condition isAMCompleted = this.AMExecutionStateLock.newCondition();
    private final AtomicBoolean amCompletionFlag = new AtomicBoolean(false);
    private final AtomicBoolean initCompleted = new AtomicBoolean(false);
    private boolean spawnedProcessExitedBeforeShutdownTriggered;
    private SliderAMArgs serviceArgs;
    private ContainerId appMasterContainerID;
    private ChaosMonkeyService monkey;
    private ProviderService providerService;
    private RegistryOperations registryOperations;
    private volatile ActionStopSlider stopAction;
    private RoleLaunchService launchService;
    private String hadoop_user_name;
    private String service_user_name;
    private SliderAMWebApp webApp;
    private InetSocketAddress rpcServiceAddress;
    private SliderAMProviderService sliderAMProvider;
    private CertificateManager certificateManager;
    private WorkflowExecutorService<ExecutorService> executorService;
    private final QueueService actionQueues = new QueueService();
    private String agentOpsUrl;
    private String agentStatusUrl;
    private YarnRegistryViewForProviders yarnRegistryOperations;
    private RegisterApplicationMasterResponse amRegistrationData;
    private PortScanner portScanner;
    private SecurityConfiguration securityConfiguration;
    private boolean securityEnabled;
    private ContentCache contentCache;
    private Resource maximumResourceCapability;

    static {
        LOG_YARN = log = LoggerFactory.getLogger(SliderAppMaster.class);
    }

    public SliderAppMaster() {
        super(SERVICE_CLASSNAME_SHORT);
        new HdfsConfiguration();
        new YarnConfiguration();
    }

    public synchronized void serviceInit(Configuration conf) throws Exception {
        UserGroupInformation ugi;
        Configuration customConf = SliderUtils.loadSliderClientXML();
        URL serverXmlUrl = ConfigHelper.getResourceUrl("slider-server.xml");
        if (serverXmlUrl != null) {
            log.info("Loading {} at {}", (Object)"slider-server.xml", (Object)serverXmlUrl);
            Configuration serverConf = ConfigHelper.loadFromResource("slider-server.xml");
            ConfigHelper.mergeConfigurations(customConf, (Iterable<Map.Entry<String, String>>)serverConf, "slider-server.xml", true);
        }
        this.serviceArgs.applyDefinitions(customConf);
        this.serviceArgs.applyFileSystemBinding(customConf);
        AbstractActionArgs action = this.serviceArgs.getCoreAction();
        SliderAMCreateAction createAction = (SliderAMCreateAction)action;
        String rmAddress = createAction.getRmAddress();
        if (rmAddress != null) {
            log.debug("Setting RM address from the command line: {}", (Object)rmAddress);
            SliderUtils.setRmSchedulerAddress(customConf, rmAddress);
        }
        log.info("AM configuration:\n{}", (Object)ConfigHelper.dumpConfigToString(customConf));
        for (Map.Entry<String, String> envs : System.getenv().entrySet()) {
            log.info("System env {}={}", (Object)envs.getKey(), (Object)envs.getValue());
        }
        ConfigHelper.mergeConfigurations(conf, (Iterable<Map.Entry<String, String>>)customConf, "slider-client.xml", true);
        if (MapRSecurityUtil.isKerberosEnabled()) {
            log.info("Secure mode with kerberos realm {}", (Object)SliderUtils.getKerberosRealm());
            UserGroupInformation.setConfiguration((Configuration)conf);
            ugi = UserGroupInformation.getCurrentUser();
            log.debug("Authenticating as {}", (Object)ugi);
            SliderUtils.verifyPrincipalSet(conf, "dfs.namenode.kerberos.principal");
        } else if (MapRSecurityUtil.isMapRSecurityEnabled()) {
            UserGroupInformation.setConfiguration((Configuration)conf);
            ugi = UserGroupInformation.getCurrentUser();
            log.debug("Authenticating as {}", (Object)ugi);
        } else {
            log.info("Cluster is insecure");
        }
        log.info("Login user is {}", (Object)UserGroupInformation.getLoginUser());
        this.checkAndWarnForAuthTokenProblems();
        boolean dependencyChecks = !conf.getBoolean("slider.am.dependency.checks.disabled", false);
        SliderUtils.validateSliderServerEnvironment(log, dependencyChecks);
        this.addService((Service)this.metricsAndMonitoring);
        this.metrics = this.metricsAndMonitoring.getMetrics();
        this.contentCache = ApplicationResouceContentCacheFactory.createContentCache(this.stateForProviders);
        this.executorService = new WorkflowExecutorService<ExecutorService>("AmExecutor", Executors.newFixedThreadPool(2, new ServiceThreadFactory("AmExecutor", true)));
        this.addService((Service)this.executorService);
        this.addService((Service)this.actionQueues);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        HealthCheckRegistry health = this.metricsAndMonitoring.getHealth();
        health.register("AM Health", (HealthCheck)new YarnServiceHealthCheck(this));
    }

    private void startQueueProcessing() {
        log.info("Queue Processing started");
        this.executorService.execute(this.actionQueues);
        this.executorService.execute(new QueueExecutor(this, this.actionQueues));
    }

    @Override
    public Configuration bindArgs(Configuration config, String ... args) throws Exception {
        Configuration superConf = super.bindArgs(config, args);
        ConfigHelper.injectSliderXMLResource();
        YarnConfiguration yarnConfiguration = new YarnConfiguration(superConf);
        this.serviceArgs = new SliderAMArgs(args);
        this.serviceArgs.parse();
        return SliderUtils.patchConfiguration((Configuration)yarnConfiguration);
    }

    @Override
    public int runService() throws Throwable {
        int exitCode;
        SliderVersionInfo.loadAndPrintVersionInfo(log);
        if (log.isDebugEnabled()) {
            log.debug("System properties:\n" + SliderUtils.propertiesToString(System.getProperties()));
        }
        String action = this.serviceArgs.getAction();
        List<String> actionArgs = this.serviceArgs.getActionArgs();
        switch (action) {
            case "help": {
                log.info("{}: {}", (Object)this.getName(), (Object)this.serviceArgs.usage());
                exitCode = 4;
                break;
            }
            case "create": {
                exitCode = this.createAndRunCluster(actionArgs.get(0));
                break;
            }
            default: {
                throw new SliderException("Unimplemented: " + action);
            }
        }
        log.info("Exiting AM; final exit code = {}", (Object)exitCode);
        return exitCode;
    }

    public Service initAndAddService(Service service) {
        service.init(this.getConfig());
        this.addService(service);
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createAndRunCluster(String clustername) throws Throwable {
        HashMap<String, String> envVars;
        List liveContainers;
        String sliderClusterDir = this.serviceArgs.getSliderClusterURI();
        URI sliderClusterURI = new URI(sliderClusterDir);
        Path clusterDirPath = new Path(sliderClusterURI);
        log.info("Application defined at {}", (Object)sliderClusterURI);
        SliderFileSystem fs = this.getClusterFS();
        MapOperations appInformation = new MapOperations();
        AggregateConf instanceDefinition = InstanceIO.loadInstanceDefinitionUnresolved(fs, clusterDirPath);
        instanceDefinition.setName(clustername);
        log.info("Deploying cluster {}:", (Object)instanceDefinition);
        AggregateConf resolvedInstance = new AggregateConf(instanceDefinition);
        resolvedInstance.resolve();
        this.stateForProviders.setApplicationName(clustername);
        Configuration serviceConf = this.getConfig();
        MapOperations amConfiguration = resolvedInstance.getAppConfOperations().getComponent("slider-appmaster");
        if (amConfiguration != null) {
            Map<String, String> sliderAppConfKeys = amConfiguration.prefixedWith("slider.");
            for (Map.Entry<String, String> entry : sliderAppConfKeys.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                boolean exists = serviceConf.get(k) != null;
                log.info("{} {} to {}", new Object[]{exists ? "Overwriting" : "Setting", k, v});
                serviceConf.set(k, v);
            }
        }
        this.securityConfiguration = new SecurityConfiguration(serviceConf, resolvedInstance, clustername);
        this.securityEnabled = this.securityConfiguration.isSecurityEnabled();
        instanceDefinition.getAppConfOperations().set("site.global.security_enabled", this.securityEnabled);
        this.appState.setInitialInstanceDefinition(instanceDefinition);
        File confDir = this.getLocalConfDir();
        if (!confDir.exists() || !confDir.isDirectory()) {
            log.info("Conf dir {} does not exist.", (Object)confDir);
            File parentFile = confDir.getParentFile();
            log.info("Parent dir {}:\n{}", (Object)parentFile, (Object)SliderUtils.listDir(parentFile));
        }
        MapOperations globalInternalOptions = this.getGlobalInternalOptions();
        String providerType = globalInternalOptions.getMandatoryOption("internal.provider.name");
        log.info("Cluster provider type is {}", (Object)providerType);
        SliderProviderFactory factory = SliderProviderFactory.createSliderProviderFactory(providerType);
        this.providerService = factory.createServerProvider();
        this.initAndAddService(this.providerService);
        this.providerRMOperationHandler = new ProviderNotifyingOperationHandler(this.providerService);
        this.sliderAMProvider = new SliderAMProviderService();
        this.initAndAddService(this.sliderAMProvider);
        InetSocketAddress rmSchedulerAddress = SliderUtils.getRmSchedulerAddress(serviceConf);
        log.info("RM is at {}", (Object)rmSchedulerAddress);
        this.yarnRPC = YarnRPC.create((Configuration)serviceConf);
        InetSocketAddress clientRpcAddress = SliderUtils.getRmAddress(serviceConf);
        if (!SliderUtils.isAddressDefined(clientRpcAddress)) {
            log.warn("Yarn RM address was unbound; attempting to fix up");
            serviceConf.set("yarn.resourcemanager.address", String.format("%s:%d", rmSchedulerAddress.getHostString(), clientRpcAddress.getPort()));
        }
        this.appMasterContainerID = ConverterUtils.toContainerId((String)SliderUtils.mandatoryEnvVariable(ApplicationConstants.Environment.CONTAINER_ID.name()));
        this.appAttemptID = this.appMasterContainerID.getApplicationAttemptId();
        ApplicationId appid = this.appAttemptID.getApplicationId();
        log.info("AM for ID {}", (Object)appid.getId());
        appInformation.put("info.am.container.id", this.appMasterContainerID.toString());
        appInformation.put("info.am.app.id", appid.toString());
        appInformation.put("info.am.attempt.id", this.appAttemptID.toString());
        AppState appState = this.appState;
        synchronized (appState) {
            String debug_kerberos;
            List<NodeReport> nodeReports;
            String acls;
            int heartbeatInterval = 1000;
            this.getConfig().setLong("yarn.resourcemanager.connect.max-wait.ms", -1L);
            this.getConfig().unset("yarn.client.failover-max-attempts");
            this.asyncRMClient = AMRMClientAsync.createAMRMClientAsync((int)heartbeatInterval, (AMRMClientAsync.CallbackHandler)this);
            this.addService((Service)this.asyncRMClient);
            this.deployChildService((Service)this.asyncRMClient);
            RMClientAccessForAppState rmClientAccess = new RMClientAccessForAppState(this.asyncRMClient);
            this.appState.setRMClientAccessForAppState(rmClientAccess);
            this.nmClientAsync = new NMClientAsyncImpl("nmclient", (NMClientAsync.CallbackHandler)this);
            this.deployChildService((Service)this.nmClientAsync);
            this.secretManager = new ClientToAMTokenSecretManager(this.appAttemptID, null);
            if (this.securityEnabled && (acls = serviceConf.get("slider.security.protocol.acl")) == null) {
                this.getConfig().set("slider.security.protocol.acl", "*");
            }
            this.certificateManager = new CertificateManager();
            this.buildPortScanner(instanceDefinition);
            this.startSliderRPCServer(instanceDefinition);
            this.rpcServiceAddress = this.rpcService.getConnectAddress();
            this.appMasterHostname = this.rpcServiceAddress.getAddress().getCanonicalHostName();
            this.appMasterRpcPort = this.rpcServiceAddress.getPort();
            this.appMasterTrackingUrl = null;
            log.info("AM Server is listening at {}:{}", (Object)this.appMasterHostname, (Object)this.appMasterRpcPort);
            appInformation.put("info.am.hostname", this.appMasterHostname);
            appInformation.set("info.am.rpc.port", this.appMasterRpcPort);
            log.info("Starting Yarn registry");
            this.registryOperations = this.startRegistryOperationsService();
            log.info(this.registryOperations.toString());
            ArrayList<ProviderRole> providerRoles = new ArrayList<ProviderRole>(this.providerService.getRoles());
            providerRoles.addAll(SliderAMClientProvider.ROLES);
            MapOperations component = instanceDefinition.getAppConfOperations().getComponent("slider-appmaster");
            this.certificateManager.initialize(component, this.appMasterHostname, this.appMasterContainerID.toString(), clustername);
            this.certificateManager.setPassphrase(instanceDefinition.getPassphrase());
            if (component.getOptionBool("ssl.server.client.auth", false).booleanValue()) {
                this.uploadServerCertForLocalization(clustername, fs);
            }
            WebAppApiImpl webAppApi = new WebAppApiImpl(this.stateForProviders, this.providerService, this.certificateManager, this.registryOperations, this.metricsAndMonitoring, this.actionQueues, this, this.contentCache);
            this.initAMFilterOptions(serviceConf);
            this.startAgentWebApp(appInformation, serviceConf, webAppApi);
            int webAppPort = this.deployWebApplication(webAppApi);
            String scheme = "http://";
            this.appMasterTrackingUrl = String.valueOf(scheme) + this.appMasterHostname + ":" + webAppPort;
            appInformation.put("info.am.web.url", String.valueOf(this.appMasterTrackingUrl) + "/");
            appInformation.set("info.am.web.port", webAppPort);
            log.info("Connecting to RM at {}; AM tracking URL={}", (Object)this.appMasterRpcPort, (Object)this.appMasterTrackingUrl);
            this.amRegistrationData = this.asyncRMClient.registerApplicationMaster(this.appMasterHostname, this.appMasterRpcPort, this.appMasterTrackingUrl);
            this.maximumResourceCapability = this.amRegistrationData.getMaximumResourceCapability();
            int minMemory = serviceConf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
            int minCores = serviceConf.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
            int maxMemory = this.maximumResourceCapability.getMemory();
            int maxCores = this.maximumResourceCapability.getVirtualCores();
            this.appState.setContainerLimits(minMemory, maxMemory, minCores, maxCores);
            this.rmOperationHandler = new AsyncRMOperationHandler(this.asyncRMClient, this.maximumResourceCapability);
            appInformation.put("yarn.vcores", Integer.toString(maxCores));
            appInformation.put("yarn.memory", Integer.toString(maxMemory));
            this.processAMCredentials(this.securityConfiguration);
            if (this.securityEnabled) {
                this.secretManager.setMasterKey(this.amRegistrationData.getClientToAMTokenMasterKey().array());
                this.applicationACLs = this.amRegistrationData.getApplicationACLs();
                this.rpcService.getServer().refreshServiceAcl(serviceConf, (PolicyProvider)new SliderAMPolicyProvider());
                if (this.securityConfiguration.isKeytabProvided()) {
                    String principal = this.securityConfiguration.getPrincipal();
                    File localKeytabFile = this.securityConfiguration.getKeytabFile(instanceDefinition);
                    this.login(principal, localKeytabFile);
                    fs = new SliderFileSystem(serviceConf);
                }
            }
            SliderYarnClientImpl yarnClient = null;
            try {
                yarnClient = new SliderYarnClientImpl();
                yarnClient.init(this.getConfig());
                yarnClient.start();
                nodeReports = this.getNodeReports(yarnClient);
                log.info("Yarn node report count: {}", (Object)nodeReports.size());
                ApplicationAttemptReport report = this.getApplicationAttemptReport(yarnClient);
                this.appMasterProxiedUrl = report.getTrackingUrl();
                if (SliderUtils.isUnset(this.appMasterProxiedUrl)) {
                    log.warn("Proxied URL is not set in application report");
                    this.appMasterProxiedUrl = this.appMasterTrackingUrl;
                }
            }
            finally {
                ServiceOperations.stop((Service)yarnClient);
                yarnClient = null;
            }
            liveContainers = this.amRegistrationData.getContainersFromPreviousAttempts();
            Configuration providerConf = this.providerService.loadProviderConfigurationInformation(confDir);
            this.providerService.initializeApplicationConfiguration(instanceDefinition, fs, null);
            this.providerService.validateApplicationConfiguration(instanceDefinition, confDir, this.securityEnabled);
            Path historyDir = new Path(clusterDirPath, "history");
            AppStateBindingInfo binding = new AppStateBindingInfo();
            binding.instanceDefinition = instanceDefinition;
            binding.serviceConfig = serviceConf;
            binding.publishedProviderConf = providerConf;
            binding.roles = providerRoles;
            binding.fs = fs.getFileSystem();
            binding.historyPath = historyDir;
            binding.liveContainers = liveContainers;
            binding.applicationInfo = appInformation;
            binding.releaseSelector = this.providerService.createContainerReleaseSelector();
            binding.nodeReports = nodeReports;
            this.appState.buildInstance(binding);
            this.providerService.rebuildContainerDetails(liveContainers, instanceDefinition.getName(), this.appState.getRolePriorityMap());
            this.appState.buildAppMasterNode(this.appMasterContainerID, this.appMasterHostname, webAppPort, String.valueOf(this.appMasterHostname) + ":" + webAppPort);
            envVars = new HashMap<String, String>();
            if (this.hadoop_user_name != null) {
                envVars.put("HADOOP_USER_NAME", this.hadoop_user_name);
            }
            if ((debug_kerberos = System.getenv("HADOOP_JAAS_DEBUG")) != null) {
                envVars.put("HADOOP_JAAS_DEBUG", debug_kerberos);
            }
        }
        String rolesTmpSubdir = String.valueOf(this.appMasterContainerID.toString()) + "/roles";
        String amTmpDir = globalInternalOptions.getMandatoryOption("internal.am.tmp.dir");
        Path tmpDirPath = new Path(amTmpDir);
        Path launcherTmpDirPath = new Path(tmpDirPath, rolesTmpSubdir);
        fs.getFileSystem().mkdirs(launcherTmpDirPath);
        this.launchService = new RoleLaunchService(this.actionQueues, this.providerService, fs, new Path(this.getGeneratedConfDir()), envVars, launcherTmpDirPath);
        this.deployChildService((Service)this.launchService);
        this.appState.noteAMLaunched();
        this.providerService.bind(this.stateForProviders, this.actionQueues, liveContainers);
        this.sliderAMProvider.bind(this.stateForProviders, this.actionQueues, liveContainers);
        this.maybeStartMonkey();
        if (!MapRSecurityUtil.isKerberosEnabled()) {
            this.hadoop_user_name = System.getenv("HADOOP_USER_NAME");
            log.info("HADOOP_USER_NAME='{}'", (Object)this.hadoop_user_name);
        }
        this.service_user_name = RegistryUtils.currentUser();
        log.info("Registry service username ={}", (Object)this.service_user_name);
        log.info("Application Master Initialization Completed");
        this.initCompleted.set(true);
        this.scheduleFailureWindowResets(instanceDefinition.getResources());
        this.scheduleEscalation(instanceDefinition.getInternal());
        try {
            this.queue(new ActionRegisterServiceInstance(clustername, appid));
            log.info("RM Webapp address {}", (Object)serviceConf.get("yarn.resourcemanager.webapp.address"));
            log.info("Slider webapp address {} proxied at {}", (Object)this.appMasterTrackingUrl, (Object)this.appMasterProxiedUrl);
            this.sliderAMProvider.start();
            this.launchProviderService(instanceDefinition, confDir);
            this.startQueueProcessing();
            this.waitForAMCompletionSignal();
        }
        catch (Exception e) {
            log.error("Exception : {}", (Object)e, (Object)e);
            ActionStopSlider stopSlider = new ActionStopSlider(e);
            stopSlider.setExitReason(SliderExitReason.SLIDER_AM_ERROR);
            this.onAMStop(stopSlider);
        }
        return this.finish();
    }

    private ApplicationAttemptReport getApplicationAttemptReport(final SliderYarnClientImpl yarnClient) throws YarnException, IOException, InterruptedException {
        ApplicationAttemptReport report;
        Preconditions.checkNotNull((Object)((Object)yarnClient), (Object)"Null Yarn client");
        if (this.securityEnabled) {
            UserGroupInformation ugi = UserGroupInformation.getLoginUser();
            report = (ApplicationAttemptReport)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationAttemptReport>(){

                @Override
                public ApplicationAttemptReport run() throws Exception {
                    return yarnClient.getApplicationAttemptReport(SliderAppMaster.this.appAttemptID);
                }
            });
        } else {
            report = yarnClient.getApplicationAttemptReport(this.appAttemptID);
        }
        return report;
    }

    private List<NodeReport> getNodeReports(final SliderYarnClientImpl yarnClient) throws IOException, YarnException, InterruptedException {
        Preconditions.checkNotNull((Object)((Object)yarnClient), (Object)"Null Yarn client");
        List nodeReports = this.securityEnabled ? (List)UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<NodeReport>>(){

            @Override
            public List<NodeReport> run() throws Exception {
                return yarnClient.getNodeReports(new NodeState[]{NodeState.RUNNING});
            }
        }) : yarnClient.getNodeReports(new NodeState[]{NodeState.RUNNING});
        log.info("Yarn node report count: {}", (Object)nodeReports.size());
        return nodeReports;
    }

    private int deployWebApplication(WebAppApiImpl webAppApi) throws IOException, SliderException {
        try {
            this.webApp = new SliderAMWebApp(webAppApi);
            HttpConfig.Policy policy = HttpConfig.Policy.HTTP_ONLY;
            int port = this.getPortToRequest();
            log.info("Launching web application at port {} with policy {}", (Object)port, (Object)policy);
            WebApps.$for((String)"slideram", WebAppApi.class, (Object)webAppApi, (String)"ws").withHttpPolicy(this.getConfig(), policy).at("0.0.0.0", port, true).inDevMode().start((WebApp)this.webApp);
            WebAppService<SliderAMWebApp> webAppService = new WebAppService<SliderAMWebApp>("slider", this.webApp);
            this.deployChildService((Service)webAppService);
            return this.webApp.port();
        }
        catch (WebAppException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    private void processAMCredentials(SecurityConfiguration securityConfig) throws IOException {
        ArrayList<Text> filteredTokens = new ArrayList<Text>(3);
        filteredTokens.add(AMRMTokenIdentifier.KIND_NAME);
        filteredTokens.add(TimelineDelegationTokenIdentifier.KIND_NAME);
        boolean keytabProvided = securityConfig.isKeytabProvided();
        log.info("Slider AM Security Mode: {}", (Object)(keytabProvided ? "KEYTAB" : "TOKEN"));
        if (keytabProvided) {
            filteredTokens.add(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
        }
        this.containerCredentials = CredentialUtils.filterTokens(UserGroupInformation.getCurrentUser().getCredentials(), filteredTokens);
        log.info(CredentialUtils.dumpTokens(this.containerCredentials, "\n"));
    }

    private void buildPortScanner(AggregateConf instanceDefinition) throws BadConfigException {
        this.portScanner = new PortScanner();
        String portRange = instanceDefinition.getAppConfOperations().getGlobalOptions().getOption("site.global.slider.allowed.ports", "0");
        if (!"0".equals(portRange)) {
            this.portScanner.setPortRange(portRange);
        }
    }

    private int getPortToRequest() throws SliderException, IOException {
        return this.portScanner.getAvailablePort();
    }

    private void uploadServerCertForLocalization(String clustername, SliderFileSystem fs) throws IOException {
        Path certsDir = fs.buildClusterSecurityDirPath(clustername);
        if (!fs.getFileSystem().exists(certsDir)) {
            fs.getFileSystem().mkdirs(certsDir, new FsPermission(FsAction.ALL, FsAction.NONE, FsAction.NONE));
        }
        Path destPath = new Path(certsDir, "ca.crt");
        if (!fs.getFileSystem().exists(destPath)) {
            fs.getFileSystem().copyFromLocalFile(new Path(CertificateManager.getServerCertficateFilePath().getAbsolutePath()), destPath);
            log.info("Uploaded server cert to localization path {}", (Object)destPath);
        }
        fs.getFileSystem().setPermission(destPath, new FsPermission(FsAction.READ, FsAction.NONE, FsAction.NONE));
    }

    protected void login(String principal, File localKeytabFile) throws IOException, SliderException {
        log.info("Logging in as {} with keytab {}", (Object)principal, (Object)localKeytabFile);
        UserGroupInformation.loginUserFromKeytab((String)principal, (String)localKeytabFile.getAbsolutePath());
        this.validateLoginUser(UserGroupInformation.getLoginUser());
    }

    protected void validateLoginUser(UserGroupInformation user) throws SliderException {
        if (!user.isFromKeytab()) {
            log.error("User is not holding on a keytab in a secure deployment: slider will fail as tokens expire");
        }
        Credentials credentials = user.getCredentials();
        Iterator iter = credentials.getAllTokens().iterator();
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            log.info("Token {}", (Object)token.getKind());
            if (!token.getKind().equals((Object)DelegationTokenIdentifier.HDFS_DELEGATION_KIND)) continue;
            log.info("HDFS delegation token {}.  Removing...", (Object)token);
            iter.remove();
        }
    }

    private void startAgentWebApp(MapOperations appInformation, Configuration serviceConf, WebAppApiImpl webAppApi) throws IOException, SliderException {
        URL[] urls = ((URLClassLoader)AgentWebApp.class.getClassLoader()).getURLs();
        StringBuilder sb = new StringBuilder("AM classpath:");
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            sb.append("\n").append(url.toString());
            ++n2;
        }
        LOG_YARN.debug(sb.append("\n").toString());
        this.initAMFilterOptions(serviceConf);
        MapOperations appMasterConfig = this.getInstanceDefinition().getAppConfOperations().getComponent("slider-appmaster");
        AgentWebApp agentWebApp = AgentWebApp.$for("slideragent", webAppApi, "ws").withComponentConfig(appMasterConfig).withPort(this.getPortToRequest()).withSecuredPort(this.getPortToRequest()).start();
        this.agentOpsUrl = "https://" + this.appMasterHostname + ":" + agentWebApp.getSecuredPort();
        this.agentStatusUrl = "https://" + this.appMasterHostname + ":" + agentWebApp.getPort();
        AgentService agentService = new AgentService("slider-agent", agentWebApp);
        agentService.init(serviceConf);
        agentService.start();
        this.addService((Service)agentService);
        appInformation.put("info.am.agent.ops.url", String.valueOf(this.agentOpsUrl) + "/");
        appInformation.put("info.am.agent.status.url", String.valueOf(this.agentStatusUrl) + "/");
        appInformation.set("info.am.agent.status.port", agentWebApp.getPort());
        appInformation.set("info.am.agent.ops.port", agentWebApp.getSecuredPort());
    }

    private void initAMFilterOptions(Configuration serviceConf) {
        String amFilterName = "org.apache.hadoop.yarn.server.webproxy.amfilter.AmFilterInitializer";
        if (serviceConf.getBoolean("slider.feature.ws.insecure", false)) {
            log.warn("Insecure filter enabled: REST operations are unauthenticated");
            amFilterName = "org.apache.slider.server.appmaster.web.rest.InsecureAmFilterInitializer";
        }
        serviceConf.set("hadoop.http.filter.initializers", amFilterName);
    }

    public void registerServiceInstance(String instanceName, ApplicationId appId) throws IOException {
        boolean isFirstAttempt;
        URL amWebURI = new URL(this.appMasterProxiedUrl);
        URL agentOpsURI = new URL(this.agentOpsUrl);
        URL agentStatusURI = new URL(this.agentStatusUrl);
        this.setupInitialRegistryPaths();
        this.yarnRegistryOperations = new YarnRegistryViewForProviders(this.registryOperations, this.service_user_name, "org-apache-slider", instanceName, this.appAttemptID);
        this.providerService.bindToYarnRegistry(this.yarnRegistryOperations);
        this.sliderAMProvider.bindToYarnRegistry(this.yarnRegistryOperations);
        ServiceRecord serviceRecord = new ServiceRecord();
        serviceRecord.set("yarn:id", (Object)appId.toString());
        serviceRecord.set("yarn:persistence", (Object)"application");
        serviceRecord.description = "Slider Application Master";
        serviceRecord.addExternalEndpoint(RegistryTypeUtils.ipcEndpoint((String)"classpath:org.apache.slider.appmaster.ipc", (InetSocketAddress)this.rpcServiceAddress));
        this.sliderAMProvider.applyInitialRegistryDefinitions(amWebURI, agentOpsURI, agentStatusURI, serviceRecord);
        this.providerService.applyInitialRegistryDefinitions(amWebURI, agentOpsURI, agentStatusURI, serviceRecord);
        this.setProvidedServiceRecordAttributes(this.getInstanceDefinition().getAppConfOperations().getComponent("slider-appmaster"), serviceRecord);
        log.info("Service Record \n{}", (Object)serviceRecord);
        this.yarnRegistryOperations.registerSelf(serviceRecord, true);
        log.info("Registered service under {}; absolute path {}", (Object)this.yarnRegistryOperations.getSelfRegistrationPath(), (Object)this.yarnRegistryOperations.getAbsoluteSelfRegistrationPath());
        boolean bl = isFirstAttempt = 1 == this.appAttemptID.getAttemptId();
        if (isFirstAttempt) {
            this.yarnRegistryOperations.deleteChildren(this.yarnRegistryOperations.getSelfRegistrationPath(), true);
        }
    }

    protected void setupInitialRegistryPaths() throws IOException {
        if (this.registryOperations instanceof RMRegistryOperationsService) {
            RMRegistryOperationsService rmRegOperations = (RMRegistryOperationsService)this.registryOperations;
            rmRegOperations.initUserRegistryAsync(this.service_user_name);
        }
    }

    public boolean registerComponent(ContainerId id, String description, String type) throws IOException {
        RoleInstance instance = this.appState.getOwnedContainer(id);
        if (instance == null) {
            return false;
        }
        log.info("Registering component {}", (Object)id);
        String cid = RegistryPathUtils.encodeYarnID((String)id.toString());
        ServiceRecord container = new ServiceRecord();
        container.set("yarn:id", (Object)cid);
        container.description = description;
        container.set("yarn:persistence", (Object)"container");
        MapOperations compOps = this.getInstanceDefinition().getAppConfOperations().getComponent(type);
        this.setProvidedServiceRecordAttributes(compOps, container);
        try {
            this.yarnRegistryOperations.putComponent(cid, container);
        }
        catch (IOException e) {
            log.warn("Failed to register container {}/{}: {}", new Object[]{id, description, e, e});
            return false;
        }
        return true;
    }

    protected void setProvidedServiceRecordAttributes(MapOperations ops, ServiceRecord record) {
        String prefix = "service.record.attribute";
        for (Map.Entry<String, String> entry : ops.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            String key = entry.getKey().substring(prefix.length() + 1);
            record.set(key, (Object)entry.getValue().trim());
        }
    }

    public void unregisterComponent(ContainerId id) {
        log.info("Unregistering component {}", (Object)id);
        if (this.yarnRegistryOperations == null) {
            log.warn("Processing unregister component event before initialization completed; init flag ={}", (Object)this.initCompleted);
            return;
        }
        String cid = RegistryPathUtils.encodeYarnID((String)id.toString());
        try {
            this.yarnRegistryOperations.deleteComponent(cid);
        }
        catch (IOException e) {
            log.warn("Failed to delete container {} : {}", new Object[]{id, e, e});
        }
    }

    private void checkAndWarnForAuthTokenProblems() {
        File tokenFile;
        String fileLocation = System.getenv("HADOOP_TOKEN_FILE_LOCATION");
        if (fileLocation != null && !(tokenFile = new File(fileLocation)).exists()) {
            log.warn("Token file {} specified in {} not found", (Object)tokenFile, (Object)"HADOOP_TOKEN_FILE_LOCATION");
        }
    }

    public File getLocalConfDir() {
        File confdir = new File("propagatedconf").getAbsoluteFile();
        return confdir;
    }

    public String getGeneratedConfDir() {
        return this.getGlobalInternalOptions().get("internal.generated.conf.path");
    }

    public MapOperations getGlobalInternalOptions() {
        return this.getInstanceDefinition().getInternalOperations().getGlobalOptions();
    }

    public SliderFileSystem getClusterFS() throws IOException {
        return new SliderFileSystem(this.getConfig());
    }

    public static Logger getLog() {
        return log;
    }

    public AppState getAppState() {
        return this.appState;
    }

    private void waitForAMCompletionSignal() {
        this.AMExecutionStateLock.lock();
        try {
            if (!this.amCompletionFlag.get()) {
                log.debug("blocking until signalled to terminate");
                this.isAMCompleted.awaitUninterruptibly();
            }
        }
        finally {
            this.AMExecutionStateLock.unlock();
        }
    }

    public synchronized void signalAMComplete(ActionStopSlider stopActionRequest) {
        this.schedule(stopActionRequest);
    }

    public synchronized void onAMStop(ActionStopSlider stopActionRequest) {
        this.AMExecutionStateLock.lock();
        try {
            if (this.amCompletionFlag.compareAndSet(false, true)) {
                this.stopAction = stopActionRequest;
                this.isAMCompleted.signal();
            }
        }
        finally {
            this.AMExecutionStateLock.unlock();
        }
    }

    private synchronized int finish() throws Exception {
        Exception exception;
        int exitCode;
        block11: {
            Preconditions.checkNotNull((Object)this.stopAction, (Object)"null stop action");
            log.info("Triggering shutdown of the AM: {}", (Object)this.stopAction);
            String finalMessage = this.stopAction.getMessage();
            exitCode = this.stopAction.getExitCode();
            exception = this.stopAction.getEx();
            FinalApplicationStatus appStatus = this.stopAction.getFinalApplicationStatus();
            if (!this.spawnedProcessExitedBeforeShutdownTriggered) {
                int forkedExitCode = this.stopForkedProcess();
                log.debug("Stopped forked process: exit code={}", (Object)forkedExitCode);
            }
            if (this.amRegistrationData == null) {
                log.info("Application attempt not yet registered; skipping unregistration");
                if (exception != null) {
                    throw exception;
                }
                return exitCode;
            }
            this.launchService.stop();
            String containerReleaseMessage = "Application stop triggered";
            this.releaseAllContainers(containerReleaseMessage);
            log.info("Application completed. Signalling finish to RM");
            ApplicationDiagnostics appDiagnostics = this.getApplicationDiagnostics();
            appDiagnostics.setFinalStatus(appStatus);
            appDiagnostics.setFinalMessage(finalMessage);
            appDiagnostics.setExitReason(this.stopAction.getExitReason());
            String appMessage = appDiagnostics.toString();
            try {
                log.info("Unregistering AM status={} message={}", (Object)appStatus, (Object)appMessage);
                this.asyncRMClient.unregisterApplicationMaster(appStatus, appMessage, null);
            }
            catch (InvalidApplicationMasterRequestException e) {
                log.info("Application not found in YARN application list; it may have been terminated/YARN shutdown in progress: {}", (Object)e, (Object)e);
                SecurityUtils.cleanupSecurityDir();
                break block11;
            }
            catch (IOException | YarnException e) {
                try {
                    log.info("Failed to unregister application: " + e, e);
                    break block11;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    SecurityUtils.cleanupSecurityDir();
                }
            }
            SecurityUtils.cleanupSecurityDir();
        }
        if (exception != null) {
            throw exception;
        }
        return exitCode;
    }

    private String getContainerDiagnosticInfo() {
        return this.appState.getContainerDiagnosticInfo();
    }

    public Object getProxy(Class protocol, InetSocketAddress addr) {
        return this.yarnRPC.getProxy(protocol, addr, this.getConfig());
    }

    private void startSliderRPCServer(AggregateConf instanceDefinition) throws IOException, SliderException {
        this.verifyIPCAccess();
        this.sliderIPCService = new SliderIPCService(this, this.certificateManager, this.stateForProviders, this.actionQueues, this.metricsAndMonitoring, this.contentCache);
        this.deployChildService((Service)this.sliderIPCService);
        SliderClusterProtocolPBImpl protobufRelay = new SliderClusterProtocolPBImpl(this.sliderIPCService);
        BlockingService blockingService = SliderClusterAPI.SliderClusterProtocolPB.newReflectiveBlockingService(protobufRelay);
        int port = this.getPortToRequest();
        InetSocketAddress rpcAddress = new InetSocketAddress("0.0.0.0", port);
        this.rpcService = new WorkflowRpcService("SliderRPC", RpcBinder.createProtobufServer(rpcAddress, this.getConfig(), (SecretManager<? extends TokenIdentifier>)this.secretManager, 5, blockingService, null));
        this.deployChildService((Service)this.rpcService);
    }

    private void verifyIPCAccess() throws BadConfigException {
        boolean authorization = this.getConfig().getBoolean("hadoop.security.authorization", false);
        String acls = this.getConfig().get("slider.security.protocol.acl");
        if (authorization && SliderUtils.isUnset(acls)) {
            throw new BadConfigException("Application has IPC authorization enabled in hadoop.security.authorization but no ACLs in slider.security.protocol.acl");
        }
    }

    public void onContainersAllocated(List<Container> allocatedContainers) {
        LOG_YARN.info("onContainersAllocated({})", (Object)allocatedContainers.size());
        ArrayList<ContainerAssignment> assignments = new ArrayList<ContainerAssignment>();
        ArrayList<AbstractRMOperation> operations = new ArrayList<AbstractRMOperation>();
        this.appState.onContainersAllocated(allocatedContainers, assignments, operations);
        for (ContainerAssignment assignment : assignments) {
            try {
                this.launchService.launchRole(assignment, this.getInstanceDefinition(), this.buildContainerCredentials());
            }
            catch (IOException e) {
                log.error("Failed to build credentials to launch container: {}", (Object)e, (Object)e);
            }
        }
        this.execute(operations);
        log.info("Diagnostics: {}", (Object)this.getContainerDiagnosticInfo());
    }

    public synchronized void onContainersCompleted(List<ContainerStatus> completedContainers) {
        LOG_YARN.info("onContainersCompleted([{}]", (Object)completedContainers.size());
        for (ContainerStatus status : completedContainers) {
            ContainerId containerId = status.getContainerId();
            LOG_YARN.info("Container Completion for containerID={}, state={}, exitStatus={}, diagnostics={}", new Object[]{containerId, status.getState(), status.getExitStatus(), status.getDiagnostics()});
            assert (status.getState() == ContainerState.COMPLETE);
            AppState.NodeCompletionResult result = this.appState.onCompletedNode(status);
            if (result.containerFailed) {
                RoleInstance ri = result.roleInstance;
                log.error("Role instance {} failed ", (Object)ri);
            }
            if (result.unknownNode) continue;
            this.getProviderService().notifyContainerCompleted(containerId);
            this.queue(new UnregisterComponentInstance(containerId, 0L, TimeUnit.MILLISECONDS));
        }
        this.reviewRequestAndReleaseNodes("onContainersCompleted");
    }

    public synchronized void onUpgradeContainers(ActionUpgradeContainers upgradeContainersRequest) throws IOException, SliderException {
        Map<ContainerId, RoleInstance> liveContainers;
        LOG_YARN.info("onUpgradeContainers({})", (Object)upgradeContainersRequest.getMessage());
        Set<Object> containers = upgradeContainersRequest.getContainers() == null ? new HashSet() : upgradeContainersRequest.getContainers();
        LOG_YARN.info("  Container list provided (total {}) : {}", (Object)containers.size(), containers);
        Set<Object> components = upgradeContainersRequest.getComponents() == null ? new HashSet() : upgradeContainersRequest.getComponents();
        LOG_YARN.info("  Component list provided (total {}) : {}", (Object)components.size(), components);
        if (CollectionUtils.isNotEmpty(components) && CollectionUtils.isNotEmpty((liveContainers = this.appState.getLiveContainers()).keySet())) {
            Map<String, Set<String>> roleContainerMap = this.prepareRoleContainerMap(liveContainers);
            for (String string : components) {
                Set<String> roleContainers = roleContainerMap.get(string);
                if (roleContainers == null) continue;
                containers.addAll(roleContainers);
            }
        }
        LOG_YARN.info("Final list of containers to be upgraded (total {}) : {}", (Object)containers.size(), containers);
        if (this.providerService instanceof AgentProviderService) {
            AgentProviderService agentProviderService = (AgentProviderService)this.providerService;
            agentProviderService.setInUpgradeMode(true);
            agentProviderService.addUpgradeContainers(containers);
        }
    }

    private Map<String, Set<String>> prepareRoleContainerMap(Map<ContainerId, RoleInstance> liveContainers) {
        HashMap<String, Set<String>> roleContainerMap = new HashMap<String, Set<String>>();
        for (Map.Entry<ContainerId, RoleInstance> liveContainer : liveContainers.entrySet()) {
            RoleInstance role = liveContainer.getValue();
            if (roleContainerMap.containsKey(role.role)) {
                ((Set)roleContainerMap.get(role.role)).add(liveContainer.getKey().toString());
                continue;
            }
            HashSet<String> containers = new HashSet<String>();
            containers.add(liveContainer.getKey().toString());
            roleContainerMap.put(role.role, containers);
        }
        return roleContainerMap;
    }

    public void flexCluster(ConfTree resources) throws IOException, SliderException {
        AggregateConf newConf = new AggregateConf(this.appState.getInstanceDefinitionSnapshot());
        newConf.setResources(resources);
        this.sliderAMProvider.validateInstanceDefinition(newConf);
        this.providerService.validateInstanceDefinition(newConf);
        this.appState.updateResourceDefinitions(resources);
        this.appState.resetFailureCounts();
        this.reviewRequestAndReleaseNodes("flexCluster");
    }

    private void scheduleFailureWindowResets(ConfTree resources) throws BadConfigException {
        ResetFailureWindow reset = new ResetFailureWindow(this.rmOperationHandler);
        ConfTreeOperations ops = new ConfTreeOperations(resources);
        MapOperations globals = ops.getGlobalOptions();
        long seconds = globals.getTimeRange("yarn.container.failure.window", 0, 6, 0, 0);
        if (seconds > 0L) {
            log.info("Scheduling the failure window reset interval to every {} seconds", (Object)seconds);
            RenewingAction<ResetFailureWindow> renew = new RenewingAction<ResetFailureWindow>(reset, seconds, seconds, TimeUnit.SECONDS, 0);
            this.actionQueues.renewing("failures", renew);
        } else {
            log.info("Failure window reset interval is not set");
        }
    }

    private void scheduleEscalation(ConfTree internal) throws BadConfigException {
        EscalateOutstandingRequests escalate = new EscalateOutstandingRequests();
        ConfTreeOperations ops = new ConfTreeOperations(internal);
        int seconds = ops.getGlobalOptions().getOptionInt("escalation.check.interval.seconds", 30);
        RenewingAction<EscalateOutstandingRequests> renew = new RenewingAction<EscalateOutstandingRequests>(escalate, seconds, seconds, TimeUnit.SECONDS, 0);
        this.actionQueues.renewing("escalation", renew);
    }

    private synchronized void reviewRequestAndReleaseNodes(String reason) {
        log.debug("reviewRequestAndReleaseNodes({})", (Object)reason);
        this.queue(new ReviewAndFlexApplicationSize(reason, 0L, TimeUnit.SECONDS));
    }

    public void handleReviewAndFlexApplicationSize(ReviewAndFlexApplicationSize action) throws SliderInternalStateException {
        if (this.actionQueues.hasQueuedActionWithAttribute(6)) {
            return;
        }
        if (this.actionQueues.hasQueuedActionWithAttribute(1)) {
            this.actionQueues.put(action);
        }
        this.executeNodeReview(action.name);
    }

    public synchronized void executeNodeReview(String reason) throws SliderInternalStateException {
        log.debug("in executeNodeReview({})", (Object)reason);
        if (this.amCompletionFlag.get()) {
            log.info("Ignoring node review operation: shutdown in progress");
        }
        try {
            List<AbstractRMOperation> allOperations = this.appState.reviewRequestAndReleaseNodes();
            this.providerRMOperationHandler.execute(allOperations);
            this.execute(allOperations);
        }
        catch (TriggerClusterTeardownException e) {
            log.error("Cluster teardown triggered {}", (Object)e, (Object)e);
            ActionStopSlider stopSlider = new ActionStopSlider(e);
            stopSlider.setExitReason(SliderExitReason.SLIDER_AM_ERROR);
            this.queue(stopSlider);
        }
    }

    public void escalateOutstandingRequests() {
        List<AbstractRMOperation> operations = this.appState.escalateOutstandingRequests();
        this.providerRMOperationHandler.execute(operations);
        this.execute(operations);
    }

    private void releaseAllContainers(String releaseMessage) {
        if (this.providerService instanceof AgentProviderService) {
            log.info("Setting stopInitiated flag to true");
            AgentProviderService agentProviderService = (AgentProviderService)this.providerService;
            agentProviderService.setAppStopInitiated(true);
        }
        try {
            try {
                long timeout = this.getContainerReleaseTimeout();
                if (timeout > 0L) {
                    Thread.sleep(timeout);
                }
            }
            catch (InterruptedException interruptedException) {
                log.info("Sleep for container release interrupted");
                List<AbstractRMOperation> operations = this.appState.releaseAllContainers(releaseMessage);
                this.appState.updateAllContainerLogLinks();
                this.providerRMOperationHandler.execute(operations);
                this.execute(operations);
            }
        }
        finally {
            List<AbstractRMOperation> operations = this.appState.releaseAllContainers(releaseMessage);
            this.appState.updateAllContainerLogLinks();
            this.providerRMOperationHandler.execute(operations);
            this.execute(operations);
        }
    }

    private long getContainerReleaseTimeout() {
        int timeout = this.getInstanceDefinition().getAppConfOperations().getGlobalOptions().getOptionInt("site.global.app_container.release_timeout_secs", 0);
        if (timeout > 0) {
            timeout += 10;
        }
        long timeoutInMillis = (long)timeout * 1000L;
        log.info("Container release timeout in millis = {}", (Object)timeoutInMillis);
        return timeoutInMillis;
    }

    public void onShutdownRequest() {
        LOG_YARN.info("Shutdown Request received");
        ActionStopSlider stopSlider = new ActionStopSlider("stop", 0, FinalApplicationStatus.SUCCEEDED, "Shutdown requested from RM");
        stopSlider.setExitReason(SliderExitReason.YARN_ERROR);
        this.signalAMComplete(stopSlider);
    }

    public void onNodesUpdated(List<NodeReport> updatedNodes) {
        LOG_YARN.info("onNodesUpdated({})", (Object)updatedNodes.size());
        log.info("Updated nodes {}", updatedNodes);
        AppState.NodeUpdatedOutcome outcome = this.appState.onNodesUpdated(updatedNodes);
        if (!outcome.operations.isEmpty()) {
            this.execute(outcome.operations);
        }
        if (outcome.clusterChanged) {
            this.reviewRequestAndReleaseNodes("nodes updated");
        }
    }

    public float getProgress() {
        return this.appState.getApplicationProgressPercentage();
    }

    public void onError(Throwable e) {
        if (e instanceof InvalidResourceRequestException) {
            LOG_YARN.error("AMRMClientAsync.onError() received {}", (Object)e, (Object)e);
            ActionStopSlider stopSlider = new ActionStopSlider("stop", 56, FinalApplicationStatus.FAILED, SliderUtils.extractFirstLine(e.getLocalizedMessage()));
            stopSlider.setExitReason(SliderExitReason.APP_ERROR);
            this.signalAMComplete(stopSlider);
        } else if (e instanceof InvalidApplicationMasterRequestException) {
            LOG_YARN.error("AMRMClientAsync.onError() received {}", (Object)e, (Object)e);
            this.queue(new ActionHalt(56, SliderUtils.extractFirstLine(e.getLocalizedMessage())));
        } else {
            LOG_YARN.info("Ignoring AMRMClientAsync.onError() received {}", e);
        }
    }

    @Override
    public void execute(List<AbstractRMOperation> operations) {
        this.rmOperationHandler.execute(operations);
    }

    @Override
    public void releaseAssignedContainer(ContainerId containerId) {
        this.rmOperationHandler.releaseAssignedContainer(containerId);
    }

    @Override
    public void addContainerRequest(AMRMClient.ContainerRequest req) {
        this.rmOperationHandler.addContainerRequest(req);
    }

    @Override
    public int cancelContainerRequests(Priority priority1, Priority priority2, int count) {
        return this.rmOperationHandler.cancelContainerRequests(priority1, priority2, count);
    }

    @Override
    public void cancelSingleRequest(AMRMClient.ContainerRequest request) {
        this.rmOperationHandler.cancelSingleRequest(request);
    }

    @Override
    public void updateBlacklist(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        this.rmOperationHandler.updateBlacklist(blacklistAdditions, blacklistRemovals);
    }

    protected synchronized void launchProviderService(AggregateConf instanceDefinition, File confDir) throws IOException, SliderException {
        HashMap<String, String> env = new HashMap<String, String>();
        boolean execStarted = this.providerService.exec(instanceDefinition, confDir, env, this);
        if (execStarted) {
            this.providerService.registerServiceListener(this);
            this.providerService.start();
        } else {
            this.providerService.start();
            this.eventCallbackEvent(null);
        }
    }

    @Override
    public void eventCallbackEvent(Object parameter) {
        this.appState.noteAMLive();
        try {
            this.flexCluster(this.getInstanceDefinition().getResources());
        }
        catch (Exception e) {
            log.error("Failed to flex cluster nodes: {}", (Object)e, (Object)e);
            ActionStopSlider stopSlider = new ActionStopSlider(e);
            stopSlider.setExitReason(SliderExitReason.SLIDER_AM_ERROR);
            this.queue(stopSlider);
        }
    }

    public synchronized void providerLostContainer(ContainerId containerId) throws SliderException {
        log.info("containerLostContactWithProvider: container {} lost", (Object)containerId);
        RoleInstance activeContainer = this.appState.getOwnedContainer(containerId);
        if (activeContainer != null) {
            this.execute(this.appState.releaseContainer(containerId));
            log.info("Container released; triggering review");
            this.reviewRequestAndReleaseNodes("Loss of container");
        } else {
            log.info("Container not in active set - ignoring");
        }
    }

    @Override
    public void stateChanged(Service service) {
        if (service == this.providerService && service.isInState(Service.STATE.STOPPED)) {
            boolean shouldTriggerFailure;
            int exitCode;
            int mappedProcessExitCode = exitCode = this.providerService.getExitCode();
            boolean bl = shouldTriggerFailure = !this.amCompletionFlag.get() && mappedProcessExitCode != 0;
            if (shouldTriggerFailure) {
                String reason = "Spawned process failed with raw " + exitCode + " mapped to " + mappedProcessExitCode;
                ActionStopSlider stop = new ActionStopSlider("stop", mappedProcessExitCode, FinalApplicationStatus.FAILED, reason);
                stop.setExitReason(SliderExitReason.YARN_ERROR);
                this.spawnedProcessExitedBeforeShutdownTriggered = true;
                log.info("Process has exited with exit code {} mapped to {} -triggering termination", (Object)exitCode, (Object)mappedProcessExitCode);
                this.signalAMComplete(stop);
            } else {
                log.info("Process has exited with exit code {} mapped to {} -ignoring", (Object)exitCode, (Object)mappedProcessExitCode);
            }
        } else {
            super.stateChanged(service);
        }
    }

    protected synchronized Integer stopForkedProcess() {
        this.providerService.stop();
        return this.providerService.getExitCode();
    }

    public void startContainer(Container container, ContainerLaunchContext ctx, RoleInstance instance) throws IOException {
        this.appState.containerStartSubmitted(container, instance);
        this.nmClientAsync.startContainerAsync(container, ctx);
    }

    private Credentials buildContainerCredentials() throws IOException {
        Credentials credentials = new Credentials(this.containerCredentials);
        if (this.securityConfiguration.isKeytabProvided()) {
            CredentialUtils.addSelfRenewableFSDelegationTokens(this.getClusterFS().getFileSystem(), credentials);
        }
        return credentials;
    }

    public void onContainerStopped(ContainerId containerId) {
        log.info("onContainerStopped {} ", (Object)containerId);
    }

    public void onContainerStarted(ContainerId containerId, Map<String, ByteBuffer> allServiceResponse) {
        LOG_YARN.info("Started Container {} ", (Object)containerId);
        RoleInstance cinfo = this.appState.onNodeManagerContainerStarted(containerId);
        if (cinfo != null) {
            LOG_YARN.info("Deployed instance of role {} onto {}", (Object)cinfo.role, (Object)containerId);
            this.nmClientAsync.getContainerStatusAsync(containerId, cinfo.container.getNodeId());
            this.queue(new RegisterComponentInstance(containerId, cinfo.role, cinfo.group, 0L, TimeUnit.MILLISECONDS));
        } else {
            log.error("Notified of started container that isn't pending {} - releasing", (Object)containerId);
            this.asyncRMClient.releaseAssignedContainer(containerId);
        }
    }

    public void onStartContainerError(ContainerId containerId, Throwable t) {
        LOG_YARN.error("Failed to start Container " + containerId, t);
        this.appState.onNodeManagerContainerStartFailed(containerId, t);
    }

    public void onContainerStatusReceived(ContainerId containerId, ContainerStatus containerStatus) {
        LOG_YARN.info("Container Status: id={}, status={}", (Object)containerId, (Object)containerStatus);
        this.appState.onContainerStatusReceived(containerId, containerStatus);
    }

    public void onGetContainerStatusError(ContainerId containerId, Throwable t) {
        LOG_YARN.error("Failed to query the status of Container " + containerId, t);
    }

    public void onStopContainerError(ContainerId containerId, Throwable t) {
        LOG_YARN.error("Failed to stop Container " + containerId, t);
    }

    public AggregateConf getInstanceDefinition() {
        return this.appState.getInstanceDefinition();
    }

    public ClusterDescription getClusterDescription() {
        return this.appState.getClusterStatus();
    }

    public ApplicationDiagnostics getApplicationDiagnostics() {
        return this.getClusterDescription().appDiagnostics;
    }

    public ProviderService getProviderService() {
        return this.providerService;
    }

    public void queue(AsyncAction action) {
        this.actionQueues.put(action);
    }

    public void schedule(AsyncAction action) {
        this.actionQueues.schedule(action);
    }

    public void onExceptionInThread(Thread thread, Throwable exception) {
        log.error("Exception in {}: {}", new Object[]{thread.getName(), exception, exception});
        if (this.amCompletionFlag.get()) {
            log.info("Ignoring exception: shutdown in progress");
        } else {
            int exitCode = 56;
            if (exception instanceof ExitCodeProvider) {
                exitCode = ((ExitCodeProvider)((Object)exception)).getExitCode();
            }
            ActionStopSlider stopSlider = new ActionStopSlider("stop", exitCode, FinalApplicationStatus.FAILED, SliderUtils.extractFirstLine(exception.getLocalizedMessage()));
            stopSlider.setExitReason(SliderExitReason.SLIDER_AM_ERROR);
            this.signalAMComplete(stopSlider);
        }
    }

    private boolean maybeStartMonkey() {
        MapOperations internals = this.getGlobalInternalOptions();
        Boolean enabled = internals.getOptionBool("internal.chaos.monkey.enabled", false);
        if (!enabled.booleanValue()) {
            log.debug("Chaos monkey disabled");
            return false;
        }
        long monkeyInterval = internals.getTimeRange("internal.chaos.monkey.interval", 0, 0, 0, 0);
        if (monkeyInterval == 0L) {
            log.debug("Chaos monkey not configured with a time interval...not enabling");
            return false;
        }
        long monkeyDelay = internals.getTimeRange("internal.chaos.monkey.delay", 0, 0, 0, (int)monkeyInterval);
        log.info("Adding Chaos Monkey scheduled every {} seconds ({} hours -delay {}", new Object[]{monkeyInterval, monkeyInterval / 3600L, monkeyDelay});
        this.monkey = new ChaosMonkeyService(this.metrics, this.actionQueues);
        this.initAndAddService((Service)this.monkey);
        int amLaunchFailProbability = internals.getOptionInt("internal.chaos.monkey.probability.amlaunchfailure", 0);
        if (amLaunchFailProbability > 0 && this.monkey.chaosCheck(amLaunchFailProbability)) {
            log.info("Chaos Monkey has triggered AM Launch failure");
            ActionStopSlider stop = new ActionStopSlider("stop", 0L, TimeUnit.SECONDS, -1, FinalApplicationStatus.FAILED, E_TRIGGERED_LAUNCH_FAILURE);
            stop.setExitReason(SliderExitReason.CHAOS_MONKEY);
            this.queue(stop);
        }
        int amKillProbability = internals.getOptionInt("internal.chaos.monkey.probability.amfailure", 0);
        this.monkey.addTarget("AM killer", new ChaosKillAM(this.actionQueues, -1), amKillProbability);
        int containerKillProbability = internals.getOptionInt("internal.chaos.monkey.probability.containerfailure", 0);
        this.monkey.addTarget("Container killer", new ChaosKillContainer(this.appState, this.actionQueues, this.rmOperationHandler), containerKillProbability);
        if (this.monkey.schedule(monkeyDelay, monkeyInterval, TimeUnit.SECONDS)) {
            log.info("Chaos Monkey is running");
            return true;
        }
        log.info("Chaos monkey not started");
        return false;
    }

    public static void main(String[] args) {
        List<String> argsList = Arrays.asList(args);
        ArrayList<String> extendedArgs = new ArrayList<String>(argsList);
        extendedArgs.add(0, SERVICE_CLASSNAME);
        ServiceLauncher.serviceMain(extendedArgs);
    }
}

