/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.launch;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.slider.common.tools.CoreFileSystem;
import org.apache.slider.core.launch.AbstractLauncher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerLauncher
extends AbstractLauncher {
    private static final Logger log = LoggerFactory.getLogger(ContainerLauncher.class);
    public final Container container;

    public ContainerLauncher(Configuration conf, CoreFileSystem coreFileSystem, Container container, Credentials credentials) {
        super(conf, coreFileSystem, credentials);
        this.container = container;
    }

    public UserGroupInformation setupUGI() {
        UserGroupInformation user = UserGroupInformation.createRemoteUser((String)this.container.getId().toString());
        String cmIpPortStr = String.valueOf(this.container.getNodeId().getHost()) + ":" + this.container.getNodeId().getPort();
        InetSocketAddress cmAddress = NetUtils.createSocketAddr((String)cmIpPortStr);
        org.apache.hadoop.yarn.api.records.Token containerToken = this.container.getContainerToken();
        if (containerToken != null) {
            Token token = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)containerToken, (InetSocketAddress)cmAddress);
            user.addToken(token);
        }
        return user;
    }
}

