/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.core.conf;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.BadConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapOperations
implements Map<String, String> {
    private static final Logger log = LoggerFactory.getLogger(MapOperations.class);
    public static final String DAYS = ".days";
    public static final String HOURS = ".hours";
    public static final String MINUTES = ".minutes";
    public static final String SECONDS = ".seconds";
    public final Map<String, String> options;
    public final String name;

    public MapOperations() {
        this.options = new HashMap<String, String>();
        this.name = "";
    }

    public MapOperations(String name, Map<String, String> options) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"null map");
        this.options = options;
        this.name = name;
    }

    public MapOperations(Map.Entry<String, Map<String, String>> entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0, (Object)"null entry");
        this.name = entry.getKey();
        this.options = entry.getValue();
    }

    public String getOption(String key, String defVal) {
        String val = this.options.get(key);
        return val != null ? val : defVal;
    }

    public Boolean getOptionBool(String key, boolean defVal) {
        String val = this.getOption(key, Boolean.toString(defVal));
        return Boolean.valueOf(val);
    }

    public String getMandatoryOption(String key) throws BadConfigException {
        String val = this.options.get(key);
        if (val == null) {
            if (log.isDebugEnabled()) {
                log.debug("Missing key {} from config containing {}", (Object)key, (Object)this);
            }
            String text = "Missing option " + key;
            if (SliderUtils.isSet(this.name)) {
                text = String.valueOf(text) + " from set " + this.name;
            }
            throw new BadConfigException(text);
        }
        return val;
    }

    public int getOptionInt(String option, int defVal) {
        String val = this.getOption(option, Integer.toString(defVal));
        return Integer.decode(val);
    }

    public long getOptionLong(String option, long defVal) {
        String val = this.getOption(option, Long.toString(defVal));
        return Long.decode(val);
    }

    public int getMandatoryOptionInt(String option) throws BadConfigException {
        this.getMandatoryOption(option);
        return this.getOptionInt(option, 0);
    }

    public void verifyOptionSet(String key) throws BadConfigException {
        if (SliderUtils.isUnset(this.getOption(key, null))) {
            throw new BadConfigException("Unset option %s", key);
        }
    }

    public void mergeWithoutOverwrite(Map<String, String> that) {
        SliderUtils.mergeMapsIgnoreDuplicateKeys(this.options, that);
    }

    public void mergeMapPrefixedKeys(Map<String, String> that, String prefix, boolean overwrite) {
        for (Map.Entry<String, String> entry : that.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(prefix) || !overwrite && this.get(key) != null) continue;
            this.put(key, entry.getValue());
        }
    }

    public void putIfUnset(String key, String value) {
        if (this.get(key) == null) {
            this.put(key, value);
        }
    }

    public void set(String key, Object value) {
        assert (value != null);
        this.put(key, value.toString());
    }

    @Override
    public int size() {
        return this.options.size();
    }

    @Override
    public boolean isEmpty() {
        return this.options.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.options.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.options.containsKey(key);
    }

    @Override
    public String get(Object key) {
        return this.options.get(key);
    }

    @Override
    public String put(String key, String value) {
        return this.options.put(key, value);
    }

    @Override
    public String remove(Object key) {
        return this.options.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.options.putAll(m);
    }

    @Override
    public void clear() {
        this.options.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.options.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.options.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.options.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.options.equals(o);
    }

    @Override
    public int hashCode() {
        return this.options.hashCode();
    }

    public boolean isSet(String key) {
        return SliderUtils.isSet(this.get(key));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append("=\n");
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            builder.append("  ").append(entry.getKey()).append('=').append(entry.getValue()).append('\n');
        }
        return builder.toString();
    }

    public long getTimeRange(String basekey, int defDays, int defHours, int defMins, int defSecs) {
        Preconditions.checkArgument((basekey != null ? 1 : 0) != 0);
        int days = this.getOptionInt(String.valueOf(basekey) + DAYS, defDays);
        int hours = this.getOptionInt(String.valueOf(basekey) + HOURS, defHours);
        int minutes = this.getOptionInt(String.valueOf(basekey) + MINUTES, defMins);
        int seconds = this.getOptionInt(String.valueOf(basekey) + SECONDS, defSecs);
        Preconditions.checkState((days >= 0 && hours >= 0 && minutes >= 0 && seconds >= 0 ? 1 : 0) != 0, (String)"Time range for %s has negative time component %s:%s:%s:%s", (Object[])new Object[]{basekey, days, hours, minutes, seconds});
        long totalMinutes = (long)days * 24L * 60L + (long)hours * 24L + (long)minutes;
        return totalMinutes * 60L + (long)seconds;
    }

    public Map<String, String> prefixedWith(String prefix) {
        HashMap<String, String> prefixed = new HashMap<String, String>(this.size());
        for (Map.Entry<String, String> entry : this.entrySet()) {
            if (!entry.getKey().startsWith(prefix)) continue;
            prefixed.put(entry.getKey(), entry.getValue());
        }
        return prefixed;
    }
}

