/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming.mutate.worker;

import java.util.List;
import org.apache.hadoop.hive.ql.io.RecordIdentifier;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hive.hcatalog.streaming.mutate.worker.RecordInspector;

public class RecordInspectorImpl
implements RecordInspector {
    private final StructObjectInspector structObjectInspector;
    private final StructField recordIdentifierField;

    public RecordInspectorImpl(ObjectInspector objectInspector, int recordIdColumn) {
        if (!(objectInspector instanceof StructObjectInspector)) {
            throw new IllegalArgumentException("Serious problem, expected a StructObjectInspector, but got a " + objectInspector.getClass().getName());
        }
        this.structObjectInspector = (StructObjectInspector)objectInspector;
        List structFields = this.structObjectInspector.getAllStructFieldRefs();
        this.recordIdentifierField = (StructField)structFields.get(recordIdColumn);
    }

    @Override
    public RecordIdentifier extractRecordIdentifier(Object record) {
        return (RecordIdentifier)this.structObjectInspector.getStructFieldData(record, this.recordIdentifierField);
    }

    public String toString() {
        return "RecordInspectorImpl [structObjectInspector=" + this.structObjectInspector + ", recordIdentifierField=" + this.recordIdentifierField + "]";
    }
}

