<?php
namespace metastore;
/**
 * Autogenerated by Thrift Compiler (0.9.2)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;


/**
 * This interface is live.
 */
interface ThriftHiveMetastoreIf extends \FacebookServiceIf {
  /**
   * @param string $key
   * @return string
   * @throws \metastore\MetaException
   */
  public function getMetaConf($key);
  /**
   * @param string $key
   * @param string $value
   * @throws \metastore\MetaException
   */
  public function setMetaConf($key, $value);
  /**
   * @param \metastore\Database $database
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   */
  public function create_database(\metastore\Database $database);
  /**
   * @param string $name
   * @return \metastore\Database
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_database($name);
  /**
   * @param string $name
   * @param bool $deleteData
   * @param bool $cascade
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function drop_database($name, $deleteData, $cascade);
  /**
   * @param string $pattern
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_databases($pattern);
  /**
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_all_databases();
  /**
   * @param string $dbname
   * @param \metastore\Database $db
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function alter_database($dbname, \metastore\Database $db);
  /**
   * @param string $name
   * @return \metastore\Type
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_type($name);
  /**
   * @param \metastore\Type $type
   * @return bool
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   */
  public function create_type(\metastore\Type $type);
  /**
   * @param string $type
   * @return bool
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function drop_type($type);
  /**
   * @param string $name
   * @return array
   * @throws \metastore\MetaException
   */
  public function get_type_all($name);
  /**
   * @param string $db_name
   * @param string $table_name
   * @return \metastore\FieldSchema[]
   * @throws \metastore\MetaException
   * @throws \metastore\UnknownTableException
   * @throws \metastore\UnknownDBException
   */
  public function get_fields($db_name, $table_name);
  /**
   * @param string $db_name
   * @param string $table_name
   * @param \metastore\EnvironmentContext $environment_context
   * @return \metastore\FieldSchema[]
   * @throws \metastore\MetaException
   * @throws \metastore\UnknownTableException
   * @throws \metastore\UnknownDBException
   */
  public function get_fields_with_environment_context($db_name, $table_name, \metastore\EnvironmentContext $environment_context);
  /**
   * @param string $db_name
   * @param string $table_name
   * @return \metastore\FieldSchema[]
   * @throws \metastore\MetaException
   * @throws \metastore\UnknownTableException
   * @throws \metastore\UnknownDBException
   */
  public function get_schema($db_name, $table_name);
  /**
   * @param string $db_name
   * @param string $table_name
   * @param \metastore\EnvironmentContext $environment_context
   * @return \metastore\FieldSchema[]
   * @throws \metastore\MetaException
   * @throws \metastore\UnknownTableException
   * @throws \metastore\UnknownDBException
   */
  public function get_schema_with_environment_context($db_name, $table_name, \metastore\EnvironmentContext $environment_context);
  /**
   * @param \metastore\Table $tbl
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function create_table(\metastore\Table $tbl);
  /**
   * @param \metastore\Table $tbl
   * @param \metastore\EnvironmentContext $environment_context
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function create_table_with_environment_context(\metastore\Table $tbl, \metastore\EnvironmentContext $environment_context);
  /**
   * @param string $dbname
   * @param string $name
   * @param bool $deleteData
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_table($dbname, $name, $deleteData);
  /**
   * @param string $dbname
   * @param string $name
   * @param bool $deleteData
   * @param \metastore\EnvironmentContext $environment_context
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_table_with_environment_context($dbname, $name, $deleteData, \metastore\EnvironmentContext $environment_context);
  /**
   * @param string $db_name
   * @param string $pattern
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_tables($db_name, $pattern);
  /**
   * @param string $db_name
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_all_tables($db_name);
  /**
   * @param string $dbname
   * @param string $tbl_name
   * @return \metastore\Table
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_table($dbname, $tbl_name);
  /**
   * @param string $dbname
   * @param string[] $tbl_names
   * @return \metastore\Table[]
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\UnknownDBException
   */
  public function get_table_objects_by_name($dbname, array $tbl_names);
  /**
   * @param string $dbname
   * @param string $filter
   * @param int $max_tables
   * @return string[]
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\UnknownDBException
   */
  public function get_table_names_by_filter($dbname, $filter, $max_tables);
  /**
   * @param string $dbname
   * @param string $tbl_name
   * @param \metastore\Table $new_tbl
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_table($dbname, $tbl_name, \metastore\Table $new_tbl);
  /**
   * @param string $dbname
   * @param string $tbl_name
   * @param \metastore\Table $new_tbl
   * @param \metastore\EnvironmentContext $environment_context
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_table_with_environment_context($dbname, $tbl_name, \metastore\Table $new_tbl, \metastore\EnvironmentContext $environment_context);
  /**
   * @param string $dbname
   * @param string $tbl_name
   * @param \metastore\Table $new_tbl
   * @param bool $cascade
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_table_with_cascade($dbname, $tbl_name, \metastore\Table $new_tbl, $cascade);
  /**
   * @param \metastore\Partition $new_part
   * @return \metastore\Partition
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function add_partition(\metastore\Partition $new_part);
  /**
   * @param \metastore\Partition $new_part
   * @param \metastore\EnvironmentContext $environment_context
   * @return \metastore\Partition
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function add_partition_with_environment_context(\metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context);
  /**
   * @param \metastore\Partition[] $new_parts
   * @return int
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function add_partitions(array $new_parts);
  /**
   * @param \metastore\PartitionSpec[] $new_parts
   * @return int
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function add_partitions_pspec(array $new_parts);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @return \metastore\Partition
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function append_partition($db_name, $tbl_name, array $part_vals);
  /**
   * @param \metastore\AddPartitionsRequest $request
   * @return \metastore\AddPartitionsResult
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function add_partitions_req(\metastore\AddPartitionsRequest $request);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @param \metastore\EnvironmentContext $environment_context
   * @return \metastore\Partition
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function append_partition_with_environment_context($db_name, $tbl_name, array $part_vals, \metastore\EnvironmentContext $environment_context);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $part_name
   * @return \metastore\Partition
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function append_partition_by_name($db_name, $tbl_name, $part_name);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $part_name
   * @param \metastore\EnvironmentContext $environment_context
   * @return \metastore\Partition
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function append_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, \metastore\EnvironmentContext $environment_context);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @param bool $deleteData
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_partition($db_name, $tbl_name, array $part_vals, $deleteData);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @param bool $deleteData
   * @param \metastore\EnvironmentContext $environment_context
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_partition_with_environment_context($db_name, $tbl_name, array $part_vals, $deleteData, \metastore\EnvironmentContext $environment_context);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $part_name
   * @param bool $deleteData
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_partition_by_name($db_name, $tbl_name, $part_name, $deleteData);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $part_name
   * @param bool $deleteData
   * @param \metastore\EnvironmentContext $environment_context
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, $deleteData, \metastore\EnvironmentContext $environment_context);
  /**
   * @param \metastore\DropPartitionsRequest $req
   * @return \metastore\DropPartitionsResult
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_partitions_req(\metastore\DropPartitionsRequest $req);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @return \metastore\Partition
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partition($db_name, $tbl_name, array $part_vals);
  /**
   * @param array $partitionSpecs
   * @param string $source_db
   * @param string $source_table_name
   * @param string $dest_db
   * @param string $dest_table_name
   * @return \metastore\Partition
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\InvalidInputException
   */
  public function exchange_partition(array $partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @param string $user_name
   * @param string[] $group_names
   * @return \metastore\Partition
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partition_with_auth($db_name, $tbl_name, array $part_vals, $user_name, array $group_names);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $part_name
   * @return \metastore\Partition
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partition_by_name($db_name, $tbl_name, $part_name);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param int $max_parts
   * @return \metastore\Partition[]
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_partitions($db_name, $tbl_name, $max_parts);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param int $max_parts
   * @param string $user_name
   * @param string[] $group_names
   * @return \metastore\Partition[]
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_partitions_with_auth($db_name, $tbl_name, $max_parts, $user_name, array $group_names);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param int $max_parts
   * @return \metastore\PartitionSpec[]
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_partitions_pspec($db_name, $tbl_name, $max_parts);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param int $max_parts
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_partition_names($db_name, $tbl_name, $max_parts);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @param int $max_parts
   * @return \metastore\Partition[]
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partitions_ps($db_name, $tbl_name, array $part_vals, $max_parts);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @param int $max_parts
   * @param string $user_name
   * @param string[] $group_names
   * @return \metastore\Partition[]
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_partitions_ps_with_auth($db_name, $tbl_name, array $part_vals, $max_parts, $user_name, array $group_names);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @param int $max_parts
   * @return string[]
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partition_names_ps($db_name, $tbl_name, array $part_vals, $max_parts);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $filter
   * @param int $max_parts
   * @return \metastore\Partition[]
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partitions_by_filter($db_name, $tbl_name, $filter, $max_parts);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $filter
   * @param int $max_parts
   * @return \metastore\PartitionSpec[]
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_part_specs_by_filter($db_name, $tbl_name, $filter, $max_parts);
  /**
   * @param \metastore\PartitionsByExprRequest $req
   * @return \metastore\PartitionsByExprResult
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partitions_by_expr(\metastore\PartitionsByExprRequest $req);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $names
   * @return \metastore\Partition[]
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partitions_by_names($db_name, $tbl_name, array $names);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param \metastore\Partition $new_part
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_partition($db_name, $tbl_name, \metastore\Partition $new_part);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param \metastore\Partition[] $new_parts
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_partitions($db_name, $tbl_name, array $new_parts);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param \metastore\Partition $new_part
   * @param \metastore\EnvironmentContext $environment_context
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_partition_with_environment_context($db_name, $tbl_name, \metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @param \metastore\Partition $new_part
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function rename_partition($db_name, $tbl_name, array $part_vals, \metastore\Partition $new_part);
  /**
   * @param string[] $part_vals
   * @param bool $throw_exception
   * @return bool
   * @throws \metastore\MetaException
   */
  public function partition_name_has_valid_characters(array $part_vals, $throw_exception);
  /**
   * @param string $name
   * @param string $defaultValue
   * @return string
   * @throws \metastore\ConfigValSecurityException
   */
  public function get_config_value($name, $defaultValue);
  /**
   * @param string $part_name
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function partition_name_to_vals($part_name);
  /**
   * @param string $part_name
   * @return array
   * @throws \metastore\MetaException
   */
  public function partition_name_to_spec($part_name);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param array $part_vals
   * @param int $eventType
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\UnknownDBException
   * @throws \metastore\UnknownTableException
   * @throws \metastore\UnknownPartitionException
   * @throws \metastore\InvalidPartitionException
   */
  public function markPartitionForEvent($db_name, $tbl_name, array $part_vals, $eventType);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param array $part_vals
   * @param int $eventType
   * @return bool
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\UnknownDBException
   * @throws \metastore\UnknownTableException
   * @throws \metastore\UnknownPartitionException
   * @throws \metastore\InvalidPartitionException
   */
  public function isPartitionMarkedForEvent($db_name, $tbl_name, array $part_vals, $eventType);
  /**
   * @param \metastore\Index $new_index
   * @param \metastore\Table $index_table
   * @return \metastore\Index
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function add_index(\metastore\Index $new_index, \metastore\Table $index_table);
  /**
   * @param string $dbname
   * @param string $base_tbl_name
   * @param string $idx_name
   * @param \metastore\Index $new_idx
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_index($dbname, $base_tbl_name, $idx_name, \metastore\Index $new_idx);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $index_name
   * @param bool $deleteData
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_index_by_name($db_name, $tbl_name, $index_name, $deleteData);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $index_name
   * @return \metastore\Index
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_index_by_name($db_name, $tbl_name, $index_name);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param int $max_indexes
   * @return \metastore\Index[]
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_indexes($db_name, $tbl_name, $max_indexes);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param int $max_indexes
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_index_names($db_name, $tbl_name, $max_indexes);
  /**
   * @param \metastore\ColumnStatistics $stats_obj
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidInputException
   */
  public function update_table_column_statistics(\metastore\ColumnStatistics $stats_obj);
  /**
   * @param \metastore\ColumnStatistics $stats_obj
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidInputException
   */
  public function update_partition_column_statistics(\metastore\ColumnStatistics $stats_obj);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $col_name
   * @return \metastore\ColumnStatistics
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidInputException
   * @throws \metastore\InvalidObjectException
   */
  public function get_table_column_statistics($db_name, $tbl_name, $col_name);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $part_name
   * @param string $col_name
   * @return \metastore\ColumnStatistics
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidInputException
   * @throws \metastore\InvalidObjectException
   */
  public function get_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name);
  /**
   * @param \metastore\TableStatsRequest $request
   * @return \metastore\TableStatsResult
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_table_statistics_req(\metastore\TableStatsRequest $request);
  /**
   * @param \metastore\PartitionsStatsRequest $request
   * @return \metastore\PartitionsStatsResult
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_partitions_statistics_req(\metastore\PartitionsStatsRequest $request);
  /**
   * @param \metastore\PartitionsStatsRequest $request
   * @return \metastore\AggrStats
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_aggr_stats_for(\metastore\PartitionsStatsRequest $request);
  /**
   * @param \metastore\SetPartitionsStatsRequest $request
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidInputException
   */
  public function set_aggr_stats_for(\metastore\SetPartitionsStatsRequest $request);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $part_name
   * @param string $col_name
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\InvalidInputException
   */
  public function delete_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $col_name
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\InvalidInputException
   */
  public function delete_table_column_statistics($db_name, $tbl_name, $col_name);
  /**
   * @param \metastore\Function $func
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function create_function(\metastore\Function $func);
  /**
   * @param string $dbName
   * @param string $funcName
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_function($dbName, $funcName);
  /**
   * @param string $dbName
   * @param string $funcName
   * @param \metastore\Function $newFunc
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_function($dbName, $funcName, \metastore\Function $newFunc);
  /**
   * @param string $dbName
   * @param string $pattern
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_functions($dbName, $pattern);
  /**
   * @param string $dbName
   * @param string $funcName
   * @return \metastore\Function
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_function($dbName, $funcName);
  /**
   * @return \metastore\GetAllFunctionsResponse
   * @throws \metastore\MetaException
   */
  public function get_all_functions();
  /**
   * @param \metastore\Role $role
   * @return bool
   * @throws \metastore\MetaException
   */
  public function create_role(\metastore\Role $role);
  /**
   * @param string $role_name
   * @return bool
   * @throws \metastore\MetaException
   */
  public function drop_role($role_name);
  /**
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_role_names();
  /**
   * @param string $role_name
   * @param string $principal_name
   * @param int $principal_type
   * @param string $grantor
   * @param int $grantorType
   * @param bool $grant_option
   * @return bool
   * @throws \metastore\MetaException
   */
  public function grant_role($role_name, $principal_name, $principal_type, $grantor, $grantorType, $grant_option);
  /**
   * @param string $role_name
   * @param string $principal_name
   * @param int $principal_type
   * @return bool
   * @throws \metastore\MetaException
   */
  public function revoke_role($role_name, $principal_name, $principal_type);
  /**
   * @param string $principal_name
   * @param int $principal_type
   * @return \metastore\Role[]
   * @throws \metastore\MetaException
   */
  public function list_roles($principal_name, $principal_type);
  /**
   * @param \metastore\GrantRevokeRoleRequest $request
   * @return \metastore\GrantRevokeRoleResponse
   * @throws \metastore\MetaException
   */
  public function grant_revoke_role(\metastore\GrantRevokeRoleRequest $request);
  /**
   * @param \metastore\GetPrincipalsInRoleRequest $request
   * @return \metastore\GetPrincipalsInRoleResponse
   * @throws \metastore\MetaException
   */
  public function get_principals_in_role(\metastore\GetPrincipalsInRoleRequest $request);
  /**
   * @param \metastore\GetRoleGrantsForPrincipalRequest $request
   * @return \metastore\GetRoleGrantsForPrincipalResponse
   * @throws \metastore\MetaException
   */
  public function get_role_grants_for_principal(\metastore\GetRoleGrantsForPrincipalRequest $request);
  /**
   * @param \metastore\HiveObjectRef $hiveObject
   * @param string $user_name
   * @param string[] $group_names
   * @return \metastore\PrincipalPrivilegeSet
   * @throws \metastore\MetaException
   */
  public function get_privilege_set(\metastore\HiveObjectRef $hiveObject, $user_name, array $group_names);
  /**
   * @param string $principal_name
   * @param int $principal_type
   * @param \metastore\HiveObjectRef $hiveObject
   * @return \metastore\HiveObjectPrivilege[]
   * @throws \metastore\MetaException
   */
  public function list_privileges($principal_name, $principal_type, \metastore\HiveObjectRef $hiveObject);
  /**
   * @param \metastore\PrivilegeBag $privileges
   * @return bool
   * @throws \metastore\MetaException
   */
  public function grant_privileges(\metastore\PrivilegeBag $privileges);
  /**
   * @param \metastore\PrivilegeBag $privileges
   * @return bool
   * @throws \metastore\MetaException
   */
  public function revoke_privileges(\metastore\PrivilegeBag $privileges);
  /**
   * @param \metastore\GrantRevokePrivilegeRequest $request
   * @return \metastore\GrantRevokePrivilegeResponse
   * @throws \metastore\MetaException
   */
  public function grant_revoke_privileges(\metastore\GrantRevokePrivilegeRequest $request);
  /**
   * @param string $user_name
   * @param string[] $group_names
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function set_ugi($user_name, array $group_names);
  /**
   * @param string $token_owner
   * @param string $renewer_kerberos_principal_name
   * @return string
   * @throws \metastore\MetaException
   */
  public function get_delegation_token($token_owner, $renewer_kerberos_principal_name);
  /**
   * @param string $token_str_form
   * @return int
   * @throws \metastore\MetaException
   */
  public function renew_delegation_token($token_str_form);
  /**
   * @param string $token_str_form
   * @throws \metastore\MetaException
   */
  public function cancel_delegation_token($token_str_form);
  /**
   * @return \metastore\GetOpenTxnsResponse
   */
  public function get_open_txns();
  /**
   * @return \metastore\GetOpenTxnsInfoResponse
   */
  public function get_open_txns_info();
  /**
   * @param \metastore\OpenTxnRequest $rqst
   * @return \metastore\OpenTxnsResponse
   */
  public function open_txns(\metastore\OpenTxnRequest $rqst);
  /**
   * @param \metastore\AbortTxnRequest $rqst
   * @throws \metastore\NoSuchTxnException
   */
  public function abort_txn(\metastore\AbortTxnRequest $rqst);
  /**
   * @param \metastore\CommitTxnRequest $rqst
   * @throws \metastore\NoSuchTxnException
   * @throws \metastore\TxnAbortedException
   */
  public function commit_txn(\metastore\CommitTxnRequest $rqst);
  /**
   * @param \metastore\LockRequest $rqst
   * @return \metastore\LockResponse
   * @throws \metastore\NoSuchTxnException
   * @throws \metastore\TxnAbortedException
   */
  public function lock(\metastore\LockRequest $rqst);
  /**
   * @param \metastore\CheckLockRequest $rqst
   * @return \metastore\LockResponse
   * @throws \metastore\NoSuchTxnException
   * @throws \metastore\TxnAbortedException
   * @throws \metastore\NoSuchLockException
   */
  public function check_lock(\metastore\CheckLockRequest $rqst);
  /**
   * @param \metastore\UnlockRequest $rqst
   * @throws \metastore\NoSuchLockException
   * @throws \metastore\TxnOpenException
   */
  public function unlock(\metastore\UnlockRequest $rqst);
  /**
   * @param \metastore\ShowLocksRequest $rqst
   * @return \metastore\ShowLocksResponse
   */
  public function show_locks(\metastore\ShowLocksRequest $rqst);
  /**
   * @param \metastore\HeartbeatRequest $ids
   * @throws \metastore\NoSuchLockException
   * @throws \metastore\NoSuchTxnException
   * @throws \metastore\TxnAbortedException
   */
  public function heartbeat(\metastore\HeartbeatRequest $ids);
  /**
   * @param \metastore\HeartbeatTxnRangeRequest $txns
   * @return \metastore\HeartbeatTxnRangeResponse
   */
  public function heartbeat_txn_range(\metastore\HeartbeatTxnRangeRequest $txns);
  /**
   * @param \metastore\CompactionRequest $rqst
   */
  public function compact(\metastore\CompactionRequest $rqst);
  /**
   * @param \metastore\ShowCompactRequest $rqst
   * @return \metastore\ShowCompactResponse
   */
  public function show_compact(\metastore\ShowCompactRequest $rqst);
  /**
   * @param \metastore\AddDynamicPartitions $rqst
   * @throws \metastore\NoSuchTxnException
   * @throws \metastore\TxnAbortedException
   */
  public function add_dynamic_partitions(\metastore\AddDynamicPartitions $rqst);
  /**
   * @param \metastore\NotificationEventRequest $rqst
   * @return \metastore\NotificationEventResponse
   */
  public function get_next_notification(\metastore\NotificationEventRequest $rqst);
  /**
   * @return \metastore\CurrentNotificationEventId
   */
  public function get_current_notificationEventId();
  /**
   * @param \metastore\FireEventRequest $rqst
   * @return \metastore\FireEventResponse
   */
  public function fire_listener_event(\metastore\FireEventRequest $rqst);
}

class ThriftHiveMetastoreClient extends \FacebookServiceClient implements \metastore\ThriftHiveMetastoreIf {
  public function __construct($input, $output=null) {
    parent::__construct($input, $output);
  }

  public function getMetaConf($key)
  {
    $this->send_getMetaConf($key);
    return $this->recv_getMetaConf();
  }

  public function send_getMetaConf($key)
  {
    $args = new \metastore\ThriftHiveMetastore_getMetaConf_args();
    $args->key = $key;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getMetaConf', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getMetaConf', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getMetaConf()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_getMetaConf_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_getMetaConf_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("getMetaConf failed: unknown result");
  }

  public function setMetaConf($key, $value)
  {
    $this->send_setMetaConf($key, $value);
    $this->recv_setMetaConf();
  }

  public function send_setMetaConf($key, $value)
  {
    $args = new \metastore\ThriftHiveMetastore_setMetaConf_args();
    $args->key = $key;
    $args->value = $value;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'setMetaConf', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('setMetaConf', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_setMetaConf()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_setMetaConf_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_setMetaConf_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    return;
  }

  public function create_database(\metastore\Database $database)
  {
    $this->send_create_database($database);
    $this->recv_create_database();
  }

  public function send_create_database(\metastore\Database $database)
  {
    $args = new \metastore\ThriftHiveMetastore_create_database_args();
    $args->database = $database;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_database', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_database', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_database()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_database_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_database_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function get_database($name)
  {
    $this->send_get_database($name);
    return $this->recv_get_database();
  }

  public function send_get_database($name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_database_args();
    $args->name = $name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_database', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_database', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_database()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_database_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_database_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_database failed: unknown result");
  }

  public function drop_database($name, $deleteData, $cascade)
  {
    $this->send_drop_database($name, $deleteData, $cascade);
    $this->recv_drop_database();
  }

  public function send_drop_database($name, $deleteData, $cascade)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_database_args();
    $args->name = $name;
    $args->deleteData = $deleteData;
    $args->cascade = $cascade;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_database', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_database', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_database()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_database_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_database_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function get_databases($pattern)
  {
    $this->send_get_databases($pattern);
    return $this->recv_get_databases();
  }

  public function send_get_databases($pattern)
  {
    $args = new \metastore\ThriftHiveMetastore_get_databases_args();
    $args->pattern = $pattern;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_databases', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_databases', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_databases()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_databases_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_databases_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_databases failed: unknown result");
  }

  public function get_all_databases()
  {
    $this->send_get_all_databases();
    return $this->recv_get_all_databases();
  }

  public function send_get_all_databases()
  {
    $args = new \metastore\ThriftHiveMetastore_get_all_databases_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_all_databases', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_all_databases', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_all_databases()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_all_databases_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_all_databases_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_all_databases failed: unknown result");
  }

  public function alter_database($dbname, \metastore\Database $db)
  {
    $this->send_alter_database($dbname, $db);
    $this->recv_alter_database();
  }

  public function send_alter_database($dbname, \metastore\Database $db)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_database_args();
    $args->dbname = $dbname;
    $args->db = $db;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_database', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_database', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_database()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_database_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_database_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function get_type($name)
  {
    $this->send_get_type($name);
    return $this->recv_get_type();
  }

  public function send_get_type($name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_type_args();
    $args->name = $name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_type', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_type', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_type()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_type_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_type_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_type failed: unknown result");
  }

  public function create_type(\metastore\Type $type)
  {
    $this->send_create_type($type);
    return $this->recv_create_type();
  }

  public function send_create_type(\metastore\Type $type)
  {
    $args = new \metastore\ThriftHiveMetastore_create_type_args();
    $args->type = $type;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_type', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_type', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_type()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_type_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_type_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("create_type failed: unknown result");
  }

  public function drop_type($type)
  {
    $this->send_drop_type($type);
    return $this->recv_drop_type();
  }

  public function send_drop_type($type)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_type_args();
    $args->type = $type;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_type', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_type', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_type()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_type_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_type_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_type failed: unknown result");
  }

  public function get_type_all($name)
  {
    $this->send_get_type_all($name);
    return $this->recv_get_type_all();
  }

  public function send_get_type_all($name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_type_all_args();
    $args->name = $name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_type_all', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_type_all', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_type_all()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_type_all_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_type_all_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_type_all failed: unknown result");
  }

  public function get_fields($db_name, $table_name)
  {
    $this->send_get_fields($db_name, $table_name);
    return $this->recv_get_fields();
  }

  public function send_get_fields($db_name, $table_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_fields_args();
    $args->db_name = $db_name;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_fields', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_fields', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_fields()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_fields_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_fields_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("get_fields failed: unknown result");
  }

  public function get_fields_with_environment_context($db_name, $table_name, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_get_fields_with_environment_context($db_name, $table_name, $environment_context);
    return $this->recv_get_fields_with_environment_context();
  }

  public function send_get_fields_with_environment_context($db_name, $table_name, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_get_fields_with_environment_context_args();
    $args->db_name = $db_name;
    $args->table_name = $table_name;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_fields_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_fields_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_fields_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_fields_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_fields_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("get_fields_with_environment_context failed: unknown result");
  }

  public function get_schema($db_name, $table_name)
  {
    $this->send_get_schema($db_name, $table_name);
    return $this->recv_get_schema();
  }

  public function send_get_schema($db_name, $table_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_schema_args();
    $args->db_name = $db_name;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_schema', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_schema', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_schema()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_schema_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_schema_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("get_schema failed: unknown result");
  }

  public function get_schema_with_environment_context($db_name, $table_name, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_get_schema_with_environment_context($db_name, $table_name, $environment_context);
    return $this->recv_get_schema_with_environment_context();
  }

  public function send_get_schema_with_environment_context($db_name, $table_name, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_get_schema_with_environment_context_args();
    $args->db_name = $db_name;
    $args->table_name = $table_name;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_schema_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_schema_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_schema_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_schema_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_schema_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("get_schema_with_environment_context failed: unknown result");
  }

  public function create_table(\metastore\Table $tbl)
  {
    $this->send_create_table($tbl);
    $this->recv_create_table();
  }

  public function send_create_table(\metastore\Table $tbl)
  {
    $args = new \metastore\ThriftHiveMetastore_create_table_args();
    $args->tbl = $tbl;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_table', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_table', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_table()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_table_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_table_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    return;
  }

  public function create_table_with_environment_context(\metastore\Table $tbl, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_create_table_with_environment_context($tbl, $environment_context);
    $this->recv_create_table_with_environment_context();
  }

  public function send_create_table_with_environment_context(\metastore\Table $tbl, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_create_table_with_environment_context_args();
    $args->tbl = $tbl;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_table_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_table_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_table_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_table_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_table_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    return;
  }

  public function drop_table($dbname, $name, $deleteData)
  {
    $this->send_drop_table($dbname, $name, $deleteData);
    $this->recv_drop_table();
  }

  public function send_drop_table($dbname, $name, $deleteData)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_table_args();
    $args->dbname = $dbname;
    $args->name = $name;
    $args->deleteData = $deleteData;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_table', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_table', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_table()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_table_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_table_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function drop_table_with_environment_context($dbname, $name, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_drop_table_with_environment_context($dbname, $name, $deleteData, $environment_context);
    $this->recv_drop_table_with_environment_context();
  }

  public function send_drop_table_with_environment_context($dbname, $name, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_table_with_environment_context_args();
    $args->dbname = $dbname;
    $args->name = $name;
    $args->deleteData = $deleteData;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_table_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_table_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_table_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_table_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_table_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function get_tables($db_name, $pattern)
  {
    $this->send_get_tables($db_name, $pattern);
    return $this->recv_get_tables();
  }

  public function send_get_tables($db_name, $pattern)
  {
    $args = new \metastore\ThriftHiveMetastore_get_tables_args();
    $args->db_name = $db_name;
    $args->pattern = $pattern;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_tables', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_tables', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_tables()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_tables_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_tables_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_tables failed: unknown result");
  }

  public function get_all_tables($db_name)
  {
    $this->send_get_all_tables($db_name);
    return $this->recv_get_all_tables();
  }

  public function send_get_all_tables($db_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_all_tables_args();
    $args->db_name = $db_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_all_tables', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_all_tables', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_all_tables()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_all_tables_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_all_tables_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_all_tables failed: unknown result");
  }

  public function get_table($dbname, $tbl_name)
  {
    $this->send_get_table($dbname, $tbl_name);
    return $this->recv_get_table();
  }

  public function send_get_table($dbname, $tbl_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_args();
    $args->dbname = $dbname;
    $args->tbl_name = $tbl_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_table failed: unknown result");
  }

  public function get_table_objects_by_name($dbname, array $tbl_names)
  {
    $this->send_get_table_objects_by_name($dbname, $tbl_names);
    return $this->recv_get_table_objects_by_name();
  }

  public function send_get_table_objects_by_name($dbname, array $tbl_names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_objects_by_name_args();
    $args->dbname = $dbname;
    $args->tbl_names = $tbl_names;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table_objects_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table_objects_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table_objects_by_name()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_objects_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_objects_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("get_table_objects_by_name failed: unknown result");
  }

  public function get_table_names_by_filter($dbname, $filter, $max_tables)
  {
    $this->send_get_table_names_by_filter($dbname, $filter, $max_tables);
    return $this->recv_get_table_names_by_filter();
  }

  public function send_get_table_names_by_filter($dbname, $filter, $max_tables)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_names_by_filter_args();
    $args->dbname = $dbname;
    $args->filter = $filter;
    $args->max_tables = $max_tables;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table_names_by_filter', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table_names_by_filter', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table_names_by_filter()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_names_by_filter_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_names_by_filter_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("get_table_names_by_filter failed: unknown result");
  }

  public function alter_table($dbname, $tbl_name, \metastore\Table $new_tbl)
  {
    $this->send_alter_table($dbname, $tbl_name, $new_tbl);
    $this->recv_alter_table();
  }

  public function send_alter_table($dbname, $tbl_name, \metastore\Table $new_tbl)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_table_args();
    $args->dbname = $dbname;
    $args->tbl_name = $tbl_name;
    $args->new_tbl = $new_tbl;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_table', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_table', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_table()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_table_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_table_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function alter_table_with_environment_context($dbname, $tbl_name, \metastore\Table $new_tbl, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_alter_table_with_environment_context($dbname, $tbl_name, $new_tbl, $environment_context);
    $this->recv_alter_table_with_environment_context();
  }

  public function send_alter_table_with_environment_context($dbname, $tbl_name, \metastore\Table $new_tbl, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_table_with_environment_context_args();
    $args->dbname = $dbname;
    $args->tbl_name = $tbl_name;
    $args->new_tbl = $new_tbl;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_table_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_table_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_table_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_table_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_table_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function alter_table_with_cascade($dbname, $tbl_name, \metastore\Table $new_tbl, $cascade)
  {
    $this->send_alter_table_with_cascade($dbname, $tbl_name, $new_tbl, $cascade);
    $this->recv_alter_table_with_cascade();
  }

  public function send_alter_table_with_cascade($dbname, $tbl_name, \metastore\Table $new_tbl, $cascade)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_table_with_cascade_args();
    $args->dbname = $dbname;
    $args->tbl_name = $tbl_name;
    $args->new_tbl = $new_tbl;
    $args->cascade = $cascade;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_table_with_cascade', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_table_with_cascade', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_table_with_cascade()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_table_with_cascade_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_table_with_cascade_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function add_partition(\metastore\Partition $new_part)
  {
    $this->send_add_partition($new_part);
    return $this->recv_add_partition();
  }

  public function send_add_partition(\metastore\Partition $new_part)
  {
    $args = new \metastore\ThriftHiveMetastore_add_partition_args();
    $args->new_part = $new_part;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_partition()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("add_partition failed: unknown result");
  }

  public function add_partition_with_environment_context(\metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_add_partition_with_environment_context($new_part, $environment_context);
    return $this->recv_add_partition_with_environment_context();
  }

  public function send_add_partition_with_environment_context(\metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_add_partition_with_environment_context_args();
    $args->new_part = $new_part;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_partition_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_partition_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_partition_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_partition_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_partition_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("add_partition_with_environment_context failed: unknown result");
  }

  public function add_partitions(array $new_parts)
  {
    $this->send_add_partitions($new_parts);
    return $this->recv_add_partitions();
  }

  public function send_add_partitions(array $new_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_add_partitions_args();
    $args->new_parts = $new_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_partitions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_partitions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_partitions()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_partitions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_partitions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("add_partitions failed: unknown result");
  }

  public function add_partitions_pspec(array $new_parts)
  {
    $this->send_add_partitions_pspec($new_parts);
    return $this->recv_add_partitions_pspec();
  }

  public function send_add_partitions_pspec(array $new_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_add_partitions_pspec_args();
    $args->new_parts = $new_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_partitions_pspec', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_partitions_pspec', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_partitions_pspec()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_partitions_pspec_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_partitions_pspec_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("add_partitions_pspec failed: unknown result");
  }

  public function append_partition($db_name, $tbl_name, array $part_vals)
  {
    $this->send_append_partition($db_name, $tbl_name, $part_vals);
    return $this->recv_append_partition();
  }

  public function send_append_partition($db_name, $tbl_name, array $part_vals)
  {
    $args = new \metastore\ThriftHiveMetastore_append_partition_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'append_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('append_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_append_partition()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_append_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_append_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("append_partition failed: unknown result");
  }

  public function add_partitions_req(\metastore\AddPartitionsRequest $request)
  {
    $this->send_add_partitions_req($request);
    return $this->recv_add_partitions_req();
  }

  public function send_add_partitions_req(\metastore\AddPartitionsRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_add_partitions_req_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_partitions_req', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_partitions_req', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_partitions_req()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_partitions_req_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_partitions_req_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("add_partitions_req failed: unknown result");
  }

  public function append_partition_with_environment_context($db_name, $tbl_name, array $part_vals, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_append_partition_with_environment_context($db_name, $tbl_name, $part_vals, $environment_context);
    return $this->recv_append_partition_with_environment_context();
  }

  public function send_append_partition_with_environment_context($db_name, $tbl_name, array $part_vals, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_append_partition_with_environment_context_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'append_partition_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('append_partition_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_append_partition_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_append_partition_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_append_partition_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("append_partition_with_environment_context failed: unknown result");
  }

  public function append_partition_by_name($db_name, $tbl_name, $part_name)
  {
    $this->send_append_partition_by_name($db_name, $tbl_name, $part_name);
    return $this->recv_append_partition_by_name();
  }

  public function send_append_partition_by_name($db_name, $tbl_name, $part_name)
  {
    $args = new \metastore\ThriftHiveMetastore_append_partition_by_name_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'append_partition_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('append_partition_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_append_partition_by_name()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_append_partition_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_append_partition_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("append_partition_by_name failed: unknown result");
  }

  public function append_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_append_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, $environment_context);
    return $this->recv_append_partition_by_name_with_environment_context();
  }

  public function send_append_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_append_partition_by_name_with_environment_context_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'append_partition_by_name_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('append_partition_by_name_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_append_partition_by_name_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_append_partition_by_name_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_append_partition_by_name_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("append_partition_by_name_with_environment_context failed: unknown result");
  }

  public function drop_partition($db_name, $tbl_name, array $part_vals, $deleteData)
  {
    $this->send_drop_partition($db_name, $tbl_name, $part_vals, $deleteData);
    return $this->recv_drop_partition();
  }

  public function send_drop_partition($db_name, $tbl_name, array $part_vals, $deleteData)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_partition_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->deleteData = $deleteData;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_partition()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_partition failed: unknown result");
  }

  public function drop_partition_with_environment_context($db_name, $tbl_name, array $part_vals, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_drop_partition_with_environment_context($db_name, $tbl_name, $part_vals, $deleteData, $environment_context);
    return $this->recv_drop_partition_with_environment_context();
  }

  public function send_drop_partition_with_environment_context($db_name, $tbl_name, array $part_vals, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_partition_with_environment_context_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->deleteData = $deleteData;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_partition_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_partition_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_partition_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_partition_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_partition_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_partition_with_environment_context failed: unknown result");
  }

  public function drop_partition_by_name($db_name, $tbl_name, $part_name, $deleteData)
  {
    $this->send_drop_partition_by_name($db_name, $tbl_name, $part_name, $deleteData);
    return $this->recv_drop_partition_by_name();
  }

  public function send_drop_partition_by_name($db_name, $tbl_name, $part_name, $deleteData)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_partition_by_name_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $args->deleteData = $deleteData;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_partition_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_partition_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_partition_by_name()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_partition_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_partition_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_partition_by_name failed: unknown result");
  }

  public function drop_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_drop_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, $deleteData, $environment_context);
    return $this->recv_drop_partition_by_name_with_environment_context();
  }

  public function send_drop_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_partition_by_name_with_environment_context_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $args->deleteData = $deleteData;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_partition_by_name_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_partition_by_name_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_partition_by_name_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_partition_by_name_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_partition_by_name_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_partition_by_name_with_environment_context failed: unknown result");
  }

  public function drop_partitions_req(\metastore\DropPartitionsRequest $req)
  {
    $this->send_drop_partitions_req($req);
    return $this->recv_drop_partitions_req();
  }

  public function send_drop_partitions_req(\metastore\DropPartitionsRequest $req)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_partitions_req_args();
    $args->req = $req;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_partitions_req', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_partitions_req', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_partitions_req()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_partitions_req_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_partitions_req_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_partitions_req failed: unknown result");
  }

  public function get_partition($db_name, $tbl_name, array $part_vals)
  {
    $this->send_get_partition($db_name, $tbl_name, $part_vals);
    return $this->recv_get_partition();
  }

  public function send_get_partition($db_name, $tbl_name, array $part_vals)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partition failed: unknown result");
  }

  public function exchange_partition(array $partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name)
  {
    $this->send_exchange_partition($partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name);
    return $this->recv_exchange_partition();
  }

  public function send_exchange_partition(array $partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name)
  {
    $args = new \metastore\ThriftHiveMetastore_exchange_partition_args();
    $args->partitionSpecs = $partitionSpecs;
    $args->source_db = $source_db;
    $args->source_table_name = $source_table_name;
    $args->dest_db = $dest_db;
    $args->dest_table_name = $dest_table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'exchange_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('exchange_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_exchange_partition()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_exchange_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_exchange_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("exchange_partition failed: unknown result");
  }

  public function get_partition_with_auth($db_name, $tbl_name, array $part_vals, $user_name, array $group_names)
  {
    $this->send_get_partition_with_auth($db_name, $tbl_name, $part_vals, $user_name, $group_names);
    return $this->recv_get_partition_with_auth();
  }

  public function send_get_partition_with_auth($db_name, $tbl_name, array $part_vals, $user_name, array $group_names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_with_auth_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->user_name = $user_name;
    $args->group_names = $group_names;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition_with_auth', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition_with_auth', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition_with_auth()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_with_auth_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_with_auth_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partition_with_auth failed: unknown result");
  }

  public function get_partition_by_name($db_name, $tbl_name, $part_name)
  {
    $this->send_get_partition_by_name($db_name, $tbl_name, $part_name);
    return $this->recv_get_partition_by_name();
  }

  public function send_get_partition_by_name($db_name, $tbl_name, $part_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_by_name_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition_by_name()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partition_by_name failed: unknown result");
  }

  public function get_partitions($db_name, $tbl_name, $max_parts)
  {
    $this->send_get_partitions($db_name, $tbl_name, $max_parts);
    return $this->recv_get_partitions();
  }

  public function send_get_partitions($db_name, $tbl_name, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions failed: unknown result");
  }

  public function get_partitions_with_auth($db_name, $tbl_name, $max_parts, $user_name, array $group_names)
  {
    $this->send_get_partitions_with_auth($db_name, $tbl_name, $max_parts, $user_name, $group_names);
    return $this->recv_get_partitions_with_auth();
  }

  public function send_get_partitions_with_auth($db_name, $tbl_name, $max_parts, $user_name, array $group_names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_with_auth_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_parts = $max_parts;
    $args->user_name = $user_name;
    $args->group_names = $group_names;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_with_auth', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_with_auth', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_with_auth()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_with_auth_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_with_auth_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_with_auth failed: unknown result");
  }

  public function get_partitions_pspec($db_name, $tbl_name, $max_parts)
  {
    $this->send_get_partitions_pspec($db_name, $tbl_name, $max_parts);
    return $this->recv_get_partitions_pspec();
  }

  public function send_get_partitions_pspec($db_name, $tbl_name, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_pspec_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_pspec', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_pspec', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_pspec()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_pspec_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_pspec_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_pspec failed: unknown result");
  }

  public function get_partition_names($db_name, $tbl_name, $max_parts)
  {
    $this->send_get_partition_names($db_name, $tbl_name, $max_parts);
    return $this->recv_get_partition_names();
  }

  public function send_get_partition_names($db_name, $tbl_name, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_names_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition_names', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition_names', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition_names()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_names_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_names_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partition_names failed: unknown result");
  }

  public function get_partitions_ps($db_name, $tbl_name, array $part_vals, $max_parts)
  {
    $this->send_get_partitions_ps($db_name, $tbl_name, $part_vals, $max_parts);
    return $this->recv_get_partitions_ps();
  }

  public function send_get_partitions_ps($db_name, $tbl_name, array $part_vals, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_ps_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_ps', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_ps', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_ps()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_ps_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_ps_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_ps failed: unknown result");
  }

  public function get_partitions_ps_with_auth($db_name, $tbl_name, array $part_vals, $max_parts, $user_name, array $group_names)
  {
    $this->send_get_partitions_ps_with_auth($db_name, $tbl_name, $part_vals, $max_parts, $user_name, $group_names);
    return $this->recv_get_partitions_ps_with_auth();
  }

  public function send_get_partitions_ps_with_auth($db_name, $tbl_name, array $part_vals, $max_parts, $user_name, array $group_names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_ps_with_auth_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->max_parts = $max_parts;
    $args->user_name = $user_name;
    $args->group_names = $group_names;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_ps_with_auth', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_ps_with_auth', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_ps_with_auth()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_ps_with_auth_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_ps_with_auth_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_ps_with_auth failed: unknown result");
  }

  public function get_partition_names_ps($db_name, $tbl_name, array $part_vals, $max_parts)
  {
    $this->send_get_partition_names_ps($db_name, $tbl_name, $part_vals, $max_parts);
    return $this->recv_get_partition_names_ps();
  }

  public function send_get_partition_names_ps($db_name, $tbl_name, array $part_vals, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_names_ps_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition_names_ps', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition_names_ps', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition_names_ps()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_names_ps_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_names_ps_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partition_names_ps failed: unknown result");
  }

  public function get_partitions_by_filter($db_name, $tbl_name, $filter, $max_parts)
  {
    $this->send_get_partitions_by_filter($db_name, $tbl_name, $filter, $max_parts);
    return $this->recv_get_partitions_by_filter();
  }

  public function send_get_partitions_by_filter($db_name, $tbl_name, $filter, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_by_filter_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->filter = $filter;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_by_filter', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_by_filter', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_by_filter()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_by_filter_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_by_filter_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_by_filter failed: unknown result");
  }

  public function get_part_specs_by_filter($db_name, $tbl_name, $filter, $max_parts)
  {
    $this->send_get_part_specs_by_filter($db_name, $tbl_name, $filter, $max_parts);
    return $this->recv_get_part_specs_by_filter();
  }

  public function send_get_part_specs_by_filter($db_name, $tbl_name, $filter, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_part_specs_by_filter_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->filter = $filter;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_part_specs_by_filter', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_part_specs_by_filter', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_part_specs_by_filter()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_part_specs_by_filter_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_part_specs_by_filter_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_part_specs_by_filter failed: unknown result");
  }

  public function get_partitions_by_expr(\metastore\PartitionsByExprRequest $req)
  {
    $this->send_get_partitions_by_expr($req);
    return $this->recv_get_partitions_by_expr();
  }

  public function send_get_partitions_by_expr(\metastore\PartitionsByExprRequest $req)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_by_expr_args();
    $args->req = $req;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_by_expr', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_by_expr', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_by_expr()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_by_expr_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_by_expr_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_by_expr failed: unknown result");
  }

  public function get_partitions_by_names($db_name, $tbl_name, array $names)
  {
    $this->send_get_partitions_by_names($db_name, $tbl_name, $names);
    return $this->recv_get_partitions_by_names();
  }

  public function send_get_partitions_by_names($db_name, $tbl_name, array $names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_by_names_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->names = $names;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_by_names', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_by_names', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_by_names()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_by_names_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_by_names_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_by_names failed: unknown result");
  }

  public function alter_partition($db_name, $tbl_name, \metastore\Partition $new_part)
  {
    $this->send_alter_partition($db_name, $tbl_name, $new_part);
    $this->recv_alter_partition();
  }

  public function send_alter_partition($db_name, $tbl_name, \metastore\Partition $new_part)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_partition_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->new_part = $new_part;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_partition()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function alter_partitions($db_name, $tbl_name, array $new_parts)
  {
    $this->send_alter_partitions($db_name, $tbl_name, $new_parts);
    $this->recv_alter_partitions();
  }

  public function send_alter_partitions($db_name, $tbl_name, array $new_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_partitions_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->new_parts = $new_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_partitions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_partitions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_partitions()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_partitions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_partitions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function alter_partition_with_environment_context($db_name, $tbl_name, \metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_alter_partition_with_environment_context($db_name, $tbl_name, $new_part, $environment_context);
    $this->recv_alter_partition_with_environment_context();
  }

  public function send_alter_partition_with_environment_context($db_name, $tbl_name, \metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_partition_with_environment_context_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->new_part = $new_part;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_partition_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_partition_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_partition_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_partition_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_partition_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function rename_partition($db_name, $tbl_name, array $part_vals, \metastore\Partition $new_part)
  {
    $this->send_rename_partition($db_name, $tbl_name, $part_vals, $new_part);
    $this->recv_rename_partition();
  }

  public function send_rename_partition($db_name, $tbl_name, array $part_vals, \metastore\Partition $new_part)
  {
    $args = new \metastore\ThriftHiveMetastore_rename_partition_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->new_part = $new_part;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'rename_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('rename_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_rename_partition()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_rename_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_rename_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function partition_name_has_valid_characters(array $part_vals, $throw_exception)
  {
    $this->send_partition_name_has_valid_characters($part_vals, $throw_exception);
    return $this->recv_partition_name_has_valid_characters();
  }

  public function send_partition_name_has_valid_characters(array $part_vals, $throw_exception)
  {
    $args = new \metastore\ThriftHiveMetastore_partition_name_has_valid_characters_args();
    $args->part_vals = $part_vals;
    $args->throw_exception = $throw_exception;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'partition_name_has_valid_characters', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('partition_name_has_valid_characters', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_partition_name_has_valid_characters()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_partition_name_has_valid_characters_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_partition_name_has_valid_characters_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("partition_name_has_valid_characters failed: unknown result");
  }

  public function get_config_value($name, $defaultValue)
  {
    $this->send_get_config_value($name, $defaultValue);
    return $this->recv_get_config_value();
  }

  public function send_get_config_value($name, $defaultValue)
  {
    $args = new \metastore\ThriftHiveMetastore_get_config_value_args();
    $args->name = $name;
    $args->defaultValue = $defaultValue;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_config_value', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_config_value', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_config_value()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_config_value_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_config_value_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_config_value failed: unknown result");
  }

  public function partition_name_to_vals($part_name)
  {
    $this->send_partition_name_to_vals($part_name);
    return $this->recv_partition_name_to_vals();
  }

  public function send_partition_name_to_vals($part_name)
  {
    $args = new \metastore\ThriftHiveMetastore_partition_name_to_vals_args();
    $args->part_name = $part_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'partition_name_to_vals', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('partition_name_to_vals', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_partition_name_to_vals()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_partition_name_to_vals_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_partition_name_to_vals_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("partition_name_to_vals failed: unknown result");
  }

  public function partition_name_to_spec($part_name)
  {
    $this->send_partition_name_to_spec($part_name);
    return $this->recv_partition_name_to_spec();
  }

  public function send_partition_name_to_spec($part_name)
  {
    $args = new \metastore\ThriftHiveMetastore_partition_name_to_spec_args();
    $args->part_name = $part_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'partition_name_to_spec', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('partition_name_to_spec', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_partition_name_to_spec()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_partition_name_to_spec_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_partition_name_to_spec_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("partition_name_to_spec failed: unknown result");
  }

  public function markPartitionForEvent($db_name, $tbl_name, array $part_vals, $eventType)
  {
    $this->send_markPartitionForEvent($db_name, $tbl_name, $part_vals, $eventType);
    $this->recv_markPartitionForEvent();
  }

  public function send_markPartitionForEvent($db_name, $tbl_name, array $part_vals, $eventType)
  {
    $args = new \metastore\ThriftHiveMetastore_markPartitionForEvent_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->eventType = $eventType;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'markPartitionForEvent', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('markPartitionForEvent', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_markPartitionForEvent()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_markPartitionForEvent_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_markPartitionForEvent_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    if ($result->o5 !== null) {
      throw $result->o5;
    }
    if ($result->o6 !== null) {
      throw $result->o6;
    }
    return;
  }

  public function isPartitionMarkedForEvent($db_name, $tbl_name, array $part_vals, $eventType)
  {
    $this->send_isPartitionMarkedForEvent($db_name, $tbl_name, $part_vals, $eventType);
    return $this->recv_isPartitionMarkedForEvent();
  }

  public function send_isPartitionMarkedForEvent($db_name, $tbl_name, array $part_vals, $eventType)
  {
    $args = new \metastore\ThriftHiveMetastore_isPartitionMarkedForEvent_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->eventType = $eventType;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'isPartitionMarkedForEvent', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('isPartitionMarkedForEvent', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_isPartitionMarkedForEvent()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_isPartitionMarkedForEvent_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_isPartitionMarkedForEvent_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    if ($result->o5 !== null) {
      throw $result->o5;
    }
    if ($result->o6 !== null) {
      throw $result->o6;
    }
    throw new \Exception("isPartitionMarkedForEvent failed: unknown result");
  }

  public function add_index(\metastore\Index $new_index, \metastore\Table $index_table)
  {
    $this->send_add_index($new_index, $index_table);
    return $this->recv_add_index();
  }

  public function send_add_index(\metastore\Index $new_index, \metastore\Table $index_table)
  {
    $args = new \metastore\ThriftHiveMetastore_add_index_args();
    $args->new_index = $new_index;
    $args->index_table = $index_table;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_index', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_index', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_index()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_index_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_index_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("add_index failed: unknown result");
  }

  public function alter_index($dbname, $base_tbl_name, $idx_name, \metastore\Index $new_idx)
  {
    $this->send_alter_index($dbname, $base_tbl_name, $idx_name, $new_idx);
    $this->recv_alter_index();
  }

  public function send_alter_index($dbname, $base_tbl_name, $idx_name, \metastore\Index $new_idx)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_index_args();
    $args->dbname = $dbname;
    $args->base_tbl_name = $base_tbl_name;
    $args->idx_name = $idx_name;
    $args->new_idx = $new_idx;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_index', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_index', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_index()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_index_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_index_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function drop_index_by_name($db_name, $tbl_name, $index_name, $deleteData)
  {
    $this->send_drop_index_by_name($db_name, $tbl_name, $index_name, $deleteData);
    return $this->recv_drop_index_by_name();
  }

  public function send_drop_index_by_name($db_name, $tbl_name, $index_name, $deleteData)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_index_by_name_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->index_name = $index_name;
    $args->deleteData = $deleteData;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_index_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_index_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_index_by_name()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_index_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_index_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_index_by_name failed: unknown result");
  }

  public function get_index_by_name($db_name, $tbl_name, $index_name)
  {
    $this->send_get_index_by_name($db_name, $tbl_name, $index_name);
    return $this->recv_get_index_by_name();
  }

  public function send_get_index_by_name($db_name, $tbl_name, $index_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_index_by_name_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->index_name = $index_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_index_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_index_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_index_by_name()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_index_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_index_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_index_by_name failed: unknown result");
  }

  public function get_indexes($db_name, $tbl_name, $max_indexes)
  {
    $this->send_get_indexes($db_name, $tbl_name, $max_indexes);
    return $this->recv_get_indexes();
  }

  public function send_get_indexes($db_name, $tbl_name, $max_indexes)
  {
    $args = new \metastore\ThriftHiveMetastore_get_indexes_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_indexes = $max_indexes;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_indexes', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_indexes', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_indexes()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_indexes_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_indexes_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_indexes failed: unknown result");
  }

  public function get_index_names($db_name, $tbl_name, $max_indexes)
  {
    $this->send_get_index_names($db_name, $tbl_name, $max_indexes);
    return $this->recv_get_index_names();
  }

  public function send_get_index_names($db_name, $tbl_name, $max_indexes)
  {
    $args = new \metastore\ThriftHiveMetastore_get_index_names_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_indexes = $max_indexes;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_index_names', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_index_names', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_index_names()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_index_names_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_index_names_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_index_names failed: unknown result");
  }

  public function update_table_column_statistics(\metastore\ColumnStatistics $stats_obj)
  {
    $this->send_update_table_column_statistics($stats_obj);
    return $this->recv_update_table_column_statistics();
  }

  public function send_update_table_column_statistics(\metastore\ColumnStatistics $stats_obj)
  {
    $args = new \metastore\ThriftHiveMetastore_update_table_column_statistics_args();
    $args->stats_obj = $stats_obj;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'update_table_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('update_table_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_update_table_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_update_table_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_update_table_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("update_table_column_statistics failed: unknown result");
  }

  public function update_partition_column_statistics(\metastore\ColumnStatistics $stats_obj)
  {
    $this->send_update_partition_column_statistics($stats_obj);
    return $this->recv_update_partition_column_statistics();
  }

  public function send_update_partition_column_statistics(\metastore\ColumnStatistics $stats_obj)
  {
    $args = new \metastore\ThriftHiveMetastore_update_partition_column_statistics_args();
    $args->stats_obj = $stats_obj;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'update_partition_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('update_partition_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_update_partition_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_update_partition_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_update_partition_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("update_partition_column_statistics failed: unknown result");
  }

  public function get_table_column_statistics($db_name, $tbl_name, $col_name)
  {
    $this->send_get_table_column_statistics($db_name, $tbl_name, $col_name);
    return $this->recv_get_table_column_statistics();
  }

  public function send_get_table_column_statistics($db_name, $tbl_name, $col_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_column_statistics_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->col_name = $col_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("get_table_column_statistics failed: unknown result");
  }

  public function get_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name)
  {
    $this->send_get_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name);
    return $this->recv_get_partition_column_statistics();
  }

  public function send_get_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_column_statistics_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $args->col_name = $col_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("get_partition_column_statistics failed: unknown result");
  }

  public function get_table_statistics_req(\metastore\TableStatsRequest $request)
  {
    $this->send_get_table_statistics_req($request);
    return $this->recv_get_table_statistics_req();
  }

  public function send_get_table_statistics_req(\metastore\TableStatsRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_statistics_req_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table_statistics_req', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table_statistics_req', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table_statistics_req()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_statistics_req_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_statistics_req_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_table_statistics_req failed: unknown result");
  }

  public function get_partitions_statistics_req(\metastore\PartitionsStatsRequest $request)
  {
    $this->send_get_partitions_statistics_req($request);
    return $this->recv_get_partitions_statistics_req();
  }

  public function send_get_partitions_statistics_req(\metastore\PartitionsStatsRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_statistics_req_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_statistics_req', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_statistics_req', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_statistics_req()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_statistics_req_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_statistics_req_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_statistics_req failed: unknown result");
  }

  public function get_aggr_stats_for(\metastore\PartitionsStatsRequest $request)
  {
    $this->send_get_aggr_stats_for($request);
    return $this->recv_get_aggr_stats_for();
  }

  public function send_get_aggr_stats_for(\metastore\PartitionsStatsRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_get_aggr_stats_for_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_aggr_stats_for', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_aggr_stats_for', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_aggr_stats_for()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_aggr_stats_for_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_aggr_stats_for_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_aggr_stats_for failed: unknown result");
  }

  public function set_aggr_stats_for(\metastore\SetPartitionsStatsRequest $request)
  {
    $this->send_set_aggr_stats_for($request);
    return $this->recv_set_aggr_stats_for();
  }

  public function send_set_aggr_stats_for(\metastore\SetPartitionsStatsRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_set_aggr_stats_for_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'set_aggr_stats_for', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('set_aggr_stats_for', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_set_aggr_stats_for()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_set_aggr_stats_for_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_set_aggr_stats_for_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("set_aggr_stats_for failed: unknown result");
  }

  public function delete_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name)
  {
    $this->send_delete_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name);
    return $this->recv_delete_partition_column_statistics();
  }

  public function send_delete_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name)
  {
    $args = new \metastore\ThriftHiveMetastore_delete_partition_column_statistics_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $args->col_name = $col_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'delete_partition_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('delete_partition_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_delete_partition_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_delete_partition_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_delete_partition_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("delete_partition_column_statistics failed: unknown result");
  }

  public function delete_table_column_statistics($db_name, $tbl_name, $col_name)
  {
    $this->send_delete_table_column_statistics($db_name, $tbl_name, $col_name);
    return $this->recv_delete_table_column_statistics();
  }

  public function send_delete_table_column_statistics($db_name, $tbl_name, $col_name)
  {
    $args = new \metastore\ThriftHiveMetastore_delete_table_column_statistics_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->col_name = $col_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'delete_table_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('delete_table_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_delete_table_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_delete_table_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_delete_table_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("delete_table_column_statistics failed: unknown result");
  }

  public function create_function(\metastore\Function $func)
  {
    $this->send_create_function($func);
    $this->recv_create_function();
  }

  public function send_create_function(\metastore\Function $func)
  {
    $args = new \metastore\ThriftHiveMetastore_create_function_args();
    $args->func = $func;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_function', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_function', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_function()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_function_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_function_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    return;
  }

  public function drop_function($dbName, $funcName)
  {
    $this->send_drop_function($dbName, $funcName);
    $this->recv_drop_function();
  }

  public function send_drop_function($dbName, $funcName)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_function_args();
    $args->dbName = $dbName;
    $args->funcName = $funcName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_function', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_function', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_function()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_function_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_function_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function alter_function($dbName, $funcName, \metastore\Function $newFunc)
  {
    $this->send_alter_function($dbName, $funcName, $newFunc);
    $this->recv_alter_function();
  }

  public function send_alter_function($dbName, $funcName, \metastore\Function $newFunc)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_function_args();
    $args->dbName = $dbName;
    $args->funcName = $funcName;
    $args->newFunc = $newFunc;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_function', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_function', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_function()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_function_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_function_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function get_functions($dbName, $pattern)
  {
    $this->send_get_functions($dbName, $pattern);
    return $this->recv_get_functions();
  }

  public function send_get_functions($dbName, $pattern)
  {
    $args = new \metastore\ThriftHiveMetastore_get_functions_args();
    $args->dbName = $dbName;
    $args->pattern = $pattern;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_functions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_functions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_functions()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_functions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_functions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_functions failed: unknown result");
  }

  public function get_function($dbName, $funcName)
  {
    $this->send_get_function($dbName, $funcName);
    return $this->recv_get_function();
  }

  public function send_get_function($dbName, $funcName)
  {
    $args = new \metastore\ThriftHiveMetastore_get_function_args();
    $args->dbName = $dbName;
    $args->funcName = $funcName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_function', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_function', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_function()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_function_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_function_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_function failed: unknown result");
  }

  public function get_all_functions()
  {
    $this->send_get_all_functions();
    return $this->recv_get_all_functions();
  }

  public function send_get_all_functions()
  {
    $args = new \metastore\ThriftHiveMetastore_get_all_functions_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_all_functions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_all_functions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_all_functions()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_all_functions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_all_functions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_all_functions failed: unknown result");
  }

  public function create_role(\metastore\Role $role)
  {
    $this->send_create_role($role);
    return $this->recv_create_role();
  }

  public function send_create_role(\metastore\Role $role)
  {
    $args = new \metastore\ThriftHiveMetastore_create_role_args();
    $args->role = $role;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_role', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_role', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_role()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_role_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_role_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("create_role failed: unknown result");
  }

  public function drop_role($role_name)
  {
    $this->send_drop_role($role_name);
    return $this->recv_drop_role();
  }

  public function send_drop_role($role_name)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_role_args();
    $args->role_name = $role_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_role', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_role', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_role()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_role_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_role_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("drop_role failed: unknown result");
  }

  public function get_role_names()
  {
    $this->send_get_role_names();
    return $this->recv_get_role_names();
  }

  public function send_get_role_names()
  {
    $args = new \metastore\ThriftHiveMetastore_get_role_names_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_role_names', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_role_names', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_role_names()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_role_names_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_role_names_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_role_names failed: unknown result");
  }

  public function grant_role($role_name, $principal_name, $principal_type, $grantor, $grantorType, $grant_option)
  {
    $this->send_grant_role($role_name, $principal_name, $principal_type, $grantor, $grantorType, $grant_option);
    return $this->recv_grant_role();
  }

  public function send_grant_role($role_name, $principal_name, $principal_type, $grantor, $grantorType, $grant_option)
  {
    $args = new \metastore\ThriftHiveMetastore_grant_role_args();
    $args->role_name = $role_name;
    $args->principal_name = $principal_name;
    $args->principal_type = $principal_type;
    $args->grantor = $grantor;
    $args->grantorType = $grantorType;
    $args->grant_option = $grant_option;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'grant_role', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('grant_role', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_grant_role()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_grant_role_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_grant_role_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("grant_role failed: unknown result");
  }

  public function revoke_role($role_name, $principal_name, $principal_type)
  {
    $this->send_revoke_role($role_name, $principal_name, $principal_type);
    return $this->recv_revoke_role();
  }

  public function send_revoke_role($role_name, $principal_name, $principal_type)
  {
    $args = new \metastore\ThriftHiveMetastore_revoke_role_args();
    $args->role_name = $role_name;
    $args->principal_name = $principal_name;
    $args->principal_type = $principal_type;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'revoke_role', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('revoke_role', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_revoke_role()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_revoke_role_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_revoke_role_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("revoke_role failed: unknown result");
  }

  public function list_roles($principal_name, $principal_type)
  {
    $this->send_list_roles($principal_name, $principal_type);
    return $this->recv_list_roles();
  }

  public function send_list_roles($principal_name, $principal_type)
  {
    $args = new \metastore\ThriftHiveMetastore_list_roles_args();
    $args->principal_name = $principal_name;
    $args->principal_type = $principal_type;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'list_roles', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('list_roles', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_list_roles()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_list_roles_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_list_roles_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("list_roles failed: unknown result");
  }

  public function grant_revoke_role(\metastore\GrantRevokeRoleRequest $request)
  {
    $this->send_grant_revoke_role($request);
    return $this->recv_grant_revoke_role();
  }

  public function send_grant_revoke_role(\metastore\GrantRevokeRoleRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_grant_revoke_role_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'grant_revoke_role', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('grant_revoke_role', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_grant_revoke_role()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_grant_revoke_role_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_grant_revoke_role_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("grant_revoke_role failed: unknown result");
  }

  public function get_principals_in_role(\metastore\GetPrincipalsInRoleRequest $request)
  {
    $this->send_get_principals_in_role($request);
    return $this->recv_get_principals_in_role();
  }

  public function send_get_principals_in_role(\metastore\GetPrincipalsInRoleRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_get_principals_in_role_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_principals_in_role', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_principals_in_role', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_principals_in_role()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_principals_in_role_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_principals_in_role_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_principals_in_role failed: unknown result");
  }

  public function get_role_grants_for_principal(\metastore\GetRoleGrantsForPrincipalRequest $request)
  {
    $this->send_get_role_grants_for_principal($request);
    return $this->recv_get_role_grants_for_principal();
  }

  public function send_get_role_grants_for_principal(\metastore\GetRoleGrantsForPrincipalRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_get_role_grants_for_principal_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_role_grants_for_principal', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_role_grants_for_principal', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_role_grants_for_principal()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_role_grants_for_principal_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_role_grants_for_principal_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_role_grants_for_principal failed: unknown result");
  }

  public function get_privilege_set(\metastore\HiveObjectRef $hiveObject, $user_name, array $group_names)
  {
    $this->send_get_privilege_set($hiveObject, $user_name, $group_names);
    return $this->recv_get_privilege_set();
  }

  public function send_get_privilege_set(\metastore\HiveObjectRef $hiveObject, $user_name, array $group_names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_privilege_set_args();
    $args->hiveObject = $hiveObject;
    $args->user_name = $user_name;
    $args->group_names = $group_names;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_privilege_set', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_privilege_set', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_privilege_set()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_privilege_set_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_privilege_set_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_privilege_set failed: unknown result");
  }

  public function list_privileges($principal_name, $principal_type, \metastore\HiveObjectRef $hiveObject)
  {
    $this->send_list_privileges($principal_name, $principal_type, $hiveObject);
    return $this->recv_list_privileges();
  }

  public function send_list_privileges($principal_name, $principal_type, \metastore\HiveObjectRef $hiveObject)
  {
    $args = new \metastore\ThriftHiveMetastore_list_privileges_args();
    $args->principal_name = $principal_name;
    $args->principal_type = $principal_type;
    $args->hiveObject = $hiveObject;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'list_privileges', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('list_privileges', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_list_privileges()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_list_privileges_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_list_privileges_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("list_privileges failed: unknown result");
  }

  public function grant_privileges(\metastore\PrivilegeBag $privileges)
  {
    $this->send_grant_privileges($privileges);
    return $this->recv_grant_privileges();
  }

  public function send_grant_privileges(\metastore\PrivilegeBag $privileges)
  {
    $args = new \metastore\ThriftHiveMetastore_grant_privileges_args();
    $args->privileges = $privileges;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'grant_privileges', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('grant_privileges', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_grant_privileges()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_grant_privileges_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_grant_privileges_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("grant_privileges failed: unknown result");
  }

  public function revoke_privileges(\metastore\PrivilegeBag $privileges)
  {
    $this->send_revoke_privileges($privileges);
    return $this->recv_revoke_privileges();
  }

  public function send_revoke_privileges(\metastore\PrivilegeBag $privileges)
  {
    $args = new \metastore\ThriftHiveMetastore_revoke_privileges_args();
    $args->privileges = $privileges;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'revoke_privileges', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('revoke_privileges', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_revoke_privileges()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_revoke_privileges_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_revoke_privileges_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("revoke_privileges failed: unknown result");
  }

  public function grant_revoke_privileges(\metastore\GrantRevokePrivilegeRequest $request)
  {
    $this->send_grant_revoke_privileges($request);
    return $this->recv_grant_revoke_privileges();
  }

  public function send_grant_revoke_privileges(\metastore\GrantRevokePrivilegeRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_grant_revoke_privileges_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'grant_revoke_privileges', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('grant_revoke_privileges', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_grant_revoke_privileges()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_grant_revoke_privileges_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_grant_revoke_privileges_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("grant_revoke_privileges failed: unknown result");
  }

  public function set_ugi($user_name, array $group_names)
  {
    $this->send_set_ugi($user_name, $group_names);
    return $this->recv_set_ugi();
  }

  public function send_set_ugi($user_name, array $group_names)
  {
    $args = new \metastore\ThriftHiveMetastore_set_ugi_args();
    $args->user_name = $user_name;
    $args->group_names = $group_names;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'set_ugi', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('set_ugi', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_set_ugi()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_set_ugi_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_set_ugi_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("set_ugi failed: unknown result");
  }

  public function get_delegation_token($token_owner, $renewer_kerberos_principal_name)
  {
    $this->send_get_delegation_token($token_owner, $renewer_kerberos_principal_name);
    return $this->recv_get_delegation_token();
  }

  public function send_get_delegation_token($token_owner, $renewer_kerberos_principal_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_delegation_token_args();
    $args->token_owner = $token_owner;
    $args->renewer_kerberos_principal_name = $renewer_kerberos_principal_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_delegation_token', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_delegation_token', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_delegation_token()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_delegation_token_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_delegation_token_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_delegation_token failed: unknown result");
  }

  public function renew_delegation_token($token_str_form)
  {
    $this->send_renew_delegation_token($token_str_form);
    return $this->recv_renew_delegation_token();
  }

  public function send_renew_delegation_token($token_str_form)
  {
    $args = new \metastore\ThriftHiveMetastore_renew_delegation_token_args();
    $args->token_str_form = $token_str_form;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'renew_delegation_token', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('renew_delegation_token', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_renew_delegation_token()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_renew_delegation_token_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_renew_delegation_token_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("renew_delegation_token failed: unknown result");
  }

  public function cancel_delegation_token($token_str_form)
  {
    $this->send_cancel_delegation_token($token_str_form);
    $this->recv_cancel_delegation_token();
  }

  public function send_cancel_delegation_token($token_str_form)
  {
    $args = new \metastore\ThriftHiveMetastore_cancel_delegation_token_args();
    $args->token_str_form = $token_str_form;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'cancel_delegation_token', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('cancel_delegation_token', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_cancel_delegation_token()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_cancel_delegation_token_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_cancel_delegation_token_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    return;
  }

  public function get_open_txns()
  {
    $this->send_get_open_txns();
    return $this->recv_get_open_txns();
  }

  public function send_get_open_txns()
  {
    $args = new \metastore\ThriftHiveMetastore_get_open_txns_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_open_txns', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_open_txns', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_open_txns()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_open_txns_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_open_txns_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("get_open_txns failed: unknown result");
  }

  public function get_open_txns_info()
  {
    $this->send_get_open_txns_info();
    return $this->recv_get_open_txns_info();
  }

  public function send_get_open_txns_info()
  {
    $args = new \metastore\ThriftHiveMetastore_get_open_txns_info_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_open_txns_info', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_open_txns_info', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_open_txns_info()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_open_txns_info_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_open_txns_info_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("get_open_txns_info failed: unknown result");
  }

  public function open_txns(\metastore\OpenTxnRequest $rqst)
  {
    $this->send_open_txns($rqst);
    return $this->recv_open_txns();
  }

  public function send_open_txns(\metastore\OpenTxnRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_open_txns_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'open_txns', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('open_txns', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_open_txns()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_open_txns_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_open_txns_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("open_txns failed: unknown result");
  }

  public function abort_txn(\metastore\AbortTxnRequest $rqst)
  {
    $this->send_abort_txn($rqst);
    $this->recv_abort_txn();
  }

  public function send_abort_txn(\metastore\AbortTxnRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_abort_txn_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'abort_txn', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('abort_txn', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_abort_txn()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_abort_txn_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_abort_txn_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    return;
  }

  public function commit_txn(\metastore\CommitTxnRequest $rqst)
  {
    $this->send_commit_txn($rqst);
    $this->recv_commit_txn();
  }

  public function send_commit_txn(\metastore\CommitTxnRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_commit_txn_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'commit_txn', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('commit_txn', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_commit_txn()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_commit_txn_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_commit_txn_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function lock(\metastore\LockRequest $rqst)
  {
    $this->send_lock($rqst);
    return $this->recv_lock();
  }

  public function send_lock(\metastore\LockRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_lock_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'lock', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('lock', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_lock()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_lock_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_lock_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("lock failed: unknown result");
  }

  public function check_lock(\metastore\CheckLockRequest $rqst)
  {
    $this->send_check_lock($rqst);
    return $this->recv_check_lock();
  }

  public function send_check_lock(\metastore\CheckLockRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_check_lock_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'check_lock', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('check_lock', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_check_lock()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_check_lock_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_check_lock_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("check_lock failed: unknown result");
  }

  public function unlock(\metastore\UnlockRequest $rqst)
  {
    $this->send_unlock($rqst);
    $this->recv_unlock();
  }

  public function send_unlock(\metastore\UnlockRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_unlock_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'unlock', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('unlock', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_unlock()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_unlock_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_unlock_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function show_locks(\metastore\ShowLocksRequest $rqst)
  {
    $this->send_show_locks($rqst);
    return $this->recv_show_locks();
  }

  public function send_show_locks(\metastore\ShowLocksRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_show_locks_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'show_locks', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('show_locks', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_show_locks()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_show_locks_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_show_locks_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("show_locks failed: unknown result");
  }

  public function heartbeat(\metastore\HeartbeatRequest $ids)
  {
    $this->send_heartbeat($ids);
    $this->recv_heartbeat();
  }

  public function send_heartbeat(\metastore\HeartbeatRequest $ids)
  {
    $args = new \metastore\ThriftHiveMetastore_heartbeat_args();
    $args->ids = $ids;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'heartbeat', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('heartbeat', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_heartbeat()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_heartbeat_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_heartbeat_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function heartbeat_txn_range(\metastore\HeartbeatTxnRangeRequest $txns)
  {
    $this->send_heartbeat_txn_range($txns);
    return $this->recv_heartbeat_txn_range();
  }

  public function send_heartbeat_txn_range(\metastore\HeartbeatTxnRangeRequest $txns)
  {
    $args = new \metastore\ThriftHiveMetastore_heartbeat_txn_range_args();
    $args->txns = $txns;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'heartbeat_txn_range', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('heartbeat_txn_range', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_heartbeat_txn_range()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_heartbeat_txn_range_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_heartbeat_txn_range_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("heartbeat_txn_range failed: unknown result");
  }

  public function compact(\metastore\CompactionRequest $rqst)
  {
    $this->send_compact($rqst);
    $this->recv_compact();
  }

  public function send_compact(\metastore\CompactionRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_compact_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'compact', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('compact', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_compact()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_compact_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_compact_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    return;
  }

  public function show_compact(\metastore\ShowCompactRequest $rqst)
  {
    $this->send_show_compact($rqst);
    return $this->recv_show_compact();
  }

  public function send_show_compact(\metastore\ShowCompactRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_show_compact_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'show_compact', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('show_compact', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_show_compact()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_show_compact_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_show_compact_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("show_compact failed: unknown result");
  }

  public function add_dynamic_partitions(\metastore\AddDynamicPartitions $rqst)
  {
    $this->send_add_dynamic_partitions($rqst);
    $this->recv_add_dynamic_partitions();
  }

  public function send_add_dynamic_partitions(\metastore\AddDynamicPartitions $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_add_dynamic_partitions_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_dynamic_partitions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_dynamic_partitions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_dynamic_partitions()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_dynamic_partitions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_dynamic_partitions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function get_next_notification(\metastore\NotificationEventRequest $rqst)
  {
    $this->send_get_next_notification($rqst);
    return $this->recv_get_next_notification();
  }

  public function send_get_next_notification(\metastore\NotificationEventRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_get_next_notification_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_next_notification', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_next_notification', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_next_notification()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_next_notification_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_next_notification_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("get_next_notification failed: unknown result");
  }

  public function get_current_notificationEventId()
  {
    $this->send_get_current_notificationEventId();
    return $this->recv_get_current_notificationEventId();
  }

  public function send_get_current_notificationEventId()
  {
    $args = new \metastore\ThriftHiveMetastore_get_current_notificationEventId_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_current_notificationEventId', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_current_notificationEventId', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_current_notificationEventId()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_current_notificationEventId_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_current_notificationEventId_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("get_current_notificationEventId failed: unknown result");
  }

  public function fire_listener_event(\metastore\FireEventRequest $rqst)
  {
    $this->send_fire_listener_event($rqst);
    return $this->recv_fire_listener_event();
  }

  public function send_fire_listener_event(\metastore\FireEventRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_fire_listener_event_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'fire_listener_event', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('fire_listener_event', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_fire_listener_event()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_fire_listener_event_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_fire_listener_event_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("fire_listener_event failed: unknown result");
  }

}

// HELPER FUNCTIONS AND STRUCTURES

class ThriftHiveMetastore_getMetaConf_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $key = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'key',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['key'])) {
        $this->key = $vals['key'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_getMetaConf_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->key);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_getMetaConf_args');
    if ($this->key !== null) {
      $xfer += $output->writeFieldBegin('key', TType::STRING, 1);
      $xfer += $output->writeString($this->key);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_getMetaConf_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_getMetaConf_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_getMetaConf_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_setMetaConf_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $key = null;
  /**
   * @var string
   */
  public $value = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'key',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'value',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['key'])) {
        $this->key = $vals['key'];
      }
      if (isset($vals['value'])) {
        $this->value = $vals['value'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_setMetaConf_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->key);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->value);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_setMetaConf_args');
    if ($this->key !== null) {
      $xfer += $output->writeFieldBegin('key', TType::STRING, 1);
      $xfer += $output->writeString($this->key);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->value !== null) {
      $xfer += $output->writeFieldBegin('value', TType::STRING, 2);
      $xfer += $output->writeString($this->value);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_setMetaConf_result {
  static $_TSPEC;

  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_setMetaConf_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_setMetaConf_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_database_args {
  static $_TSPEC;

  /**
   * @var \metastore\Database
   */
  public $database = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'database',
          'type' => TType::STRUCT,
          'class' => '\metastore\Database',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['database'])) {
        $this->database = $vals['database'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_database_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->database = new \metastore\Database();
            $xfer += $this->database->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_database_args');
    if ($this->database !== null) {
      if (!is_object($this->database)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('database', TType::STRUCT, 1);
      $xfer += $this->database->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_database_result {
  static $_TSPEC;

  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_database_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\AlreadyExistsException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_database_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_database_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_database_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_database_args');
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 1);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_database_result {
  static $_TSPEC;

  /**
   * @var \metastore\Database
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Database',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_database_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Database();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_database_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_database_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $name = null;
  /**
   * @var bool
   */
  public $deleteData = null;
  /**
   * @var bool
   */
  public $cascade = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        3 => array(
          'var' => 'cascade',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
      if (isset($vals['cascade'])) {
        $this->cascade = $vals['cascade'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_database_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->cascade);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_database_args');
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 1);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 2);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cascade !== null) {
      $xfer += $output->writeFieldBegin('cascade', TType::BOOL, 3);
      $xfer += $output->writeBool($this->cascade);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_database_result {
  static $_TSPEC;

  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidOperationException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_database_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidOperationException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_database_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_databases_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $pattern = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'pattern',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['pattern'])) {
        $this->pattern = $vals['pattern'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_databases_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->pattern);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_databases_args');
    if ($this->pattern !== null) {
      $xfer += $output->writeFieldBegin('pattern', TType::STRING, 1);
      $xfer += $output->writeString($this->pattern);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_databases_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_databases_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size472 = 0;
            $_etype475 = 0;
            $xfer += $input->readListBegin($_etype475, $_size472);
            for ($_i476 = 0; $_i476 < $_size472; ++$_i476)
            {
              $elem477 = null;
              $xfer += $input->readString($elem477);
              $this->success []= $elem477;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_databases_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter478)
          {
            $xfer += $output->writeString($iter478);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_all_databases_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_all_databases_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_all_databases_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_all_databases_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_all_databases_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size479 = 0;
            $_etype482 = 0;
            $xfer += $input->readListBegin($_etype482, $_size479);
            for ($_i483 = 0; $_i483 < $_size479; ++$_i483)
            {
              $elem484 = null;
              $xfer += $input->readString($elem484);
              $this->success []= $elem484;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_all_databases_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter485)
          {
            $xfer += $output->writeString($iter485);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_database_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var \metastore\Database
   */
  public $db = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'db',
          'type' => TType::STRUCT,
          'class' => '\metastore\Database',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['db'])) {
        $this->db = $vals['db'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_database_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->db = new \metastore\Database();
            $xfer += $this->db->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_database_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->db !== null) {
      if (!is_object($this->db)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('db', TType::STRUCT, 2);
      $xfer += $this->db->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_database_result {
  static $_TSPEC;

  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_database_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_database_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_type_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_type_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_type_args');
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 1);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_type_result {
  static $_TSPEC;

  /**
   * @var \metastore\Type
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Type',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_type_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Type();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_type_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_type_args {
  static $_TSPEC;

  /**
   * @var \metastore\Type
   */
  public $type = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'type',
          'type' => TType::STRUCT,
          'class' => '\metastore\Type',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['type'])) {
        $this->type = $vals['type'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_type_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->type = new \metastore\Type();
            $xfer += $this->type->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_type_args');
    if ($this->type !== null) {
      if (!is_object($this->type)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('type', TType::STRUCT, 1);
      $xfer += $this->type->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_type_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_type_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\AlreadyExistsException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_type_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_type_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $type = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'type',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['type'])) {
        $this->type = $vals['type'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_type_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->type);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_type_args');
    if ($this->type !== null) {
      $xfer += $output->writeFieldBegin('type', TType::STRING, 1);
      $xfer += $output->writeString($this->type);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_type_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_type_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_type_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_type_all_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_type_all_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_type_all_args');
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 1);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_type_all_result {
  static $_TSPEC;

  /**
   * @var array
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRUCT,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Type',
            ),
          ),
        1 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_type_all_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::MAP) {
            $this->success = array();
            $_size486 = 0;
            $_ktype487 = 0;
            $_vtype488 = 0;
            $xfer += $input->readMapBegin($_ktype487, $_vtype488, $_size486);
            for ($_i490 = 0; $_i490 < $_size486; ++$_i490)
            {
              $key491 = '';
              $val492 = new \metastore\Type();
              $xfer += $input->readString($key491);
              $val492 = new \metastore\Type();
              $xfer += $val492->read($input);
              $this->success[$key491] = $val492;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_type_all_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::MAP, 0);
      {
        $output->writeMapBegin(TType::STRING, TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $kiter493 => $viter494)
          {
            $xfer += $output->writeString($kiter493);
            $xfer += $viter494->write($output);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 1);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_fields_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_fields_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_fields_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_fields_result {
  static $_TSPEC;

  /**
   * @var \metastore\FieldSchema[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\UnknownTableException
   */
  public $o2 = null;
  /**
   * @var \metastore\UnknownDBException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\FieldSchema',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownTableException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_fields_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size495 = 0;
            $_etype498 = 0;
            $xfer += $input->readListBegin($_etype498, $_size495);
            for ($_i499 = 0; $_i499 < $_size495; ++$_i499)
            {
              $elem500 = null;
              $elem500 = new \metastore\FieldSchema();
              $xfer += $elem500->read($input);
              $this->success []= $elem500;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\UnknownTableException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_fields_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter501)
          {
            $xfer += $iter501->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_fields_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_fields_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_fields_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 3);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_fields_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\FieldSchema[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\UnknownTableException
   */
  public $o2 = null;
  /**
   * @var \metastore\UnknownDBException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\FieldSchema',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownTableException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_fields_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size502 = 0;
            $_etype505 = 0;
            $xfer += $input->readListBegin($_etype505, $_size502);
            for ($_i506 = 0; $_i506 < $_size502; ++$_i506)
            {
              $elem507 = null;
              $elem507 = new \metastore\FieldSchema();
              $xfer += $elem507->read($input);
              $this->success []= $elem507;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\UnknownTableException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_fields_with_environment_context_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter508)
          {
            $xfer += $iter508->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_schema_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_schema_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_schema_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_schema_result {
  static $_TSPEC;

  /**
   * @var \metastore\FieldSchema[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\UnknownTableException
   */
  public $o2 = null;
  /**
   * @var \metastore\UnknownDBException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\FieldSchema',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownTableException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_schema_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size509 = 0;
            $_etype512 = 0;
            $xfer += $input->readListBegin($_etype512, $_size509);
            for ($_i513 = 0; $_i513 < $_size509; ++$_i513)
            {
              $elem514 = null;
              $elem514 = new \metastore\FieldSchema();
              $xfer += $elem514->read($input);
              $this->success []= $elem514;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\UnknownTableException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_schema_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter515)
          {
            $xfer += $iter515->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_schema_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_schema_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_schema_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 3);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_schema_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\FieldSchema[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\UnknownTableException
   */
  public $o2 = null;
  /**
   * @var \metastore\UnknownDBException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\FieldSchema',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownTableException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_schema_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size516 = 0;
            $_etype519 = 0;
            $xfer += $input->readListBegin($_etype519, $_size516);
            for ($_i520 = 0; $_i520 < $_size516; ++$_i520)
            {
              $elem521 = null;
              $elem521 = new \metastore\FieldSchema();
              $xfer += $elem521->read($input);
              $this->success []= $elem521;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\UnknownTableException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_schema_with_environment_context_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter522)
          {
            $xfer += $iter522->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_table_args {
  static $_TSPEC;

  /**
   * @var \metastore\Table
   */
  public $tbl = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tbl',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tbl'])) {
        $this->tbl = $vals['tbl'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_table_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->tbl = new \metastore\Table();
            $xfer += $this->tbl->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_table_args');
    if ($this->tbl !== null) {
      if (!is_object($this->tbl)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('tbl', TType::STRUCT, 1);
      $xfer += $this->tbl->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_table_result {
  static $_TSPEC;

  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_table_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\AlreadyExistsException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\NoSuchObjectException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_table_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_table_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var \metastore\Table
   */
  public $tbl = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tbl',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        2 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tbl'])) {
        $this->tbl = $vals['tbl'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_table_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->tbl = new \metastore\Table();
            $xfer += $this->tbl->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_table_with_environment_context_args');
    if ($this->tbl !== null) {
      if (!is_object($this->tbl)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('tbl', TType::STRUCT, 1);
      $xfer += $this->tbl->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 2);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_table_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_table_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\AlreadyExistsException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\NoSuchObjectException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_table_with_environment_context_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_table_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string
   */
  public $name = null;
  /**
   * @var bool
   */
  public $deleteData = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_table_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_table_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 2);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 3);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_table_result {
  static $_TSPEC;

  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_table_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_table_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 2);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_table_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string
   */
  public $name = null;
  /**
   * @var bool
   */
  public $deleteData = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        4 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_table_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_table_with_environment_context_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 2);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 3);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 4);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_table_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_table_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_table_with_environment_context_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 2);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_tables_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $pattern = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'pattern',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['pattern'])) {
        $this->pattern = $vals['pattern'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_tables_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->pattern);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_tables_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->pattern !== null) {
      $xfer += $output->writeFieldBegin('pattern', TType::STRING, 2);
      $xfer += $output->writeString($this->pattern);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_tables_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_tables_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size523 = 0;
            $_etype526 = 0;
            $xfer += $input->readListBegin($_etype526, $_size523);
            for ($_i527 = 0; $_i527 < $_size523; ++$_i527)
            {
              $elem528 = null;
              $xfer += $input->readString($elem528);
              $this->success []= $elem528;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_tables_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter529)
          {
            $xfer += $output->writeString($iter529);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_all_tables_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_all_tables_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_all_tables_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_all_tables_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_all_tables_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size530 = 0;
            $_etype533 = 0;
            $xfer += $input->readListBegin($_etype533, $_size530);
            for ($_i534 = 0; $_i534 < $_size530; ++$_i534)
            {
              $elem535 = null;
              $xfer += $input->readString($elem535);
              $this->success []= $elem535;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_all_tables_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter536)
          {
            $xfer += $output->writeString($iter536);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string
   */
  public $tbl_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_result {
  static $_TSPEC;

  /**
   * @var \metastore\Table
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Table();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_objects_by_name_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string[]
   */
  public $tbl_names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['tbl_names'])) {
        $this->tbl_names = $vals['tbl_names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_objects_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->tbl_names = array();
            $_size537 = 0;
            $_etype540 = 0;
            $xfer += $input->readListBegin($_etype540, $_size537);
            for ($_i541 = 0; $_i541 < $_size537; ++$_i541)
            {
              $elem542 = null;
              $xfer += $input->readString($elem542);
              $this->tbl_names []= $elem542;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_objects_by_name_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_names !== null) {
      if (!is_array($this->tbl_names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('tbl_names', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRING, count($this->tbl_names));
        {
          foreach ($this->tbl_names as $iter543)
          {
            $xfer += $output->writeString($iter543);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_objects_by_name_result {
  static $_TSPEC;

  /**
   * @var \metastore\Table[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidOperationException
   */
  public $o2 = null;
  /**
   * @var \metastore\UnknownDBException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Table',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_objects_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size544 = 0;
            $_etype547 = 0;
            $xfer += $input->readListBegin($_etype547, $_size544);
            for ($_i548 = 0; $_i548 < $_size544; ++$_i548)
            {
              $elem549 = null;
              $elem549 = new \metastore\Table();
              $xfer += $elem549->read($input);
              $this->success []= $elem549;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidOperationException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_objects_by_name_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter550)
          {
            $xfer += $iter550->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_names_by_filter_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string
   */
  public $filter = null;
  /**
   * @var int
   */
  public $max_tables = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'filter',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_tables',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['filter'])) {
        $this->filter = $vals['filter'];
      }
      if (isset($vals['max_tables'])) {
        $this->max_tables = $vals['max_tables'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_names_by_filter_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->filter);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_tables);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_names_by_filter_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filter !== null) {
      $xfer += $output->writeFieldBegin('filter', TType::STRING, 2);
      $xfer += $output->writeString($this->filter);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_tables !== null) {
      $xfer += $output->writeFieldBegin('max_tables', TType::I16, 3);
      $xfer += $output->writeI16($this->max_tables);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_names_by_filter_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidOperationException
   */
  public $o2 = null;
  /**
   * @var \metastore\UnknownDBException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_names_by_filter_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size551 = 0;
            $_etype554 = 0;
            $xfer += $input->readListBegin($_etype554, $_size551);
            for ($_i555 = 0; $_i555 < $_size551; ++$_i555)
            {
              $elem556 = null;
              $xfer += $input->readString($elem556);
              $this->success []= $elem556;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidOperationException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_names_by_filter_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter557)
          {
            $xfer += $output->writeString($iter557);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_table_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var \metastore\Table
   */
  public $new_tbl = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_tbl',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_tbl'])) {
        $this->new_tbl = $vals['new_tbl'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_table_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->new_tbl = new \metastore\Table();
            $xfer += $this->new_tbl->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_table_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_tbl !== null) {
      if (!is_object($this->new_tbl)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_tbl', TType::STRUCT, 3);
      $xfer += $this->new_tbl->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_table_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_table_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_table_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_table_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var \metastore\Table
   */
  public $new_tbl = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_tbl',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        4 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_tbl'])) {
        $this->new_tbl = $vals['new_tbl'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_table_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->new_tbl = new \metastore\Table();
            $xfer += $this->new_tbl->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_table_with_environment_context_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_tbl !== null) {
      if (!is_object($this->new_tbl)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_tbl', TType::STRUCT, 3);
      $xfer += $this->new_tbl->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 4);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_table_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_table_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_table_with_environment_context_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_table_with_cascade_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var \metastore\Table
   */
  public $new_tbl = null;
  /**
   * @var bool
   */
  public $cascade = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_tbl',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        4 => array(
          'var' => 'cascade',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_tbl'])) {
        $this->new_tbl = $vals['new_tbl'];
      }
      if (isset($vals['cascade'])) {
        $this->cascade = $vals['cascade'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_table_with_cascade_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->new_tbl = new \metastore\Table();
            $xfer += $this->new_tbl->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->cascade);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_table_with_cascade_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_tbl !== null) {
      if (!is_object($this->new_tbl)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_tbl', TType::STRUCT, 3);
      $xfer += $this->new_tbl->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cascade !== null) {
      $xfer += $output->writeFieldBegin('cascade', TType::BOOL, 4);
      $xfer += $output->writeBool($this->cascade);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_table_with_cascade_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_table_with_cascade_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_table_with_cascade_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partition_args {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $new_part = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'new_part',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['new_part'])) {
        $this->new_part = $vals['new_part'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->new_part = new \metastore\Partition();
            $xfer += $this->new_part->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partition_args');
    if ($this->new_part !== null) {
      if (!is_object($this->new_part)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_part', TType::STRUCT, 1);
      $xfer += $this->new_part->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partition_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partition_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partition_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $new_part = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'new_part',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        2 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['new_part'])) {
        $this->new_part = $vals['new_part'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partition_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->new_part = new \metastore\Partition();
            $xfer += $this->new_part->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partition_with_environment_context_args');
    if ($this->new_part !== null) {
      if (!is_object($this->new_part)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_part', TType::STRUCT, 1);
      $xfer += $this->new_part->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 2);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partition_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partition_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partition_with_environment_context_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partitions_args {
  static $_TSPEC;

  /**
   * @var \metastore\Partition[]
   */
  public $new_parts = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'new_parts',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['new_parts'])) {
        $this->new_parts = $vals['new_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partitions_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::LST) {
            $this->new_parts = array();
            $_size558 = 0;
            $_etype561 = 0;
            $xfer += $input->readListBegin($_etype561, $_size558);
            for ($_i562 = 0; $_i562 < $_size558; ++$_i562)
            {
              $elem563 = null;
              $elem563 = new \metastore\Partition();
              $xfer += $elem563->read($input);
              $this->new_parts []= $elem563;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partitions_args');
    if ($this->new_parts !== null) {
      if (!is_array($this->new_parts)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_parts', TType::LST, 1);
      {
        $output->writeListBegin(TType::STRUCT, count($this->new_parts));
        {
          foreach ($this->new_parts as $iter564)
          {
            $xfer += $iter564->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partitions_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I32,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partitions_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partitions_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partitions_pspec_args {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionSpec[]
   */
  public $new_parts = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'new_parts',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\PartitionSpec',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['new_parts'])) {
        $this->new_parts = $vals['new_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partitions_pspec_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::LST) {
            $this->new_parts = array();
            $_size565 = 0;
            $_etype568 = 0;
            $xfer += $input->readListBegin($_etype568, $_size565);
            for ($_i569 = 0; $_i569 < $_size565; ++$_i569)
            {
              $elem570 = null;
              $elem570 = new \metastore\PartitionSpec();
              $xfer += $elem570->read($input);
              $this->new_parts []= $elem570;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partitions_pspec_args');
    if ($this->new_parts !== null) {
      if (!is_array($this->new_parts)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_parts', TType::LST, 1);
      {
        $output->writeListBegin(TType::STRUCT, count($this->new_parts));
        {
          foreach ($this->new_parts as $iter571)
          {
            $xfer += $iter571->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partitions_pspec_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I32,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partitions_pspec_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partitions_pspec_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size572 = 0;
            $_etype575 = 0;
            $xfer += $input->readListBegin($_etype575, $_size572);
            for ($_i576 = 0; $_i576 < $_size572; ++$_i576)
            {
              $elem577 = null;
              $xfer += $input->readString($elem577);
              $this->part_vals []= $elem577;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter578)
          {
            $xfer += $output->writeString($iter578);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partitions_req_args {
  static $_TSPEC;

  /**
   * @var \metastore\AddPartitionsRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\AddPartitionsRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partitions_req_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\AddPartitionsRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partitions_req_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partitions_req_result {
  static $_TSPEC;

  /**
   * @var \metastore\AddPartitionsResult
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\AddPartitionsResult',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partitions_req_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\AddPartitionsResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partitions_req_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size579 = 0;
            $_etype582 = 0;
            $xfer += $input->readListBegin($_etype582, $_size579);
            for ($_i583 = 0; $_i583 < $_size579; ++$_i583)
            {
              $elem584 = null;
              $xfer += $input->readString($elem584);
              $this->part_vals []= $elem584;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter585)
          {
            $xfer += $output->writeString($iter585);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 4);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_with_environment_context_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_by_name_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $part_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_by_name_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_by_name_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_by_name_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_by_name_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $part_name = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_by_name_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_by_name_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 4);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_by_name_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_by_name_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_by_name_with_environment_context_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var bool
   */
  public $deleteData = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size586 = 0;
            $_etype589 = 0;
            $xfer += $input->readListBegin($_etype589, $_size586);
            for ($_i590 = 0; $_i590 < $_size586; ++$_i590)
            {
              $elem591 = null;
              $xfer += $input->readString($elem591);
              $this->part_vals []= $elem591;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter592)
          {
            $xfer += $output->writeString($iter592);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 4);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var bool
   */
  public $deleteData = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        5 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size593 = 0;
            $_etype596 = 0;
            $xfer += $input->readListBegin($_etype596, $_size593);
            for ($_i597 = 0; $_i597 < $_size593; ++$_i597)
            {
              $elem598 = null;
              $xfer += $input->readString($elem598);
              $this->part_vals []= $elem598;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter599)
          {
            $xfer += $output->writeString($iter599);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 4);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 5);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_with_environment_context_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_by_name_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $part_name = null;
  /**
   * @var bool
   */
  public $deleteData = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_by_name_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 4);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_by_name_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_by_name_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_by_name_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $part_name = null;
  /**
   * @var bool
   */
  public $deleteData = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        5 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_by_name_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_by_name_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 4);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 5);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_by_name_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_by_name_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_by_name_with_environment_context_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partitions_req_args {
  static $_TSPEC;

  /**
   * @var \metastore\DropPartitionsRequest
   */
  public $req = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'req',
          'type' => TType::STRUCT,
          'class' => '\metastore\DropPartitionsRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['req'])) {
        $this->req = $vals['req'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partitions_req_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->req = new \metastore\DropPartitionsRequest();
            $xfer += $this->req->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partitions_req_args');
    if ($this->req !== null) {
      if (!is_object($this->req)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('req', TType::STRUCT, 1);
      $xfer += $this->req->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partitions_req_result {
  static $_TSPEC;

  /**
   * @var \metastore\DropPartitionsResult
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\DropPartitionsResult',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partitions_req_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\DropPartitionsResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partitions_req_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size600 = 0;
            $_etype603 = 0;
            $xfer += $input->readListBegin($_etype603, $_size600);
            for ($_i604 = 0; $_i604 < $_size600; ++$_i604)
            {
              $elem605 = null;
              $xfer += $input->readString($elem605);
              $this->part_vals []= $elem605;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter606)
          {
            $xfer += $output->writeString($iter606);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_exchange_partition_args {
  static $_TSPEC;

  /**
   * @var array
   */
  public $partitionSpecs = null;
  /**
   * @var string
   */
  public $source_db = null;
  /**
   * @var string
   */
  public $source_table_name = null;
  /**
   * @var string
   */
  public $dest_db = null;
  /**
   * @var string
   */
  public $dest_table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'partitionSpecs',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        2 => array(
          'var' => 'source_db',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'source_table_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'dest_db',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'dest_table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['partitionSpecs'])) {
        $this->partitionSpecs = $vals['partitionSpecs'];
      }
      if (isset($vals['source_db'])) {
        $this->source_db = $vals['source_db'];
      }
      if (isset($vals['source_table_name'])) {
        $this->source_table_name = $vals['source_table_name'];
      }
      if (isset($vals['dest_db'])) {
        $this->dest_db = $vals['dest_db'];
      }
      if (isset($vals['dest_table_name'])) {
        $this->dest_table_name = $vals['dest_table_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_exchange_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::MAP) {
            $this->partitionSpecs = array();
            $_size607 = 0;
            $_ktype608 = 0;
            $_vtype609 = 0;
            $xfer += $input->readMapBegin($_ktype608, $_vtype609, $_size607);
            for ($_i611 = 0; $_i611 < $_size607; ++$_i611)
            {
              $key612 = '';
              $val613 = '';
              $xfer += $input->readString($key612);
              $xfer += $input->readString($val613);
              $this->partitionSpecs[$key612] = $val613;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->source_db);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->source_table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dest_db);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dest_table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_exchange_partition_args');
    if ($this->partitionSpecs !== null) {
      if (!is_array($this->partitionSpecs)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('partitionSpecs', TType::MAP, 1);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->partitionSpecs));
        {
          foreach ($this->partitionSpecs as $kiter614 => $viter615)
          {
            $xfer += $output->writeString($kiter614);
            $xfer += $output->writeString($viter615);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->source_db !== null) {
      $xfer += $output->writeFieldBegin('source_db', TType::STRING, 2);
      $xfer += $output->writeString($this->source_db);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->source_table_name !== null) {
      $xfer += $output->writeFieldBegin('source_table_name', TType::STRING, 3);
      $xfer += $output->writeString($this->source_table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->dest_db !== null) {
      $xfer += $output->writeFieldBegin('dest_db', TType::STRING, 4);
      $xfer += $output->writeString($this->dest_db);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->dest_table_name !== null) {
      $xfer += $output->writeFieldBegin('dest_table_name', TType::STRING, 5);
      $xfer += $output->writeString($this->dest_table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_exchange_partition_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o3 = null;
  /**
   * @var \metastore\InvalidInputException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_exchange_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\InvalidObjectException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidInputException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_exchange_partition_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_with_auth_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var string
   */
  public $user_name = null;
  /**
   * @var string[]
   */
  public $group_names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'user_name',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'group_names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['user_name'])) {
        $this->user_name = $vals['user_name'];
      }
      if (isset($vals['group_names'])) {
        $this->group_names = $vals['group_names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_with_auth_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size616 = 0;
            $_etype619 = 0;
            $xfer += $input->readListBegin($_etype619, $_size616);
            for ($_i620 = 0; $_i620 < $_size616; ++$_i620)
            {
              $elem621 = null;
              $xfer += $input->readString($elem621);
              $this->part_vals []= $elem621;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->user_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::LST) {
            $this->group_names = array();
            $_size622 = 0;
            $_etype625 = 0;
            $xfer += $input->readListBegin($_etype625, $_size622);
            for ($_i626 = 0; $_i626 < $_size622; ++$_i626)
            {
              $elem627 = null;
              $xfer += $input->readString($elem627);
              $this->group_names []= $elem627;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_with_auth_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter628)
          {
            $xfer += $output->writeString($iter628);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->user_name !== null) {
      $xfer += $output->writeFieldBegin('user_name', TType::STRING, 4);
      $xfer += $output->writeString($this->user_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->group_names !== null) {
      if (!is_array($this->group_names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('group_names', TType::LST, 5);
      {
        $output->writeListBegin(TType::STRING, count($this->group_names));
        {
          foreach ($this->group_names as $iter629)
          {
            $xfer += $output->writeString($iter629);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_with_auth_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_with_auth_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_with_auth_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_by_name_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $part_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_by_name_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_by_name_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_by_name_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var int
   */
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 3);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition[]
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size630 = 0;
            $_etype633 = 0;
            $xfer += $input->readListBegin($_etype633, $_size630);
            for ($_i634 = 0; $_i634 < $_size630; ++$_i634)
            {
              $elem635 = null;
              $elem635 = new \metastore\Partition();
              $xfer += $elem635->read($input);
              $this->success []= $elem635;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter636)
          {
            $xfer += $iter636->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_with_auth_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var int
   */
  public $max_parts = -1;
  /**
   * @var string
   */
  public $user_name = null;
  /**
   * @var string[]
   */
  public $group_names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        4 => array(
          'var' => 'user_name',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'group_names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
      if (isset($vals['user_name'])) {
        $this->user_name = $vals['user_name'];
      }
      if (isset($vals['group_names'])) {
        $this->group_names = $vals['group_names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_with_auth_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->user_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::LST) {
            $this->group_names = array();
            $_size637 = 0;
            $_etype640 = 0;
            $xfer += $input->readListBegin($_etype640, $_size637);
            for ($_i641 = 0; $_i641 < $_size637; ++$_i641)
            {
              $elem642 = null;
              $xfer += $input->readString($elem642);
              $this->group_names []= $elem642;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_with_auth_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 3);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->user_name !== null) {
      $xfer += $output->writeFieldBegin('user_name', TType::STRING, 4);
      $xfer += $output->writeString($this->user_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->group_names !== null) {
      if (!is_array($this->group_names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('group_names', TType::LST, 5);
      {
        $output->writeListBegin(TType::STRING, count($this->group_names));
        {
          foreach ($this->group_names as $iter643)
          {
            $xfer += $output->writeString($iter643);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_with_auth_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition[]
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_with_auth_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size644 = 0;
            $_etype647 = 0;
            $xfer += $input->readListBegin($_etype647, $_size644);
            for ($_i648 = 0; $_i648 < $_size644; ++$_i648)
            {
              $elem649 = null;
              $elem649 = new \metastore\Partition();
              $xfer += $elem649->read($input);
              $this->success []= $elem649;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_with_auth_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter650)
          {
            $xfer += $iter650->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_pspec_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var int
   */
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_parts',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_pspec_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_pspec_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I32, 3);
      $xfer += $output->writeI32($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_pspec_result {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionSpec[]
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\PartitionSpec',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_pspec_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size651 = 0;
            $_etype654 = 0;
            $xfer += $input->readListBegin($_etype654, $_size651);
            for ($_i655 = 0; $_i655 < $_size651; ++$_i655)
            {
              $elem656 = null;
              $elem656 = new \metastore\PartitionSpec();
              $xfer += $elem656->read($input);
              $this->success []= $elem656;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_pspec_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter657)
          {
            $xfer += $iter657->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_names_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var int
   */
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_names_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_names_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 3);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_names_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_names_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size658 = 0;
            $_etype661 = 0;
            $xfer += $input->readListBegin($_etype661, $_size658);
            for ($_i662 = 0; $_i662 < $_size658; ++$_i662)
            {
              $elem663 = null;
              $xfer += $input->readString($elem663);
              $this->success []= $elem663;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_names_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter664)
          {
            $xfer += $output->writeString($iter664);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 1);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_ps_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var int
   */
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_ps_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size665 = 0;
            $_etype668 = 0;
            $xfer += $input->readListBegin($_etype668, $_size665);
            for ($_i669 = 0; $_i669 < $_size665; ++$_i669)
            {
              $elem670 = null;
              $xfer += $input->readString($elem670);
              $this->part_vals []= $elem670;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_ps_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter671)
          {
            $xfer += $output->writeString($iter671);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 4);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_ps_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_ps_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size672 = 0;
            $_etype675 = 0;
            $xfer += $input->readListBegin($_etype675, $_size672);
            for ($_i676 = 0; $_i676 < $_size672; ++$_i676)
            {
              $elem677 = null;
              $elem677 = new \metastore\Partition();
              $xfer += $elem677->read($input);
              $this->success []= $elem677;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_ps_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter678)
          {
            $xfer += $iter678->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_ps_with_auth_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var int
   */
  public $max_parts = -1;
  /**
   * @var string
   */
  public $user_name = null;
  /**
   * @var string[]
   */
  public $group_names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        5 => array(
          'var' => 'user_name',
          'type' => TType::STRING,
          ),
        6 => array(
          'var' => 'group_names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
      if (isset($vals['user_name'])) {
        $this->user_name = $vals['user_name'];
      }
      if (isset($vals['group_names'])) {
        $this->group_names = $vals['group_names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_ps_with_auth_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size679 = 0;
            $_etype682 = 0;
            $xfer += $input->readListBegin($_etype682, $_size679);
            for ($_i683 = 0; $_i683 < $_size679; ++$_i683)
            {
              $elem684 = null;
              $xfer += $input->readString($elem684);
              $this->part_vals []= $elem684;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->user_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::LST) {
            $this->group_names = array();
            $_size685 = 0;
            $_etype688 = 0;
            $xfer += $input->readListBegin($_etype688, $_size685);
            for ($_i689 = 0; $_i689 < $_size685; ++$_i689)
            {
              $elem690 = null;
              $xfer += $input->readString($elem690);
              $this->group_names []= $elem690;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_ps_with_auth_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter691)
          {
            $xfer += $output->writeString($iter691);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 4);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->user_name !== null) {
      $xfer += $output->writeFieldBegin('user_name', TType::STRING, 5);
      $xfer += $output->writeString($this->user_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->group_names !== null) {
      if (!is_array($this->group_names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('group_names', TType::LST, 6);
      {
        $output->writeListBegin(TType::STRING, count($this->group_names));
        {
          foreach ($this->group_names as $iter692)
          {
            $xfer += $output->writeString($iter692);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_ps_with_auth_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition[]
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_ps_with_auth_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size693 = 0;
            $_etype696 = 0;
            $xfer += $input->readListBegin($_etype696, $_size693);
            for ($_i697 = 0; $_i697 < $_size693; ++$_i697)
            {
              $elem698 = null;
              $elem698 = new \metastore\Partition();
              $xfer += $elem698->read($input);
              $this->success []= $elem698;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_ps_with_auth_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter699)
          {
            $xfer += $iter699->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_names_ps_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var int
   */
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_names_ps_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size700 = 0;
            $_etype703 = 0;
            $xfer += $input->readListBegin($_etype703, $_size700);
            for ($_i704 = 0; $_i704 < $_size700; ++$_i704)
            {
              $elem705 = null;
              $xfer += $input->readString($elem705);
              $this->part_vals []= $elem705;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_names_ps_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter706)
          {
            $xfer += $output->writeString($iter706);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 4);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_names_ps_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_names_ps_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size707 = 0;
            $_etype710 = 0;
            $xfer += $input->readListBegin($_etype710, $_size707);
            for ($_i711 = 0; $_i711 < $_size707; ++$_i711)
            {
              $elem712 = null;
              $xfer += $input->readString($elem712);
              $this->success []= $elem712;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_names_ps_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter713)
          {
            $xfer += $output->writeString($iter713);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_by_filter_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $filter = null;
  /**
   * @var int
   */
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'filter',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['filter'])) {
        $this->filter = $vals['filter'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_by_filter_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->filter);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_by_filter_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filter !== null) {
      $xfer += $output->writeFieldBegin('filter', TType::STRING, 3);
      $xfer += $output->writeString($this->filter);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 4);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_by_filter_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_by_filter_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size714 = 0;
            $_etype717 = 0;
            $xfer += $input->readListBegin($_etype717, $_size714);
            for ($_i718 = 0; $_i718 < $_size714; ++$_i718)
            {
              $elem719 = null;
              $elem719 = new \metastore\Partition();
              $xfer += $elem719->read($input);
              $this->success []= $elem719;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_by_filter_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter720)
          {
            $xfer += $iter720->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_part_specs_by_filter_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $filter = null;
  /**
   * @var int
   */
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'filter',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'max_parts',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['filter'])) {
        $this->filter = $vals['filter'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_part_specs_by_filter_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->filter);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_part_specs_by_filter_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filter !== null) {
      $xfer += $output->writeFieldBegin('filter', TType::STRING, 3);
      $xfer += $output->writeString($this->filter);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I32, 4);
      $xfer += $output->writeI32($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_part_specs_by_filter_result {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionSpec[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\PartitionSpec',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_part_specs_by_filter_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size721 = 0;
            $_etype724 = 0;
            $xfer += $input->readListBegin($_etype724, $_size721);
            for ($_i725 = 0; $_i725 < $_size721; ++$_i725)
            {
              $elem726 = null;
              $elem726 = new \metastore\PartitionSpec();
              $xfer += $elem726->read($input);
              $this->success []= $elem726;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_part_specs_by_filter_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter727)
          {
            $xfer += $iter727->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_by_expr_args {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionsByExprRequest
   */
  public $req = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'req',
          'type' => TType::STRUCT,
          'class' => '\metastore\PartitionsByExprRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['req'])) {
        $this->req = $vals['req'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_by_expr_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->req = new \metastore\PartitionsByExprRequest();
            $xfer += $this->req->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_by_expr_args');
    if ($this->req !== null) {
      if (!is_object($this->req)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('req', TType::STRUCT, 1);
      $xfer += $this->req->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_by_expr_result {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionsByExprResult
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\PartitionsByExprResult',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_by_expr_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\PartitionsByExprResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_by_expr_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_by_names_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['names'])) {
        $this->names = $vals['names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_by_names_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->names = array();
            $_size728 = 0;
            $_etype731 = 0;
            $xfer += $input->readListBegin($_etype731, $_size728);
            for ($_i732 = 0; $_i732 < $_size728; ++$_i732)
            {
              $elem733 = null;
              $xfer += $input->readString($elem733);
              $this->names []= $elem733;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_by_names_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->names !== null) {
      if (!is_array($this->names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('names', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->names));
        {
          foreach ($this->names as $iter734)
          {
            $xfer += $output->writeString($iter734);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_by_names_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_by_names_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size735 = 0;
            $_etype738 = 0;
            $xfer += $input->readListBegin($_etype738, $_size735);
            for ($_i739 = 0; $_i739 < $_size735; ++$_i739)
            {
              $elem740 = null;
              $elem740 = new \metastore\Partition();
              $xfer += $elem740->read($input);
              $this->success []= $elem740;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_by_names_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter741)
          {
            $xfer += $iter741->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partition_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var \metastore\Partition
   */
  public $new_part = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_part',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_part'])) {
        $this->new_part = $vals['new_part'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->new_part = new \metastore\Partition();
            $xfer += $this->new_part->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partition_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_part !== null) {
      if (!is_object($this->new_part)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_part', TType::STRUCT, 3);
      $xfer += $this->new_part->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partition_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partition_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partitions_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var \metastore\Partition[]
   */
  public $new_parts = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_parts',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_parts'])) {
        $this->new_parts = $vals['new_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partitions_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->new_parts = array();
            $_size742 = 0;
            $_etype745 = 0;
            $xfer += $input->readListBegin($_etype745, $_size742);
            for ($_i746 = 0; $_i746 < $_size742; ++$_i746)
            {
              $elem747 = null;
              $elem747 = new \metastore\Partition();
              $xfer += $elem747->read($input);
              $this->new_parts []= $elem747;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partitions_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_parts !== null) {
      if (!is_array($this->new_parts)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_parts', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRUCT, count($this->new_parts));
        {
          foreach ($this->new_parts as $iter748)
          {
            $xfer += $iter748->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partitions_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partitions_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partitions_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partition_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var \metastore\Partition
   */
  public $new_part = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_part',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        4 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_part'])) {
        $this->new_part = $vals['new_part'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partition_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->new_part = new \metastore\Partition();
            $xfer += $this->new_part->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partition_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_part !== null) {
      if (!is_object($this->new_part)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_part', TType::STRUCT, 3);
      $xfer += $this->new_part->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 4);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partition_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partition_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partition_with_environment_context_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_rename_partition_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var \metastore\Partition
   */
  public $new_part = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'new_part',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['new_part'])) {
        $this->new_part = $vals['new_part'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_rename_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size749 = 0;
            $_etype752 = 0;
            $xfer += $input->readListBegin($_etype752, $_size749);
            for ($_i753 = 0; $_i753 < $_size749; ++$_i753)
            {
              $elem754 = null;
              $xfer += $input->readString($elem754);
              $this->part_vals []= $elem754;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->new_part = new \metastore\Partition();
            $xfer += $this->new_part->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_rename_partition_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter755)
          {
            $xfer += $output->writeString($iter755);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_part !== null) {
      if (!is_object($this->new_part)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_part', TType::STRUCT, 4);
      $xfer += $this->new_part->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_rename_partition_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_rename_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_rename_partition_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_has_valid_characters_args {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var bool
   */
  public $throw_exception = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        2 => array(
          'var' => 'throw_exception',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['throw_exception'])) {
        $this->throw_exception = $vals['throw_exception'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_has_valid_characters_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size756 = 0;
            $_etype759 = 0;
            $xfer += $input->readListBegin($_etype759, $_size756);
            for ($_i760 = 0; $_i760 < $_size756; ++$_i760)
            {
              $elem761 = null;
              $xfer += $input->readString($elem761);
              $this->part_vals []= $elem761;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->throw_exception);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_has_valid_characters_args');
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 1);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter762)
          {
            $xfer += $output->writeString($iter762);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->throw_exception !== null) {
      $xfer += $output->writeFieldBegin('throw_exception', TType::BOOL, 2);
      $xfer += $output->writeBool($this->throw_exception);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_has_valid_characters_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_has_valid_characters_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_has_valid_characters_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_config_value_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $name = null;
  /**
   * @var string
   */
  public $defaultValue = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'defaultValue',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['defaultValue'])) {
        $this->defaultValue = $vals['defaultValue'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_config_value_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->defaultValue);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_config_value_args');
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 1);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->defaultValue !== null) {
      $xfer += $output->writeFieldBegin('defaultValue', TType::STRING, 2);
      $xfer += $output->writeString($this->defaultValue);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_config_value_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \metastore\ConfigValSecurityException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\ConfigValSecurityException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_config_value_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\ConfigValSecurityException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_config_value_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_to_vals_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $part_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_to_vals_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_to_vals_args');
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 1);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_to_vals_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_to_vals_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size763 = 0;
            $_etype766 = 0;
            $xfer += $input->readListBegin($_etype766, $_size763);
            for ($_i767 = 0; $_i767 < $_size763; ++$_i767)
            {
              $elem768 = null;
              $xfer += $input->readString($elem768);
              $this->success []= $elem768;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_to_vals_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter769)
          {
            $xfer += $output->writeString($iter769);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_to_spec_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $part_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_to_spec_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_to_spec_args');
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 1);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_to_spec_result {
  static $_TSPEC;

  /**
   * @var array
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_to_spec_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::MAP) {
            $this->success = array();
            $_size770 = 0;
            $_ktype771 = 0;
            $_vtype772 = 0;
            $xfer += $input->readMapBegin($_ktype771, $_vtype772, $_size770);
            for ($_i774 = 0; $_i774 < $_size770; ++$_i774)
            {
              $key775 = '';
              $val776 = '';
              $xfer += $input->readString($key775);
              $xfer += $input->readString($val776);
              $this->success[$key775] = $val776;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_to_spec_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::MAP, 0);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->success));
        {
          foreach ($this->success as $kiter777 => $viter778)
          {
            $xfer += $output->writeString($kiter777);
            $xfer += $output->writeString($viter778);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_markPartitionForEvent_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var array
   */
  public $part_vals = null;
  /**
   * @var int
   */
  public $eventType = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'eventType',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['eventType'])) {
        $this->eventType = $vals['eventType'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_markPartitionForEvent_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::MAP) {
            $this->part_vals = array();
            $_size779 = 0;
            $_ktype780 = 0;
            $_vtype781 = 0;
            $xfer += $input->readMapBegin($_ktype780, $_vtype781, $_size779);
            for ($_i783 = 0; $_i783 < $_size779; ++$_i783)
            {
              $key784 = '';
              $val785 = '';
              $xfer += $input->readString($key784);
              $xfer += $input->readString($val785);
              $this->part_vals[$key784] = $val785;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->eventType);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_markPartitionForEvent_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::MAP, 3);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $kiter786 => $viter787)
          {
            $xfer += $output->writeString($kiter786);
            $xfer += $output->writeString($viter787);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->eventType !== null) {
      $xfer += $output->writeFieldBegin('eventType', TType::I32, 4);
      $xfer += $output->writeI32($this->eventType);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_markPartitionForEvent_result {
  static $_TSPEC;

  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\UnknownDBException
   */
  public $o3 = null;
  /**
   * @var \metastore\UnknownTableException
   */
  public $o4 = null;
  /**
   * @var \metastore\UnknownPartitionException
   */
  public $o5 = null;
  /**
   * @var \metastore\InvalidPartitionException
   */
  public $o6 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownTableException',
          ),
        5 => array(
          'var' => 'o5',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownPartitionException',
          ),
        6 => array(
          'var' => 'o6',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidPartitionException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
      if (isset($vals['o5'])) {
        $this->o5 = $vals['o5'];
      }
      if (isset($vals['o6'])) {
        $this->o6 = $vals['o6'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_markPartitionForEvent_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\UnknownTableException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->o5 = new \metastore\UnknownPartitionException();
            $xfer += $this->o5->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::STRUCT) {
            $this->o6 = new \metastore\InvalidPartitionException();
            $xfer += $this->o6->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_markPartitionForEvent_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o5 !== null) {
      $xfer += $output->writeFieldBegin('o5', TType::STRUCT, 5);
      $xfer += $this->o5->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o6 !== null) {
      $xfer += $output->writeFieldBegin('o6', TType::STRUCT, 6);
      $xfer += $this->o6->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_isPartitionMarkedForEvent_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var array
   */
  public $part_vals = null;
  /**
   * @var int
   */
  public $eventType = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'eventType',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['eventType'])) {
        $this->eventType = $vals['eventType'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_isPartitionMarkedForEvent_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::MAP) {
            $this->part_vals = array();
            $_size788 = 0;
            $_ktype789 = 0;
            $_vtype790 = 0;
            $xfer += $input->readMapBegin($_ktype789, $_vtype790, $_size788);
            for ($_i792 = 0; $_i792 < $_size788; ++$_i792)
            {
              $key793 = '';
              $val794 = '';
              $xfer += $input->readString($key793);
              $xfer += $input->readString($val794);
              $this->part_vals[$key793] = $val794;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->eventType);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_isPartitionMarkedForEvent_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::MAP, 3);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $kiter795 => $viter796)
          {
            $xfer += $output->writeString($kiter795);
            $xfer += $output->writeString($viter796);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->eventType !== null) {
      $xfer += $output->writeFieldBegin('eventType', TType::I32, 4);
      $xfer += $output->writeI32($this->eventType);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_isPartitionMarkedForEvent_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\UnknownDBException
   */
  public $o3 = null;
  /**
   * @var \metastore\UnknownTableException
   */
  public $o4 = null;
  /**
   * @var \metastore\UnknownPartitionException
   */
  public $o5 = null;
  /**
   * @var \metastore\InvalidPartitionException
   */
  public $o6 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownTableException',
          ),
        5 => array(
          'var' => 'o5',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownPartitionException',
          ),
        6 => array(
          'var' => 'o6',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidPartitionException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
      if (isset($vals['o5'])) {
        $this->o5 = $vals['o5'];
      }
      if (isset($vals['o6'])) {
        $this->o6 = $vals['o6'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_isPartitionMarkedForEvent_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\UnknownTableException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->o5 = new \metastore\UnknownPartitionException();
            $xfer += $this->o5->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::STRUCT) {
            $this->o6 = new \metastore\InvalidPartitionException();
            $xfer += $this->o6->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_isPartitionMarkedForEvent_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o5 !== null) {
      $xfer += $output->writeFieldBegin('o5', TType::STRUCT, 5);
      $xfer += $this->o5->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o6 !== null) {
      $xfer += $output->writeFieldBegin('o6', TType::STRUCT, 6);
      $xfer += $this->o6->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_index_args {
  static $_TSPEC;

  /**
   * @var \metastore\Index
   */
  public $new_index = null;
  /**
   * @var \metastore\Table
   */
  public $index_table = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'new_index',
          'type' => TType::STRUCT,
          'class' => '\metastore\Index',
          ),
        2 => array(
          'var' => 'index_table',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['new_index'])) {
        $this->new_index = $vals['new_index'];
      }
      if (isset($vals['index_table'])) {
        $this->index_table = $vals['index_table'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_index_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->new_index = new \metastore\Index();
            $xfer += $this->new_index->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->index_table = new \metastore\Table();
            $xfer += $this->index_table->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_index_args');
    if ($this->new_index !== null) {
      if (!is_object($this->new_index)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_index', TType::STRUCT, 1);
      $xfer += $this->new_index->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->index_table !== null) {
      if (!is_object($this->index_table)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('index_table', TType::STRUCT, 2);
      $xfer += $this->index_table->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_index_result {
  static $_TSPEC;

  /**
   * @var \metastore\Index
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Index',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_index_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Index();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_index_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_index_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string
   */
  public $base_tbl_name = null;
  /**
   * @var string
   */
  public $idx_name = null;
  /**
   * @var \metastore\Index
   */
  public $new_idx = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'base_tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'idx_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'new_idx',
          'type' => TType::STRUCT,
          'class' => '\metastore\Index',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['base_tbl_name'])) {
        $this->base_tbl_name = $vals['base_tbl_name'];
      }
      if (isset($vals['idx_name'])) {
        $this->idx_name = $vals['idx_name'];
      }
      if (isset($vals['new_idx'])) {
        $this->new_idx = $vals['new_idx'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_index_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->base_tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->idx_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->new_idx = new \metastore\Index();
            $xfer += $this->new_idx->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_index_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->base_tbl_name !== null) {
      $xfer += $output->writeFieldBegin('base_tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->base_tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->idx_name !== null) {
      $xfer += $output->writeFieldBegin('idx_name', TType::STRING, 3);
      $xfer += $output->writeString($this->idx_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_idx !== null) {
      if (!is_object($this->new_idx)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_idx', TType::STRUCT, 4);
      $xfer += $this->new_idx->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_index_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_index_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_index_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_index_by_name_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $index_name = null;
  /**
   * @var bool
   */
  public $deleteData = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'index_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['index_name'])) {
        $this->index_name = $vals['index_name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_index_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->index_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_index_by_name_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->index_name !== null) {
      $xfer += $output->writeFieldBegin('index_name', TType::STRING, 3);
      $xfer += $output->writeString($this->index_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 4);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_index_by_name_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_index_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_index_by_name_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_index_by_name_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $index_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'index_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['index_name'])) {
        $this->index_name = $vals['index_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_index_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->index_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_index_by_name_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->index_name !== null) {
      $xfer += $output->writeFieldBegin('index_name', TType::STRING, 3);
      $xfer += $output->writeString($this->index_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_index_by_name_result {
  static $_TSPEC;

  /**
   * @var \metastore\Index
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Index',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_index_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Index();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_index_by_name_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_indexes_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var int
   */
  public $max_indexes = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_indexes',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_indexes'])) {
        $this->max_indexes = $vals['max_indexes'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_indexes_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_indexes);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_indexes_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_indexes !== null) {
      $xfer += $output->writeFieldBegin('max_indexes', TType::I16, 3);
      $xfer += $output->writeI16($this->max_indexes);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_indexes_result {
  static $_TSPEC;

  /**
   * @var \metastore\Index[]
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Index',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_indexes_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size797 = 0;
            $_etype800 = 0;
            $xfer += $input->readListBegin($_etype800, $_size797);
            for ($_i801 = 0; $_i801 < $_size797; ++$_i801)
            {
              $elem802 = null;
              $elem802 = new \metastore\Index();
              $xfer += $elem802->read($input);
              $this->success []= $elem802;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_indexes_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter803)
          {
            $xfer += $iter803->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_index_names_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var int
   */
  public $max_indexes = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_indexes',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_indexes'])) {
        $this->max_indexes = $vals['max_indexes'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_index_names_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_indexes);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_index_names_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_indexes !== null) {
      $xfer += $output->writeFieldBegin('max_indexes', TType::I16, 3);
      $xfer += $output->writeI16($this->max_indexes);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_index_names_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_index_names_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size804 = 0;
            $_etype807 = 0;
            $xfer += $input->readListBegin($_etype807, $_size804);
            for ($_i808 = 0; $_i808 < $_size804; ++$_i808)
            {
              $elem809 = null;
              $xfer += $input->readString($elem809);
              $this->success []= $elem809;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_index_names_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter810)
          {
            $xfer += $output->writeString($iter810);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 1);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_update_table_column_statistics_args {
  static $_TSPEC;

  /**
   * @var \metastore\ColumnStatistics
   */
  public $stats_obj = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'stats_obj',
          'type' => TType::STRUCT,
          'class' => '\metastore\ColumnStatistics',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['stats_obj'])) {
        $this->stats_obj = $vals['stats_obj'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_update_table_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->stats_obj = new \metastore\ColumnStatistics();
            $xfer += $this->stats_obj->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_update_table_column_statistics_args');
    if ($this->stats_obj !== null) {
      if (!is_object($this->stats_obj)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('stats_obj', TType::STRUCT, 1);
      $xfer += $this->stats_obj->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_update_table_column_statistics_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;
  /**
   * @var \metastore\InvalidInputException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_update_table_column_statistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidInputException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_update_table_column_statistics_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_update_partition_column_statistics_args {
  static $_TSPEC;

  /**
   * @var \metastore\ColumnStatistics
   */
  public $stats_obj = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'stats_obj',
          'type' => TType::STRUCT,
          'class' => '\metastore\ColumnStatistics',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['stats_obj'])) {
        $this->stats_obj = $vals['stats_obj'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_update_partition_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->stats_obj = new \metastore\ColumnStatistics();
            $xfer += $this->stats_obj->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_update_partition_column_statistics_args');
    if ($this->stats_obj !== null) {
      if (!is_object($this->stats_obj)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('stats_obj', TType::STRUCT, 1);
      $xfer += $this->stats_obj->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_update_partition_column_statistics_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;
  /**
   * @var \metastore\InvalidInputException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_update_partition_column_statistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidInputException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_update_partition_column_statistics_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_column_statistics_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $col_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'col_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['col_name'])) {
        $this->col_name = $vals['col_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->col_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_column_statistics_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->col_name !== null) {
      $xfer += $output->writeFieldBegin('col_name', TType::STRING, 3);
      $xfer += $output->writeString($this->col_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_column_statistics_result {
  static $_TSPEC;

  /**
   * @var \metastore\ColumnStatistics
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;
  /**
   * @var \metastore\InvalidInputException
   */
  public $o3 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\ColumnStatistics',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_column_statistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\ColumnStatistics();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\InvalidInputException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidObjectException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_column_statistics_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_column_statistics_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $part_name = null;
  /**
   * @var string
   */
  public $col_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'col_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
      if (isset($vals['col_name'])) {
        $this->col_name = $vals['col_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->col_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_column_statistics_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->col_name !== null) {
      $xfer += $output->writeFieldBegin('col_name', TType::STRING, 4);
      $xfer += $output->writeString($this->col_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_column_statistics_result {
  static $_TSPEC;

  /**
   * @var \metastore\ColumnStatistics
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;
  /**
   * @var \metastore\InvalidInputException
   */
  public $o3 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\ColumnStatistics',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_column_statistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\ColumnStatistics();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\InvalidInputException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidObjectException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_column_statistics_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_statistics_req_args {
  static $_TSPEC;

  /**
   * @var \metastore\TableStatsRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\TableStatsRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_statistics_req_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\TableStatsRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_statistics_req_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_statistics_req_result {
  static $_TSPEC;

  /**
   * @var \metastore\TableStatsResult
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\TableStatsResult',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_statistics_req_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\TableStatsResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_statistics_req_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_statistics_req_args {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionsStatsRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\PartitionsStatsRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_statistics_req_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\PartitionsStatsRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_statistics_req_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_statistics_req_result {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionsStatsResult
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\PartitionsStatsResult',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_statistics_req_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\PartitionsStatsResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_statistics_req_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_aggr_stats_for_args {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionsStatsRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\PartitionsStatsRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_aggr_stats_for_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\PartitionsStatsRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_aggr_stats_for_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_aggr_stats_for_result {
  static $_TSPEC;

  /**
   * @var \metastore\AggrStats
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\AggrStats',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_aggr_stats_for_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\AggrStats();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_aggr_stats_for_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_set_aggr_stats_for_args {
  static $_TSPEC;

  /**
   * @var \metastore\SetPartitionsStatsRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\SetPartitionsStatsRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_set_aggr_stats_for_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\SetPartitionsStatsRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_set_aggr_stats_for_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_set_aggr_stats_for_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;
  /**
   * @var \metastore\InvalidInputException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_set_aggr_stats_for_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidInputException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_set_aggr_stats_for_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_delete_partition_column_statistics_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $part_name = null;
  /**
   * @var string
   */
  public $col_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'col_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
      if (isset($vals['col_name'])) {
        $this->col_name = $vals['col_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_delete_partition_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->col_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_delete_partition_column_statistics_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->col_name !== null) {
      $xfer += $output->writeFieldBegin('col_name', TType::STRING, 4);
      $xfer += $output->writeString($this->col_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_delete_partition_column_statistics_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o3 = null;
  /**
   * @var \metastore\InvalidInputException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_delete_partition_column_statistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\InvalidObjectException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidInputException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_delete_partition_column_statistics_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_delete_table_column_statistics_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $col_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'col_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['col_name'])) {
        $this->col_name = $vals['col_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_delete_table_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->col_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_delete_table_column_statistics_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->col_name !== null) {
      $xfer += $output->writeFieldBegin('col_name', TType::STRING, 3);
      $xfer += $output->writeString($this->col_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_delete_table_column_statistics_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o3 = null;
  /**
   * @var \metastore\InvalidInputException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_delete_table_column_statistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\InvalidObjectException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidInputException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_delete_table_column_statistics_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_function_args {
  static $_TSPEC;

  /**
   * @var \metastore\Function
   */
  public $func = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'func',
          'type' => TType::STRUCT,
          'class' => '\metastore\Function',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['func'])) {
        $this->func = $vals['func'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_function_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->func = new \metastore\Function();
            $xfer += $this->func->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_function_args');
    if ($this->func !== null) {
      if (!is_object($this->func)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('func', TType::STRUCT, 1);
      $xfer += $this->func->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_function_result {
  static $_TSPEC;

  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_function_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\AlreadyExistsException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\NoSuchObjectException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_function_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_function_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbName = null;
  /**
   * @var string
   */
  public $funcName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'funcName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbName'])) {
        $this->dbName = $vals['dbName'];
      }
      if (isset($vals['funcName'])) {
        $this->funcName = $vals['funcName'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_function_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->funcName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_function_args');
    if ($this->dbName !== null) {
      $xfer += $output->writeFieldBegin('dbName', TType::STRING, 1);
      $xfer += $output->writeString($this->dbName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->funcName !== null) {
      $xfer += $output->writeFieldBegin('funcName', TType::STRING, 2);
      $xfer += $output->writeString($this->funcName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_function_result {
  static $_TSPEC;

  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_function_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_function_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 2);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_function_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbName = null;
  /**
   * @var string
   */
  public $funcName = null;
  /**
   * @var \metastore\Function
   */
  public $newFunc = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'funcName',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'newFunc',
          'type' => TType::STRUCT,
          'class' => '\metastore\Function',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbName'])) {
        $this->dbName = $vals['dbName'];
      }
      if (isset($vals['funcName'])) {
        $this->funcName = $vals['funcName'];
      }
      if (isset($vals['newFunc'])) {
        $this->newFunc = $vals['newFunc'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_function_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->funcName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->newFunc = new \metastore\Function();
            $xfer += $this->newFunc->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_function_args');
    if ($this->dbName !== null) {
      $xfer += $output->writeFieldBegin('dbName', TType::STRING, 1);
      $xfer += $output->writeString($this->dbName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->funcName !== null) {
      $xfer += $output->writeFieldBegin('funcName', TType::STRING, 2);
      $xfer += $output->writeString($this->funcName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->newFunc !== null) {
      if (!is_object($this->newFunc)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('newFunc', TType::STRUCT, 3);
      $xfer += $this->newFunc->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_function_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_function_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_function_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_functions_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbName = null;
  /**
   * @var string
   */
  public $pattern = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'pattern',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbName'])) {
        $this->dbName = $vals['dbName'];
      }
      if (isset($vals['pattern'])) {
        $this->pattern = $vals['pattern'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_functions_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->pattern);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_functions_args');
    if ($this->dbName !== null) {
      $xfer += $output->writeFieldBegin('dbName', TType::STRING, 1);
      $xfer += $output->writeString($this->dbName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->pattern !== null) {
      $xfer += $output->writeFieldBegin('pattern', TType::STRING, 2);
      $xfer += $output->writeString($this->pattern);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_functions_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_functions_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size811 = 0;
            $_etype814 = 0;
            $xfer += $input->readListBegin($_etype814, $_size811);
            for ($_i815 = 0; $_i815 < $_size811; ++$_i815)
            {
              $elem816 = null;
              $xfer += $input->readString($elem816);
              $this->success []= $elem816;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_functions_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter817)
          {
            $xfer += $output->writeString($iter817);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_function_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbName = null;
  /**
   * @var string
   */
  public $funcName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'funcName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbName'])) {
        $this->dbName = $vals['dbName'];
      }
      if (isset($vals['funcName'])) {
        $this->funcName = $vals['funcName'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_function_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->funcName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_function_args');
    if ($this->dbName !== null) {
      $xfer += $output->writeFieldBegin('dbName', TType::STRING, 1);
      $xfer += $output->writeString($this->dbName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->funcName !== null) {
      $xfer += $output->writeFieldBegin('funcName', TType::STRING, 2);
      $xfer += $output->writeString($this->funcName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_function_result {
  static $_TSPEC;

  /**
   * @var \metastore\Function
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Function',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_function_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Function();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_function_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_all_functions_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_all_functions_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_all_functions_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_all_functions_result {
  static $_TSPEC;

  /**
   * @var \metastore\GetAllFunctionsResponse
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\GetAllFunctionsResponse',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_all_functions_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\GetAllFunctionsResponse();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_all_functions_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_role_args {
  static $_TSPEC;

  /**
   * @var \metastore\Role
   */
  public $role = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'role',
          'type' => TType::STRUCT,
          'class' => '\metastore\Role',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['role'])) {
        $this->role = $vals['role'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_role_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->role = new \metastore\Role();
            $xfer += $this->role->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_role_args');
    if ($this->role !== null) {
      if (!is_object($this->role)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('role', TType::STRUCT, 1);
      $xfer += $this->role->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_role_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_role_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_role_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_role_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $role_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'role_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['role_name'])) {
        $this->role_name = $vals['role_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_role_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->role_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_role_args');
    if ($this->role_name !== null) {
      $xfer += $output->writeFieldBegin('role_name', TType::STRING, 1);
      $xfer += $output->writeString($this->role_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_role_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_role_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_role_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_role_names_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_role_names_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_role_names_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_role_names_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_role_names_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size818 = 0;
            $_etype821 = 0;
            $xfer += $input->readListBegin($_etype821, $_size818);
            for ($_i822 = 0; $_i822 < $_size818; ++$_i822)
            {
              $elem823 = null;
              $xfer += $input->readString($elem823);
              $this->success []= $elem823;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_role_names_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter824)
          {
            $xfer += $output->writeString($iter824);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_grant_role_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $role_name = null;
  /**
   * @var string
   */
  public $principal_name = null;
  /**
   * @var int
   */
  public $principal_type = null;
  /**
   * @var string
   */
  public $grantor = null;
  /**
   * @var int
   */
  public $grantorType = null;
  /**
   * @var bool
   */
  public $grant_option = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'role_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'principal_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'principal_type',
          'type' => TType::I32,
          ),
        4 => array(
          'var' => 'grantor',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'grantorType',
          'type' => TType::I32,
          ),
        6 => array(
          'var' => 'grant_option',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['role_name'])) {
        $this->role_name = $vals['role_name'];
      }
      if (isset($vals['principal_name'])) {
        $this->principal_name = $vals['principal_name'];
      }
      if (isset($vals['principal_type'])) {
        $this->principal_type = $vals['principal_type'];
      }
      if (isset($vals['grantor'])) {
        $this->grantor = $vals['grantor'];
      }
      if (isset($vals['grantorType'])) {
        $this->grantorType = $vals['grantorType'];
      }
      if (isset($vals['grant_option'])) {
        $this->grant_option = $vals['grant_option'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_grant_role_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->role_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->principal_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->principal_type);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->grantor);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->grantorType);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->grant_option);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_grant_role_args');
    if ($this->role_name !== null) {
      $xfer += $output->writeFieldBegin('role_name', TType::STRING, 1);
      $xfer += $output->writeString($this->role_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->principal_name !== null) {
      $xfer += $output->writeFieldBegin('principal_name', TType::STRING, 2);
      $xfer += $output->writeString($this->principal_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->principal_type !== null) {
      $xfer += $output->writeFieldBegin('principal_type', TType::I32, 3);
      $xfer += $output->writeI32($this->principal_type);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->grantor !== null) {
      $xfer += $output->writeFieldBegin('grantor', TType::STRING, 4);
      $xfer += $output->writeString($this->grantor);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->grantorType !== null) {
      $xfer += $output->writeFieldBegin('grantorType', TType::I32, 5);
      $xfer += $output->writeI32($this->grantorType);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->grant_option !== null) {
      $xfer += $output->writeFieldBegin('grant_option', TType::BOOL, 6);
      $xfer += $output->writeBool($this->grant_option);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_grant_role_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_grant_role_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_grant_role_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_revoke_role_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $role_name = null;
  /**
   * @var string
   */
  public $principal_name = null;
  /**
   * @var int
   */
  public $principal_type = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'role_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'principal_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'principal_type',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['role_name'])) {
        $this->role_name = $vals['role_name'];
      }
      if (isset($vals['principal_name'])) {
        $this->principal_name = $vals['principal_name'];
      }
      if (isset($vals['principal_type'])) {
        $this->principal_type = $vals['principal_type'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_revoke_role_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->role_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->principal_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->principal_type);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_revoke_role_args');
    if ($this->role_name !== null) {
      $xfer += $output->writeFieldBegin('role_name', TType::STRING, 1);
      $xfer += $output->writeString($this->role_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->principal_name !== null) {
      $xfer += $output->writeFieldBegin('principal_name', TType::STRING, 2);
      $xfer += $output->writeString($this->principal_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->principal_type !== null) {
      $xfer += $output->writeFieldBegin('principal_type', TType::I32, 3);
      $xfer += $output->writeI32($this->principal_type);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_revoke_role_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_revoke_role_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_revoke_role_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_list_roles_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $principal_name = null;
  /**
   * @var int
   */
  public $principal_type = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'principal_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'principal_type',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['principal_name'])) {
        $this->principal_name = $vals['principal_name'];
      }
      if (isset($vals['principal_type'])) {
        $this->principal_type = $vals['principal_type'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_list_roles_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->principal_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->principal_type);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_list_roles_args');
    if ($this->principal_name !== null) {
      $xfer += $output->writeFieldBegin('principal_name', TType::STRING, 1);
      $xfer += $output->writeString($this->principal_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->principal_type !== null) {
      $xfer += $output->writeFieldBegin('principal_type', TType::I32, 2);
      $xfer += $output->writeI32($this->principal_type);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_list_roles_result {
  static $_TSPEC;

  /**
   * @var \metastore\Role[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Role',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_list_roles_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size825 = 0;
            $_etype828 = 0;
            $xfer += $input->readListBegin($_etype828, $_size825);
            for ($_i829 = 0; $_i829 < $_size825; ++$_i829)
            {
              $elem830 = null;
              $elem830 = new \metastore\Role();
              $xfer += $elem830->read($input);
              $this->success []= $elem830;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_list_roles_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter831)
          {
            $xfer += $iter831->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_grant_revoke_role_args {
  static $_TSPEC;

  /**
   * @var \metastore\GrantRevokeRoleRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\GrantRevokeRoleRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_grant_revoke_role_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\GrantRevokeRoleRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_grant_revoke_role_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_grant_revoke_role_result {
  static $_TSPEC;

  /**
   * @var \metastore\GrantRevokeRoleResponse
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\GrantRevokeRoleResponse',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_grant_revoke_role_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\GrantRevokeRoleResponse();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_grant_revoke_role_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_principals_in_role_args {
  static $_TSPEC;

  /**
   * @var \metastore\GetPrincipalsInRoleRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\GetPrincipalsInRoleRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_principals_in_role_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\GetPrincipalsInRoleRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_principals_in_role_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_principals_in_role_result {
  static $_TSPEC;

  /**
   * @var \metastore\GetPrincipalsInRoleResponse
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\GetPrincipalsInRoleResponse',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_principals_in_role_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\GetPrincipalsInRoleResponse();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_principals_in_role_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_role_grants_for_principal_args {
  static $_TSPEC;

  /**
   * @var \metastore\GetRoleGrantsForPrincipalRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\GetRoleGrantsForPrincipalRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_role_grants_for_principal_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\GetRoleGrantsForPrincipalRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_role_grants_for_principal_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_role_grants_for_principal_result {
  static $_TSPEC;

  /**
   * @var \metastore\GetRoleGrantsForPrincipalResponse
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\GetRoleGrantsForPrincipalResponse',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_role_grants_for_principal_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\GetRoleGrantsForPrincipalResponse();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_role_grants_for_principal_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_privilege_set_args {
  static $_TSPEC;

  /**
   * @var \metastore\HiveObjectRef
   */
  public $hiveObject = null;
  /**
   * @var string
   */
  public $user_name = null;
  /**
   * @var string[]
   */
  public $group_names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'hiveObject',
          'type' => TType::STRUCT,
          'class' => '\metastore\HiveObjectRef',
          ),
        2 => array(
          'var' => 'user_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'group_names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['hiveObject'])) {
        $this->hiveObject = $vals['hiveObject'];
      }
      if (isset($vals['user_name'])) {
        $this->user_name = $vals['user_name'];
      }
      if (isset($vals['group_names'])) {
        $this->group_names = $vals['group_names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_privilege_set_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->hiveObject = new \metastore\HiveObjectRef();
            $xfer += $this->hiveObject->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->user_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->group_names = array();
            $_size832 = 0;
            $_etype835 = 0;
            $xfer += $input->readListBegin($_etype835, $_size832);
            for ($_i836 = 0; $_i836 < $_size832; ++$_i836)
            {
              $elem837 = null;
              $xfer += $input->readString($elem837);
              $this->group_names []= $elem837;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_privilege_set_args');
    if ($this->hiveObject !== null) {
      if (!is_object($this->hiveObject)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('hiveObject', TType::STRUCT, 1);
      $xfer += $this->hiveObject->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->user_name !== null) {
      $xfer += $output->writeFieldBegin('user_name', TType::STRING, 2);
      $xfer += $output->writeString($this->user_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->group_names !== null) {
      if (!is_array($this->group_names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('group_names', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->group_names));
        {
          foreach ($this->group_names as $iter838)
          {
            $xfer += $output->writeString($iter838);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_privilege_set_result {
  static $_TSPEC;

  /**
   * @var \metastore\PrincipalPrivilegeSet
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\PrincipalPrivilegeSet',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_privilege_set_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\PrincipalPrivilegeSet();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_privilege_set_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_list_privileges_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $principal_name = null;
  /**
   * @var int
   */
  public $principal_type = null;
  /**
   * @var \metastore\HiveObjectRef
   */
  public $hiveObject = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'principal_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'principal_type',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'hiveObject',
          'type' => TType::STRUCT,
          'class' => '\metastore\HiveObjectRef',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['principal_name'])) {
        $this->principal_name = $vals['principal_name'];
      }
      if (isset($vals['principal_type'])) {
        $this->principal_type = $vals['principal_type'];
      }
      if (isset($vals['hiveObject'])) {
        $this->hiveObject = $vals['hiveObject'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_list_privileges_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->principal_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->principal_type);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->hiveObject = new \metastore\HiveObjectRef();
            $xfer += $this->hiveObject->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_list_privileges_args');
    if ($this->principal_name !== null) {
      $xfer += $output->writeFieldBegin('principal_name', TType::STRING, 1);
      $xfer += $output->writeString($this->principal_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->principal_type !== null) {
      $xfer += $output->writeFieldBegin('principal_type', TType::I32, 2);
      $xfer += $output->writeI32($this->principal_type);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->hiveObject !== null) {
      if (!is_object($this->hiveObject)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('hiveObject', TType::STRUCT, 3);
      $xfer += $this->hiveObject->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_list_privileges_result {
  static $_TSPEC;

  /**
   * @var \metastore\HiveObjectPrivilege[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\HiveObjectPrivilege',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_list_privileges_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size839 = 0;
            $_etype842 = 0;
            $xfer += $input->readListBegin($_etype842, $_size839);
            for ($_i843 = 0; $_i843 < $_size839; ++$_i843)
            {
              $elem844 = null;
              $elem844 = new \metastore\HiveObjectPrivilege();
              $xfer += $elem844->read($input);
              $this->success []= $elem844;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_list_privileges_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter845)
          {
            $xfer += $iter845->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_grant_privileges_args {
  static $_TSPEC;

  /**
   * @var \metastore\PrivilegeBag
   */
  public $privileges = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'privileges',
          'type' => TType::STRUCT,
          'class' => '\metastore\PrivilegeBag',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['privileges'])) {
        $this->privileges = $vals['privileges'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_grant_privileges_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->privileges = new \metastore\PrivilegeBag();
            $xfer += $this->privileges->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_grant_privileges_args');
    if ($this->privileges !== null) {
      if (!is_object($this->privileges)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('privileges', TType::STRUCT, 1);
      $xfer += $this->privileges->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_grant_privileges_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_grant_privileges_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_grant_privileges_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_revoke_privileges_args {
  static $_TSPEC;

  /**
   * @var \metastore\PrivilegeBag
   */
  public $privileges = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'privileges',
          'type' => TType::STRUCT,
          'class' => '\metastore\PrivilegeBag',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['privileges'])) {
        $this->privileges = $vals['privileges'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_revoke_privileges_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->privileges = new \metastore\PrivilegeBag();
            $xfer += $this->privileges->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_revoke_privileges_args');
    if ($this->privileges !== null) {
      if (!is_object($this->privileges)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('privileges', TType::STRUCT, 1);
      $xfer += $this->privileges->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_revoke_privileges_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_revoke_privileges_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_revoke_privileges_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_grant_revoke_privileges_args {
  static $_TSPEC;

  /**
   * @var \metastore\GrantRevokePrivilegeRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\GrantRevokePrivilegeRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_grant_revoke_privileges_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\GrantRevokePrivilegeRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_grant_revoke_privileges_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_grant_revoke_privileges_result {
  static $_TSPEC;

  /**
   * @var \metastore\GrantRevokePrivilegeResponse
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\GrantRevokePrivilegeResponse',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_grant_revoke_privileges_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\GrantRevokePrivilegeResponse();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_grant_revoke_privileges_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_set_ugi_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $user_name = null;
  /**
   * @var string[]
   */
  public $group_names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'user_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'group_names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['user_name'])) {
        $this->user_name = $vals['user_name'];
      }
      if (isset($vals['group_names'])) {
        $this->group_names = $vals['group_names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_set_ugi_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->user_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->group_names = array();
            $_size846 = 0;
            $_etype849 = 0;
            $xfer += $input->readListBegin($_etype849, $_size846);
            for ($_i850 = 0; $_i850 < $_size846; ++$_i850)
            {
              $elem851 = null;
              $xfer += $input->readString($elem851);
              $this->group_names []= $elem851;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_set_ugi_args');
    if ($this->user_name !== null) {
      $xfer += $output->writeFieldBegin('user_name', TType::STRING, 1);
      $xfer += $output->writeString($this->user_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->group_names !== null) {
      if (!is_array($this->group_names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('group_names', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRING, count($this->group_names));
        {
          foreach ($this->group_names as $iter852)
          {
            $xfer += $output->writeString($iter852);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_set_ugi_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_set_ugi_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size853 = 0;
            $_etype856 = 0;
            $xfer += $input->readListBegin($_etype856, $_size853);
            for ($_i857 = 0; $_i857 < $_size853; ++$_i857)
            {
              $elem858 = null;
              $xfer += $input->readString($elem858);
              $this->success []= $elem858;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_set_ugi_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter859)
          {
            $xfer += $output->writeString($iter859);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_delegation_token_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $token_owner = null;
  /**
   * @var string
   */
  public $renewer_kerberos_principal_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'token_owner',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'renewer_kerberos_principal_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['token_owner'])) {
        $this->token_owner = $vals['token_owner'];
      }
      if (isset($vals['renewer_kerberos_principal_name'])) {
        $this->renewer_kerberos_principal_name = $vals['renewer_kerberos_principal_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_delegation_token_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->token_owner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->renewer_kerberos_principal_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_delegation_token_args');
    if ($this->token_owner !== null) {
      $xfer += $output->writeFieldBegin('token_owner', TType::STRING, 1);
      $xfer += $output->writeString($this->token_owner);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->renewer_kerberos_principal_name !== null) {
      $xfer += $output->writeFieldBegin('renewer_kerberos_principal_name', TType::STRING, 2);
      $xfer += $output->writeString($this->renewer_kerberos_principal_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_delegation_token_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_delegation_token_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_delegation_token_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_renew_delegation_token_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $token_str_form = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'token_str_form',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['token_str_form'])) {
        $this->token_str_form = $vals['token_str_form'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_renew_delegation_token_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->token_str_form);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_renew_delegation_token_args');
    if ($this->token_str_form !== null) {
      $xfer += $output->writeFieldBegin('token_str_form', TType::STRING, 1);
      $xfer += $output->writeString($this->token_str_form);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_renew_delegation_token_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I64,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_renew_delegation_token_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_renew_delegation_token_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I64, 0);
      $xfer += $output->writeI64($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_cancel_delegation_token_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $token_str_form = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'token_str_form',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['token_str_form'])) {
        $this->token_str_form = $vals['token_str_form'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_cancel_delegation_token_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->token_str_form);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_cancel_delegation_token_args');
    if ($this->token_str_form !== null) {
      $xfer += $output->writeFieldBegin('token_str_form', TType::STRING, 1);
      $xfer += $output->writeString($this->token_str_form);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_cancel_delegation_token_result {
  static $_TSPEC;

  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_cancel_delegation_token_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_cancel_delegation_token_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_open_txns_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_open_txns_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_open_txns_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_open_txns_result {
  static $_TSPEC;

  /**
   * @var \metastore\GetOpenTxnsResponse
   */
  public $success = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\GetOpenTxnsResponse',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_open_txns_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\GetOpenTxnsResponse();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_open_txns_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_open_txns_info_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_open_txns_info_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_open_txns_info_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_open_txns_info_result {
  static $_TSPEC;

  /**
   * @var \metastore\GetOpenTxnsInfoResponse
   */
  public $success = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\GetOpenTxnsInfoResponse',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_open_txns_info_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\GetOpenTxnsInfoResponse();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_open_txns_info_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_open_txns_args {
  static $_TSPEC;

  /**
   * @var \metastore\OpenTxnRequest
   */
  public $rqst = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'rqst',
          'type' => TType::STRUCT,
          'class' => '\metastore\OpenTxnRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['rqst'])) {
        $this->rqst = $vals['rqst'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_open_txns_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->rqst = new \metastore\OpenTxnRequest();
            $xfer += $this->rqst->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_open_txns_args');
    if ($this->rqst !== null) {
      if (!is_object($this->rqst)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('rqst', TType::STRUCT, 1);
      $xfer += $this->rqst->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_open_txns_result {
  static $_TSPEC;

  /**
   * @var \metastore\OpenTxnsResponse
   */
  public $success = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\OpenTxnsResponse',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_open_txns_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\OpenTxnsResponse();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_open_txns_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_abort_txn_args {
  static $_TSPEC;

  /**
   * @var \metastore\AbortTxnRequest
   */
  public $rqst = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'rqst',
          'type' => TType::STRUCT,
          'class' => '\metastore\AbortTxnRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['rqst'])) {
        $this->rqst = $vals['rqst'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_abort_txn_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->rqst = new \metastore\AbortTxnRequest();
            $xfer += $this->rqst->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_abort_txn_args');
    if ($this->rqst !== null) {
      if (!is_object($this->rqst)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('rqst', TType::STRUCT, 1);
      $xfer += $this->rqst->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_abort_txn_result {
  static $_TSPEC;

  /**
   * @var \metastore\NoSuchTxnException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchTxnException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_abort_txn_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchTxnException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_abort_txn_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_commit_txn_args {
  static $_TSPEC;

  /**
   * @var \metastore\CommitTxnRequest
   */
  public $rqst = nu