/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableInputFormatBase;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.ColumnMappings;
import org.apache.hadoop.hive.hbase.HBaseScanRange;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.hbase.HBaseSplit;
import org.apache.hadoop.hive.hbase.HiveHBaseInputFormatUtil;
import org.apache.hadoop.hive.hbase.ResultWritable;
import org.apache.hadoop.hive.ql.exec.ExprNodeConstantEvaluator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;

public class HiveHBaseTableInputFormat
extends TableInputFormatBase
implements InputFormat<ImmutableBytesWritable, ResultWritable> {
    static final Log LOG = LogFactory.getLog(HiveHBaseTableInputFormat.class);
    private static final Object hbaseTableMonitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.apache.hadoop.mapred.RecordReader<ImmutableBytesWritable, ResultWritable> getRecordReader(InputSplit split, JobConf jobConf, Reporter reporter) throws IOException {
        RecordReader recordReader;
        HBaseSplit hbaseSplit = (HBaseSplit)split;
        TableSplit tableSplit = hbaseSplit.getTableSplit();
        Job job = new Job((Configuration)jobConf);
        TaskAttemptContext tac = ShimLoader.getHadoopShims().newTaskAttemptContext(job.getConfiguration(), (Progressable)reporter);
        Object object = hbaseTableMonitor;
        synchronized (object) {
            this.setHTable(HiveHBaseInputFormatUtil.getTable(jobConf));
            this.setScan(HiveHBaseInputFormatUtil.getScan(jobConf));
            recordReader = this.createRecordReader((org.apache.hadoop.mapreduce.InputSplit)tableSplit, tac);
            try {
                recordReader.initialize((org.apache.hadoop.mapreduce.InputSplit)tableSplit, tac);
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to initialize RecordReader", e);
            }
        }
        return new org.apache.hadoop.mapred.RecordReader<ImmutableBytesWritable, ResultWritable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                Object object = hbaseTableMonitor;
                synchronized (object) {
                    recordReader.close();
                }
            }

            public ImmutableBytesWritable createKey() {
                return new ImmutableBytesWritable();
            }

            public ResultWritable createValue() {
                return new ResultWritable(new Result());
            }

            public long getPos() throws IOException {
                return 0L;
            }

            public float getProgress() throws IOException {
                float progress = 0.0f;
                try {
                    progress = recordReader.getProgress();
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                return progress;
            }

            public boolean next(ImmutableBytesWritable rowKey, ResultWritable value) throws IOException {
                boolean next = false;
                try {
                    next = recordReader.nextKeyValue();
                    if (next) {
                        rowKey.set(((Result)recordReader.getCurrentValue()).getRow());
                        value.setResult((Result)recordReader.getCurrentValue());
                    }
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                return next;
            }
        };
    }

    private Scan createFilterScan(JobConf jobConf, int iKey, int iTimestamp, boolean isKeyBinary) throws IOException {
        List<IndexSearchCondition> tsConditions;
        Map<String, List<IndexSearchCondition>> split;
        List<IndexSearchCondition> keyConditions;
        ArrayList<IndexSearchCondition> conditions;
        IndexPredicateAnalyzer analyzer;
        ExprNodeDesc residualPredicate;
        Scan scan = new Scan();
        String filterObjectSerialized = jobConf.get("hive.io.filter.object");
        if (filterObjectSerialized != null) {
            HBaseScanRange range = (HBaseScanRange)Utilities.deserializeObject((String)filterObjectSerialized, HBaseScanRange.class);
            try {
                range.setup(scan, (Configuration)jobConf);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            return scan;
        }
        String filterExprSerialized = jobConf.get("hive.io.filter.expr.serialized");
        if (filterExprSerialized == null) {
            return scan;
        }
        ExprNodeGenericFuncDesc filterExpr = Utilities.deserializeExpression((String)filterExprSerialized);
        String keyColName = jobConf.get("columns").split(",")[iKey];
        String colType = jobConf.get("columns.types").split(",")[iKey];
        boolean isKeyComparable = isKeyBinary || colType.equalsIgnoreCase("string");
        String tsColName = null;
        if (iTimestamp >= 0) {
            tsColName = jobConf.get("columns").split(",")[iTimestamp];
        }
        if ((residualPredicate = (analyzer = HiveHBaseTableInputFormat.newIndexPredicateAnalyzer(keyColName, isKeyComparable, tsColName)).analyzePredicate((ExprNodeDesc)filterExpr, conditions = new ArrayList<IndexSearchCondition>())) != null) {
            LOG.debug((Object)("Ignoring residual predicate " + residualPredicate.getExprString()));
        }
        if ((keyConditions = (split = HiveHBaseInputFormatUtil.decompose(conditions)).get(keyColName)) != null && !keyConditions.isEmpty()) {
            this.setupKeyRange(scan, keyConditions, isKeyBinary);
        }
        if ((tsConditions = split.get(tsColName)) != null && !tsConditions.isEmpty()) {
            this.setupTimeRange(scan, tsConditions);
        }
        return scan;
    }

    private void setupKeyRange(Scan scan, List<IndexSearchCondition> conditions, boolean isBinary) throws IOException {
        byte[] startRow = HConstants.EMPTY_START_ROW;
        byte[] stopRow = HConstants.EMPTY_END_ROW;
        for (IndexSearchCondition sc : conditions) {
            Object writable;
            PrimitiveObjectInspector objInspector;
            ExprNodeConstantEvaluator eval = new ExprNodeConstantEvaluator(sc.getConstantDesc());
            try {
                objInspector = (PrimitiveObjectInspector)eval.initialize(null);
                writable = eval.evaluate(null);
            }
            catch (ClassCastException cce) {
                throw new IOException("Currently only primitve types are supported. Found: " + sc.getConstantDesc().getTypeString());
            }
            catch (HiveException e) {
                throw new IOException(e);
            }
            byte[] constantVal = this.getConstantVal(writable, objInspector, isBinary);
            String comparisonOp = sc.getComparisonOp();
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual".equals(comparisonOp)) {
                startRow = constantVal;
                stopRow = this.getNextBA(constantVal);
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan".equals(comparisonOp)) {
                stopRow = constantVal;
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan".equals(comparisonOp)) {
                startRow = constantVal;
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan".equals(comparisonOp)) {
                startRow = this.getNextBA(constantVal);
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan".equals(comparisonOp)) {
                stopRow = this.getNextBA(constantVal);
                continue;
            }
            throw new IOException(comparisonOp + " is not a supported comparison operator");
        }
        scan.setStartRow(startRow);
        scan.setStopRow(stopRow);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(Bytes.toStringBinary((byte[])startRow) + " ~ " + Bytes.toStringBinary((byte[])stopRow)));
        }
    }

    private void setupTimeRange(Scan scan, List<IndexSearchCondition> conditions) throws IOException {
        long start = 0L;
        long end = Long.MAX_VALUE;
        for (IndexSearchCondition sc : conditions) {
            long timestamp = this.getTimestampVal(sc);
            String comparisonOp = sc.getComparisonOp();
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual".equals(comparisonOp)) {
                start = timestamp;
                end = timestamp + 1L;
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan".equals(comparisonOp)) {
                end = timestamp;
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan".equals(comparisonOp)) {
                start = timestamp;
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan".equals(comparisonOp)) {
                start = timestamp + 1L;
                continue;
            }
            if ("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan".equals(comparisonOp)) {
                end = timestamp + 1L;
                continue;
            }
            throw new IOException(comparisonOp + " is not a supported comparison operator");
        }
        scan.setTimeRange(start, end);
    }

    private long getTimestampVal(IndexSearchCondition sc) throws IOException {
        long timestamp;
        try {
            ExprNodeConstantEvaluator eval = new ExprNodeConstantEvaluator(sc.getConstantDesc());
            ObjectInspector inspector = eval.initialize(null);
            Object value = eval.evaluate(null);
            if (inspector instanceof LongObjectInspector) {
                timestamp = ((LongObjectInspector)inspector).get(value);
            } else {
                PrimitiveObjectInspector primitive = (PrimitiveObjectInspector)inspector;
                timestamp = PrimitiveObjectInspectorUtils.getTimestamp((Object)value, (PrimitiveObjectInspector)primitive).getTime();
            }
        }
        catch (HiveException e) {
            throw new IOException(e);
        }
        return timestamp;
    }

    private byte[] getConstantVal(Object writable, PrimitiveObjectInspector poi, boolean isKeyBinary) throws IOException {
        if (!isKeyBinary) {
            ByteStream.Output serializeStream = new ByteStream.Output();
            LazyUtils.writePrimitiveUTF8((OutputStream)serializeStream, (Object)writable, (PrimitiveObjectInspector)poi, (boolean)false, (byte)0, null);
            byte[] startRow = new byte[serializeStream.getLength()];
            System.arraycopy(serializeStream.getData(), 0, startRow, 0, serializeStream.getLength());
            return startRow;
        }
        PrimitiveObjectInspector.PrimitiveCategory pc = poi.getPrimitiveCategory();
        switch (poi.getPrimitiveCategory()) {
            case INT: {
                return Bytes.toBytes((int)((IntWritable)writable).get());
            }
            case BOOLEAN: {
                return Bytes.toBytes((boolean)((BooleanWritable)writable).get());
            }
            case LONG: {
                return Bytes.toBytes((long)((LongWritable)writable).get());
            }
            case FLOAT: {
                return Bytes.toBytes((float)((FloatWritable)writable).get());
            }
            case DOUBLE: {
                return Bytes.toBytes((double)((DoubleWritable)writable).get());
            }
            case SHORT: {
                return Bytes.toBytes((short)((ShortWritable)writable).get());
            }
            case STRING: {
                return Bytes.toBytes((String)((Text)writable).toString());
            }
            case BYTE: {
                return Bytes.toBytes((short)((ByteWritable)writable).get());
            }
        }
        throw new IOException("Type not supported " + pc);
    }

    private byte[] getNextBA(byte[] current) {
        byte[] next = new byte[current.length + 1];
        System.arraycopy(current, 0, next, 0, current.length);
        return next;
    }

    static IndexPredicateAnalyzer newIndexPredicateAnalyzer(String keyColumnName, boolean isKeyComparable, String timestampColumn) {
        IndexPredicateAnalyzer analyzer = new IndexPredicateAnalyzer();
        if (isKeyComparable) {
            analyzer.addComparisonOp(keyColumnName, new String[]{"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan"});
        } else {
            analyzer.addComparisonOp(keyColumnName, new String[]{"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual"});
        }
        if (timestampColumn != null) {
            analyzer.addComparisonOp(timestampColumn, new String[]{"org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan", "org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan"});
        }
        return analyzer;
    }

    public InputSplit[] getSplits(final JobConf jobConf, final int numSplits) throws IOException {
        Object object = hbaseTableMonitor;
        synchronized (object) {
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            if (ugi == null) {
                return this.getSplitsInternal(jobConf, numSplits);
            }
            try {
                return (InputSplit[])ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<InputSplit[]>(){

                    @Override
                    public InputSplit[] run() throws IOException {
                        return HiveHBaseTableInputFormat.this.getSplitsInternal(jobConf, numSplits);
                    }
                });
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }
    }

    private InputSplit[] getSplitsInternal(JobConf jobConf, int numSplits) throws IOException {
        if (UserGroupInformation.getCurrentUser().hasKerberosCredentials()) {
            TableMapReduceUtil.initCredentials((JobConf)jobConf);
        }
        String hbaseTableName = jobConf.get("hbase.table.name");
        this.setHTable(new HTable(HBaseConfiguration.create((Configuration)jobConf), Bytes.toBytes((String)hbaseTableName)));
        String hbaseColumnsMapping = jobConf.get("hbase.columns.mapping");
        boolean doColumnRegexMatching = jobConf.getBoolean("hbase.columns.mapping.regex.matching", true);
        if (hbaseColumnsMapping == null) {
            throw new IOException("hbase.columns.mapping required for HBase Table.");
        }
        ColumnMappings columnMappings = null;
        try {
            columnMappings = HBaseSerDe.parseColumnsMapping(hbaseColumnsMapping, doColumnRegexMatching);
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
        int iKey = columnMappings.getKeyIndex();
        int iTimestamp = columnMappings.getTimestampIndex();
        ColumnMappings.ColumnMapping keyMapping = columnMappings.getKeyMapping();
        Scan scan = this.createFilterScan(jobConf, iKey, iTimestamp, HiveHBaseInputFormatUtil.getStorageFormatOfKey(keyMapping.mappingSpec, jobConf.get("hbase.table.default.storage.type", "string")));
        ArrayList<String> addedFamilies = new ArrayList<String>();
        for (ColumnMappings.ColumnMapping colMap : columnMappings) {
            if (colMap.hbaseRowKey || colMap.hbaseTimestamp) continue;
            if (colMap.qualifierName == null) {
                scan.addFamily(colMap.familyNameBytes);
                addedFamilies.add(colMap.familyName);
                continue;
            }
            if (addedFamilies.contains(colMap.familyName)) continue;
            scan.addColumn(colMap.familyNameBytes, colMap.qualifierNameBytes);
        }
        this.setScan(scan);
        Job job = new Job((Configuration)jobConf);
        JobContext jobContext = ShimLoader.getHadoopShims().newJobContext(job);
        Path[] tablePaths = FileInputFormat.getInputPaths((JobContext)jobContext);
        List splits = super.getSplits(jobContext);
        InputSplit[] results = new InputSplit[splits.size()];
        for (int i = 0; i < splits.size(); ++i) {
            results[i] = new HBaseSplit((TableSplit)splits.get(i), tablePaths[0]);
        }
        return results;
    }
}

