/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalIntersect;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalMinus;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.logical.LogicalUnion;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableBitSet;

public class RelFactories {
    public static final ProjectFactory DEFAULT_PROJECT_FACTORY = new ProjectFactoryImpl();
    public static final FilterFactory DEFAULT_FILTER_FACTORY = new FilterFactoryImpl();
    public static final JoinFactory DEFAULT_JOIN_FACTORY = new JoinFactoryImpl();
    public static final SemiJoinFactory DEFAULT_SEMI_JOIN_FACTORY = new SemiJoinFactoryImpl();
    public static final SortFactory DEFAULT_SORT_FACTORY = new SortFactoryImpl();
    public static final AggregateFactory DEFAULT_AGGREGATE_FACTORY = new AggregateFactoryImpl();
    public static final SetOpFactory DEFAULT_SET_OP_FACTORY = new SetOpFactoryImpl();

    private RelFactories() {
    }

    private static class SemiJoinFactoryImpl
    implements SemiJoinFactory {
        private SemiJoinFactoryImpl() {
        }

        @Override
        public RelNode createSemiJoin(RelNode left, RelNode right, RexNode condition) {
            JoinInfo joinInfo = JoinInfo.of(left, right, condition);
            return new SemiJoin(left.getCluster(), left.getTraitSet(), left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys);
        }
    }

    public static interface SemiJoinFactory {
        public RelNode createSemiJoin(RelNode var1, RelNode var2, RexNode var3);
    }

    private static class JoinFactoryImpl
    implements JoinFactory {
        private JoinFactoryImpl() {
        }

        @Override
        public RelNode createJoin(RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped, boolean semiJoinDone) {
            return LogicalJoin.create(left, right, condition, joinType, variablesStopped, semiJoinDone, (ImmutableList<RelDataTypeField>)ImmutableList.of());
        }
    }

    public static interface JoinFactory {
        public RelNode createJoin(RelNode var1, RelNode var2, RexNode var3, JoinRelType var4, Set<String> var5, boolean var6);
    }

    private static class FilterFactoryImpl
    implements FilterFactory {
        private FilterFactoryImpl() {
        }

        @Override
        public RelNode createFilter(RelNode child, RexNode condition) {
            return LogicalFilter.create(child, condition);
        }
    }

    public static interface FilterFactory {
        public RelNode createFilter(RelNode var1, RexNode var2);
    }

    private static class AggregateFactoryImpl
    implements AggregateFactory {
        private AggregateFactoryImpl() {
        }

        @Override
        public RelNode createAggregate(RelNode child, boolean indicator, ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            return LogicalAggregate.create(child, indicator, groupSet, groupSets, aggCalls);
        }
    }

    public static interface AggregateFactory {
        public RelNode createAggregate(RelNode var1, boolean var2, ImmutableBitSet var3, ImmutableList<ImmutableBitSet> var4, List<AggregateCall> var5);
    }

    private static class SetOpFactoryImpl
    implements SetOpFactory {
        private SetOpFactoryImpl() {
        }

        @Override
        public RelNode createSetOp(SqlKind kind, List<RelNode> inputs, boolean all) {
            switch (kind) {
                case UNION: {
                    return LogicalUnion.create(inputs, all);
                }
                case EXCEPT: {
                    return LogicalMinus.create(inputs, all);
                }
                case INTERSECT: {
                    return LogicalIntersect.create(inputs, all);
                }
            }
            throw new AssertionError((Object)("not a set op: " + (Object)((Object)kind)));
        }
    }

    public static interface SetOpFactory {
        public RelNode createSetOp(SqlKind var1, List<RelNode> var2, boolean var3);
    }

    private static class SortFactoryImpl
    implements SortFactory {
        private SortFactoryImpl() {
        }

        @Override
        public RelNode createSort(RelTraitSet traits, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
            return LogicalSort.create(child, collation, offset, fetch);
        }
    }

    public static interface SortFactory {
        public RelNode createSort(RelTraitSet var1, RelNode var2, RelCollation var3, RexNode var4, RexNode var5);
    }

    private static class ProjectFactoryImpl
    implements ProjectFactory {
        private ProjectFactoryImpl() {
        }

        @Override
        public RelNode createProject(RelNode child, List<? extends RexNode> childExprs, List<String> fieldNames) {
            return RelOptUtil.createProject(child, childExprs, fieldNames);
        }
    }

    public static interface ProjectFactory {
        public RelNode createProject(RelNode var1, List<? extends RexNode> var2, List<String> var3);
    }
}

