/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton.tool;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hive.hcatalog.templeton.tool.TempletonUtils;

final class TrivialExecService {
    private static final Log LOG = LogFactory.getLog(TrivialExecService.class);
    private static volatile TrivialExecService theSingleton;

    TrivialExecService() {
    }

    public static synchronized TrivialExecService getInstance() {
        if (theSingleton == null) {
            theSingleton = new TrivialExecService();
        }
        return theSingleton;
    }

    public Process run(List<String> cmd, List<String> removeEnv, Map<String, String> environmentVariables) throws IOException {
        LOG.info((Object)"run(cmd, removeEnv, environmentVariables)");
        LOG.info((Object)("Starting cmd: " + cmd));
        ProcessBuilder pb = new ProcessBuilder(cmd);
        for (String key : removeEnv) {
            if (pb.environment().containsKey(key)) {
                LOG.info((Object)("Removing env var: " + key + "=" + pb.environment().get(key)));
            }
            pb.environment().remove(key);
        }
        pb.environment().putAll(environmentVariables);
        TrivialExecService.logDebugInfo("========Starting process with env:========", pb.environment());
        TrivialExecService.printContentsOfDir(".");
        return pb.start();
    }

    private static void logDebugInfo(String msg, Map<String, String> props) {
        StringBuilder sb = TempletonUtils.dumpPropMap(msg, props);
        LOG.info((Object)sb.toString());
        String sqoopHome = props.get("SQOOP_HOME");
        if (TempletonUtils.isset(sqoopHome)) {
            TrivialExecService.printContentsOfDir(sqoopHome + File.separator + "lib");
        }
    }

    private static StringBuilder printContentsOfDir(String dir, int depth, StringBuilder sb) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            indent.append("--");
        }
        File folder = new File(dir);
        sb.append((CharSequence)indent).append("Files in '").append(dir).append("' dir:").append(folder.getAbsolutePath()).append('\n');
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles == null) {
            return sb;
        }
        for (File fileName : listOfFiles) {
            if (fileName.isFile()) {
                sb.append((CharSequence)indent).append("File: ").append(fileName.getName()).append('\n');
                continue;
            }
            if (!fileName.isDirectory()) continue;
            TrivialExecService.printContentsOfDir(fileName.getName(), depth + 1, sb);
        }
        return sb;
    }

    private static void printContentsOfDir(String dir) {
        LOG.info((Object)TrivialExecService.printContentsOfDir(dir, 0, new StringBuilder()).toString());
    }
}

