/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.templeton;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.JobProfile;
import org.apache.hadoop.mapred.JobStatus;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.hcatalog.templeton.AppConfig;
import org.apache.hive.hcatalog.templeton.BadParam;
import org.apache.hive.hcatalog.templeton.Main;
import org.apache.hive.hcatalog.templeton.NotAuthorizedException;
import org.apache.hive.hcatalog.templeton.QueueStatusBean;
import org.apache.hive.hcatalog.templeton.TempletonDelegator;
import org.apache.hive.hcatalog.templeton.UgiFactory;
import org.apache.hive.hcatalog.templeton.tool.JobState;

public class StatusDelegator
extends TempletonDelegator {
    private static final Log LOG = LogFactory.getLog(StatusDelegator.class);

    public StatusDelegator(AppConfig appConf) {
        super(appConf);
    }

    public QueueStatusBean run(String user, String id) throws NotAuthorizedException, BadParam, IOException, InterruptedException {
        HadoopShims.WebHCatJTShim tracker = null;
        JobState state = null;
        try {
            UserGroupInformation ugi = UgiFactory.getUgi(user);
            tracker = ShimLoader.getHadoopShims().getWebHCatShim((Configuration)this.appConf, ugi);
            JobID jobid = StatusDelegator.StringToJobID(id);
            if (jobid == null) {
                throw new BadParam("Invalid jobid: " + id);
            }
            state = new JobState(id, Main.getAppConfigInstance());
            QueueStatusBean queueStatusBean = StatusDelegator.makeStatus(tracker, jobid, state);
            return queueStatusBean;
        }
        catch (IllegalStateException e) {
            throw new BadParam(e.getMessage());
        }
        finally {
            if (tracker != null) {
                tracker.close();
            }
            if (state != null) {
                state.close();
            }
        }
    }

    static QueueStatusBean makeStatus(HadoopShims.WebHCatJTShim tracker, JobID jobid, JobState state) throws BadParam, IOException {
        JobStatus status = tracker.getJobStatus(jobid);
        JobProfile profile = tracker.getJobProfile(jobid);
        if (status == null || profile == null) {
            throw new BadParam("Could not find job " + jobid);
        }
        return new QueueStatusBean(state, status, profile);
    }

    public static JobID StringToJobID(String id) throws BadParam {
        try {
            return JobID.forName((String)id);
        }
        catch (IllegalArgumentException e) {
            throw new BadParam(e.getMessage());
        }
    }
}

