/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Modifier;
import java.util.function.Supplier;
import org.springframework.asm.MethodVisitor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.ValueRef;
import org.springframework.lang.Nullable;

public class VariableReference
extends SpelNodeImpl {
    private static final String THIS = "this";
    private static final String ROOT = "root";
    private final String name;

    public VariableReference(String variableName, int startPos, int endPos) {
        super(startPos, endPos, new SpelNodeImpl[0]);
        this.name = variableName;
    }

    public ValueRef getValueRef(ExpressionState state) throws SpelEvaluationException {
        if (this.name.equals(THIS)) {
            return new ValueRef.TypedValueHolderValueRef(state.getActiveContextObject(), (SpelNodeImpl)this);
        }
        if (this.name.equals(ROOT)) {
            return new ValueRef.TypedValueHolderValueRef(state.getRootContextObject(), (SpelNodeImpl)this);
        }
        TypedValue result = state.lookupVariable(this.name);
        return new VariableRef(this.name, result, state.getEvaluationContext());
    }

    public TypedValue getValueInternal(ExpressionState state) throws SpelEvaluationException {
        if (this.name.equals(THIS)) {
            return state.getActiveContextObject();
        }
        if (this.name.equals(ROOT)) {
            TypedValue result = state.getRootContextObject();
            this.exitTypeDescriptor = CodeFlow.toDescriptorFromObject(result.getValue());
            return result;
        }
        TypedValue result = state.lookupVariable(this.name);
        Object value = result.getValue();
        this.exitTypeDescriptor = value == null || !Modifier.isPublic(value.getClass().getModifiers()) ? "Ljava/lang/Object" : CodeFlow.toDescriptorFromObject(value);
        return result;
    }

    public TypedValue setValueInternal(ExpressionState state, Supplier<TypedValue> valueSupplier) throws EvaluationException {
        return state.assignVariable(this.name, valueSupplier);
    }

    public String toStringAST() {
        return "#" + this.name;
    }

    public boolean isWritable(ExpressionState expressionState) throws SpelEvaluationException {
        return !this.name.equals(THIS) && !this.name.equals(ROOT);
    }

    public boolean isCompilable() {
        return this.exitTypeDescriptor != null;
    }

    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        if (this.name.equals(ROOT)) {
            mv.visitVarInsn(25, 1);
        } else {
            mv.visitVarInsn(25, 2);
            mv.visitLdcInsn((Object)this.name);
            mv.visitMethodInsn(185, "org/springframework/expression/EvaluationContext", "lookupVariable", "(Ljava/lang/String;)Ljava/lang/Object;", true);
        }
        CodeFlow.insertCheckCast(mv, this.exitTypeDescriptor);
        cf.pushDescriptor(this.exitTypeDescriptor);
    }

    private static class VariableRef
    implements ValueRef {
        private final String name;
        private final TypedValue value;
        private final EvaluationContext evaluationContext;

        public VariableRef(String name, TypedValue value, EvaluationContext evaluationContext) {
            this.name = name;
            this.value = value;
            this.evaluationContext = evaluationContext;
        }

        @Override
        public TypedValue getValue() {
            return this.value;
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            this.evaluationContext.setVariable(this.name, newValue);
        }

        @Override
        public boolean isWritable() {
            return true;
        }
    }
}

