/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.wadl.resourcedoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.ClassDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.MethodDocType;
import com.sun.jersey.server.wadl.generators.resourcedoc.model.ParamDocType;
import com.sun.jersey.wadl.resourcedoc.DocProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DocProcessorWrapper
implements DocProcessor {
    private final List<DocProcessor> _docProcessors = new ArrayList<DocProcessor>();

    void add(DocProcessor docProcessor) {
        this._docProcessors.add(docProcessor);
    }

    @Override
    public Class<?>[] getRequiredJaxbContextClasses() {
        ArrayList result = new ArrayList();
        for (DocProcessor docProcessor : this._docProcessors) {
            Class<?>[] requiredJaxbContextClasses = docProcessor.getRequiredJaxbContextClasses();
            if (requiredJaxbContextClasses == null || requiredJaxbContextClasses.length <= 0) continue;
            result.addAll(Arrays.asList(requiredJaxbContextClasses));
        }
        return result.toArray(new Class[0]);
    }

    @Override
    public String[] getCDataElements() {
        ArrayList<String> result = new ArrayList<String>();
        for (DocProcessor docProcessor : this._docProcessors) {
            String[] cdataElements = docProcessor.getCDataElements();
            if (cdataElements == null || cdataElements.length <= 0) continue;
            result.addAll(Arrays.asList(cdataElements));
        }
        return result.toArray(new String[0]);
    }

    @Override
    public void processClassDoc(ClassDoc classDoc, ClassDocType classDocType) {
        for (DocProcessor docProcessor : this._docProcessors) {
            docProcessor.processClassDoc(classDoc, classDocType);
        }
    }

    @Override
    public void processMethodDoc(MethodDoc methodDoc, MethodDocType methodDocType) {
        for (DocProcessor docProcessor : this._docProcessors) {
            docProcessor.processMethodDoc(methodDoc, methodDocType);
        }
    }

    @Override
    public void processParamTag(ParamTag paramTag, Parameter parameter, ParamDocType paramDocType) {
        for (DocProcessor docProcessor : this._docProcessors) {
            docProcessor.processParamTag(paramTag, parameter, paramDocType);
        }
    }
}

