/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.streaming;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hive.hcatalog.streaming.AbstractRecordWriter;
import org.apache.hive.hcatalog.streaming.ConnectionError;
import org.apache.hive.hcatalog.streaming.HiveEndPoint;
import org.apache.hive.hcatalog.streaming.InvalidColumn;
import org.apache.hive.hcatalog.streaming.SerializationError;
import org.apache.hive.hcatalog.streaming.StreamingException;
import org.apache.hive.hcatalog.streaming.StreamingIOFailure;

public class DelimitedInputWriter
extends AbstractRecordWriter {
    private final boolean reorderingNeeded;
    private String delimiter;
    private char serdeSeparator;
    private int[] fieldToColMapping;
    private final ArrayList<String> tableColumns = this.getCols(this.tbl);
    private AbstractSerDe serde = null;
    private static final Log LOG = LogFactory.getLog((String)DelimitedInputWriter.class.getName());

    public DelimitedInputWriter(String[] colNamesForFields, String delimiter, HiveEndPoint endPoint) throws ClassNotFoundException, ConnectionError, SerializationError, InvalidColumn, StreamingException {
        this(colNamesForFields, delimiter, endPoint, null);
    }

    public DelimitedInputWriter(String[] colNamesForFields, String delimiter, HiveEndPoint endPoint, HiveConf conf) throws ClassNotFoundException, ConnectionError, SerializationError, InvalidColumn, StreamingException {
        this(colNamesForFields, delimiter, endPoint, conf, (char)LazySerDeParameters.DefaultSeparators[0]);
    }

    public DelimitedInputWriter(String[] colNamesForFields, String delimiter, HiveEndPoint endPoint, HiveConf conf, char serdeSeparator) throws ClassNotFoundException, ConnectionError, SerializationError, InvalidColumn, StreamingException {
        super(endPoint, conf);
        this.serdeSeparator = serdeSeparator;
        this.delimiter = delimiter;
        this.fieldToColMapping = DelimitedInputWriter.getFieldReordering(colNamesForFields, this.getTableColumns());
        this.reorderingNeeded = this.isReorderingNeeded(delimiter, this.getTableColumns());
        LOG.debug((Object)("Field reordering needed = " + this.reorderingNeeded + ", for endpoint " + endPoint));
        this.serdeSeparator = serdeSeparator;
    }

    private boolean isReorderingNeeded(String delimiter, ArrayList<String> tableColumns) {
        return !delimiter.equals(String.valueOf(this.getSerdeSeparator())) || !DelimitedInputWriter.areFieldsInColOrder(this.fieldToColMapping) || tableColumns.size() < this.fieldToColMapping.length;
    }

    private static boolean areFieldsInColOrder(int[] fieldToColMapping) {
        for (int i = 0; i < fieldToColMapping.length; ++i) {
            if (fieldToColMapping[i] == i) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static int[] getFieldReordering(String[] colNamesForFields, List<String> tableColNames) throws InvalidColumn {
        int i;
        int[] result = new int[colNamesForFields.length];
        for (i = 0; i < colNamesForFields.length; ++i) {
            result[i] = -1;
        }
        i = -1;
        int fieldLabelCount = 0;
        for (String col : colNamesForFields) {
            ++i;
            if (col == null || col.trim().isEmpty()) continue;
            ++fieldLabelCount;
            int loc = tableColNames.indexOf(col);
            if (loc == -1) {
                throw new InvalidColumn("Column '" + col + "' not found in table for input field " + i + 1);
            }
            result[i] = loc;
        }
        if (fieldLabelCount > tableColNames.size()) {
            throw new InvalidColumn("Number of field names exceeds the number of columns in table");
        }
        return result;
    }

    protected byte[] reorderFields(byte[] record) throws UnsupportedEncodingException {
        if (!this.reorderingNeeded) {
            return record;
        }
        String[] reorderedFields = new String[this.getTableColumns().size()];
        String decoded = new String(record);
        String[] fields = decoded.split(this.delimiter);
        for (int i = 0; i < this.fieldToColMapping.length; ++i) {
            int newIndex = this.fieldToColMapping[i];
            if (newIndex == -1) continue;
            reorderedFields[newIndex] = fields[i];
        }
        return DelimitedInputWriter.join(reorderedFields, this.getSerdeSeparator());
    }

    private static byte[] join(String[] items, char separator) {
        int i;
        StringBuffer buff = new StringBuffer(100);
        if (items.length == 0) {
            return "".getBytes();
        }
        for (i = 0; i < items.length - 1; ++i) {
            if (items[i] != null) {
                buff.append(items[i]);
            }
            buff.append(separator);
        }
        if (items[i] != null) {
            buff.append(items[i]);
        }
        return buff.toString().getBytes();
    }

    protected ArrayList<String> getTableColumns() {
        return this.tableColumns;
    }

    @Override
    public void write(long transactionId, byte[] record) throws SerializationError, StreamingIOFailure {
        try {
            byte[] orderedFields = this.reorderFields(record);
            Object encodedRow = this.encode(orderedFields);
            this.updater.insert(transactionId, encodedRow);
        }
        catch (IOException e) {
            throw new StreamingIOFailure("Error writing record in transaction (" + transactionId + ")", e);
        }
    }

    @Override
    SerDe getSerde() throws SerializationError {
        if (this.serde != null) {
            return this.serde;
        }
        this.serde = this.createSerde(this.tbl, this.conf);
        return this.serde;
    }

    private Object encode(byte[] record) throws SerializationError {
        try {
            BytesWritable blob = new BytesWritable();
            blob.set(record, 0, record.length);
            return this.serde.deserialize((Writable)blob);
        }
        catch (SerDeException e) {
            throw new SerializationError("Unable to convert byte[] record into Object", (Exception)((Object)e));
        }
    }

    protected LazySimpleSerDe createSerde(Table tbl, HiveConf conf) throws SerializationError {
        try {
            Properties tableProps = MetaStoreUtils.getTableMetadata((Table)tbl);
            tableProps.setProperty("field.delim", String.valueOf(this.serdeSeparator));
            LazySimpleSerDe serde = new LazySimpleSerDe();
            SerDeUtils.initializeSerDe((Deserializer)serde, (Configuration)conf, (Properties)tableProps, null);
            return serde;
        }
        catch (SerDeException e) {
            throw new SerializationError("Error initializing serde", (Exception)((Object)e));
        }
    }

    private ArrayList<String> getCols(Table table) {
        List cols = table.getSd().getCols();
        ArrayList<String> colNames = new ArrayList<String>(cols.size());
        for (FieldSchema col : cols) {
            colNames.add(col.getName().toLowerCase());
        }
        return colNames;
    }

    public char getSerdeSeparator() {
        return this.serdeSeparator;
    }
}

