/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.plan.Explain;

public class SplitSample
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long totalLength;
    private Double percent;
    private Integer rowCount;
    private int seedNum = 0;

    public SplitSample() {
    }

    public SplitSample(double percent, int seedNum) {
        this.percent = percent;
        this.seedNum = seedNum;
    }

    public SplitSample(long totalLength, int seedNum) {
        this.totalLength = totalLength;
        this.seedNum = seedNum;
    }

    public SplitSample(int rowCount) {
        this.rowCount = rowCount;
    }

    @Explain(displayName="percentage")
    public Double getPercent() {
        return this.percent;
    }

    public void setPercent(Double percent) {
        this.percent = percent;
    }

    @Explain(displayName="total length")
    public Long getTotalLength() {
        return this.totalLength;
    }

    public void setTotalLength(Long totalLength) {
        this.totalLength = totalLength;
    }

    @Explain(displayName="row count")
    public Integer getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(Integer rowCount) {
        this.rowCount = rowCount;
    }

    @Explain(displayName="seed number")
    public int getSeedNum() {
        return this.seedNum;
    }

    public void setSeedNum(int seedNum) {
        this.seedNum = seedNum;
    }

    public long getTargetSize(long totalSize) {
        return this.totalLength != null ? this.totalLength : (long)((double)totalSize * this.percent / 100.0);
    }
}

