/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.cli;

import com.beust.jcommander.Parameter;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.hadoop.mapreduce.Job;

public class ClientOnDefaultTable
extends ClientOpts {
    private final String defaultTable;
    @Parameter(names={"--table"}, description="table to use")
    public String tableName;

    public ClientOnDefaultTable(String table) {
        this.defaultTable = table;
    }

    public String getTableName() {
        if (this.tableName == null) {
            return this.defaultTable;
        }
        return this.tableName;
    }

    @Override
    public void setAccumuloConfigs(Job job) throws AccumuloSecurityException {
        super.setAccumuloConfigs(job);
        AccumuloInputFormat.setConnectorInfo(job, this.principal, this.getToken());
        AccumuloInputFormat.setInputTableName(job, this.getTableName());
        AccumuloInputFormat.setScanAuthorizations(job, this.auths);
        AccumuloOutputFormat.setConnectorInfo(job, this.principal, this.getToken());
        AccumuloOutputFormat.setCreateTables(job, true);
        AccumuloOutputFormat.setDefaultTableName(job, this.getTableName());
    }
}

