/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.hbase.HBaseStore;
import org.apache.hadoop.hive.metastore.hbase.MockUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHBaseStoreCached {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestHBaseStoreCached.class.getName());
    static Map<String, String> emptyParameters = new HashMap<String, String>();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Mock
    HTableInterface htable;
    SortedMap<String, Cell> rows = new TreeMap<String, Cell>();
    HBaseStore store;

    @Before
    public void init() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        HiveConf conf = new HiveConf();
        this.store = MockUtils.init((Configuration)conf, this.htable, this.rows);
    }

    @Test
    public void createTable() throws Exception {
        String tableName = "mytable";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", "int", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, emptyParameters);
        Table table = new Table(tableName, "default", "me", startTime, startTime, 0, sd, null, emptyParameters, null, null, null);
        this.store.createTable(table);
        Table t = this.store.getTable("default", tableName);
        Assert.assertEquals((long)1L, (long)t.getSd().getColsSize());
        Assert.assertEquals((Object)"col1", (Object)((FieldSchema)t.getSd().getCols().get(0)).getName());
        Assert.assertEquals((Object)"int", (Object)((FieldSchema)t.getSd().getCols().get(0)).getType());
        Assert.assertEquals((Object)"nocomment", (Object)((FieldSchema)t.getSd().getCols().get(0)).getComment());
        Assert.assertEquals((Object)"serde", (Object)t.getSd().getSerdeInfo().getName());
        Assert.assertEquals((Object)"seriallib", (Object)t.getSd().getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)"file:/tmp", (Object)t.getSd().getLocation());
        Assert.assertEquals((Object)"input", (Object)t.getSd().getInputFormat());
        Assert.assertEquals((Object)"output", (Object)t.getSd().getOutputFormat());
        Assert.assertEquals((Object)"me", (Object)t.getOwner());
        Assert.assertEquals((Object)"default", (Object)t.getDbName());
        Assert.assertEquals((Object)tableName, (Object)t.getTableName());
    }

    @Test
    public void alterTable() throws Exception {
        String tableName = "alttable";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", "int", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, emptyParameters);
        Table table = new Table(tableName, "default", "me", startTime, startTime, 0, sd, null, emptyParameters, null, null, null);
        this.store.createTable(table);
        table.setLastAccessTime(startTime += 10);
        this.store.alterTable("default", tableName, table);
        Table t = this.store.getTable("default", tableName);
        Assert.assertEquals((long)1L, (long)t.getSd().getColsSize());
        Assert.assertEquals((Object)"col1", (Object)((FieldSchema)t.getSd().getCols().get(0)).getName());
        Assert.assertEquals((Object)"int", (Object)((FieldSchema)t.getSd().getCols().get(0)).getType());
        Assert.assertEquals((Object)"nocomment", (Object)((FieldSchema)t.getSd().getCols().get(0)).getComment());
        Assert.assertEquals((Object)"serde", (Object)t.getSd().getSerdeInfo().getName());
        Assert.assertEquals((Object)"seriallib", (Object)t.getSd().getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)"file:/tmp", (Object)t.getSd().getLocation());
        Assert.assertEquals((Object)"input", (Object)t.getSd().getInputFormat());
        Assert.assertEquals((Object)"output", (Object)t.getSd().getOutputFormat());
        Assert.assertEquals((Object)"me", (Object)t.getOwner());
        Assert.assertEquals((Object)"default", (Object)t.getDbName());
        Assert.assertEquals((Object)tableName, (Object)t.getTableName());
        Assert.assertEquals((long)startTime, (long)t.getLastAccessTime());
    }

    @Test
    public void dropTable() throws Exception {
        String tableName = "dtable";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", "int", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, emptyParameters);
        Table table = new Table(tableName, "default", "me", startTime, startTime, 0, sd, null, emptyParameters, null, null, null);
        this.store.createTable(table);
        Table t = this.store.getTable("default", tableName);
        Assert.assertNotNull((Object)t);
        this.store.dropTable("default", tableName);
        Assert.assertNull((Object)this.store.getTable("default", tableName));
    }

    @Test
    public void createPartition() throws Exception {
        String dbName = "default";
        String tableName = "myparttable";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", "int", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, emptyParameters);
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("pc", "string", ""));
        Table table = new Table(tableName, dbName, "me", startTime, startTime, 0, sd, partCols, emptyParameters, null, null, null);
        this.store.createTable(table);
        List<String> vals = Arrays.asList("fred");
        StorageDescriptor psd = new StorageDescriptor(sd);
        psd.setLocation("file:/tmp/pc=fred");
        Partition part = new Partition(vals, dbName, tableName, startTime, startTime, psd, emptyParameters);
        this.store.addPartition(part);
        Partition p = this.store.getPartition(dbName, tableName, vals);
        Assert.assertEquals((long)1L, (long)p.getSd().getColsSize());
        Assert.assertEquals((Object)"col1", (Object)((FieldSchema)p.getSd().getCols().get(0)).getName());
        Assert.assertEquals((Object)"int", (Object)((FieldSchema)p.getSd().getCols().get(0)).getType());
        Assert.assertEquals((Object)"nocomment", (Object)((FieldSchema)p.getSd().getCols().get(0)).getComment());
        Assert.assertEquals((Object)"serde", (Object)p.getSd().getSerdeInfo().getName());
        Assert.assertEquals((Object)"seriallib", (Object)p.getSd().getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)"file:/tmp/pc=fred", (Object)p.getSd().getLocation());
        Assert.assertEquals((Object)"input", (Object)p.getSd().getInputFormat());
        Assert.assertEquals((Object)"output", (Object)p.getSd().getOutputFormat());
        Assert.assertEquals((Object)dbName, (Object)p.getDbName());
        Assert.assertEquals((Object)tableName, (Object)p.getTableName());
        Assert.assertEquals((long)1L, (long)p.getValuesSize());
        Assert.assertEquals((Object)"fred", p.getValues().get(0));
    }

    @Test
    public void getPartitions() throws Exception {
        String dbName = "default";
        String tableName = "manyParts";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", "int", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, emptyParameters);
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("pc", "string", ""));
        Table table = new Table(tableName, dbName, "me", startTime, startTime, 0, sd, partCols, emptyParameters, null, null, null);
        this.store.createTable(table);
        List<String> partVals = Arrays.asList("alan", "bob", "carl", "doug", "ethan");
        for (String val : partVals) {
            ArrayList<String> vals = new ArrayList<String>();
            vals.add(val);
            StorageDescriptor psd = new StorageDescriptor(sd);
            psd.setLocation("file:/tmp/pc=" + val);
            Partition part = new Partition(vals, dbName, tableName, startTime, startTime, psd, emptyParameters);
            this.store.addPartition(part);
            Partition p = this.store.getPartition(dbName, tableName, vals);
            Assert.assertEquals((Object)("file:/tmp/pc=" + val), (Object)p.getSd().getLocation());
        }
        List parts = this.store.getPartitions(dbName, tableName, -1);
        Assert.assertEquals((long)5L, (long)parts.size());
        Object[] pv = new String[5];
        for (int i = 0; i < 5; ++i) {
            pv[i] = (String)((Partition)parts.get(i)).getValues().get(0);
        }
        Arrays.sort(pv);
        Assert.assertArrayEquals((Object[])pv, (Object[])partVals.toArray(new String[5]));
    }

    @Test
    public void listGetDropPartitionNames() throws Exception {
        String[][] partVals;
        String dbName = "default";
        String tableName = "listParts";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", "int", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, emptyParameters);
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("pc", "string", ""));
        partCols.add(new FieldSchema("region", "string", ""));
        Table table = new Table(tableName, dbName, "me", startTime, startTime, 0, sd, partCols, emptyParameters, null, null, null);
        this.store.createTable(table);
        for (String[] pv : partVals = new String[][]{{"today", "north america"}, {"tomorrow", "europe"}}) {
            ArrayList<String> vals = new ArrayList<String>();
            for (String v : pv) {
                vals.add(v);
            }
            StorageDescriptor psd = new StorageDescriptor(sd);
            psd.setLocation("file:/tmp/pc=" + pv[0] + "/region=" + pv[1]);
            Partition part = new Partition(vals, dbName, tableName, startTime, startTime, psd, emptyParameters);
            this.store.addPartition(part);
        }
        List names = this.store.listPartitionNames(dbName, tableName, (short)-1);
        Assert.assertEquals((long)2L, (long)names.size());
        Object[] resultNames = names.toArray(new String[names.size()]);
        Arrays.sort(resultNames);
        Assert.assertArrayEquals((Object[])resultNames, (Object[])new String[]{"pc=today/region=north america", "pc=tomorrow/region=europe"});
        List parts = this.store.getPartitionsByNames(dbName, tableName, names);
        Assert.assertArrayEquals((Object[])partVals[0], (Object[])((Partition)parts.get(0)).getValues().toArray(new String[2]));
        Assert.assertArrayEquals((Object[])partVals[1], (Object[])((Partition)parts.get(1)).getValues().toArray(new String[2]));
        this.store.dropPartitions(dbName, tableName, names);
        List afterDropParts = this.store.getPartitions(dbName, tableName, -1);
        Assert.assertEquals((long)0L, (long)afterDropParts.size());
    }

    @Test
    public void dropPartition() throws Exception {
        String dbName = "default";
        String tableName = "myparttable2";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", "int", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, emptyParameters);
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("pc", "string", ""));
        Table table = new Table(tableName, dbName, "me", startTime, startTime, 0, sd, partCols, emptyParameters, null, null, null);
        this.store.createTable(table);
        List<String> vals = Arrays.asList("fred");
        StorageDescriptor psd = new StorageDescriptor(sd);
        psd.setLocation("file:/tmp/pc=fred");
        Partition part = new Partition(vals, dbName, tableName, startTime, startTime, psd, emptyParameters);
        this.store.addPartition(part);
        Assert.assertNotNull((Object)this.store.getPartition(dbName, tableName, vals));
        this.store.dropPartition(dbName, tableName, vals);
        this.thrown.expect(NoSuchObjectException.class);
        this.store.getPartition(dbName, tableName, vals);
    }

    @Test
    public void booleanTableStatistics() throws Exception {
        long now = System.currentTimeMillis();
        String dbname = "default";
        String tableName = "statstable";
        String boolcol = "boolcol";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(boolcol, "boolean", "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, emptyParameters);
        Table table = new Table(tableName, dbname, "me", startTime, startTime, 0, sd, null, emptyParameters, null, null, null);
        this.store.createTable(table);
        long trues = 37L;
        long falses = 12L;
        long booleanNulls = 2L;
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = new ColumnStatisticsDesc();
        desc.setLastAnalyzed(now);
        desc.setDbName(dbname);
        desc.setTableName(tableName);
        desc.setIsTblLevel(true);
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = new ColumnStatisticsObj();
        obj.setColName(boolcol);
        obj.setColType("boolean");
        ColumnStatisticsData data = new ColumnStatisticsData();
        BooleanColumnStatsData boolData = new BooleanColumnStatsData();
        boolData.setNumTrues(trues);
        boolData.setNumFalses(falses);
        boolData.setNumNulls(booleanNulls);
        data.setBooleanStats(boolData);
        obj.setStatsData(data);
        stats.addToStatsObj(obj);
        this.store.updateTableColumnStatistics(stats);
        stats = this.store.getTableColumnStatistics(dbname, tableName, Arrays.asList(boolcol));
        Assert.assertEquals((long)now, (long)stats.getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)dbname, (Object)stats.getStatsDesc().getDbName());
        Assert.assertEquals((Object)tableName, (Object)stats.getStatsDesc().getTableName());
        Assert.assertTrue((boolean)stats.getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)stats.getStatsObjSize());
        ColumnStatisticsData colData = obj.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.BOOLEAN_STATS, (Object)colData.getSetField());
        boolData = colData.getBooleanStats();
        Assert.assertEquals((long)trues, (long)boolData.getNumTrues());
        Assert.assertEquals((long)falses, (long)boolData.getNumFalses());
        Assert.assertEquals((long)booleanNulls, (long)boolData.getNumNulls());
    }
}

