/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.hbase.HBaseStore;
import org.apache.hadoop.hive.metastore.hbase.MockUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHBaseStoreBitVector {
    private static final Logger LOG;
    static Map<String, String> emptyParameters;
    static final int NUM_PART_KEYS = 1;
    static final int NUM_PARTITIONS = 5;
    static final String DB = "db";
    static final String TBL = "tbl";
    static final String COL = "col";
    static final String PART_KEY_PREFIX = "part";
    static final String PART_VAL_PREFIX = "val";
    static final String PART_KV_SEPARATOR = "=";
    static final List<String> PART_KEYS;
    static final List<String> PART_VALS;
    static final long DEFAULT_TIME;
    static final String PART_KEY = "part";
    static final String LONG_COL = "longCol";
    static final String LONG_TYPE = "long";
    static final String INT_TYPE = "int";
    static final String INT_VAL = "1234";
    static final String DOUBLE_COL = "doubleCol";
    static final String DOUBLE_TYPE = "double";
    static final String DOUBLE_VAL = "3.1415";
    static final String STRING_COL = "stringCol";
    static final String STRING_TYPE = "string";
    static final String STRING_VAL = "stringval";
    static final String DECIMAL_COL = "decimalCol";
    static final String DECIMAL_TYPE = "decimal(5,3)";
    static final String DECIMAL_VAL = "12.123";
    static List<ColumnStatisticsObj> longColStatsObjs;
    static List<ColumnStatisticsObj> doubleColStatsObjs;
    static List<ColumnStatisticsObj> stringColStatsObjs;
    static List<ColumnStatisticsObj> decimalColStatsObjs;
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Mock
    HTableInterface htable;
    SortedMap<String, Cell> rows = new TreeMap<String, Cell>();
    HBaseStore store;

    @BeforeClass
    public static void beforeTest() {
        TestHBaseStoreBitVector.populateMockStats();
    }

    private static void populateMockStats() {
        for (int i = 0; i < 5; ++i) {
            ColumnStatisticsObj statsObj = TestHBaseStoreBitVector.mockLongStats(i);
            longColStatsObjs.add(statsObj);
            statsObj = TestHBaseStoreBitVector.mockDoubleStats(i);
            doubleColStatsObjs.add(statsObj);
            statsObj = TestHBaseStoreBitVector.mockStringStats(i);
            stringColStatsObjs.add(statsObj);
            statsObj = TestHBaseStoreBitVector.mockDecimalStats(i);
            decimalColStatsObjs.add(statsObj);
        }
    }

    private static ColumnStatisticsObj mockLongStats(int i) {
        long high = 120938479124L + (long)(100 * i);
        long low = -12341243213412124L - (long)(50 * i);
        long nulls = 23 + i;
        long dVs = 213L + (long)(10 * i);
        String bitVectors = "{0, 1, 2, 3, 4, 5, 6, 7, 8}{1, 2, 3, 4, 5, 6, 7, 8}";
        ColumnStatisticsObj colStatsObj = new ColumnStatisticsObj();
        colStatsObj.setColName(LONG_COL);
        colStatsObj.setColType(LONG_TYPE);
        ColumnStatisticsData data = new ColumnStatisticsData();
        LongColumnStatsData longData = new LongColumnStatsData();
        longData.setHighValue(high);
        longData.setLowValue(low);
        longData.setNumNulls(nulls);
        longData.setNumDVs(dVs);
        longData.setBitVectors(bitVectors);
        data.setLongStats(longData);
        colStatsObj.setStatsData(data);
        return colStatsObj;
    }

    private static ColumnStatisticsObj mockDoubleStats(int i) {
        double high = 123423.23423 + (double)(100 * i);
        double low = 1.234233E-5 - (double)(50 * i);
        long nulls = 92 + i;
        long dVs = 1234123421L + (long)(10 * i);
        String bitVectors = "{0, 1, 2, 3, 4, 5, 6, 7, 8}{0, 2, 3, 4, 5, 6, 7, 8}";
        ColumnStatisticsObj colStatsObj = new ColumnStatisticsObj();
        colStatsObj.setColName(DOUBLE_COL);
        colStatsObj.setColType(DOUBLE_TYPE);
        ColumnStatisticsData data = new ColumnStatisticsData();
        DoubleColumnStatsData doubleData = new DoubleColumnStatsData();
        doubleData.setHighValue(high);
        doubleData.setLowValue(low);
        doubleData.setNumNulls(nulls);
        doubleData.setNumDVs(dVs);
        doubleData.setBitVectors(bitVectors);
        data.setDoubleStats(doubleData);
        colStatsObj.setStatsData(data);
        return colStatsObj;
    }

    private static ColumnStatisticsObj mockStringStats(int i) {
        long maxLen = 1234 + 10 * i;
        double avgLen = 32.3 + (double)i;
        long nulls = 987 + 10 * i;
        long dVs = 906 + i;
        String bitVectors = "{0, 1, 2, 3, 4, 5, 6, 7, 8}{0, 1, 3, 4, 5, 6, 7, 8}";
        ColumnStatisticsObj colStatsObj = new ColumnStatisticsObj();
        colStatsObj.setColName(STRING_COL);
        colStatsObj.setColType(STRING_TYPE);
        ColumnStatisticsData data = new ColumnStatisticsData();
        StringColumnStatsData stringData = new StringColumnStatsData();
        stringData.setMaxColLen(maxLen);
        stringData.setAvgColLen(avgLen);
        stringData.setNumNulls(nulls);
        stringData.setNumDVs(dVs);
        stringData.setBitVectors(bitVectors);
        data.setStringStats(stringData);
        colStatsObj.setStatsData(data);
        return colStatsObj;
    }

    private static ColumnStatisticsObj mockDecimalStats(int i) {
        Decimal high = new Decimal();
        high.setScale((short)3);
        String strHigh = String.valueOf(3876 + 100 * i);
        high.setUnscaled(strHigh.getBytes());
        Decimal low = new Decimal();
        low.setScale((short)3);
        String strLow = String.valueOf(38 + i);
        low.setUnscaled(strLow.getBytes());
        long nulls = 13 + i;
        long dVs = 923947293L + (long)(100 * i);
        String bitVectors = "{0, 1, 2, 3, 4, 5, 6, 7, 8}{0, 1, 2, 4, 5, 6, 7, 8}";
        ColumnStatisticsObj colStatsObj = new ColumnStatisticsObj();
        colStatsObj.setColName(DECIMAL_COL);
        colStatsObj.setColType(DECIMAL_TYPE);
        ColumnStatisticsData data = new ColumnStatisticsData();
        DecimalColumnStatsData decimalData = new DecimalColumnStatsData();
        decimalData.setHighValue(high);
        decimalData.setLowValue(low);
        decimalData.setNumNulls(nulls);
        decimalData.setNumDVs(dVs);
        decimalData.setBitVectors(bitVectors);
        data.setDecimalStats(decimalData);
        colStatsObj.setStatsData(data);
        return colStatsObj;
    }

    @AfterClass
    public static void afterTest() {
    }

    @Before
    public void init() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        HiveConf conf = new HiveConf();
        conf.setBoolean("no.use.cache", true);
        this.store = MockUtils.init((Configuration)conf, this.htable, this.rows);
    }

    @Test
    public void longTableStatistics() throws Exception {
        this.createMockTable(LONG_COL, LONG_TYPE);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockTblColStatsDesc();
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = longColStatsObjs.get(0);
        LongColumnStatsData longData = obj.getStatsData().getLongStats();
        stats.addToStatsObj(obj);
        this.store.updateTableColumnStatistics(stats);
        ColumnStatistics statsFromDB = this.store.getTableColumnStatistics(DB, TBL, Arrays.asList(LONG_COL));
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)statsFromDB.getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)statsFromDB.getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)statsFromDB.getStatsDesc().getTableName());
        Assert.assertTrue((boolean)statsFromDB.getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)statsFromDB.getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)statsFromDB.getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.LONG_STATS, (Object)dataFromDB.getSetField());
        LongColumnStatsData longDataFromDB = dataFromDB.getLongStats();
        Assert.assertEquals((long)longData.getHighValue(), (long)longDataFromDB.getHighValue());
        Assert.assertEquals((long)longData.getLowValue(), (long)longDataFromDB.getLowValue());
        Assert.assertEquals((long)longData.getNumNulls(), (long)longDataFromDB.getNumNulls());
        Assert.assertEquals((long)longData.getNumDVs(), (long)longDataFromDB.getNumDVs());
        Assert.assertEquals((Object)longData.getBitVectors(), (Object)longDataFromDB.getBitVectors());
    }

    @Test
    public void doubleTableStatistics() throws Exception {
        this.createMockTable(DOUBLE_COL, DOUBLE_TYPE);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockTblColStatsDesc();
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = doubleColStatsObjs.get(0);
        DoubleColumnStatsData doubleData = obj.getStatsData().getDoubleStats();
        stats.addToStatsObj(obj);
        this.store.updateTableColumnStatistics(stats);
        ColumnStatistics statsFromDB = this.store.getTableColumnStatistics(DB, TBL, Arrays.asList(DOUBLE_COL));
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)statsFromDB.getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)statsFromDB.getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)statsFromDB.getStatsDesc().getTableName());
        Assert.assertTrue((boolean)statsFromDB.getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)statsFromDB.getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)statsFromDB.getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.DOUBLE_STATS, (Object)dataFromDB.getSetField());
        DoubleColumnStatsData doubleDataFromDB = dataFromDB.getDoubleStats();
        Assert.assertEquals((double)doubleData.getHighValue(), (double)doubleDataFromDB.getHighValue(), (double)0.01);
        Assert.assertEquals((double)doubleData.getLowValue(), (double)doubleDataFromDB.getLowValue(), (double)0.01);
        Assert.assertEquals((long)doubleData.getNumNulls(), (long)doubleDataFromDB.getNumNulls());
        Assert.assertEquals((long)doubleData.getNumDVs(), (long)doubleDataFromDB.getNumDVs());
        Assert.assertEquals((Object)doubleData.getBitVectors(), (Object)doubleDataFromDB.getBitVectors());
    }

    @Test
    public void stringTableStatistics() throws Exception {
        this.createMockTable(STRING_COL, STRING_TYPE);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockTblColStatsDesc();
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = stringColStatsObjs.get(0);
        StringColumnStatsData stringData = obj.getStatsData().getStringStats();
        stats.addToStatsObj(obj);
        this.store.updateTableColumnStatistics(stats);
        ColumnStatistics statsFromDB = this.store.getTableColumnStatistics(DB, TBL, Arrays.asList(STRING_COL));
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)statsFromDB.getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)statsFromDB.getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)statsFromDB.getStatsDesc().getTableName());
        Assert.assertTrue((boolean)statsFromDB.getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)statsFromDB.getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)statsFromDB.getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.STRING_STATS, (Object)dataFromDB.getSetField());
        StringColumnStatsData stringDataFromDB = dataFromDB.getStringStats();
        Assert.assertEquals((long)stringData.getMaxColLen(), (long)stringDataFromDB.getMaxColLen());
        Assert.assertEquals((double)stringData.getAvgColLen(), (double)stringDataFromDB.getAvgColLen(), (double)0.01);
        Assert.assertEquals((long)stringData.getNumNulls(), (long)stringDataFromDB.getNumNulls());
        Assert.assertEquals((long)stringData.getNumDVs(), (long)stringDataFromDB.getNumDVs());
        Assert.assertEquals((Object)stringData.getBitVectors(), (Object)stringDataFromDB.getBitVectors());
    }

    @Test
    public void decimalTableStatistics() throws Exception {
        this.createMockTable(DECIMAL_COL, DECIMAL_TYPE);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockTblColStatsDesc();
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = decimalColStatsObjs.get(0);
        DecimalColumnStatsData decimalData = obj.getStatsData().getDecimalStats();
        stats.addToStatsObj(obj);
        this.store.updateTableColumnStatistics(stats);
        ColumnStatistics statsFromDB = this.store.getTableColumnStatistics(DB, TBL, Arrays.asList(DECIMAL_COL));
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)statsFromDB.getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)statsFromDB.getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)statsFromDB.getStatsDesc().getTableName());
        Assert.assertTrue((boolean)statsFromDB.getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)statsFromDB.getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)statsFromDB.getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.DECIMAL_STATS, (Object)dataFromDB.getSetField());
        DecimalColumnStatsData decimalDataFromDB = dataFromDB.getDecimalStats();
        Assert.assertEquals((Object)decimalData.getHighValue(), (Object)decimalDataFromDB.getHighValue());
        Assert.assertEquals((Object)decimalData.getLowValue(), (Object)decimalDataFromDB.getLowValue());
        Assert.assertEquals((long)decimalData.getNumNulls(), (long)decimalDataFromDB.getNumNulls());
        Assert.assertEquals((long)decimalData.getNumDVs(), (long)decimalDataFromDB.getNumDVs());
        Assert.assertEquals((Object)decimalData.getBitVectors(), (Object)decimalDataFromDB.getBitVectors());
    }

    @Test
    public void longPartitionStatistics() throws Exception {
        this.createMockTableAndPartition(INT_TYPE, INT_VAL);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockPartColStatsDesc("part", INT_VAL);
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = longColStatsObjs.get(0);
        LongColumnStatsData longData = obj.getStatsData().getLongStats();
        stats.addToStatsObj(obj);
        ArrayList<String> parVals = new ArrayList<String>();
        parVals.add(INT_VAL);
        this.store.updatePartitionColumnStatistics(stats, parVals);
        ArrayList<String> partNames = new ArrayList<String>();
        partNames.add(desc.getPartName());
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add(obj.getColName());
        List statsFromDB = this.store.getPartitionColumnStatistics(DB, TBL, partNames, colNames);
        Assert.assertEquals((long)1L, (long)statsFromDB.size());
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getTableName());
        Assert.assertFalse((boolean)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)((ColumnStatistics)statsFromDB.get(0)).getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)((ColumnStatistics)statsFromDB.get(0)).getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.LONG_STATS, (Object)dataFromDB.getSetField());
        LongColumnStatsData longDataFromDB = dataFromDB.getLongStats();
        Assert.assertEquals((long)longData.getHighValue(), (long)longDataFromDB.getHighValue());
        Assert.assertEquals((long)longData.getLowValue(), (long)longDataFromDB.getLowValue());
        Assert.assertEquals((long)longData.getNumNulls(), (long)longDataFromDB.getNumNulls());
        Assert.assertEquals((long)longData.getNumDVs(), (long)longDataFromDB.getNumDVs());
        Assert.assertEquals((Object)longData.getBitVectors(), (Object)longDataFromDB.getBitVectors());
    }

    @Test
    public void doublePartitionStatistics() throws Exception {
        this.createMockTableAndPartition(DOUBLE_TYPE, DOUBLE_VAL);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockPartColStatsDesc("part", DOUBLE_VAL);
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = doubleColStatsObjs.get(0);
        DoubleColumnStatsData doubleData = obj.getStatsData().getDoubleStats();
        stats.addToStatsObj(obj);
        ArrayList<String> parVals = new ArrayList<String>();
        parVals.add(DOUBLE_VAL);
        this.store.updatePartitionColumnStatistics(stats, parVals);
        ArrayList<String> partNames = new ArrayList<String>();
        partNames.add(desc.getPartName());
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add(obj.getColName());
        List statsFromDB = this.store.getPartitionColumnStatistics(DB, TBL, partNames, colNames);
        Assert.assertEquals((long)1L, (long)statsFromDB.size());
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getTableName());
        Assert.assertFalse((boolean)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)((ColumnStatistics)statsFromDB.get(0)).getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)((ColumnStatistics)statsFromDB.get(0)).getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.DOUBLE_STATS, (Object)dataFromDB.getSetField());
        DoubleColumnStatsData doubleDataFromDB = dataFromDB.getDoubleStats();
        Assert.assertEquals((double)doubleData.getHighValue(), (double)doubleDataFromDB.getHighValue(), (double)0.01);
        Assert.assertEquals((double)doubleData.getLowValue(), (double)doubleDataFromDB.getLowValue(), (double)0.01);
        Assert.assertEquals((long)doubleData.getNumNulls(), (long)doubleDataFromDB.getNumNulls());
        Assert.assertEquals((long)doubleData.getNumDVs(), (long)doubleDataFromDB.getNumDVs());
        Assert.assertEquals((Object)doubleData.getBitVectors(), (Object)doubleDataFromDB.getBitVectors());
    }

    @Test
    public void stringPartitionStatistics() throws Exception {
        this.createMockTableAndPartition(STRING_TYPE, STRING_VAL);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockPartColStatsDesc("part", STRING_VAL);
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = stringColStatsObjs.get(0);
        StringColumnStatsData stringData = obj.getStatsData().getStringStats();
        stats.addToStatsObj(obj);
        ArrayList<String> parVals = new ArrayList<String>();
        parVals.add(STRING_VAL);
        this.store.updatePartitionColumnStatistics(stats, parVals);
        ArrayList<String> partNames = new ArrayList<String>();
        partNames.add(desc.getPartName());
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add(obj.getColName());
        List statsFromDB = this.store.getPartitionColumnStatistics(DB, TBL, partNames, colNames);
        Assert.assertEquals((long)1L, (long)statsFromDB.size());
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getTableName());
        Assert.assertFalse((boolean)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)((ColumnStatistics)statsFromDB.get(0)).getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)((ColumnStatistics)statsFromDB.get(0)).getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.STRING_STATS, (Object)dataFromDB.getSetField());
        StringColumnStatsData stringDataFromDB = dataFromDB.getStringStats();
        Assert.assertEquals((long)stringData.getMaxColLen(), (long)stringDataFromDB.getMaxColLen());
        Assert.assertEquals((double)stringData.getAvgColLen(), (double)stringDataFromDB.getAvgColLen(), (double)0.01);
        Assert.assertEquals((long)stringData.getNumNulls(), (long)stringDataFromDB.getNumNulls());
        Assert.assertEquals((long)stringData.getNumDVs(), (long)stringDataFromDB.getNumDVs());
        Assert.assertEquals((Object)stringData.getBitVectors(), (Object)stringDataFromDB.getBitVectors());
    }

    @Test
    public void decimalPartitionStatistics() throws Exception {
        this.createMockTableAndPartition(DECIMAL_TYPE, DECIMAL_VAL);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockPartColStatsDesc("part", DECIMAL_VAL);
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = decimalColStatsObjs.get(0);
        DecimalColumnStatsData decimalData = obj.getStatsData().getDecimalStats();
        stats.addToStatsObj(obj);
        ArrayList<String> parVals = new ArrayList<String>();
        parVals.add(DECIMAL_VAL);
        this.store.updatePartitionColumnStatistics(stats, parVals);
        ArrayList<String> partNames = new ArrayList<String>();
        partNames.add(desc.getPartName());
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add(obj.getColName());
        List statsFromDB = this.store.getPartitionColumnStatistics(DB, TBL, partNames, colNames);
        Assert.assertEquals((long)1L, (long)statsFromDB.size());
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getTableName());
        Assert.assertFalse((boolean)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)((ColumnStatistics)statsFromDB.get(0)).getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)((ColumnStatistics)statsFromDB.get(0)).getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.DECIMAL_STATS, (Object)dataFromDB.getSetField());
        DecimalColumnStatsData decimalDataFromDB = dataFromDB.getDecimalStats();
        Assert.assertEquals((Object)decimalData.getHighValue(), (Object)decimalDataFromDB.getHighValue());
        Assert.assertEquals((Object)decimalData.getLowValue(), (Object)decimalDataFromDB.getLowValue());
        Assert.assertEquals((long)decimalData.getNumNulls(), (long)decimalDataFromDB.getNumNulls());
        Assert.assertEquals((long)decimalData.getNumDVs(), (long)decimalDataFromDB.getNumDVs());
        Assert.assertEquals((Object)decimalData.getBitVectors(), (Object)decimalDataFromDB.getBitVectors());
    }

    private Table createMockTable(String name, String type) throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema(name, type, ""));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", "value");
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 17, serde, new ArrayList(), new ArrayList(), params);
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        Table table = new Table(TBL, DB, "me", currentTime, currentTime, 0, sd, cols, emptyParameters, null, null, null);
        this.store.createTable(table);
        return table;
    }

    private Table createMockTableAndPartition(String partType, String partVal) throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", partType, ""));
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(partVal);
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", "value");
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 17, serde, Arrays.asList("bucketcol"), Arrays.asList(new Order("sortcol", 1)), params);
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        Table table = new Table(TBL, DB, "me", currentTime, currentTime, 0, sd, cols, emptyParameters, null, null, null);
        this.store.createTable(table);
        Partition part = new Partition(vals, DB, TBL, currentTime, currentTime, sd, emptyParameters);
        this.store.addPartition(part);
        return table;
    }

    private ColumnStatisticsDesc getMockTblColStatsDesc() {
        ColumnStatisticsDesc desc = new ColumnStatisticsDesc();
        desc.setLastAnalyzed(DEFAULT_TIME);
        desc.setDbName(DB);
        desc.setTableName(TBL);
        desc.setIsTblLevel(true);
        return desc;
    }

    private ColumnStatisticsDesc getMockPartColStatsDesc(String partKey, String partVal) {
        ColumnStatisticsDesc desc = new ColumnStatisticsDesc();
        desc.setLastAnalyzed(DEFAULT_TIME);
        desc.setDbName(DB);
        desc.setTableName(TBL);
        desc.setPartName(partKey + PART_KV_SEPARATOR + partVal);
        desc.setIsTblLevel(false);
        return desc;
    }

    static {
        int i;
        LOG = LoggerFactory.getLogger((String)TestHBaseStoreBitVector.class.getName());
        emptyParameters = new HashMap<String, String>();
        PART_KEYS = new ArrayList<String>();
        PART_VALS = new ArrayList<String>();
        for (i = 1; i <= 1; ++i) {
            PART_KEYS.add("part" + i);
        }
        for (i = 1; i <= 5; ++i) {
            PART_VALS.add(PART_VAL_PREFIX + i);
        }
        DEFAULT_TIME = System.currentTimeMillis();
        longColStatsObjs = new ArrayList<ColumnStatisticsObj>(5);
        doubleColStatsObjs = new ArrayList<ColumnStatisticsObj>(5);
        stringColStatsObjs = new ArrayList<ColumnStatisticsObj>(5);
        decimalColStatsObjs = new ArrayList<ColumnStatisticsObj>(5);
    }
}

