/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.hbase.HBaseStore;
import org.apache.hadoop.hive.metastore.hbase.HBaseUtils;
import org.apache.hadoop.hive.metastore.hbase.MockUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHBaseStore {
    private static final Logger LOG;
    static Map<String, String> emptyParameters;
    static final int NUM_PART_KEYS = 1;
    static final int NUM_PARTITIONS = 5;
    static final String DB = "db";
    static final String TBL = "tbl";
    static final String COL = "col";
    static final String PART_KEY_PREFIX = "part";
    static final String PART_VAL_PREFIX = "val";
    static final String PART_KV_SEPARATOR = "=";
    static final List<String> PART_KEYS;
    static final List<String> PART_VALS;
    static final long DEFAULT_TIME;
    static final String PART_KEY = "part";
    static final String BOOLEAN_COL = "boolCol";
    static final String BOOLEAN_TYPE = "boolean";
    static final String BOOLEAN_VAL = "true";
    static final String LONG_COL = "longCol";
    static final String LONG_TYPE = "long";
    static final String INT_TYPE = "int";
    static final String INT_VAL = "1234";
    static final String DOUBLE_COL = "doubleCol";
    static final String DOUBLE_TYPE = "double";
    static final String DOUBLE_VAL = "3.1415";
    static final String STRING_COL = "stringCol";
    static final String STRING_TYPE = "string";
    static final String STRING_VAL = "stringval";
    static final String BINARY_COL = "binaryCol";
    static final String BINARY_TYPE = "binary";
    static final String BINARY_VAL = "1";
    static final String DECIMAL_COL = "decimalCol";
    static final String DECIMAL_TYPE = "decimal(5,3)";
    static final String DECIMAL_VAL = "12.123";
    static List<ColumnStatisticsObj> booleanColStatsObjs;
    static List<ColumnStatisticsObj> longColStatsObjs;
    static List<ColumnStatisticsObj> doubleColStatsObjs;
    static List<ColumnStatisticsObj> stringColStatsObjs;
    static List<ColumnStatisticsObj> binaryColStatsObjs;
    static List<ColumnStatisticsObj> decimalColStatsObjs;
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Mock
    HTableInterface htable;
    SortedMap<String, Cell> rows = new TreeMap<String, Cell>();
    HBaseStore store;

    @BeforeClass
    public static void beforeTest() {
        TestHBaseStore.populateMockStats();
    }

    private static void populateMockStats() {
        for (int i = 0; i < 5; ++i) {
            ColumnStatisticsObj statsObj = TestHBaseStore.mockBooleanStats(i);
            booleanColStatsObjs.add(statsObj);
            statsObj = TestHBaseStore.mockLongStats(i);
            longColStatsObjs.add(statsObj);
            statsObj = TestHBaseStore.mockDoubleStats(i);
            doubleColStatsObjs.add(statsObj);
            statsObj = TestHBaseStore.mockStringStats(i);
            stringColStatsObjs.add(statsObj);
            statsObj = TestHBaseStore.mockBinaryStats(i);
            binaryColStatsObjs.add(statsObj);
            statsObj = TestHBaseStore.mockDecimalStats(i);
            decimalColStatsObjs.add(statsObj);
        }
    }

    private static ColumnStatisticsObj mockBooleanStats(int i) {
        long trues = 37 + 100 * i;
        long falses = 12 + 50 * i;
        long nulls = 2 + i;
        ColumnStatisticsObj colStatsObj = new ColumnStatisticsObj();
        colStatsObj.setColName(BOOLEAN_COL);
        colStatsObj.setColType(BOOLEAN_TYPE);
        ColumnStatisticsData data = new ColumnStatisticsData();
        BooleanColumnStatsData boolData = new BooleanColumnStatsData();
        boolData.setNumTrues(trues);
        boolData.setNumFalses(falses);
        boolData.setNumNulls(nulls);
        data.setBooleanStats(boolData);
        colStatsObj.setStatsData(data);
        return colStatsObj;
    }

    private static ColumnStatisticsObj mockLongStats(int i) {
        long high = 120938479124L + (long)(100 * i);
        long low = -12341243213412124L - (long)(50 * i);
        long nulls = 23 + i;
        long dVs = 213L + (long)(10 * i);
        ColumnStatisticsObj colStatsObj = new ColumnStatisticsObj();
        colStatsObj.setColName(LONG_COL);
        colStatsObj.setColType(LONG_TYPE);
        ColumnStatisticsData data = new ColumnStatisticsData();
        LongColumnStatsData longData = new LongColumnStatsData();
        longData.setHighValue(high);
        longData.setLowValue(low);
        longData.setNumNulls(nulls);
        longData.setNumDVs(dVs);
        data.setLongStats(longData);
        colStatsObj.setStatsData(data);
        return colStatsObj;
    }

    private static ColumnStatisticsObj mockDoubleStats(int i) {
        double high = 123423.23423 + (double)(100 * i);
        double low = 1.234233E-5 - (double)(50 * i);
        long nulls = 92 + i;
        long dVs = 1234123421L + (long)(10 * i);
        ColumnStatisticsObj colStatsObj = new ColumnStatisticsObj();
        colStatsObj.setColName(DOUBLE_COL);
        colStatsObj.setColType(DOUBLE_TYPE);
        ColumnStatisticsData data = new ColumnStatisticsData();
        DoubleColumnStatsData doubleData = new DoubleColumnStatsData();
        doubleData.setHighValue(high);
        doubleData.setLowValue(low);
        doubleData.setNumNulls(nulls);
        doubleData.setNumDVs(dVs);
        data.setDoubleStats(doubleData);
        colStatsObj.setStatsData(data);
        return colStatsObj;
    }

    private static ColumnStatisticsObj mockStringStats(int i) {
        long maxLen = 1234 + 10 * i;
        double avgLen = 32.3 + (double)i;
        long nulls = 987 + 10 * i;
        long dVs = 906 + i;
        ColumnStatisticsObj colStatsObj = new ColumnStatisticsObj();
        colStatsObj.setColName(STRING_COL);
        colStatsObj.setColType(STRING_TYPE);
        ColumnStatisticsData data = new ColumnStatisticsData();
        StringColumnStatsData stringData = new StringColumnStatsData();
        stringData.setMaxColLen(maxLen);
        stringData.setAvgColLen(avgLen);
        stringData.setNumNulls(nulls);
        stringData.setNumDVs(dVs);
        data.setStringStats(stringData);
        colStatsObj.setStatsData(data);
        return colStatsObj;
    }

    private static ColumnStatisticsObj mockBinaryStats(int i) {
        long maxLen = 123412987L + (long)(10 * i);
        double avgLen = 76.98 + (double)i;
        long nulls = 976998797L + (long)(10 * i);
        ColumnStatisticsObj colStatsObj = new ColumnStatisticsObj();
        colStatsObj.setColName(BINARY_COL);
        colStatsObj.setColType(BINARY_TYPE);
        ColumnStatisticsData data = new ColumnStatisticsData();
        BinaryColumnStatsData binaryData = new BinaryColumnStatsData();
        binaryData.setMaxColLen(maxLen);
        binaryData.setAvgColLen(avgLen);
        binaryData.setNumNulls(nulls);
        data.setBinaryStats(binaryData);
        colStatsObj.setStatsData(data);
        return colStatsObj;
    }

    private static ColumnStatisticsObj mockDecimalStats(int i) {
        Decimal high = new Decimal();
        high.setScale((short)3);
        String strHigh = String.valueOf(3876 + 100 * i);
        high.setUnscaled(strHigh.getBytes());
        Decimal low = new Decimal();
        low.setScale((short)3);
        String strLow = String.valueOf(38 + i);
        low.setUnscaled(strLow.getBytes());
        long nulls = 13 + i;
        long dVs = 923947293L + (long)(100 * i);
        ColumnStatisticsObj colStatsObj = new ColumnStatisticsObj();
        colStatsObj.setColName(DECIMAL_COL);
        colStatsObj.setColType(DECIMAL_TYPE);
        ColumnStatisticsData data = new ColumnStatisticsData();
        DecimalColumnStatsData decimalData = new DecimalColumnStatsData();
        decimalData.setHighValue(high);
        decimalData.setLowValue(low);
        decimalData.setNumNulls(nulls);
        decimalData.setNumDVs(dVs);
        data.setDecimalStats(decimalData);
        colStatsObj.setStatsData(data);
        return colStatsObj;
    }

    @AfterClass
    public static void afterTest() {
    }

    @Before
    public void init() throws IOException {
        MockitoAnnotations.initMocks((Object)this);
        HiveConf conf = new HiveConf();
        conf.setBoolean("no.use.cache", true);
        this.store = MockUtils.init((Configuration)conf, this.htable, this.rows);
    }

    @Test
    public void createDb() throws Exception {
        String dbname = "mydb";
        Database db = new Database(dbname, "no description", "file:///tmp", emptyParameters);
        this.store.createDatabase(db);
        Database d = this.store.getDatabase(dbname);
        Assert.assertEquals((Object)dbname, (Object)d.getName());
        Assert.assertEquals((Object)"no description", (Object)d.getDescription());
        Assert.assertEquals((Object)"file:///tmp", (Object)d.getLocationUri());
    }

    @Test
    public void alterDb() throws Exception {
        String dbname = "mydb";
        Database db = new Database(dbname, "no description", "file:///tmp", emptyParameters);
        this.store.createDatabase(db);
        db.setDescription("a description");
        this.store.alterDatabase(dbname, db);
        Database d = this.store.getDatabase(dbname);
        Assert.assertEquals((Object)dbname, (Object)d.getName());
        Assert.assertEquals((Object)"a description", (Object)d.getDescription());
        Assert.assertEquals((Object)"file:///tmp", (Object)d.getLocationUri());
    }

    @Test
    public void dropDb() throws Exception {
        String dbname = "anotherdb";
        Database db = new Database(dbname, "no description", "file:///tmp", emptyParameters);
        this.store.createDatabase(db);
        Database d = this.store.getDatabase(dbname);
        Assert.assertNotNull((Object)d);
        this.store.dropDatabase(dbname);
        this.thrown.expect(NoSuchObjectException.class);
        this.store.getDatabase(dbname);
    }

    @Test
    public void createFunction() throws Exception {
        String funcName = "createfunc";
        int now = (int)(System.currentTimeMillis() / 1000L);
        Function func = new Function(funcName, DB, "o.a.h.h.myfunc", "me", PrincipalType.USER, now, FunctionType.JAVA, Arrays.asList(new ResourceUri(ResourceType.JAR, "file:/tmp/somewhere")));
        this.store.createFunction(func);
        Function f = this.store.getFunction(DB, funcName);
        Assert.assertEquals((Object)DB, (Object)f.getDbName());
        Assert.assertEquals((Object)funcName, (Object)f.getFunctionName());
        Assert.assertEquals((Object)"o.a.h.h.myfunc", (Object)f.getClassName());
        Assert.assertEquals((Object)"me", (Object)f.getOwnerName());
        Assert.assertEquals((Object)PrincipalType.USER, (Object)f.getOwnerType());
        Assert.assertTrue((now <= f.getCreateTime() ? 1 : 0) != 0);
        Assert.assertEquals((Object)FunctionType.JAVA, (Object)f.getFunctionType());
        Assert.assertEquals((long)1L, (long)f.getResourceUrisSize());
        Assert.assertEquals((Object)ResourceType.JAR, (Object)((ResourceUri)f.getResourceUris().get(0)).getResourceType());
        Assert.assertEquals((Object)"file:/tmp/somewhere", (Object)((ResourceUri)f.getResourceUris().get(0)).getUri());
    }

    @Test
    public void alterFunction() throws Exception {
        String funcName = "alterfunc";
        int now = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<ResourceUri> uris = new ArrayList<ResourceUri>();
        uris.add(new ResourceUri(ResourceType.FILE, "whatever"));
        Function func = new Function(funcName, DB, "o.a.h.h.myfunc", "me", PrincipalType.USER, now, FunctionType.JAVA, uris);
        this.store.createFunction(func);
        Function f = this.store.getFunction(DB, funcName);
        Assert.assertEquals((Object)ResourceType.FILE, (Object)((ResourceUri)f.getResourceUris().get(0)).getResourceType());
        func.addToResourceUris(new ResourceUri(ResourceType.ARCHIVE, "file"));
        this.store.alterFunction(DB, funcName, func);
        f = this.store.getFunction(DB, funcName);
        Assert.assertEquals((long)2L, (long)f.getResourceUrisSize());
        Assert.assertEquals((Object)ResourceType.FILE, (Object)((ResourceUri)f.getResourceUris().get(0)).getResourceType());
        Assert.assertEquals((Object)ResourceType.ARCHIVE, (Object)((ResourceUri)f.getResourceUris().get(1)).getResourceType());
    }

    @Test
    public void dropFunction() throws Exception {
        String funcName = "delfunc";
        int now = (int)(System.currentTimeMillis() / 1000L);
        Function func = new Function(funcName, DB, "o.a.h.h.myfunc", "me", PrincipalType.USER, now, FunctionType.JAVA, Arrays.asList(new ResourceUri(ResourceType.JAR, "file:/tmp/somewhere")));
        this.store.createFunction(func);
        Function f = this.store.getFunction(DB, funcName);
        Assert.assertNotNull((Object)f);
        this.store.dropFunction(DB, funcName);
        Assert.assertNull((Object)this.store.getFunction(DB, funcName));
    }

    @Test
    public void createTable() throws Exception {
        String tableName = "mytable";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", INT_TYPE, ""));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", "value");
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 17, serde, Arrays.asList("bucketcol"), Arrays.asList(new Order("sortcol", 1)), params);
        Table table = new Table(tableName, "default", "me", startTime, startTime, 0, sd, null, emptyParameters, null, null, null);
        this.store.createTable(table);
        Table t = this.store.getTable("default", tableName);
        Assert.assertEquals((long)1L, (long)t.getSd().getColsSize());
        Assert.assertEquals((Object)"col1", (Object)((FieldSchema)t.getSd().getCols().get(0)).getName());
        Assert.assertEquals((Object)INT_TYPE, (Object)((FieldSchema)t.getSd().getCols().get(0)).getType());
        Assert.assertEquals((Object)"", (Object)((FieldSchema)t.getSd().getCols().get(0)).getComment());
        Assert.assertEquals((Object)"serde", (Object)t.getSd().getSerdeInfo().getName());
        Assert.assertEquals((Object)"seriallib", (Object)t.getSd().getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)"file:/tmp", (Object)t.getSd().getLocation());
        Assert.assertEquals((Object)"input", (Object)t.getSd().getInputFormat());
        Assert.assertEquals((Object)"output", (Object)t.getSd().getOutputFormat());
        Assert.assertFalse((boolean)t.getSd().isCompressed());
        Assert.assertEquals((long)17L, (long)t.getSd().getNumBuckets());
        Assert.assertEquals((long)1L, (long)t.getSd().getBucketColsSize());
        Assert.assertEquals((Object)"bucketcol", t.getSd().getBucketCols().get(0));
        Assert.assertEquals((long)1L, (long)t.getSd().getSortColsSize());
        Assert.assertEquals((Object)"sortcol", (Object)((Order)t.getSd().getSortCols().get(0)).getCol());
        Assert.assertEquals((long)1L, (long)((Order)t.getSd().getSortCols().get(0)).getOrder());
        Assert.assertEquals((long)1L, (long)t.getSd().getParametersSize());
        Assert.assertEquals((Object)"value", t.getSd().getParameters().get("key"));
        Assert.assertEquals((Object)"me", (Object)t.getOwner());
        Assert.assertEquals((Object)"default", (Object)t.getDbName());
        Assert.assertEquals((Object)tableName, (Object)t.getTableName());
        Assert.assertEquals((long)0L, (long)t.getParametersSize());
    }

    @Test
    public void skewInfo() throws Exception {
        String tableName = "mytable";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", INT_TYPE, ""));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", true, 0, serde, null, null, emptyParameters);
        HashMap<List<String>, String> map = new HashMap<List<String>, String>();
        map.put(Arrays.asList("col3"), "col4");
        SkewedInfo skew = new SkewedInfo(Arrays.asList("col1"), Arrays.asList(Arrays.asList("col2")), map);
        sd.setSkewedInfo(skew);
        Table table = new Table(tableName, "default", "me", startTime, startTime, 0, sd, null, emptyParameters, null, null, null);
        this.store.createTable(table);
        Table t = this.store.getTable("default", tableName);
        Assert.assertEquals((long)1L, (long)t.getSd().getColsSize());
        Assert.assertEquals((Object)"col1", (Object)((FieldSchema)t.getSd().getCols().get(0)).getName());
        Assert.assertEquals((Object)INT_TYPE, (Object)((FieldSchema)t.getSd().getCols().get(0)).getType());
        Assert.assertEquals((Object)"", (Object)((FieldSchema)t.getSd().getCols().get(0)).getComment());
        Assert.assertEquals((Object)"serde", (Object)t.getSd().getSerdeInfo().getName());
        Assert.assertEquals((Object)"seriallib", (Object)t.getSd().getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)"file:/tmp", (Object)t.getSd().getLocation());
        Assert.assertEquals((Object)"input", (Object)t.getSd().getInputFormat());
        Assert.assertEquals((Object)"output", (Object)t.getSd().getOutputFormat());
        Assert.assertTrue((boolean)t.getSd().isCompressed());
        Assert.assertEquals((long)0L, (long)t.getSd().getNumBuckets());
        Assert.assertEquals((long)0L, (long)t.getSd().getSortColsSize());
        Assert.assertEquals((Object)"me", (Object)t.getOwner());
        Assert.assertEquals((Object)"default", (Object)t.getDbName());
        Assert.assertEquals((Object)tableName, (Object)t.getTableName());
        Assert.assertEquals((long)0L, (long)t.getParametersSize());
        skew = t.getSd().getSkewedInfo();
        Assert.assertNotNull((Object)skew);
        Assert.assertEquals((long)1L, (long)skew.getSkewedColNamesSize());
        Assert.assertEquals((Object)"col1", skew.getSkewedColNames().get(0));
        Assert.assertEquals((long)1L, (long)skew.getSkewedColValuesSize());
        Assert.assertEquals((Object)"col2", ((List)skew.getSkewedColValues().get(0)).get(0));
        Assert.assertEquals((long)1L, (long)skew.getSkewedColValueLocationMapsSize());
        Assert.assertEquals((Object)"col4", skew.getSkewedColValueLocationMaps().get(Arrays.asList("col3")));
    }

    @Test
    public void hashSd() throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", INT_TYPE, ""));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", true, 0, serde, null, null, emptyParameters);
        HashMap<List<String>, String> map = new HashMap<List<String>, String>();
        map.put(Arrays.asList("col3"), "col4");
        SkewedInfo skew = new SkewedInfo(Arrays.asList("col1"), Arrays.asList(Arrays.asList("col2")), map);
        sd.setSkewedInfo(skew);
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] baseHash = HBaseUtils.hashStorageDescriptor((StorageDescriptor)sd, (MessageDigest)md);
        StorageDescriptor changeSchema = new StorageDescriptor(sd);
        changeSchema.getCols().add(new FieldSchema("col2", "varchar(32)", "a comment"));
        byte[] schemaHash = HBaseUtils.hashStorageDescriptor((StorageDescriptor)changeSchema, (MessageDigest)md);
        Assert.assertFalse((boolean)Arrays.equals(baseHash, schemaHash));
        StorageDescriptor changeLocation = new StorageDescriptor(sd);
        changeLocation.setLocation("file:/somewhere/else");
        byte[] locationHash = HBaseUtils.hashStorageDescriptor((StorageDescriptor)changeLocation, (MessageDigest)md);
        Assert.assertArrayEquals((byte[])baseHash, (byte[])locationHash);
    }

    @Test
    public void alterTable() throws Exception {
        String tableName = "alttable";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", INT_TYPE, "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, emptyParameters);
        Table table = new Table(tableName, "default", "me", startTime, startTime, 0, sd, null, emptyParameters, null, null, null);
        this.store.createTable(table);
        table.setLastAccessTime(startTime += 10);
        this.store.alterTable("default", tableName, table);
        Table t = this.store.getTable("default", tableName);
        Assert.assertEquals((long)1L, (long)t.getSd().getColsSize());
        Assert.assertEquals((Object)"col1", (Object)((FieldSchema)t.getSd().getCols().get(0)).getName());
        Assert.assertEquals((Object)INT_TYPE, (Object)((FieldSchema)t.getSd().getCols().get(0)).getType());
        Assert.assertEquals((Object)"nocomment", (Object)((FieldSchema)t.getSd().getCols().get(0)).getComment());
        Assert.assertEquals((Object)"serde", (Object)t.getSd().getSerdeInfo().getName());
        Assert.assertEquals((Object)"seriallib", (Object)t.getSd().getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)"file:/tmp", (Object)t.getSd().getLocation());
        Assert.assertEquals((Object)"input", (Object)t.getSd().getInputFormat());
        Assert.assertEquals((Object)"output", (Object)t.getSd().getOutputFormat());
        Assert.assertEquals((Object)"me", (Object)t.getOwner());
        Assert.assertEquals((Object)"default", (Object)t.getDbName());
        Assert.assertEquals((Object)tableName, (Object)t.getTableName());
        Assert.assertEquals((long)startTime, (long)t.getLastAccessTime());
    }

    @Test
    public void dropTable() throws Exception {
        String tableName = "dtable";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", INT_TYPE, "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, emptyParameters);
        Table table = new Table(tableName, "default", "me", startTime, startTime, 0, sd, null, emptyParameters, null, null, null);
        this.store.createTable(table);
        Table t = this.store.getTable("default", tableName);
        Assert.assertNotNull((Object)t);
        this.store.dropTable("default", tableName);
        Assert.assertNull((Object)this.store.getTable("default", tableName));
    }

    @Test
    public void createPartition() throws Exception {
        String tableName = "myparttable";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", INT_TYPE, "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, emptyParameters);
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("pc", STRING_TYPE, ""));
        Table table = new Table(tableName, DB, "me", startTime, startTime, 0, sd, partCols, emptyParameters, null, null, null);
        this.store.createTable(table);
        List<String> vals = Arrays.asList("fred");
        StorageDescriptor psd = new StorageDescriptor(sd);
        psd.setLocation("file:/tmp/pc=fred");
        Partition part = new Partition(vals, DB, tableName, startTime, startTime, psd, emptyParameters);
        this.store.addPartition(part);
        Partition p = this.store.getPartition(DB, tableName, vals);
        Assert.assertEquals((long)1L, (long)p.getSd().getColsSize());
        Assert.assertEquals((Object)"col1", (Object)((FieldSchema)p.getSd().getCols().get(0)).getName());
        Assert.assertEquals((Object)INT_TYPE, (Object)((FieldSchema)p.getSd().getCols().get(0)).getType());
        Assert.assertEquals((Object)"nocomment", (Object)((FieldSchema)p.getSd().getCols().get(0)).getComment());
        Assert.assertEquals((Object)"serde", (Object)p.getSd().getSerdeInfo().getName());
        Assert.assertEquals((Object)"seriallib", (Object)p.getSd().getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)"file:/tmp/pc=fred", (Object)p.getSd().getLocation());
        Assert.assertEquals((Object)"input", (Object)p.getSd().getInputFormat());
        Assert.assertEquals((Object)"output", (Object)p.getSd().getOutputFormat());
        Assert.assertEquals((Object)DB, (Object)p.getDbName());
        Assert.assertEquals((Object)tableName, (Object)p.getTableName());
        Assert.assertEquals((long)1L, (long)p.getValuesSize());
        Assert.assertEquals((Object)"fred", p.getValues().get(0));
        Assert.assertTrue((boolean)this.store.doesPartitionExist(DB, tableName, vals));
        Assert.assertFalse((boolean)this.store.doesPartitionExist(DB, tableName, Arrays.asList("bob")));
    }

    @Test
    public void alterPartition() throws Exception {
        String tableName = "alterparttable";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", INT_TYPE, "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, emptyParameters);
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("pc", STRING_TYPE, ""));
        Table table = new Table(tableName, DB, "me", startTime, startTime, 0, sd, partCols, emptyParameters, null, null, null);
        this.store.createTable(table);
        List<String> vals = Arrays.asList("fred");
        StorageDescriptor psd = new StorageDescriptor(sd);
        psd.setLocation("file:/tmp/pc=fred");
        Partition part = new Partition(vals, DB, tableName, startTime, startTime, psd, emptyParameters);
        this.store.addPartition(part);
        part.setLastAccessTime(startTime + 10);
        this.store.alterPartition(DB, tableName, vals, part);
        Partition p = this.store.getPartition(DB, tableName, vals);
        Assert.assertEquals((long)1L, (long)p.getSd().getColsSize());
        Assert.assertEquals((Object)"col1", (Object)((FieldSchema)p.getSd().getCols().get(0)).getName());
        Assert.assertEquals((Object)INT_TYPE, (Object)((FieldSchema)p.getSd().getCols().get(0)).getType());
        Assert.assertEquals((Object)"nocomment", (Object)((FieldSchema)p.getSd().getCols().get(0)).getComment());
        Assert.assertEquals((Object)"serde", (Object)p.getSd().getSerdeInfo().getName());
        Assert.assertEquals((Object)"seriallib", (Object)p.getSd().getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)"file:/tmp/pc=fred", (Object)p.getSd().getLocation());
        Assert.assertEquals((Object)"input", (Object)p.getSd().getInputFormat());
        Assert.assertEquals((Object)"output", (Object)p.getSd().getOutputFormat());
        Assert.assertEquals((Object)DB, (Object)p.getDbName());
        Assert.assertEquals((Object)tableName, (Object)p.getTableName());
        Assert.assertEquals((long)1L, (long)p.getValuesSize());
        Assert.assertEquals((Object)"fred", p.getValues().get(0));
        Assert.assertEquals((long)(startTime + 10), (long)p.getLastAccessTime());
        Assert.assertTrue((boolean)this.store.doesPartitionExist(DB, tableName, vals));
        Assert.assertFalse((boolean)this.store.doesPartitionExist(DB, tableName, Arrays.asList("bob")));
    }

    @Test
    public void getPartitions() throws Exception {
        String tableName = "manyParts";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", INT_TYPE, "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, emptyParameters);
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("pc", STRING_TYPE, ""));
        Table table = new Table(tableName, DB, "me", startTime, startTime, 0, sd, partCols, emptyParameters, null, null, null);
        this.store.createTable(table);
        List<String> partVals = Arrays.asList("alan", "bob", "carl", "doug", "ethan");
        for (String val : partVals) {
            ArrayList<String> vals = new ArrayList<String>();
            vals.add(val);
            StorageDescriptor psd = new StorageDescriptor(sd);
            psd.setLocation("file:/tmp/pc=" + val);
            Partition part = new Partition(vals, DB, tableName, startTime, startTime, psd, emptyParameters);
            this.store.addPartition(part);
            Partition p = this.store.getPartition(DB, tableName, vals);
            Assert.assertEquals((Object)("file:/tmp/pc=" + val), (Object)p.getSd().getLocation());
        }
        List parts = this.store.getPartitions(DB, tableName, -1);
        Assert.assertEquals((long)5L, (long)parts.size());
        Object[] pv = new String[5];
        for (int i = 0; i < 5; ++i) {
            pv[i] = (String)((Partition)parts.get(i)).getValues().get(0);
        }
        Arrays.sort(pv);
        Assert.assertArrayEquals((Object[])pv, (Object[])partVals.toArray(new String[5]));
    }

    @Test
    public void listGetDropPartitionNames() throws Exception {
        String[][] partVals;
        String tableName = "listParts";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", INT_TYPE, "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, emptyParameters);
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("pc", STRING_TYPE, ""));
        partCols.add(new FieldSchema("region", STRING_TYPE, ""));
        Table table = new Table(tableName, DB, "me", startTime, startTime, 0, sd, partCols, emptyParameters, null, null, null);
        this.store.createTable(table);
        for (String[] pv : partVals = new String[][]{{"today", "north america"}, {"tomorrow", "europe"}}) {
            ArrayList<String> vals = new ArrayList<String>();
            for (String v : pv) {
                vals.add(v);
            }
            StorageDescriptor psd = new StorageDescriptor(sd);
            psd.setLocation("file:/tmp/pc=" + pv[0] + "/region=" + pv[1]);
            Partition part = new Partition(vals, DB, tableName, startTime, startTime, psd, emptyParameters);
            this.store.addPartition(part);
        }
        List names = this.store.listPartitionNames(DB, tableName, (short)-1);
        Assert.assertEquals((long)2L, (long)names.size());
        Object[] resultNames = names.toArray(new String[names.size()]);
        Arrays.sort(resultNames);
        Assert.assertArrayEquals((Object[])resultNames, (Object[])new String[]{"pc=today/region=north america", "pc=tomorrow/region=europe"});
        List parts = this.store.getPartitionsByNames(DB, tableName, names);
        Assert.assertArrayEquals((Object[])partVals[0], (Object[])((Partition)parts.get(0)).getValues().toArray(new String[2]));
        Assert.assertArrayEquals((Object[])partVals[1], (Object[])((Partition)parts.get(1)).getValues().toArray(new String[2]));
        this.store.dropPartitions(DB, tableName, names);
        List afterDropParts = this.store.getPartitions(DB, tableName, -1);
        Assert.assertEquals((long)0L, (long)afterDropParts.size());
    }

    @Test
    public void dropPartition() throws Exception {
        String tableName = "myparttable2";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", INT_TYPE, "nocomment"));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 0, serde, null, null, emptyParameters);
        ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>();
        partCols.add(new FieldSchema("pc", STRING_TYPE, ""));
        Table table = new Table(tableName, DB, "me", startTime, startTime, 0, sd, partCols, emptyParameters, null, null, null);
        this.store.createTable(table);
        List<String> vals = Arrays.asList("fred");
        StorageDescriptor psd = new StorageDescriptor(sd);
        psd.setLocation("file:/tmp/pc=fred");
        Partition part = new Partition(vals, DB, tableName, startTime, startTime, psd, emptyParameters);
        this.store.addPartition(part);
        Assert.assertNotNull((Object)this.store.getPartition(DB, tableName, vals));
        this.store.dropPartition(DB, tableName, vals);
        this.thrown.expect(NoSuchObjectException.class);
        this.store.getPartition(DB, tableName, vals);
    }

    @Test
    public void createIndex() throws Exception {
        String tableName = "mytable";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", INT_TYPE, ""));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", "value");
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 17, serde, Arrays.asList("bucketcol"), Arrays.asList(new Order("sortcol", 1)), params);
        Table table = new Table(tableName, "default", "me", startTime, startTime, 0, sd, null, emptyParameters, null, null, null);
        this.store.createTable(table);
        String indexName = "myindex";
        String indexTableName = tableName + "__" + indexName + "__";
        Index index = new Index(indexName, null, "default", tableName, startTime, startTime, indexTableName, sd, emptyParameters, false);
        this.store.addIndex(index);
        Index ind = this.store.getIndex("default", tableName, indexName);
        Assert.assertEquals((long)1L, (long)ind.getSd().getColsSize());
        Assert.assertEquals((Object)"col1", (Object)((FieldSchema)ind.getSd().getCols().get(0)).getName());
        Assert.assertEquals((Object)INT_TYPE, (Object)((FieldSchema)ind.getSd().getCols().get(0)).getType());
        Assert.assertEquals((Object)"", (Object)((FieldSchema)ind.getSd().getCols().get(0)).getComment());
        Assert.assertEquals((Object)"serde", (Object)ind.getSd().getSerdeInfo().getName());
        Assert.assertEquals((Object)"seriallib", (Object)ind.getSd().getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)"file:/tmp", (Object)ind.getSd().getLocation());
        Assert.assertEquals((Object)"input", (Object)ind.getSd().getInputFormat());
        Assert.assertEquals((Object)"output", (Object)ind.getSd().getOutputFormat());
        Assert.assertFalse((boolean)ind.getSd().isCompressed());
        Assert.assertEquals((long)17L, (long)ind.getSd().getNumBuckets());
        Assert.assertEquals((long)1L, (long)ind.getSd().getBucketColsSize());
        Assert.assertEquals((Object)"bucketcol", ind.getSd().getBucketCols().get(0));
        Assert.assertEquals((long)1L, (long)ind.getSd().getSortColsSize());
        Assert.assertEquals((Object)"sortcol", (Object)((Order)ind.getSd().getSortCols().get(0)).getCol());
        Assert.assertEquals((long)1L, (long)((Order)ind.getSd().getSortCols().get(0)).getOrder());
        Assert.assertEquals((long)1L, (long)ind.getSd().getParametersSize());
        Assert.assertEquals((Object)"value", ind.getSd().getParameters().get("key"));
        Assert.assertEquals((Object)indexName, (Object)ind.getIndexName());
        Assert.assertNull((Object)ind.getIndexHandlerClass());
        Assert.assertEquals((Object)"default", (Object)ind.getDbName());
        Assert.assertEquals((Object)tableName, (Object)ind.getOrigTableName());
        Assert.assertEquals((long)0L, (long)ind.getParametersSize());
        Assert.assertEquals((long)startTime, (long)ind.getCreateTime());
        Assert.assertEquals((long)startTime, (long)ind.getLastAccessTime());
        Assert.assertEquals((Object)false, (Object)ind.isDeferredRebuild());
    }

    @Test
    public void alterIndex() throws Exception {
        String tableName = "mytable";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", INT_TYPE, ""));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", "value");
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 17, serde, Arrays.asList("bucketcol"), Arrays.asList(new Order("sortcol", 1)), params);
        Table table = new Table(tableName, "default", "me", startTime, startTime, 0, sd, null, emptyParameters, null, null, null);
        this.store.createTable(table);
        String indexName = "myindex";
        Index index = new Index(indexName, null, "default", tableName, startTime, startTime, tableName + "__" + indexName + "__", sd, emptyParameters, false);
        this.store.addIndex(index);
        index.setLastAccessTime(startTime += 10);
        this.store.alterIndex("default", tableName, indexName, index);
        Index ind = this.store.getIndex("default", tableName, indexName);
        Assert.assertEquals((long)1L, (long)ind.getSd().getColsSize());
        Assert.assertEquals((Object)"col1", (Object)((FieldSchema)ind.getSd().getCols().get(0)).getName());
        Assert.assertEquals((Object)INT_TYPE, (Object)((FieldSchema)ind.getSd().getCols().get(0)).getType());
        Assert.assertEquals((Object)"", (Object)((FieldSchema)ind.getSd().getCols().get(0)).getComment());
        Assert.assertEquals((Object)"serde", (Object)ind.getSd().getSerdeInfo().getName());
        Assert.assertEquals((Object)"seriallib", (Object)ind.getSd().getSerdeInfo().getSerializationLib());
        Assert.assertEquals((Object)"file:/tmp", (Object)ind.getSd().getLocation());
        Assert.assertEquals((Object)"input", (Object)ind.getSd().getInputFormat());
        Assert.assertEquals((Object)"output", (Object)ind.getSd().getOutputFormat());
        Assert.assertFalse((boolean)ind.getSd().isCompressed());
        Assert.assertEquals((long)17L, (long)ind.getSd().getNumBuckets());
        Assert.assertEquals((long)1L, (long)ind.getSd().getBucketColsSize());
        Assert.assertEquals((Object)"bucketcol", ind.getSd().getBucketCols().get(0));
        Assert.assertEquals((long)1L, (long)ind.getSd().getSortColsSize());
        Assert.assertEquals((Object)"sortcol", (Object)((Order)ind.getSd().getSortCols().get(0)).getCol());
        Assert.assertEquals((long)1L, (long)((Order)ind.getSd().getSortCols().get(0)).getOrder());
        Assert.assertEquals((long)1L, (long)ind.getSd().getParametersSize());
        Assert.assertEquals((Object)"value", ind.getSd().getParameters().get("key"));
        Assert.assertEquals((Object)indexName, (Object)ind.getIndexName());
        Assert.assertNull((Object)ind.getIndexHandlerClass());
        Assert.assertEquals((Object)"default", (Object)ind.getDbName());
        Assert.assertEquals((Object)tableName, (Object)ind.getOrigTableName());
        Assert.assertEquals((long)0L, (long)ind.getParametersSize());
        Assert.assertEquals((long)startTime, (long)ind.getLastAccessTime());
        Assert.assertEquals((Object)false, (Object)ind.isDeferredRebuild());
    }

    @Test
    public void dropIndex() throws Exception {
        String tableName = "mytable";
        int startTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", INT_TYPE, ""));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", "value");
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 17, serde, Arrays.asList("bucketcol"), Arrays.asList(new Order("sortcol", 1)), params);
        Table table = new Table(tableName, "default", "me", startTime, startTime, 0, sd, null, emptyParameters, null, null, null);
        this.store.createTable(table);
        String indexName = "myindex";
        Index index = new Index(indexName, null, "default", tableName, startTime, startTime, tableName + "__" + indexName + "__", sd, emptyParameters, false);
        this.store.addIndex(index);
        this.store.dropIndex("default", tableName, indexName);
    }

    @Test
    public void createRole() throws Exception {
        int now = (int)System.currentTimeMillis() / 1000;
        String roleName = "myrole";
        this.store.addRole(roleName, "me");
        Role r = this.store.getRole(roleName);
        Assert.assertEquals((Object)roleName, (Object)r.getRoleName());
        Assert.assertEquals((Object)"me", (Object)r.getOwnerName());
        Assert.assertTrue((now <= r.getCreateTime() ? 1 : 0) != 0);
    }

    @Test
    public void dropRole() throws Exception {
        String roleName = "anotherrole";
        this.store.addRole(roleName, "me");
        Role role = this.store.getRole(roleName);
        Assert.assertNotNull((Object)role);
        this.store.removeRole(roleName);
        this.thrown.expect(NoSuchObjectException.class);
        this.store.getRole(roleName);
    }

    @Test
    public void booleanTableStatistics() throws Exception {
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockTblColStatsDesc();
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = booleanColStatsObjs.get(0);
        BooleanColumnStatsData boolData = obj.getStatsData().getBooleanStats();
        stats.addToStatsObj(obj);
        this.store.updateTableColumnStatistics(stats);
        ColumnStatistics statsFromDB = this.store.getTableColumnStatistics(DB, TBL, Arrays.asList(BOOLEAN_COL));
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)statsFromDB.getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)statsFromDB.getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)statsFromDB.getStatsDesc().getTableName());
        Assert.assertTrue((boolean)statsFromDB.getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)statsFromDB.getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)statsFromDB.getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.BOOLEAN_STATS, (Object)dataFromDB.getSetField());
        BooleanColumnStatsData boolDataFromDB = dataFromDB.getBooleanStats();
        Assert.assertEquals((long)boolData.getNumTrues(), (long)boolDataFromDB.getNumTrues());
        Assert.assertEquals((long)boolData.getNumFalses(), (long)boolDataFromDB.getNumFalses());
        Assert.assertEquals((long)boolData.getNumNulls(), (long)boolDataFromDB.getNumNulls());
    }

    @Test
    public void longTableStatistics() throws Exception {
        this.createMockTable(LONG_TYPE);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockTblColStatsDesc();
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = longColStatsObjs.get(0);
        LongColumnStatsData longData = obj.getStatsData().getLongStats();
        stats.addToStatsObj(obj);
        this.store.updateTableColumnStatistics(stats);
        ColumnStatistics statsFromDB = this.store.getTableColumnStatistics(DB, TBL, Arrays.asList(LONG_COL));
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)statsFromDB.getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)statsFromDB.getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)statsFromDB.getStatsDesc().getTableName());
        Assert.assertTrue((boolean)statsFromDB.getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)statsFromDB.getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)statsFromDB.getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.LONG_STATS, (Object)dataFromDB.getSetField());
        LongColumnStatsData longDataFromDB = dataFromDB.getLongStats();
        Assert.assertEquals((long)longData.getHighValue(), (long)longDataFromDB.getHighValue());
        Assert.assertEquals((long)longData.getLowValue(), (long)longDataFromDB.getLowValue());
        Assert.assertEquals((long)longData.getNumNulls(), (long)longDataFromDB.getNumNulls());
        Assert.assertEquals((long)longData.getNumDVs(), (long)longDataFromDB.getNumDVs());
    }

    @Test
    public void doubleTableStatistics() throws Exception {
        this.createMockTable(DOUBLE_TYPE);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockTblColStatsDesc();
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = doubleColStatsObjs.get(0);
        DoubleColumnStatsData doubleData = obj.getStatsData().getDoubleStats();
        stats.addToStatsObj(obj);
        this.store.updateTableColumnStatistics(stats);
        ColumnStatistics statsFromDB = this.store.getTableColumnStatistics(DB, TBL, Arrays.asList(DOUBLE_COL));
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)statsFromDB.getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)statsFromDB.getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)statsFromDB.getStatsDesc().getTableName());
        Assert.assertTrue((boolean)statsFromDB.getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)statsFromDB.getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)statsFromDB.getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.DOUBLE_STATS, (Object)dataFromDB.getSetField());
        DoubleColumnStatsData doubleDataFromDB = dataFromDB.getDoubleStats();
        Assert.assertEquals((double)doubleData.getHighValue(), (double)doubleDataFromDB.getHighValue(), (double)0.01);
        Assert.assertEquals((double)doubleData.getLowValue(), (double)doubleDataFromDB.getLowValue(), (double)0.01);
        Assert.assertEquals((long)doubleData.getNumNulls(), (long)doubleDataFromDB.getNumNulls());
        Assert.assertEquals((long)doubleData.getNumDVs(), (long)doubleDataFromDB.getNumDVs());
    }

    @Test
    public void stringTableStatistics() throws Exception {
        this.createMockTable(STRING_TYPE);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockTblColStatsDesc();
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = stringColStatsObjs.get(0);
        StringColumnStatsData stringData = obj.getStatsData().getStringStats();
        stats.addToStatsObj(obj);
        this.store.updateTableColumnStatistics(stats);
        ColumnStatistics statsFromDB = this.store.getTableColumnStatistics(DB, TBL, Arrays.asList(STRING_COL));
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)statsFromDB.getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)statsFromDB.getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)statsFromDB.getStatsDesc().getTableName());
        Assert.assertTrue((boolean)statsFromDB.getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)statsFromDB.getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)statsFromDB.getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.STRING_STATS, (Object)dataFromDB.getSetField());
        StringColumnStatsData stringDataFromDB = dataFromDB.getStringStats();
        Assert.assertEquals((long)stringData.getMaxColLen(), (long)stringDataFromDB.getMaxColLen());
        Assert.assertEquals((double)stringData.getAvgColLen(), (double)stringDataFromDB.getAvgColLen(), (double)0.01);
        Assert.assertEquals((long)stringData.getNumNulls(), (long)stringDataFromDB.getNumNulls());
        Assert.assertEquals((long)stringData.getNumDVs(), (long)stringDataFromDB.getNumDVs());
    }

    @Test
    public void binaryTableStatistics() throws Exception {
        this.createMockTable(BINARY_TYPE);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockTblColStatsDesc();
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = binaryColStatsObjs.get(0);
        BinaryColumnStatsData binaryData = obj.getStatsData().getBinaryStats();
        stats.addToStatsObj(obj);
        this.store.updateTableColumnStatistics(stats);
        ColumnStatistics statsFromDB = this.store.getTableColumnStatistics(DB, TBL, Arrays.asList(BINARY_COL));
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)statsFromDB.getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)statsFromDB.getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)statsFromDB.getStatsDesc().getTableName());
        Assert.assertTrue((boolean)statsFromDB.getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)statsFromDB.getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)statsFromDB.getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.BINARY_STATS, (Object)dataFromDB.getSetField());
        BinaryColumnStatsData binaryDataFromDB = dataFromDB.getBinaryStats();
        Assert.assertEquals((long)binaryData.getMaxColLen(), (long)binaryDataFromDB.getMaxColLen());
        Assert.assertEquals((double)binaryData.getAvgColLen(), (double)binaryDataFromDB.getAvgColLen(), (double)0.01);
        Assert.assertEquals((long)binaryData.getNumNulls(), (long)binaryDataFromDB.getNumNulls());
    }

    @Test
    public void decimalTableStatistics() throws Exception {
        this.createMockTable(DECIMAL_TYPE);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockTblColStatsDesc();
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = decimalColStatsObjs.get(0);
        DecimalColumnStatsData decimalData = obj.getStatsData().getDecimalStats();
        stats.addToStatsObj(obj);
        this.store.updateTableColumnStatistics(stats);
        ColumnStatistics statsFromDB = this.store.getTableColumnStatistics(DB, TBL, Arrays.asList(DECIMAL_COL));
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)statsFromDB.getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)statsFromDB.getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)statsFromDB.getStatsDesc().getTableName());
        Assert.assertTrue((boolean)statsFromDB.getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)statsFromDB.getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)statsFromDB.getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.DECIMAL_STATS, (Object)dataFromDB.getSetField());
        DecimalColumnStatsData decimalDataFromDB = dataFromDB.getDecimalStats();
        Assert.assertEquals((Object)decimalData.getHighValue(), (Object)decimalDataFromDB.getHighValue());
        Assert.assertEquals((Object)decimalData.getLowValue(), (Object)decimalDataFromDB.getLowValue());
        Assert.assertEquals((long)decimalData.getNumNulls(), (long)decimalDataFromDB.getNumNulls());
        Assert.assertEquals((long)decimalData.getNumDVs(), (long)decimalDataFromDB.getNumDVs());
    }

    @Test
    public void booleanPartitionStatistics() throws Exception {
        this.createMockTableAndPartition(BOOLEAN_TYPE, BOOLEAN_VAL);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockPartColStatsDesc("part", BOOLEAN_VAL);
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = booleanColStatsObjs.get(0);
        BooleanColumnStatsData boolData = obj.getStatsData().getBooleanStats();
        stats.addToStatsObj(obj);
        ArrayList<String> parVals = new ArrayList<String>();
        parVals.add(BOOLEAN_VAL);
        this.store.updatePartitionColumnStatistics(stats, parVals);
        ArrayList<String> partNames = new ArrayList<String>();
        partNames.add(desc.getPartName());
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add(obj.getColName());
        List statsFromDB = this.store.getPartitionColumnStatistics(DB, TBL, partNames, colNames);
        Assert.assertEquals((long)1L, (long)statsFromDB.size());
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getTableName());
        Assert.assertFalse((boolean)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)((ColumnStatistics)statsFromDB.get(0)).getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)((ColumnStatistics)statsFromDB.get(0)).getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.BOOLEAN_STATS, (Object)dataFromDB.getSetField());
        BooleanColumnStatsData boolDataFromDB = dataFromDB.getBooleanStats();
        Assert.assertEquals((long)boolData.getNumTrues(), (long)boolDataFromDB.getNumTrues());
        Assert.assertEquals((long)boolData.getNumFalses(), (long)boolDataFromDB.getNumFalses());
        Assert.assertEquals((long)boolData.getNumNulls(), (long)boolDataFromDB.getNumNulls());
    }

    @Test
    public void longPartitionStatistics() throws Exception {
        this.createMockTableAndPartition(INT_TYPE, INT_VAL);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockPartColStatsDesc("part", INT_VAL);
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = longColStatsObjs.get(0);
        LongColumnStatsData longData = obj.getStatsData().getLongStats();
        stats.addToStatsObj(obj);
        ArrayList<String> parVals = new ArrayList<String>();
        parVals.add(INT_VAL);
        this.store.updatePartitionColumnStatistics(stats, parVals);
        ArrayList<String> partNames = new ArrayList<String>();
        partNames.add(desc.getPartName());
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add(obj.getColName());
        List statsFromDB = this.store.getPartitionColumnStatistics(DB, TBL, partNames, colNames);
        Assert.assertEquals((long)1L, (long)statsFromDB.size());
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getTableName());
        Assert.assertFalse((boolean)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)((ColumnStatistics)statsFromDB.get(0)).getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)((ColumnStatistics)statsFromDB.get(0)).getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.LONG_STATS, (Object)dataFromDB.getSetField());
        LongColumnStatsData longDataFromDB = dataFromDB.getLongStats();
        Assert.assertEquals((long)longData.getHighValue(), (long)longDataFromDB.getHighValue());
        Assert.assertEquals((long)longData.getLowValue(), (long)longDataFromDB.getLowValue());
        Assert.assertEquals((long)longData.getNumNulls(), (long)longDataFromDB.getNumNulls());
        Assert.assertEquals((long)longData.getNumDVs(), (long)longDataFromDB.getNumDVs());
    }

    @Test
    public void doublePartitionStatistics() throws Exception {
        this.createMockTableAndPartition(DOUBLE_TYPE, DOUBLE_VAL);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockPartColStatsDesc("part", DOUBLE_VAL);
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = doubleColStatsObjs.get(0);
        DoubleColumnStatsData doubleData = obj.getStatsData().getDoubleStats();
        stats.addToStatsObj(obj);
        ArrayList<String> parVals = new ArrayList<String>();
        parVals.add(DOUBLE_VAL);
        this.store.updatePartitionColumnStatistics(stats, parVals);
        ArrayList<String> partNames = new ArrayList<String>();
        partNames.add(desc.getPartName());
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add(obj.getColName());
        List statsFromDB = this.store.getPartitionColumnStatistics(DB, TBL, partNames, colNames);
        Assert.assertEquals((long)1L, (long)statsFromDB.size());
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getTableName());
        Assert.assertFalse((boolean)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)((ColumnStatistics)statsFromDB.get(0)).getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)((ColumnStatistics)statsFromDB.get(0)).getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.DOUBLE_STATS, (Object)dataFromDB.getSetField());
        DoubleColumnStatsData doubleDataFromDB = dataFromDB.getDoubleStats();
        Assert.assertEquals((double)doubleData.getHighValue(), (double)doubleDataFromDB.getHighValue(), (double)0.01);
        Assert.assertEquals((double)doubleData.getLowValue(), (double)doubleDataFromDB.getLowValue(), (double)0.01);
        Assert.assertEquals((long)doubleData.getNumNulls(), (long)doubleDataFromDB.getNumNulls());
        Assert.assertEquals((long)doubleData.getNumDVs(), (long)doubleDataFromDB.getNumDVs());
    }

    @Test
    public void stringPartitionStatistics() throws Exception {
        this.createMockTableAndPartition(STRING_TYPE, STRING_VAL);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockPartColStatsDesc("part", STRING_VAL);
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = stringColStatsObjs.get(0);
        StringColumnStatsData stringData = obj.getStatsData().getStringStats();
        stats.addToStatsObj(obj);
        ArrayList<String> parVals = new ArrayList<String>();
        parVals.add(STRING_VAL);
        this.store.updatePartitionColumnStatistics(stats, parVals);
        ArrayList<String> partNames = new ArrayList<String>();
        partNames.add(desc.getPartName());
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add(obj.getColName());
        List statsFromDB = this.store.getPartitionColumnStatistics(DB, TBL, partNames, colNames);
        Assert.assertEquals((long)1L, (long)statsFromDB.size());
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getTableName());
        Assert.assertFalse((boolean)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)((ColumnStatistics)statsFromDB.get(0)).getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)((ColumnStatistics)statsFromDB.get(0)).getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.STRING_STATS, (Object)dataFromDB.getSetField());
        StringColumnStatsData stringDataFromDB = dataFromDB.getStringStats();
        Assert.assertEquals((long)stringData.getMaxColLen(), (long)stringDataFromDB.getMaxColLen());
        Assert.assertEquals((double)stringData.getAvgColLen(), (double)stringDataFromDB.getAvgColLen(), (double)0.01);
        Assert.assertEquals((long)stringData.getNumNulls(), (long)stringDataFromDB.getNumNulls());
        Assert.assertEquals((long)stringData.getNumDVs(), (long)stringDataFromDB.getNumDVs());
    }

    @Test
    public void binaryPartitionStatistics() throws Exception {
        this.createMockTableAndPartition(BINARY_TYPE, BINARY_VAL);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockPartColStatsDesc("part", BINARY_VAL);
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = binaryColStatsObjs.get(0);
        BinaryColumnStatsData binaryData = obj.getStatsData().getBinaryStats();
        stats.addToStatsObj(obj);
        ArrayList<String> parVals = new ArrayList<String>();
        parVals.add(BINARY_VAL);
        this.store.updatePartitionColumnStatistics(stats, parVals);
        ArrayList<String> partNames = new ArrayList<String>();
        partNames.add(desc.getPartName());
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add(obj.getColName());
        List statsFromDB = this.store.getPartitionColumnStatistics(DB, TBL, partNames, colNames);
        Assert.assertEquals((long)1L, (long)statsFromDB.size());
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getTableName());
        Assert.assertFalse((boolean)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)((ColumnStatistics)statsFromDB.get(0)).getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)((ColumnStatistics)statsFromDB.get(0)).getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.BINARY_STATS, (Object)dataFromDB.getSetField());
        BinaryColumnStatsData binaryDataFromDB = dataFromDB.getBinaryStats();
        Assert.assertEquals((long)binaryData.getMaxColLen(), (long)binaryDataFromDB.getMaxColLen());
        Assert.assertEquals((double)binaryData.getAvgColLen(), (double)binaryDataFromDB.getAvgColLen(), (double)0.01);
        Assert.assertEquals((long)binaryData.getNumNulls(), (long)binaryDataFromDB.getNumNulls());
    }

    @Test
    public void decimalPartitionStatistics() throws Exception {
        this.createMockTableAndPartition(DECIMAL_TYPE, DECIMAL_VAL);
        ColumnStatistics stats = new ColumnStatistics();
        ColumnStatisticsDesc desc = this.getMockPartColStatsDesc("part", DECIMAL_VAL);
        stats.setStatsDesc(desc);
        ColumnStatisticsObj obj = decimalColStatsObjs.get(0);
        DecimalColumnStatsData decimalData = obj.getStatsData().getDecimalStats();
        stats.addToStatsObj(obj);
        ArrayList<String> parVals = new ArrayList<String>();
        parVals.add(DECIMAL_VAL);
        this.store.updatePartitionColumnStatistics(stats, parVals);
        ArrayList<String> partNames = new ArrayList<String>();
        partNames.add(desc.getPartName());
        ArrayList<String> colNames = new ArrayList<String>();
        colNames.add(obj.getColName());
        List statsFromDB = this.store.getPartitionColumnStatistics(DB, TBL, partNames, colNames);
        Assert.assertEquals((long)1L, (long)statsFromDB.size());
        Assert.assertEquals((long)desc.getLastAnalyzed(), (long)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getLastAnalyzed());
        Assert.assertEquals((Object)DB, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getDbName());
        Assert.assertEquals((Object)TBL, (Object)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().getTableName());
        Assert.assertFalse((boolean)((ColumnStatistics)statsFromDB.get(0)).getStatsDesc().isIsTblLevel());
        Assert.assertEquals((long)1L, (long)((ColumnStatistics)statsFromDB.get(0)).getStatsObjSize());
        ColumnStatisticsObj objFromDB = (ColumnStatisticsObj)((ColumnStatistics)statsFromDB.get(0)).getStatsObj().get(0);
        ColumnStatisticsData dataFromDB = objFromDB.getStatsData();
        Assert.assertEquals((Object)ColumnStatisticsData._Fields.DECIMAL_STATS, (Object)dataFromDB.getSetField());
        DecimalColumnStatsData decimalDataFromDB = dataFromDB.getDecimalStats();
        Assert.assertEquals((Object)decimalData.getHighValue(), (Object)decimalDataFromDB.getHighValue());
        Assert.assertEquals((Object)decimalData.getLowValue(), (Object)decimalDataFromDB.getLowValue());
        Assert.assertEquals((long)decimalData.getNumNulls(), (long)decimalDataFromDB.getNumNulls());
        Assert.assertEquals((long)decimalData.getNumDVs(), (long)decimalDataFromDB.getNumDVs());
    }

    @Test
    public void createTableWithPrimaryKey() throws Exception {
        String tableName = "pktable";
        String pkName = "test_pk";
        String[] pkColNames = new String[]{"col0"};
        Table table = this.createMultiColumnTable(tableName, INT_TYPE);
        List pk = Arrays.asList(new SQLPrimaryKey(DB, tableName, pkColNames[0], 0, pkName, true, false, true));
        this.store.createTableWithConstraints(table, pk, null);
        pk = this.store.getPrimaryKeys(DB, tableName);
        Assert.assertNotNull((Object)pk);
        Assert.assertEquals((long)1L, (long)pk.size());
        Assert.assertEquals((Object)DB, (Object)((SQLPrimaryKey)pk.get(0)).getTable_db());
        Assert.assertEquals((Object)tableName, (Object)((SQLPrimaryKey)pk.get(0)).getTable_name());
        Assert.assertEquals((Object)pkColNames[0], (Object)((SQLPrimaryKey)pk.get(0)).getColumn_name());
        Assert.assertEquals((long)0L, (long)((SQLPrimaryKey)pk.get(0)).getKey_seq());
        Assert.assertEquals((Object)pkName, (Object)((SQLPrimaryKey)pk.get(0)).getPk_name());
        Assert.assertTrue((boolean)((SQLPrimaryKey)pk.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLPrimaryKey)pk.get(0)).isValidate_cstr());
        Assert.assertTrue((boolean)((SQLPrimaryKey)pk.get(0)).isRely_cstr());
        this.store.dropConstraint(DB, tableName, pkName);
        pk = this.store.getPrimaryKeys(DB, tableName);
        Assert.assertNull((Object)pk);
    }

    @Test
    public void createTableWithForeignKey() throws Exception {
        String tableName = "fktable";
        String pkTable = "pktable";
        String pkName = "test_pk";
        String fkName = "test_fk";
        String[] fkColNames = new String[]{"col0"};
        String[] pkColNames = new String[]{"pcol0"};
        Table table = this.createMultiColumnTable(tableName, INT_TYPE);
        List fk = Arrays.asList(new SQLForeignKey(DB, pkTable, pkColNames[0], DB, tableName, fkColNames[0], 0, 1, 2, fkName, pkName, true, false, false));
        this.store.createTableWithConstraints(table, null, fk);
        fk = this.store.getForeignKeys(DB, pkTable, DB, tableName);
        Assert.assertNotNull((Object)fk);
        Assert.assertEquals((long)1L, (long)fk.size());
        Assert.assertEquals((Object)DB, (Object)((SQLForeignKey)fk.get(0)).getPktable_db());
        Assert.assertEquals((Object)pkTable, (Object)((SQLForeignKey)fk.get(0)).getPktable_name());
        Assert.assertEquals((Object)pkColNames[0], (Object)((SQLForeignKey)fk.get(0)).getPkcolumn_name());
        Assert.assertEquals((Object)DB, (Object)((SQLForeignKey)fk.get(0)).getFktable_db());
        Assert.assertEquals((Object)tableName, (Object)((SQLForeignKey)fk.get(0)).getFktable_name());
        Assert.assertEquals((Object)fkColNames[0], (Object)((SQLForeignKey)fk.get(0)).getFkcolumn_name());
        Assert.assertEquals((long)0L, (long)((SQLForeignKey)fk.get(0)).getKey_seq());
        Assert.assertEquals((long)1L, (long)((SQLForeignKey)fk.get(0)).getUpdate_rule());
        Assert.assertEquals((long)2L, (long)((SQLForeignKey)fk.get(0)).getDelete_rule());
        Assert.assertEquals((Object)fkName, (Object)((SQLForeignKey)fk.get(0)).getFk_name());
        Assert.assertEquals((Object)pkName, (Object)((SQLForeignKey)fk.get(0)).getPk_name());
        Assert.assertTrue((boolean)((SQLForeignKey)fk.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLForeignKey)fk.get(0)).isValidate_cstr());
        Assert.assertFalse((boolean)((SQLForeignKey)fk.get(0)).isRely_cstr());
    }

    @Test
    public void addMultiColPrimaryKey() throws Exception {
        String tableName = "mcpktable";
        String pkName = "test_pk";
        String[] pkColNames = new String[]{"col0", "col1", "col2"};
        Table table = this.createMultiColumnTable(tableName, INT_TYPE, "varchar(32)", "decimal(10,2)");
        List<SQLPrimaryKey> pk = Arrays.asList(new SQLPrimaryKey(DB, tableName, pkColNames[1], 0, pkName, false, true, true), new SQLPrimaryKey(DB, tableName, pkColNames[2], 1, pkName, false, true, true));
        this.store.createTable(table);
        this.store.addPrimaryKeys(pk);
        Assert.assertNotNull(pk);
        Assert.assertEquals((long)2L, (long)pk.size());
        SQLPrimaryKey[] sorted = pk.toArray(new SQLPrimaryKey[2]);
        Arrays.sort(sorted, new Comparator<SQLPrimaryKey>(){

            @Override
            public int compare(SQLPrimaryKey o1, SQLPrimaryKey o2) {
                return o1.getColumn_name().compareTo(o2.getColumn_name());
            }
        });
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((Object)DB, (Object)sorted[i].getTable_db());
            Assert.assertEquals((Object)tableName, (Object)sorted[i].getTable_name());
            Assert.assertEquals((Object)pkColNames[i + 1], (Object)sorted[i].getColumn_name());
            Assert.assertEquals((long)i, (long)sorted[i].getKey_seq());
            Assert.assertEquals((Object)pkName, (Object)sorted[i].getPk_name());
            Assert.assertFalse((boolean)sorted[i].isEnable_cstr());
            Assert.assertTrue((boolean)sorted[i].isValidate_cstr());
            Assert.assertTrue((boolean)sorted[i].isRely_cstr());
        }
    }

    @Test
    public void addMultiColForeignKey() throws Exception {
        String tableName = "mcfktable";
        String pkTable = "pktable";
        String pkName = "test_pk";
        String fkName = "test_fk";
        String[] fkColNames = new String[]{"col0", "col1", "col2"};
        String[] pkColNames = new String[]{"pcol0", "pcol1"};
        Table table = this.createMultiColumnTable(tableName, INT_TYPE, DOUBLE_TYPE, "timestamp");
        List fk = Arrays.asList(new SQLForeignKey(DB, pkTable, pkColNames[0], DB, tableName, fkColNames[1], 0, 1, 2, fkName, pkName, true, false, false), new SQLForeignKey(DB, pkTable, pkColNames[1], DB, tableName, fkColNames[2], 1, 1, 2, fkName, pkName, true, false, false));
        this.store.createTable(table);
        this.store.addForeignKeys(fk);
        fk = this.store.getForeignKeys(DB, pkTable, DB, tableName);
        Assert.assertNotNull((Object)fk);
        Assert.assertEquals((long)2L, (long)fk.size());
        SQLForeignKey[] sorted = fk.toArray(new SQLForeignKey[2]);
        Arrays.sort(sorted, new Comparator<SQLForeignKey>(){

            @Override
            public int compare(SQLForeignKey o1, SQLForeignKey o2) {
                if (o1.getFk_name().equals(o2.getFk_name())) {
                    return o1.getFkcolumn_name().compareTo(o2.getFkcolumn_name());
                }
                return o1.getFk_name().compareTo(o2.getFk_name());
            }
        });
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((Object)DB, (Object)sorted[i].getPktable_db());
            Assert.assertEquals((Object)pkTable, (Object)sorted[i].getPktable_name());
            Assert.assertEquals((Object)pkColNames[i], (Object)sorted[i].getPkcolumn_name());
            Assert.assertEquals((Object)DB, (Object)sorted[i].getFktable_db());
            Assert.assertEquals((Object)tableName, (Object)sorted[i].getFktable_name());
            Assert.assertEquals((Object)fkColNames[i + 1], (Object)sorted[i].getFkcolumn_name());
            Assert.assertEquals((long)i, (long)sorted[i].getKey_seq());
            Assert.assertEquals((long)1L, (long)sorted[i].getUpdate_rule());
            Assert.assertEquals((long)2L, (long)sorted[i].getDelete_rule());
            Assert.assertEquals((Object)fkName, (Object)sorted[i].getFk_name());
            Assert.assertEquals((Object)pkName, (Object)sorted[i].getPk_name());
            Assert.assertTrue((boolean)sorted[i].isEnable_cstr());
            Assert.assertFalse((boolean)sorted[i].isValidate_cstr());
            Assert.assertFalse((boolean)sorted[i].isRely_cstr());
        }
    }

    @Test
    public void addMultiForeignKeys() throws Exception {
        String tableName = "mcfktable";
        String pkTable = "pktable";
        String pkTable2 = "pktable2";
        String pkName = "test_pk";
        String pkName2 = "test_pk2";
        String fkName = "test_fk";
        String fkName2 = "test_fk2";
        String[] fkColNames = new String[]{"col0", "col1", "col2"};
        String[] pkColNames = new String[]{"pcol0", "pcol1"};
        String[] pkColNames2 = new String[]{"p2col0"};
        Table table = this.createMultiColumnTable(tableName, INT_TYPE, DOUBLE_TYPE, "timestamp");
        List fk = Arrays.asList(new SQLForeignKey(DB, pkTable, pkColNames[0], DB, tableName, fkColNames[1], 0, 1, 2, fkName, pkName, true, false, true), new SQLForeignKey(DB, pkTable, pkColNames[1], DB, tableName, fkColNames[2], 1, 1, 2, fkName, pkName, true, false, true), new SQLForeignKey(DB, pkTable2, pkColNames2[0], DB, tableName, fkColNames[0], 0, 1, 2, fkName2, pkName2, true, false, true));
        this.store.createTable(table);
        this.store.addForeignKeys(fk);
        fk = this.store.getForeignKeys(DB, pkTable, DB, tableName);
        Assert.assertNotNull((Object)fk);
        Assert.assertEquals((long)2L, (long)fk.size());
        SQLForeignKey[] sorted = fk.toArray(new SQLForeignKey[2]);
        Arrays.sort(sorted, new Comparator<SQLForeignKey>(){

            @Override
            public int compare(SQLForeignKey o1, SQLForeignKey o2) {
                if (o1.getFk_name().equals(o2.getFk_name())) {
                    return o1.getFkcolumn_name().compareTo(o2.getFkcolumn_name());
                }
                return o1.getFk_name().compareTo(o2.getFk_name());
            }
        });
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((Object)DB, (Object)sorted[i].getPktable_db());
            Assert.assertEquals((Object)pkTable, (Object)sorted[i].getPktable_name());
            Assert.assertEquals((Object)pkColNames[i], (Object)sorted[i].getPkcolumn_name());
            Assert.assertEquals((Object)DB, (Object)sorted[i].getFktable_db());
            Assert.assertEquals((Object)tableName, (Object)sorted[i].getFktable_name());
            Assert.assertEquals((Object)fkColNames[i + 1], (Object)sorted[i].getFkcolumn_name());
            Assert.assertEquals((long)i, (long)sorted[i].getKey_seq());
            Assert.assertEquals((long)1L, (long)sorted[i].getUpdate_rule());
            Assert.assertEquals((long)2L, (long)sorted[i].getDelete_rule());
            Assert.assertEquals((Object)fkName, (Object)sorted[i].getFk_name());
            Assert.assertEquals((Object)pkName, (Object)sorted[i].getPk_name());
            Assert.assertTrue((boolean)sorted[i].isEnable_cstr());
            Assert.assertFalse((boolean)sorted[i].isValidate_cstr());
            Assert.assertTrue((boolean)sorted[i].isRely_cstr());
        }
        fk = this.store.getForeignKeys(DB, pkTable2, DB, tableName);
        Assert.assertNotNull((Object)fk);
        Assert.assertEquals((long)1L, (long)fk.size());
        Assert.assertEquals((Object)DB, (Object)((SQLForeignKey)fk.get(0)).getPktable_db());
        Assert.assertEquals((Object)pkTable2, (Object)((SQLForeignKey)fk.get(0)).getPktable_name());
        Assert.assertEquals((Object)pkColNames2[0], (Object)((SQLForeignKey)fk.get(0)).getPkcolumn_name());
        Assert.assertEquals((Object)DB, (Object)((SQLForeignKey)fk.get(0)).getFktable_db());
        Assert.assertEquals((Object)tableName, (Object)((SQLForeignKey)fk.get(0)).getFktable_name());
        Assert.assertEquals((Object)fkColNames[0], (Object)((SQLForeignKey)fk.get(0)).getFkcolumn_name());
        Assert.assertEquals((long)0L, (long)((SQLForeignKey)fk.get(0)).getKey_seq());
        Assert.assertEquals((long)1L, (long)((SQLForeignKey)fk.get(0)).getUpdate_rule());
        Assert.assertEquals((long)2L, (long)((SQLForeignKey)fk.get(0)).getDelete_rule());
        Assert.assertEquals((Object)fkName2, (Object)((SQLForeignKey)fk.get(0)).getFk_name());
        Assert.assertEquals((Object)pkName2, (Object)((SQLForeignKey)fk.get(0)).getPk_name());
        Assert.assertTrue((boolean)((SQLForeignKey)fk.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLForeignKey)fk.get(0)).isValidate_cstr());
        Assert.assertTrue((boolean)((SQLForeignKey)fk.get(0)).isRely_cstr());
    }

    @Test
    public void addSecondForeignKeys() throws Exception {
        String tableName = "mcfktable";
        String pkTable = "pktable";
        String pkTable2 = "pktable2";
        String pkName = "test_pk";
        String pkName2 = "test_pk2";
        String fkName = "test_fk";
        String fkName2 = "test_fk2";
        String[] fkColNames = new String[]{"col0", "col1", "col2"};
        String[] pkColNames = new String[]{"pcol0", "pcol1"};
        String[] pkColNames2 = new String[]{"p2col0"};
        Table table = this.createMultiColumnTable(tableName, INT_TYPE, DOUBLE_TYPE, "timestamp");
        List fk = Arrays.asList(new SQLForeignKey(DB, pkTable, pkColNames[0], DB, tableName, fkColNames[1], 0, 1, 2, fkName, pkName, true, false, true), new SQLForeignKey(DB, pkTable, pkColNames[1], DB, tableName, fkColNames[2], 1, 1, 2, fkName, pkName, true, false, true));
        this.store.createTable(table);
        this.store.addForeignKeys(fk);
        fk = Arrays.asList(new SQLForeignKey(DB, pkTable2, pkColNames2[0], DB, tableName, fkColNames[0], 0, 1, 2, fkName2, pkName2, true, false, true));
        this.store.addForeignKeys(fk);
        fk = this.store.getForeignKeys(DB, pkTable, DB, tableName);
        Assert.assertNotNull((Object)fk);
        Assert.assertEquals((long)2L, (long)fk.size());
        SQLForeignKey[] sorted = fk.toArray(new SQLForeignKey[2]);
        Arrays.sort(sorted, new Comparator<SQLForeignKey>(){

            @Override
            public int compare(SQLForeignKey o1, SQLForeignKey o2) {
                if (o1.getFk_name().equals(o2.getFk_name())) {
                    return o1.getFkcolumn_name().compareTo(o2.getFkcolumn_name());
                }
                return o1.getFk_name().compareTo(o2.getFk_name());
            }
        });
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals((Object)DB, (Object)sorted[i].getPktable_db());
            Assert.assertEquals((Object)pkTable, (Object)sorted[i].getPktable_name());
            Assert.assertEquals((Object)pkColNames[i], (Object)sorted[i].getPkcolumn_name());
            Assert.assertEquals((Object)DB, (Object)sorted[i].getFktable_db());
            Assert.assertEquals((Object)tableName, (Object)sorted[i].getFktable_name());
            Assert.assertEquals((Object)fkColNames[i + 1], (Object)sorted[i].getFkcolumn_name());
            Assert.assertEquals((long)i, (long)sorted[i].getKey_seq());
            Assert.assertEquals((long)1L, (long)sorted[i].getUpdate_rule());
            Assert.assertEquals((long)2L, (long)sorted[i].getDelete_rule());
            Assert.assertEquals((Object)fkName, (Object)sorted[i].getFk_name());
            Assert.assertEquals((Object)pkName, (Object)sorted[i].getPk_name());
            Assert.assertTrue((boolean)sorted[i].isEnable_cstr());
            Assert.assertFalse((boolean)sorted[i].isValidate_cstr());
            Assert.assertTrue((boolean)sorted[i].isRely_cstr());
        }
        fk = this.store.getForeignKeys(DB, pkTable2, DB, tableName);
        Assert.assertNotNull((Object)fk);
        Assert.assertEquals((long)1L, (long)fk.size());
        Assert.assertEquals((Object)DB, (Object)((SQLForeignKey)fk.get(0)).getPktable_db());
        Assert.assertEquals((Object)pkTable2, (Object)((SQLForeignKey)fk.get(0)).getPktable_name());
        Assert.assertEquals((Object)pkColNames2[0], (Object)((SQLForeignKey)fk.get(0)).getPkcolumn_name());
        Assert.assertEquals((Object)DB, (Object)((SQLForeignKey)fk.get(0)).getFktable_db());
        Assert.assertEquals((Object)tableName, (Object)((SQLForeignKey)fk.get(0)).getFktable_name());
        Assert.assertEquals((Object)fkColNames[0], (Object)((SQLForeignKey)fk.get(0)).getFkcolumn_name());
        Assert.assertEquals((long)0L, (long)((SQLForeignKey)fk.get(0)).getKey_seq());
        Assert.assertEquals((long)1L, (long)((SQLForeignKey)fk.get(0)).getUpdate_rule());
        Assert.assertEquals((long)2L, (long)((SQLForeignKey)fk.get(0)).getDelete_rule());
        Assert.assertEquals((Object)fkName2, (Object)((SQLForeignKey)fk.get(0)).getFk_name());
        Assert.assertEquals((Object)pkName2, (Object)((SQLForeignKey)fk.get(0)).getPk_name());
        Assert.assertTrue((boolean)((SQLForeignKey)fk.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLForeignKey)fk.get(0)).isValidate_cstr());
        Assert.assertTrue((boolean)((SQLForeignKey)fk.get(0)).isRely_cstr());
        fk = this.store.getForeignKeys(null, null, DB, tableName);
        Assert.assertNotNull((Object)fk);
        Assert.assertEquals((long)3L, (long)fk.size());
        this.store.dropConstraint(DB, tableName, fkName);
        fk = this.store.getForeignKeys(DB, pkTable2, DB, tableName);
        Assert.assertNotNull((Object)fk);
        Assert.assertEquals((long)1L, (long)fk.size());
        Assert.assertEquals((Object)DB, (Object)((SQLForeignKey)fk.get(0)).getPktable_db());
        Assert.assertEquals((Object)pkTable2, (Object)((SQLForeignKey)fk.get(0)).getPktable_name());
        Assert.assertEquals((Object)pkColNames2[0], (Object)((SQLForeignKey)fk.get(0)).getPkcolumn_name());
        Assert.assertEquals((Object)DB, (Object)((SQLForeignKey)fk.get(0)).getFktable_db());
        Assert.assertEquals((Object)tableName, (Object)((SQLForeignKey)fk.get(0)).getFktable_name());
        Assert.assertEquals((Object)fkColNames[0], (Object)((SQLForeignKey)fk.get(0)).getFkcolumn_name());
        Assert.assertEquals((long)0L, (long)((SQLForeignKey)fk.get(0)).getKey_seq());
        Assert.assertEquals((long)1L, (long)((SQLForeignKey)fk.get(0)).getUpdate_rule());
        Assert.assertEquals((long)2L, (long)((SQLForeignKey)fk.get(0)).getDelete_rule());
        Assert.assertEquals((Object)fkName2, (Object)((SQLForeignKey)fk.get(0)).getFk_name());
        Assert.assertEquals((Object)pkName2, (Object)((SQLForeignKey)fk.get(0)).getPk_name());
        Assert.assertTrue((boolean)((SQLForeignKey)fk.get(0)).isEnable_cstr());
        Assert.assertFalse((boolean)((SQLForeignKey)fk.get(0)).isValidate_cstr());
        Assert.assertTrue((boolean)((SQLForeignKey)fk.get(0)).isRely_cstr());
        this.store.dropConstraint(DB, tableName, fkName2);
        fk = this.store.getForeignKeys(DB, pkTable2, DB, tableName);
        Assert.assertNull((Object)fk);
    }

    @Test(expected=MetaException.class)
    public void doublePrimaryKey() throws Exception {
        String tableName = "pktable";
        String pkName = "test_pk";
        String[] pkColNames = new String[]{"col0"};
        Table table = this.createMultiColumnTable(tableName, INT_TYPE);
        List<SQLPrimaryKey> pk = Arrays.asList(new SQLPrimaryKey(DB, tableName, pkColNames[0], 0, pkName, true, false, true));
        this.store.createTableWithConstraints(table, pk, null);
        this.store.addPrimaryKeys(pk);
    }

    private Table createMockTableAndPartition(String partType, String partVal) throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", partType, ""));
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(partVal);
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", "value");
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 17, serde, Arrays.asList("bucketcol"), Arrays.asList(new Order("sortcol", 1)), params);
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        Table table = new Table(TBL, DB, "me", currentTime, currentTime, 0, sd, cols, emptyParameters, null, null, null);
        this.store.createTable(table);
        Partition part = new Partition(vals, DB, TBL, currentTime, currentTime, sd, emptyParameters);
        this.store.addPartition(part);
        return table;
    }

    private Table createMockTable(String type) throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        cols.add(new FieldSchema("col1", type, ""));
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", "value");
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 17, serde, Arrays.asList("bucketcol"), Arrays.asList(new Order("sortcol", 1)), params);
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        Table table = new Table(TBL, DB, "me", currentTime, currentTime, 0, sd, cols, emptyParameters, null, null, null);
        this.store.createTable(table);
        return table;
    }

    private Table createMultiColumnTable(String tblName, String ... types) throws Exception {
        ArrayList<FieldSchema> cols = new ArrayList<FieldSchema>();
        for (int i = 0; i < types.length; ++i) {
            cols.add(new FieldSchema(COL + i, types[i], ""));
        }
        SerDeInfo serde = new SerDeInfo("serde", "seriallib", null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key", "value");
        StorageDescriptor sd = new StorageDescriptor(cols, "file:/tmp", "input", "output", false, 17, serde, Arrays.asList("bucketcol"), Arrays.asList(new Order("sortcol", 1)), params);
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        Table table = new Table(tblName, DB, "me", currentTime, currentTime, 0, sd, cols, emptyParameters, null, null, null);
        this.store.createTable(table);
        return table;
    }

    private ColumnStatisticsDesc getMockTblColStatsDesc() {
        ColumnStatisticsDesc desc = new ColumnStatisticsDesc();
        desc.setLastAnalyzed(DEFAULT_TIME);
        desc.setDbName(DB);
        desc.setTableName(TBL);
        desc.setIsTblLevel(true);
        return desc;
    }

    private ColumnStatisticsDesc getMockPartColStatsDesc(String partKey, String partVal) {
        ColumnStatisticsDesc desc = new ColumnStatisticsDesc();
        desc.setLastAnalyzed(DEFAULT_TIME);
        desc.setDbName(DB);
        desc.setTableName(TBL);
        desc.setPartName(partKey + PART_KV_SEPARATOR + partVal);
        desc.setIsTblLevel(false);
        return desc;
    }

    static {
        int i;
        LOG = LoggerFactory.getLogger((String)TestHBaseStore.class.getName());
        emptyParameters = new HashMap<String, String>();
        PART_KEYS = new ArrayList<String>();
        PART_VALS = new ArrayList<String>();
        for (i = 1; i <= 1; ++i) {
            PART_KEYS.add("part" + i);
        }
        for (i = 1; i <= 5; ++i) {
            PART_VALS.add(PART_VAL_PREFIX + i);
        }
        DEFAULT_TIME = System.currentTimeMillis();
        booleanColStatsObjs = new ArrayList<ColumnStatisticsObj>(5);
        longColStatsObjs = new ArrayList<ColumnStatisticsObj>(5);
        doubleColStatsObjs = new ArrayList<ColumnStatisticsObj>(5);
        stringColStatsObjs = new ArrayList<ColumnStatisticsObj>(5);
        binaryColStatsObjs = new ArrayList<ColumnStatisticsObj>(5);
        decimalColStatsObjs = new ArrayList<ColumnStatisticsObj>(5);
    }
}

