/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase;

import com.google.common.primitives.Shorts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.metastore.PartFilterExprUtil;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.hbase.HBaseFilterPlanUtil;
import org.apache.hadoop.hive.metastore.hbase.PartitionKeyComparator;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.junit.Assert;
import org.junit.Test;

public class TestHBaseFilterPlanUtil {
    final boolean INCLUSIVE = true;

    @Test
    public void testCompare() {
        Assert.assertEquals((long)-1L, (long)HBaseFilterPlanUtil.compare((byte[])new byte[]{1, 2}, (byte[])new byte[]{1, 3}));
        Assert.assertEquals((long)-1L, (long)HBaseFilterPlanUtil.compare((byte[])new byte[]{1, 2, 3}, (byte[])new byte[]{1, 3}));
        Assert.assertEquals((long)-1L, (long)HBaseFilterPlanUtil.compare((byte[])new byte[]{1, 2}, (byte[])new byte[]{1, 2, 3}));
        Assert.assertEquals((long)0L, (long)HBaseFilterPlanUtil.compare((byte[])new byte[]{3, 2}, (byte[])new byte[]{3, 2}));
        Assert.assertEquals((long)1L, (long)HBaseFilterPlanUtil.compare((byte[])new byte[]{3, 2, 1}, (byte[])new byte[]{3, 2}));
        Assert.assertEquals((long)1L, (long)HBaseFilterPlanUtil.compare((byte[])new byte[]{3, 3, 1}, (byte[])new byte[]{3, 2}));
    }

    @Test
    public void testgetComparedMarker() {
        HBaseFilterPlanUtil.ScanPlan.ScanMarker l = new HBaseFilterPlanUtil.ScanPlan.ScanMarker("1", true, "int");
        HBaseFilterPlanUtil.ScanPlan.ScanMarker r = new HBaseFilterPlanUtil.ScanPlan.ScanMarker("1", true, "int");
        this.assertFirstGreater(l, r);
        l = new HBaseFilterPlanUtil.ScanPlan.ScanMarker("1", false, "int");
        r = new HBaseFilterPlanUtil.ScanPlan.ScanMarker("1", false, "int");
        this.assertFirstGreater(l, r);
        this.assertFirstGreater(null, null);
        l = new HBaseFilterPlanUtil.ScanPlan.ScanMarker("1", false, "int");
        Assert.assertEquals((Object)l, (Object)HBaseFilterPlanUtil.ScanPlan.getComparedMarker((HBaseFilterPlanUtil.ScanPlan.ScanMarker)l, null, (boolean)true));
        Assert.assertEquals((Object)l, (Object)HBaseFilterPlanUtil.ScanPlan.getComparedMarker(null, (HBaseFilterPlanUtil.ScanPlan.ScanMarker)l, (boolean)true));
        Assert.assertEquals((Object)l, (Object)HBaseFilterPlanUtil.ScanPlan.getComparedMarker((HBaseFilterPlanUtil.ScanPlan.ScanMarker)l, null, (boolean)false));
        Assert.assertEquals((Object)l, (Object)HBaseFilterPlanUtil.ScanPlan.getComparedMarker(null, (HBaseFilterPlanUtil.ScanPlan.ScanMarker)l, (boolean)false));
        l = new HBaseFilterPlanUtil.ScanPlan.ScanMarker("2", true, "int");
        r = new HBaseFilterPlanUtil.ScanPlan.ScanMarker("1", true, "int");
        this.assertFirstGreater(l, r);
    }

    private void assertFirstGreater(HBaseFilterPlanUtil.ScanPlan.ScanMarker big, HBaseFilterPlanUtil.ScanPlan.ScanMarker small) {
        Assert.assertEquals((Object)big, (Object)HBaseFilterPlanUtil.ScanPlan.getComparedMarker((HBaseFilterPlanUtil.ScanPlan.ScanMarker)big, (HBaseFilterPlanUtil.ScanPlan.ScanMarker)small, (boolean)true));
        Assert.assertEquals((Object)big, (Object)HBaseFilterPlanUtil.ScanPlan.getComparedMarker((HBaseFilterPlanUtil.ScanPlan.ScanMarker)small, (HBaseFilterPlanUtil.ScanPlan.ScanMarker)big, (boolean)true));
        Assert.assertEquals((Object)small, (Object)HBaseFilterPlanUtil.ScanPlan.getComparedMarker((HBaseFilterPlanUtil.ScanPlan.ScanMarker)big, (HBaseFilterPlanUtil.ScanPlan.ScanMarker)small, (boolean)false));
        Assert.assertEquals((Object)small, (Object)HBaseFilterPlanUtil.ScanPlan.getComparedMarker((HBaseFilterPlanUtil.ScanPlan.ScanMarker)small, (HBaseFilterPlanUtil.ScanPlan.ScanMarker)big, (boolean)false));
    }

    @Test
    public void testScanPlanAnd() {
        HBaseFilterPlanUtil.ScanPlan l = new HBaseFilterPlanUtil.ScanPlan();
        HBaseFilterPlanUtil.ScanPlan r = new HBaseFilterPlanUtil.ScanPlan();
        l.setStartMarker("a", "int", "10", true);
        r.setStartMarker("a", "int", "10", true);
        HBaseFilterPlanUtil.ScanPlan res = (HBaseFilterPlanUtil.ScanPlan)l.and((HBaseFilterPlanUtil.FilterPlan)r).getPlans().get(0);
        Assert.assertEquals((Object)new HBaseFilterPlanUtil.ScanPlan.ScanMarker("10", true, "int"), (Object)((HBaseFilterPlanUtil.ScanPlan.ScanMarkerPair)res.markers.get((Object)"a")).startMarker);
        l.setEndMarker("a", "int", "20", true);
        r.setEndMarker("a", "int", "20", true);
        res = (HBaseFilterPlanUtil.ScanPlan)l.and((HBaseFilterPlanUtil.FilterPlan)r).getPlans().get(0);
        Assert.assertEquals((Object)new HBaseFilterPlanUtil.ScanPlan.ScanMarker("10", true, "int"), (Object)((HBaseFilterPlanUtil.ScanPlan.ScanMarkerPair)res.markers.get((Object)"a")).startMarker);
        Assert.assertEquals((Object)new HBaseFilterPlanUtil.ScanPlan.ScanMarker("20", true, "int"), (Object)((HBaseFilterPlanUtil.ScanPlan.ScanMarkerPair)res.markers.get((Object)"a")).endMarker);
        l.setStartMarker("a", "int", "10", false);
        l.setEndMarker("a", "int", "20", true);
        r.setStartMarker("a", "int", "10", true);
        r.setEndMarker("a", "int", "15", true);
        res = (HBaseFilterPlanUtil.ScanPlan)l.and((HBaseFilterPlanUtil.FilterPlan)r).getPlans().get(0);
        Assert.assertEquals((Object)((HBaseFilterPlanUtil.ScanPlan.ScanMarkerPair)l.markers.get((Object)"a")).startMarker, (Object)((HBaseFilterPlanUtil.ScanPlan.ScanMarkerPair)res.markers.get((Object)"a")).startMarker);
        Assert.assertEquals((Object)((HBaseFilterPlanUtil.ScanPlan.ScanMarkerPair)r.markers.get((Object)"a")).endMarker, (Object)((HBaseFilterPlanUtil.ScanPlan.ScanMarkerPair)res.markers.get((Object)"a")).endMarker);
    }

    @Test
    public void testScanPlanOr() {
        HBaseFilterPlanUtil.ScanPlan l = new HBaseFilterPlanUtil.ScanPlan();
        HBaseFilterPlanUtil.ScanPlan r = new HBaseFilterPlanUtil.ScanPlan();
        l.setStartMarker("a", "int", "1", true);
        r.setStartMarker("a", "int", "11", true);
        HBaseFilterPlanUtil.FilterPlan res1 = l.or((HBaseFilterPlanUtil.FilterPlan)r);
        Assert.assertEquals((long)2L, (long)res1.getPlans().size());
        ((HBaseFilterPlanUtil.ScanPlan.ScanMarkerPair)((HBaseFilterPlanUtil.ScanPlan)res1.getPlans().get((int)0)).markers.get((Object)"a")).startMarker.equals((Object)((HBaseFilterPlanUtil.ScanPlan.ScanMarkerPair)l.markers.get((Object)"a")).startMarker);
        ((HBaseFilterPlanUtil.ScanPlan.ScanMarkerPair)((HBaseFilterPlanUtil.ScanPlan)res1.getPlans().get((int)1)).markers.get((Object)"a")).startMarker.equals((Object)((HBaseFilterPlanUtil.ScanPlan.ScanMarkerPair)r.markers.get((Object)"a")).startMarker);
        HBaseFilterPlanUtil.FilterPlan res2 = res1.or((HBaseFilterPlanUtil.FilterPlan)r);
        Assert.assertEquals((long)3L, (long)res2.getPlans().size());
    }

    @Test
    public void testMultiScanPlanOr() {
        HBaseFilterPlanUtil.MultiScanPlan l = this.createMultiScanPlan(new HBaseFilterPlanUtil.ScanPlan());
        HBaseFilterPlanUtil.MultiScanPlan r = this.createMultiScanPlan(new HBaseFilterPlanUtil.ScanPlan());
        Assert.assertEquals((long)2L, (long)l.or((HBaseFilterPlanUtil.FilterPlan)r).getPlans().size());
        Assert.assertEquals((long)2L, (long)l.or((HBaseFilterPlanUtil.FilterPlan)new HBaseFilterPlanUtil.ScanPlan()).getPlans().size());
        Assert.assertEquals((long)2L, (long)new HBaseFilterPlanUtil.ScanPlan().or((HBaseFilterPlanUtil.FilterPlan)l).getPlans().size());
        r = this.createMultiScanPlan(new HBaseFilterPlanUtil.ScanPlan(), new HBaseFilterPlanUtil.ScanPlan());
        Assert.assertEquals((long)3L, (long)l.or((HBaseFilterPlanUtil.FilterPlan)r).getPlans().size());
        Assert.assertEquals((long)3L, (long)r.or((HBaseFilterPlanUtil.FilterPlan)l).getPlans().size());
    }

    private HBaseFilterPlanUtil.MultiScanPlan createMultiScanPlan(HBaseFilterPlanUtil.ScanPlan ... scanPlans) {
        return new HBaseFilterPlanUtil.MultiScanPlan(Arrays.asList(scanPlans));
    }

    @Test
    public void testMultiScanPlanAnd() {
        HBaseFilterPlanUtil.MultiScanPlan l = this.createMultiScanPlan(new HBaseFilterPlanUtil.ScanPlan());
        HBaseFilterPlanUtil.MultiScanPlan r = this.createMultiScanPlan(new HBaseFilterPlanUtil.ScanPlan());
        Assert.assertEquals((long)1L, (long)l.and((HBaseFilterPlanUtil.FilterPlan)r).getPlans().size());
        r = this.createMultiScanPlan(new HBaseFilterPlanUtil.ScanPlan(), new HBaseFilterPlanUtil.ScanPlan());
        Assert.assertEquals((long)2L, (long)l.and((HBaseFilterPlanUtil.FilterPlan)r).getPlans().size());
        Assert.assertEquals((long)2L, (long)r.and((HBaseFilterPlanUtil.FilterPlan)l).getPlans().size());
        l = this.createMultiScanPlan(new HBaseFilterPlanUtil.ScanPlan(), new HBaseFilterPlanUtil.ScanPlan());
        r = this.createMultiScanPlan(new HBaseFilterPlanUtil.ScanPlan(), new HBaseFilterPlanUtil.ScanPlan(), new HBaseFilterPlanUtil.ScanPlan());
        Assert.assertEquals((long)6L, (long)l.and((HBaseFilterPlanUtil.FilterPlan)r).getPlans().size());
        Assert.assertEquals((long)6L, (long)r.and((HBaseFilterPlanUtil.FilterPlan)l).getPlans().size());
    }

    @Test
    public void testLeafNodePlan() throws MetaException {
        String KEY = "k1";
        String VAL = "v1";
        String OTHERKEY = "k2";
        ExpressionTree.LeafNode l = new ExpressionTree.LeafNode();
        l.keyName = "k1";
        l.value = "v1";
        HBaseFilterPlanUtil.ScanPlan.ScanMarker DEFAULT_SCANMARKER = null;
        ArrayList<FieldSchema> parts = new ArrayList<FieldSchema>();
        parts.add(new FieldSchema("k1", "int", null));
        parts.add(new FieldSchema("k2", "int", null));
        l.operator = ExpressionTree.Operator.EQUALS;
        this.verifyPlan((ExpressionTree.TreeNode)l, parts, "k1", new HBaseFilterPlanUtil.ScanPlan.ScanMarker("v1", true, "int"), new HBaseFilterPlanUtil.ScanPlan.ScanMarker("v1", true, "int"));
        l.operator = ExpressionTree.Operator.GREATERTHAN;
        this.verifyPlan((ExpressionTree.TreeNode)l, parts, "k1", new HBaseFilterPlanUtil.ScanPlan.ScanMarker("v1", false, "int"), DEFAULT_SCANMARKER);
        l.operator = ExpressionTree.Operator.GREATERTHANOREQUALTO;
        this.verifyPlan((ExpressionTree.TreeNode)l, parts, "k1", new HBaseFilterPlanUtil.ScanPlan.ScanMarker("v1", true, "int"), DEFAULT_SCANMARKER);
        l.operator = ExpressionTree.Operator.LESSTHAN;
        this.verifyPlan((ExpressionTree.TreeNode)l, parts, "k1", DEFAULT_SCANMARKER, new HBaseFilterPlanUtil.ScanPlan.ScanMarker("v1", false, "int"));
        l.operator = ExpressionTree.Operator.LESSTHANOREQUALTO;
        this.verifyPlan((ExpressionTree.TreeNode)l, parts, "k1", DEFAULT_SCANMARKER, new HBaseFilterPlanUtil.ScanPlan.ScanMarker("v1", true, "int"));
        l.operator = ExpressionTree.Operator.EQUALS;
        this.verifyPlan((ExpressionTree.TreeNode)l, parts, "k2", DEFAULT_SCANMARKER, DEFAULT_SCANMARKER, false);
        this.verifyPlan(null, parts, "k1", DEFAULT_SCANMARKER, DEFAULT_SCANMARKER, true);
    }

    private void verifyPlan(ExpressionTree.TreeNode l, List<FieldSchema> parts, String keyName, HBaseFilterPlanUtil.ScanPlan.ScanMarker startMarker, HBaseFilterPlanUtil.ScanPlan.ScanMarker endMarker) throws MetaException {
        this.verifyPlan(l, parts, keyName, startMarker, endMarker, false);
    }

    private void verifyPlan(ExpressionTree.TreeNode l, List<FieldSchema> parts, String keyName, HBaseFilterPlanUtil.ScanPlan.ScanMarker startMarker, HBaseFilterPlanUtil.ScanPlan.ScanMarker endMarker, boolean hasUnsupportedCondition) throws MetaException {
        ExpressionTree e = null;
        if (l != null) {
            e = new ExpressionTree();
            e.setRootForTest(l);
        }
        HBaseFilterPlanUtil.PlanResult planRes = HBaseFilterPlanUtil.getFilterPlan(e, parts);
        HBaseFilterPlanUtil.FilterPlan plan = planRes.plan;
        Assert.assertEquals((String)"Has unsupported condition", (Object)hasUnsupportedCondition, (Object)planRes.hasUnsupportedCondition);
        Assert.assertEquals((long)1L, (long)plan.getPlans().size());
        HBaseFilterPlanUtil.ScanPlan splan = (HBaseFilterPlanUtil.ScanPlan)plan.getPlans().get(0);
        if (startMarker != null) {
            Assert.assertEquals((Object)startMarker, (Object)((HBaseFilterPlanUtil.ScanPlan.ScanMarkerPair)splan.markers.get((Object)keyName)).startMarker);
        } else {
            Assert.assertTrue((splan.markers.get(keyName) == null || ((HBaseFilterPlanUtil.ScanPlan.ScanMarkerPair)splan.markers.get((Object)keyName)).startMarker == null ? 1 : 0) != 0);
        }
        if (endMarker != null) {
            Assert.assertEquals((Object)endMarker, (Object)((HBaseFilterPlanUtil.ScanPlan.ScanMarkerPair)splan.markers.get((Object)keyName)).endMarker);
        } else {
            Assert.assertTrue((splan.markers.get(keyName) == null || ((HBaseFilterPlanUtil.ScanPlan.ScanMarkerPair)splan.markers.get((Object)keyName)).endMarker == null ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTreeNodePlan() throws MetaException {
        String KEY = "k1";
        String VAL1 = "10";
        String VAL2 = "11";
        ExpressionTree.LeafNode l = new ExpressionTree.LeafNode();
        l.keyName = "k1";
        l.value = "10";
        HBaseFilterPlanUtil.ScanPlan.ScanMarker DEFAULT_SCANMARKER = null;
        ArrayList<FieldSchema> parts = new ArrayList<FieldSchema>();
        parts.add(new FieldSchema("k1", "int", null));
        ExpressionTree.LeafNode r = new ExpressionTree.LeafNode();
        r.keyName = "k1";
        r.value = "11";
        ExpressionTree.TreeNode tn = new ExpressionTree.TreeNode((ExpressionTree.TreeNode)l, ExpressionTree.LogicalOperator.AND, (ExpressionTree.TreeNode)r);
        l.operator = ExpressionTree.Operator.GREATERTHANOREQUALTO;
        r.operator = ExpressionTree.Operator.LESSTHAN;
        this.verifyPlan(tn, parts, "k1", new HBaseFilterPlanUtil.ScanPlan.ScanMarker("10", true, "int"), new HBaseFilterPlanUtil.ScanPlan.ScanMarker("11", false, "int"));
        l.operator = ExpressionTree.Operator.GREATERTHANOREQUALTO;
        r.operator = ExpressionTree.Operator.GREATERTHAN;
        this.verifyPlan(tn, parts, "k1", new HBaseFilterPlanUtil.ScanPlan.ScanMarker("11", false, "int"), DEFAULT_SCANMARKER);
        tn = new ExpressionTree.TreeNode((ExpressionTree.TreeNode)l, ExpressionTree.LogicalOperator.OR, (ExpressionTree.TreeNode)r);
        ExpressionTree e = new ExpressionTree();
        e.setRootForTest(tn);
        HBaseFilterPlanUtil.PlanResult planRes = HBaseFilterPlanUtil.getFilterPlan((ExpressionTree)e, parts);
        Assert.assertEquals((long)2L, (long)planRes.plan.getPlans().size());
        Assert.assertEquals((Object)false, (Object)planRes.hasUnsupportedCondition);
        ExpressionTree.TreeNode tn2 = new ExpressionTree.TreeNode((ExpressionTree.TreeNode)l, ExpressionTree.LogicalOperator.AND, tn);
        e = new ExpressionTree();
        e.setRootForTest(tn2);
        planRes = HBaseFilterPlanUtil.getFilterPlan((ExpressionTree)e, parts);
        Assert.assertEquals((long)2L, (long)planRes.plan.getPlans().size());
        Assert.assertEquals((Object)false, (Object)planRes.hasUnsupportedCondition);
        ExpressionTree.LeafNode klike = new ExpressionTree.LeafNode();
        klike.keyName = "k1";
        klike.value = "10";
        klike.operator = ExpressionTree.Operator.LIKE;
        ExpressionTree.TreeNode tn3 = new ExpressionTree.TreeNode(tn2, ExpressionTree.LogicalOperator.OR, (ExpressionTree.TreeNode)klike);
        e = new ExpressionTree();
        e.setRootForTest(tn3);
        planRes = HBaseFilterPlanUtil.getFilterPlan((ExpressionTree)e, parts);
        Assert.assertEquals((long)3L, (long)planRes.plan.getPlans().size());
        Assert.assertEquals((Object)false, (Object)planRes.hasUnsupportedCondition);
    }

    @Test
    public void testPartitionKeyScannerAllString() throws Exception {
        ArrayList<FieldSchema> parts = new ArrayList<FieldSchema>();
        parts.add(new FieldSchema("year", "string", null));
        parts.add(new FieldSchema("month", "string", null));
        parts.add(new FieldSchema("state", "string", null));
        ExpressionTree exprTree = PartFilterExprUtil.getFilterParser((String)"year = 2015 and state = 'CA'").tree;
        HBaseFilterPlanUtil.PlanResult planRes = HBaseFilterPlanUtil.getFilterPlan((ExpressionTree)exprTree, parts);
        Assert.assertEquals((long)planRes.plan.getPlans().size(), (long)1L);
        HBaseFilterPlanUtil.ScanPlan sp = (HBaseFilterPlanUtil.ScanPlan)planRes.plan.getPlans().get(0);
        byte[] startRowSuffix = sp.getStartRowSuffix("testdb", "testtb", parts);
        byte[] endRowSuffix = sp.getEndRowSuffix("testdb", "testtb", parts);
        RowFilter filter = (RowFilter)sp.getFilter(parts);
        Assert.assertTrue((boolean)Bytes.contains((byte[])startRowSuffix, (byte[])"2015".getBytes()));
        Assert.assertTrue((boolean)Bytes.contains((byte[])endRowSuffix, (byte[])"2015".getBytes()));
        Assert.assertFalse((boolean)Bytes.contains((byte[])startRowSuffix, (byte[])"CA".getBytes()));
        Assert.assertFalse((boolean)Bytes.contains((byte[])endRowSuffix, (byte[])"CA".getBytes()));
        PartitionKeyComparator comparator = (PartitionKeyComparator)filter.getComparator();
        Assert.assertEquals((long)comparator.ranges.size(), (long)1L);
        Assert.assertEquals((Object)((PartitionKeyComparator.Range)comparator.ranges.get((int)0)).keyName, (Object)"state");
        exprTree = PartFilterExprUtil.getFilterParser((String)"year = 2015 and month > 10 and month <= 11 and state like 'C%'").tree;
        planRes = HBaseFilterPlanUtil.getFilterPlan((ExpressionTree)exprTree, parts);
        Assert.assertEquals((long)planRes.plan.getPlans().size(), (long)1L);
        sp = (HBaseFilterPlanUtil.ScanPlan)planRes.plan.getPlans().get(0);
        startRowSuffix = sp.getStartRowSuffix("testdb", "testtb", parts);
        endRowSuffix = sp.getEndRowSuffix("testdb", "testtb", parts);
        filter = (RowFilter)sp.getFilter(parts);
        Assert.assertTrue((boolean)Bytes.contains((byte[])startRowSuffix, (byte[])"2015".getBytes()));
        Assert.assertTrue((boolean)Bytes.contains((byte[])endRowSuffix, (byte[])"2015".getBytes()));
        Assert.assertTrue((boolean)Bytes.contains((byte[])startRowSuffix, (byte[])"10".getBytes()));
        Assert.assertTrue((boolean)Bytes.contains((byte[])endRowSuffix, (byte[])"11".getBytes()));
        comparator = (PartitionKeyComparator)filter.getComparator();
        Assert.assertEquals((long)comparator.ops.size(), (long)1L);
        Assert.assertEquals((Object)((PartitionKeyComparator.Operator)comparator.ops.get((int)0)).keyName, (Object)"state");
        exprTree = PartFilterExprUtil.getFilterParser((String)"year >= 2014 and month > 10 and month <= 11 and state like 'C%'").tree;
        planRes = HBaseFilterPlanUtil.getFilterPlan((ExpressionTree)exprTree, parts);
        Assert.assertEquals((long)planRes.plan.getPlans().size(), (long)1L);
        sp = (HBaseFilterPlanUtil.ScanPlan)planRes.plan.getPlans().get(0);
        startRowSuffix = sp.getStartRowSuffix("testdb", "testtb", parts);
        endRowSuffix = sp.getEndRowSuffix("testdb", "testtb", parts);
        filter = (RowFilter)sp.getFilter(parts);
        Assert.assertTrue((boolean)Bytes.contains((byte[])startRowSuffix, (byte[])"2014".getBytes()));
        comparator = (PartitionKeyComparator)filter.getComparator();
        Assert.assertEquals((long)comparator.ranges.size(), (long)1L);
        Assert.assertEquals((Object)((PartitionKeyComparator.Range)comparator.ranges.get((int)0)).keyName, (Object)"month");
        Assert.assertEquals((long)comparator.ops.size(), (long)1L);
        Assert.assertEquals((Object)((PartitionKeyComparator.Operator)comparator.ops.get((int)0)).keyName, (Object)"state");
        exprTree = PartFilterExprUtil.getFilterParser((String)"year = 2014 and (month > 10 or month < 3)").tree;
        planRes = HBaseFilterPlanUtil.getFilterPlan((ExpressionTree)exprTree, parts);
        sp = (HBaseFilterPlanUtil.ScanPlan)planRes.plan.getPlans().get(0);
        startRowSuffix = sp.getStartRowSuffix("testdb", "testtb", parts);
        endRowSuffix = sp.getEndRowSuffix("testdb", "testtb", parts);
        filter = (RowFilter)sp.getFilter(parts);
        Assert.assertTrue((boolean)Bytes.contains((byte[])startRowSuffix, (byte[])"2014".getBytes()));
        Assert.assertTrue((boolean)Bytes.contains((byte[])endRowSuffix, (byte[])"2014".getBytes()));
        Assert.assertTrue((boolean)Bytes.contains((byte[])startRowSuffix, (byte[])"10".getBytes()));
        sp = (HBaseFilterPlanUtil.ScanPlan)planRes.plan.getPlans().get(1);
        startRowSuffix = sp.getStartRowSuffix("testdb", "testtb", parts);
        endRowSuffix = sp.getEndRowSuffix("testdb", "testtb", parts);
        filter = (RowFilter)sp.getFilter(parts);
        Assert.assertTrue((boolean)Bytes.contains((byte[])startRowSuffix, (byte[])"2014".getBytes()));
        Assert.assertTrue((boolean)Bytes.contains((byte[])endRowSuffix, (byte[])"2014".getBytes()));
        Assert.assertTrue((boolean)Bytes.contains((byte[])endRowSuffix, (byte[])"3".getBytes()));
    }

    @Test
    public void testPartitionKeyScannerMixedType() throws Exception {
        ArrayList<FieldSchema> parts = new ArrayList<FieldSchema>();
        parts.add(new FieldSchema("year", "int", null));
        parts.add(new FieldSchema("month", "int", null));
        parts.add(new FieldSchema("state", "string", null));
        ExpressionTree exprTree = PartFilterExprUtil.getFilterParser((String)"year = 2015 and state = 'CA'").tree;
        HBaseFilterPlanUtil.PlanResult planRes = HBaseFilterPlanUtil.getFilterPlan((ExpressionTree)exprTree, parts);
        Assert.assertEquals((long)planRes.plan.getPlans().size(), (long)1L);
        HBaseFilterPlanUtil.ScanPlan sp = (HBaseFilterPlanUtil.ScanPlan)planRes.plan.getPlans().get(0);
        byte[] startRowSuffix = sp.getStartRowSuffix("testdb", "testtb", parts);
        byte[] endRowSuffix = sp.getEndRowSuffix("testdb", "testtb", parts);
        RowFilter filter = (RowFilter)sp.getFilter(parts);
        Assert.assertTrue((boolean)Bytes.contains((byte[])startRowSuffix, (byte[])Shorts.toByteArray((short)2015)));
        Assert.assertTrue((boolean)Bytes.contains((byte[])endRowSuffix, (byte[])Shorts.toByteArray((short)2016)));
        PartitionKeyComparator comparator = (PartitionKeyComparator)filter.getComparator();
        Assert.assertEquals((long)comparator.ranges.size(), (long)1L);
        Assert.assertEquals((Object)((PartitionKeyComparator.Range)comparator.ranges.get((int)0)).keyName, (Object)"state");
    }
}

