/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jdo.Query;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.metrics.MetricsTestUtils;
import org.apache.hadoop.hive.common.metrics.common.MetricsFactory;
import org.apache.hadoop.hive.common.metrics.metrics2.CodahaleMetrics;
import org.apache.hadoop.hive.common.metrics.metrics2.MetricsReporting;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Deadline;
import org.apache.hadoop.hive.metastore.FileFormatProxy;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestObjectStore {
    private ObjectStore objectStore = null;
    private static final String DB1 = "testobjectstoredb1";
    private static final String DB2 = "testobjectstoredb2";
    private static final String TABLE1 = "testobjectstoretable1";
    private static final String KEY1 = "testobjectstorekey1";
    private static final String KEY2 = "testobjectstorekey2";
    private static final String OWNER = "testobjectstoreowner";
    private static final String USER1 = "testobjectstoreuser1";
    private static final String ROLE1 = "testobjectstorerole1";
    private static final String ROLE2 = "testobjectstorerole2";
    private static final Logger LOG = LoggerFactory.getLogger((String)TestObjectStore.class.getName());

    @Before
    public void setUp() throws Exception {
        HiveConf conf = new HiveConf();
        conf.setVar(HiveConf.ConfVars.METASTORE_EXPRESSION_PROXY_CLASS, MockPartitionExpressionProxy.class.getName());
        this.objectStore = new ObjectStore();
        this.objectStore.setConf((Configuration)conf);
        TestObjectStore.dropAllStoreObjects((RawStore)this.objectStore);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testNotificationOps() throws InterruptedException {
        boolean NO_EVENT_ID = false;
        boolean FIRST_EVENT_ID = true;
        int SECOND_EVENT_ID = 2;
        NotificationEvent event = new NotificationEvent(0L, 0, EventMessage.EventType.CREATE_DATABASE.toString(), "");
        CurrentNotificationEventId eventId = this.objectStore.getCurrentNotificationEventId();
        Assert.assertEquals((long)0L, (long)eventId.getEventId());
        this.objectStore.addNotificationEvent(event);
        Assert.assertEquals((long)1L, (long)event.getEventId());
        this.objectStore.addNotificationEvent(event);
        Assert.assertEquals((long)2L, (long)event.getEventId());
        eventId = this.objectStore.getCurrentNotificationEventId();
        Assert.assertEquals((long)2L, (long)eventId.getEventId());
        NotificationEventResponse eventResponse = this.objectStore.getNextNotification(new NotificationEventRequest());
        Assert.assertEquals((long)2L, (long)eventResponse.getEventsSize());
        Assert.assertEquals((long)1L, (long)((NotificationEvent)eventResponse.getEvents().get(0)).getEventId());
        Assert.assertEquals((long)2L, (long)((NotificationEvent)eventResponse.getEvents().get(1)).getEventId());
        eventResponse = this.objectStore.getNextNotification(new NotificationEventRequest(1L));
        Assert.assertEquals((long)1L, (long)eventResponse.getEventsSize());
        Assert.assertEquals((long)2L, (long)((NotificationEvent)eventResponse.getEvents().get(0)).getEventId());
        eventResponse = this.objectStore.getNextNotification(new NotificationEventRequest(2L));
        Assert.assertEquals((long)0L, (long)eventResponse.getEventsSize());
        Thread.sleep(1L);
        this.objectStore.cleanNotificationEvents(1);
        eventResponse = this.objectStore.getNextNotification(new NotificationEventRequest());
        Assert.assertEquals((long)0L, (long)eventResponse.getEventsSize());
    }

    @Test
    public void testDatabaseOps() throws MetaException, InvalidObjectException, NoSuchObjectException {
        Database db1 = new Database(DB1, "description", "locationurl", null);
        Database db2 = new Database(DB2, "description", "locationurl", null);
        this.objectStore.createDatabase(db1);
        this.objectStore.createDatabase(db2);
        List databases = this.objectStore.getAllDatabases();
        LOG.info("databases: " + databases);
        Assert.assertEquals((long)2L, (long)databases.size());
        Assert.assertEquals((Object)DB1, databases.get(0));
        Assert.assertEquals((Object)DB2, databases.get(1));
        this.objectStore.dropDatabase(DB1);
        databases = this.objectStore.getAllDatabases();
        Assert.assertEquals((long)1L, (long)databases.size());
        Assert.assertEquals((Object)DB2, databases.get(0));
        this.objectStore.dropDatabase(DB2);
    }

    @Test
    public void testTableOps() throws MetaException, InvalidObjectException, NoSuchObjectException, InvalidInputException {
        Database db1 = new Database(DB1, "description", "locationurl", null);
        this.objectStore.createDatabase(db1);
        StorageDescriptor sd1 = new StorageDescriptor((List)ImmutableList.of((Object)new FieldSchema("pk_col", "double", null)), "location", null, null, false, 0, new SerDeInfo("SerDeName", "serializationLib", null), null, null, null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("EXTERNAL", "false");
        Table tbl1 = new Table(TABLE1, DB1, "owner", 1, 2, 3, sd1, null, params, null, null, "MANAGED_TABLE");
        this.objectStore.createTable(tbl1);
        List tables = this.objectStore.getAllTables(DB1);
        Assert.assertEquals((long)1L, (long)tables.size());
        Assert.assertEquals((Object)TABLE1, tables.get(0));
        StorageDescriptor sd2 = new StorageDescriptor((List)ImmutableList.of((Object)new FieldSchema("fk_col", "double", null)), "location", null, null, false, 0, new SerDeInfo("SerDeName", "serializationLib", null), null, null, null);
        Table newTbl1 = new Table("newtestobjectstoretable1", DB1, "owner", 1, 2, 3, sd2, null, params, null, null, "MANAGED_TABLE");
        this.objectStore.alterTable(DB1, TABLE1, newTbl1);
        tables = this.objectStore.getTables(DB1, "new*");
        Assert.assertEquals((long)1L, (long)tables.size());
        Assert.assertEquals((Object)"newtestobjectstoretable1", tables.get(0));
        this.objectStore.createTable(tbl1);
        tables = this.objectStore.getAllTables(DB1);
        Assert.assertEquals((long)2L, (long)tables.size());
        List foreignKeys = this.objectStore.getForeignKeys(DB1, TABLE1, null, null);
        Assert.assertEquals((long)0L, (long)foreignKeys.size());
        SQLPrimaryKey pk = new SQLPrimaryKey(DB1, TABLE1, "pk_col", 1, "pk_const_1", false, false, false);
        this.objectStore.addPrimaryKeys((List)ImmutableList.of((Object)pk));
        SQLForeignKey fk = new SQLForeignKey(DB1, TABLE1, "pk_col", DB1, "newtestobjectstoretable1", "fk_col", 1, 0, 0, "fk_const_1", "pk_const_1", false, false, false);
        this.objectStore.addForeignKeys((List)ImmutableList.of((Object)fk));
        foreignKeys = this.objectStore.getForeignKeys(null, null, DB1, "newtestobjectstoretable1");
        Assert.assertEquals((long)1L, (long)foreignKeys.size());
        List fks = this.objectStore.getForeignKeys(null, null, DB1, "newtestobjectstoretable1");
        if (fks != null) {
            for (SQLForeignKey fkcol : fks) {
                this.objectStore.dropConstraint(fkcol.getFktable_db(), fkcol.getFktable_name(), fkcol.getFk_name());
            }
        }
        foreignKeys = this.objectStore.getForeignKeys(DB1, TABLE1, null, null);
        Assert.assertEquals((long)0L, (long)foreignKeys.size());
        foreignKeys = this.objectStore.getForeignKeys(null, null, DB1, "newtestobjectstoretable1");
        Assert.assertEquals((long)0L, (long)foreignKeys.size());
        this.objectStore.dropTable(DB1, TABLE1);
        tables = this.objectStore.getAllTables(DB1);
        Assert.assertEquals((long)1L, (long)tables.size());
        this.objectStore.dropTable(DB1, "newtestobjectstoretable1");
        tables = this.objectStore.getAllTables(DB1);
        Assert.assertEquals((long)0L, (long)tables.size());
        this.objectStore.dropDatabase(DB1);
    }

    @Test
    public void testPartitionOps() throws MetaException, InvalidObjectException, NoSuchObjectException, InvalidInputException {
        Database db1 = new Database(DB1, "description", "locationurl", null);
        this.objectStore.createDatabase(db1);
        StorageDescriptor sd = new StorageDescriptor(null, "location", null, null, false, 0, new SerDeInfo("SerDeName", "serializationLib", null), null, null, null);
        HashMap<String, String> tableParams = new HashMap<String, String>();
        tableParams.put("EXTERNAL", "false");
        FieldSchema partitionKey1 = new FieldSchema("Country", "string", "");
        FieldSchema partitionKey2 = new FieldSchema("State", "string", "");
        Table tbl1 = new Table(TABLE1, DB1, "owner", 1, 2, 3, sd, Arrays.asList(partitionKey1, partitionKey2), tableParams, null, null, "MANAGED_TABLE");
        this.objectStore.createTable(tbl1);
        HashMap<String, String> partitionParams = new HashMap<String, String>();
        partitionParams.put("PARTITION_LEVEL_PRIVILEGE", "true");
        List<String> value1 = Arrays.asList("US", "CA");
        Partition part1 = new Partition(value1, DB1, TABLE1, 111, 111, sd, partitionParams);
        this.objectStore.addPartition(part1);
        List<String> value2 = Arrays.asList("US", "MA");
        Partition part2 = new Partition(value2, DB1, TABLE1, 222, 222, sd, partitionParams);
        this.objectStore.addPartition(part2);
        Deadline.startTimer((String)"getPartition");
        List partitions = this.objectStore.getPartitions(DB1, TABLE1, 10);
        Assert.assertEquals((long)2L, (long)partitions.size());
        Assert.assertEquals((long)111L, (long)((Partition)partitions.get(0)).getCreateTime());
        Assert.assertEquals((long)222L, (long)((Partition)partitions.get(1)).getCreateTime());
        int numPartitions = this.objectStore.getNumPartitionsByFilter(DB1, TABLE1, "");
        Assert.assertEquals((long)partitions.size(), (long)numPartitions);
        numPartitions = this.objectStore.getNumPartitionsByFilter(DB1, TABLE1, "country = \"US\"");
        Assert.assertEquals((long)2L, (long)numPartitions);
        this.objectStore.dropPartition(DB1, TABLE1, value1);
        partitions = this.objectStore.getPartitions(DB1, TABLE1, 10);
        Assert.assertEquals((long)1L, (long)partitions.size());
        Assert.assertEquals((long)222L, (long)((Partition)partitions.get(0)).getCreateTime());
        this.objectStore.dropPartition(DB1, TABLE1, value2);
        this.objectStore.dropTable(DB1, TABLE1);
        this.objectStore.dropDatabase(DB1);
    }

    @Test
    public void testConcurrentDropPartitions() throws MetaException, InvalidObjectException {
        Database db1 = new DatabaseBuilder().setName(DB1).setDescription("description").setLocation("locationurl").build();
        this.objectStore.createDatabase(db1);
        StorageDescriptor sd = this.createFakeSd("location");
        HashMap<String, String> tableParams = new HashMap<String, String>();
        tableParams.put("EXTERNAL", "false");
        FieldSchema partitionKey1 = new FieldSchema("Country", "string", "");
        FieldSchema partitionKey2 = new FieldSchema("State", "string", "");
        Table tbl1 = new Table(TABLE1, DB1, "owner", 1, 2, 3, sd, Arrays.asList(partitionKey1, partitionKey2), tableParams, null, null, "MANAGED_TABLE");
        this.objectStore.createTable(tbl1);
        HashMap<String, String> partitionParams = new HashMap<String, String>();
        partitionParams.put("PARTITION_LEVEL_PRIVILEGE", "true");
        final LinkedList<List<String>> partNames = new LinkedList<List<String>>();
        for (char c = 'A'; c < 'Z'; c = (char)(c + '\u0001')) {
            String string = "" + c;
            partNames.add(Arrays.asList(string, string));
        }
        for (List list : partNames) {
            Partition p = new Partition(list, DB1, TABLE1, 111, 111, sd, partitionParams);
            this.objectStore.addPartition(p);
        }
        int numThreads = 2;
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    for (List p : partNames) {
                        try {
                            TestObjectStore.this.objectStore.dropPartition(TestObjectStore.DB1, TestObjectStore.TABLE1, p);
                            System.out.println("Dropping partition: " + (String)p.get(0));
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            Assert.assertTrue((String)"Got interrupted.", (boolean)false);
        }
        Assert.assertTrue((String)"Expect no active transactions.", (!this.objectStore.isActiveTransaction() ? 1 : 0) != 0);
    }

    private StorageDescriptor createFakeSd(String location) {
        return new StorageDescriptor(null, location, null, null, false, 0, new SerDeInfo("SerDeName", "serializationLib", null), null, null, null);
    }

    @Test
    public void testMasterKeyOps() throws MetaException, NoSuchObjectException {
        int id1 = this.objectStore.addMasterKey(KEY1);
        int id2 = this.objectStore.addMasterKey(KEY2);
        String[] keys = this.objectStore.getMasterKeys();
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertEquals((Object)KEY1, (Object)keys[0]);
        Assert.assertEquals((Object)KEY2, (Object)keys[1]);
        this.objectStore.updateMasterKey(Integer.valueOf(id1), "newtestobjectstorekey1");
        this.objectStore.updateMasterKey(Integer.valueOf(id2), "newtestobjectstorekey2");
        keys = this.objectStore.getMasterKeys();
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertEquals((Object)"newtestobjectstorekey1", (Object)keys[0]);
        Assert.assertEquals((Object)"newtestobjectstorekey2", (Object)keys[1]);
        this.objectStore.removeMasterKey(Integer.valueOf(id1));
        keys = this.objectStore.getMasterKeys();
        Assert.assertEquals((long)1L, (long)keys.length);
        Assert.assertEquals((Object)"newtestobjectstorekey2", (Object)keys[0]);
        this.objectStore.removeMasterKey(Integer.valueOf(id2));
    }

    @Test
    public void testRoleOps() throws InvalidObjectException, MetaException, NoSuchObjectException {
        this.objectStore.addRole(ROLE1, OWNER);
        this.objectStore.addRole(ROLE2, OWNER);
        List roles = this.objectStore.listRoleNames();
        Assert.assertEquals((long)2L, (long)roles.size());
        Assert.assertEquals((Object)ROLE2, roles.get(1));
        Role role1 = this.objectStore.getRole(ROLE1);
        Assert.assertEquals((Object)OWNER, (Object)role1.getOwnerName());
        this.objectStore.grantRole(role1, USER1, PrincipalType.USER, OWNER, PrincipalType.ROLE, true);
        this.objectStore.revokeRole(role1, USER1, PrincipalType.USER, false);
        this.objectStore.removeRole(ROLE1);
    }

    @Test
    public void testDirectSqlErrorMetrics() throws Exception {
        HiveConf conf = new HiveConf();
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_METRICS_ENABLED, true);
        conf.setVar(HiveConf.ConfVars.HIVE_METRICS_REPORTER, MetricsReporting.JSON_FILE.name() + "," + MetricsReporting.JMX.name());
        MetricsFactory.init((HiveConf)conf);
        CodahaleMetrics metrics = (CodahaleMetrics)MetricsFactory.getInstance();
        ObjectStore objectStore = this.objectStore;
        objectStore.getClass();
        new ObjectStore.GetDbHelper(objectStore, "foo", null, true, true){
            {
                ObjectStore objectStore = x0;
                objectStore.getClass();
                super(objectStore, x1, x2, x3, x4);
            }

            protected Database getSqlResult(ObjectStore.GetHelper<Database> ctx) throws MetaException {
                return null;
            }

            protected Database getJdoResult(ObjectStore.GetHelper<Database> ctx) throws MetaException, NoSuchObjectException {
                return null;
            }
        }.run(false);
        String json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.COUNTER, (String)"directsql_errors", (Object)"");
        ObjectStore objectStore2 = this.objectStore;
        objectStore2.getClass();
        new ObjectStore.GetDbHelper(objectStore2, "foo", null, true, true){
            {
                ObjectStore objectStore = x0;
                objectStore.getClass();
                super(objectStore, x1, x2, x3, x4);
            }

            protected Database getSqlResult(ObjectStore.GetHelper<Database> ctx) throws MetaException {
                throw new RuntimeException();
            }

            protected Database getJdoResult(ObjectStore.GetHelper<Database> ctx) throws MetaException, NoSuchObjectException {
                return null;
            }
        }.run(false);
        json = metrics.dumpJson();
        MetricsTestUtils.verifyMetricsJson((String)json, (MetricsTestUtils.MetricsCategory)MetricsTestUtils.COUNTER, (String)"directsql_errors", (Object)1);
    }

    public static void dropAllStoreObjects(RawStore store) throws MetaException, InvalidObjectException, InvalidInputException {
        try {
            Deadline.registerIfNot((long)100000L);
            List funcs = store.getAllFunctions();
            for (Function func : funcs) {
                store.dropFunction(func.getDbName(), func.getFunctionName());
            }
            List dbs = store.getAllDatabases();
            for (int i = 0; i < dbs.size(); ++i) {
                String db = (String)dbs.get(i);
                List tbls = store.getAllTables(db);
                for (String tbl : tbls) {
                    List indexes = store.getIndexes(db, tbl, 100);
                    for (Index index : indexes) {
                        store.dropIndex(db, tbl, index.getIndexName());
                    }
                }
                for (String tbl : tbls) {
                    List fks;
                    Deadline.startTimer((String)"getPartition");
                    List parts = store.getPartitions(db, tbl, 100);
                    for (Partition part : parts) {
                        store.dropPartition(db, tbl, part.getValues());
                    }
                    HashSet<String> constraints = new HashSet<String>();
                    List pk = store.getPrimaryKeys(db, tbl);
                    if (pk != null) {
                        for (SQLPrimaryKey pkcol : pk) {
                            constraints.add(pkcol.getPk_name());
                        }
                    }
                    if ((fks = store.getForeignKeys(null, null, db, tbl)) != null) {
                        for (SQLForeignKey fkcol : fks) {
                            constraints.add(fkcol.getFk_name());
                        }
                    }
                    for (String constraint : constraints) {
                        store.dropConstraint(db, tbl, constraint);
                    }
                    store.dropTable(db, tbl);
                }
                store.dropDatabase(db);
            }
            List roles = store.listRoleNames();
            for (String role : roles) {
                store.removeRole(role);
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    @Test
    public void testQueryCloseOnError() throws Exception {
        ObjectStore spy = (ObjectStore)Mockito.spy((Object)this.objectStore);
        spy.getAllDatabases();
        spy.getAllFunctions();
        spy.getAllTables(DB1);
        spy.getPartitionCount();
        ((ObjectStore)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)2))).rollbackAndCleanup(Mockito.anyBoolean(), (Query)Mockito.anyObject());
    }

    public static class MockPartitionExpressionProxy
    implements PartitionExpressionProxy {
        public String convertExprToFilter(byte[] expr) throws MetaException {
            return null;
        }

        public boolean filterPartitionsByExpr(List<String> partColumnNames, List<PrimitiveTypeInfo> partColumnTypeInfos, byte[] expr, String defaultPartitionName, List<String> partitionNames) throws MetaException {
            return false;
        }

        public FileMetadataExprType getMetadataType(String inputFormat) {
            return null;
        }

        public SearchArgument createSarg(byte[] expr) {
            return null;
        }

        public FileFormatProxy getFileFormatProxy(FileMetadataExprType type) {
            return null;
        }
    }
}

