/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import org.apache.hadoop.hive.common.ValidCompactorTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.junit.Assert;
import org.junit.Test;

public class TestValidCompactorTxnList {
    @Test
    public void minTxnHigh() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList(new long[]{3L, 4L}, 2L);
        ValidTxnList.RangeResponse rsp = txns.isTxnRangeValid(7L, 9L);
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.NONE, (Object)rsp);
    }

    @Test
    public void maxTxnLow() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList(new long[]{13L, 14L}, 12L);
        ValidTxnList.RangeResponse rsp = txns.isTxnRangeValid(7L, 9L);
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.ALL, (Object)rsp);
    }

    @Test
    public void minTxnHighNoExceptions() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList(new long[0], 5L);
        ValidTxnList.RangeResponse rsp = txns.isTxnRangeValid(7L, 9L);
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.NONE, (Object)rsp);
    }

    @Test
    public void maxTxnLowNoExceptions() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList(new long[0], 15L);
        ValidTxnList.RangeResponse rsp = txns.isTxnRangeValid(7L, 9L);
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.ALL, (Object)rsp);
    }

    @Test
    public void exceptionsAllBelow() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList(new long[]{3L, 6L}, 3L);
        ValidTxnList.RangeResponse rsp = txns.isTxnRangeValid(7L, 9L);
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.NONE, (Object)rsp);
    }

    @Test
    public void exceptionsInMidst() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList(new long[]{8L}, 7L);
        ValidTxnList.RangeResponse rsp = txns.isTxnRangeValid(7L, 9L);
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.NONE, (Object)rsp);
    }

    @Test
    public void exceptionsAbveHighWaterMark() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList(new long[]{8L, 11L, 17L, 29L}, 15L);
        Assert.assertArrayEquals((String)"", (long[])new long[]{8L, 11L}, (long[])txns.getInvalidTransactions());
        ValidTxnList.RangeResponse rsp = txns.isTxnRangeValid(7L, 9L);
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.ALL, (Object)rsp);
        rsp = txns.isTxnRangeValid(12L, 16L);
        Assert.assertEquals((Object)ValidTxnList.RangeResponse.NONE, (Object)rsp);
    }

    @Test
    public void writeToString() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList(new long[]{9L, 7L, 10L, Long.MAX_VALUE}, 8L);
        Assert.assertEquals((Object)"8:9223372036854775807:7", (Object)txns.writeToString());
        txns = new ValidCompactorTxnList();
        Assert.assertEquals((Object)(Long.toString(Long.MAX_VALUE) + ":" + Long.MAX_VALUE + ":"), (Object)txns.writeToString());
        txns = new ValidCompactorTxnList(new long[0], 23L);
        Assert.assertEquals((Object)"23:9223372036854775807:", (Object)txns.writeToString());
    }

    @Test
    public void readFromString() {
        ValidCompactorTxnList txns = new ValidCompactorTxnList("37:9223372036854775807:7:9:10");
        Assert.assertEquals((long)37L, (long)txns.getHighWatermark());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)txns.getMinOpenTxn());
        Assert.assertArrayEquals((long[])new long[]{7L, 9L, 10L}, (long[])txns.getInvalidTransactions());
        txns = new ValidCompactorTxnList("21:9223372036854775807:");
        Assert.assertEquals((long)21L, (long)txns.getHighWatermark());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)txns.getMinOpenTxn());
        Assert.assertEquals((long)0L, (long)txns.getInvalidTransactions().length);
    }
}

