/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.maprdb.json.BaseExplainTest;
import org.apache.hadoop.hive.maprdb.json.MapRDBJsonStorageHandler;
import org.apache.hadoop.hive.maprdb.json.input.HiveMapRDBJsonInputFormat;
import org.apache.hadoop.hive.maprdb.json.output.HiveMapRDBJsonOutputFormat;
import org.apache.hadoop.hive.maprdb.json.serde.MapRDBSerDe;
import org.apache.hadoop.hive.ql.io.HiveBinaryOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;

class BaseOptimizedDeleteInMergeTest
extends BaseExplainTest {
    private static final String TGT = "tgt";
    private static final String SRC = "src";
    private static final String SRC_SEQ = "src_seq";

    BaseOptimizedDeleteInMergeTest(String query) {
        this.query = query;
    }

    BaseOptimizedDeleteInMergeTest() {
        this.query = "";
    }

    @Override
    void createTables() throws HiveException {
        HashMap<String, String> commonParams = new HashMap<String, String>();
        commonParams.put("maprdb.column.id", "id");
        commonParams.put("maprdb.is.in.test.mode", "true");
        commonParams.put("storage_handler", MapRDBJsonStorageHandler.class.getName());
        List<String> columns = Arrays.asList("id", "value");
        HashMap<String, String> targetParams = new HashMap<String, String>(commonParams);
        targetParams.put("maprdb.table.name", "/tgt");
        HashMap<String, String> sourceParams = new HashMap<String, String>(commonParams);
        sourceParams.put("maprdb.table.name", "/src");
        this.cleanupTables();
        this.db.createTable(TGT, columns, null, HiveMapRDBJsonInputFormat.class, HiveMapRDBJsonOutputFormat.class, -1, null, targetParams, MapRDBSerDe.class);
        this.db.createTable(SRC, columns, null, HiveMapRDBJsonInputFormat.class, HiveMapRDBJsonOutputFormat.class, -1, null, sourceParams, MapRDBSerDe.class);
        this.db.createTable(SRC_SEQ, columns, null, HiveInputFormat.class, HiveBinaryOutputFormat.class);
    }

    void cleanupTables() throws HiveException {
        if (this.db != null) {
            this.db.dropTable(TGT);
            this.db.dropTable(SRC);
            this.db.dropTable(SRC_SEQ);
        }
    }
}

