/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json;

import com.google.common.io.Resources;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hive.maprdb.json.BaseExplainTest;
import org.apache.hadoop.hive.maprdb.json.BaseOptimizedDeleteInMergeTest;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizedDeleteInMergeNegativeTest
extends BaseOptimizedDeleteInMergeTest {
    private static final Logger LOG = LoggerFactory.getLogger((String)OptimizedDeleteInMergeNegativeTest.class.getName());
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Override
    @Before
    public void setup() throws HiveException {
        super.setup();
    }

    @Test
    public void testNonSupportedCondition() throws Exception {
        try {
            this.thrown.expect(SemanticException.class);
            this.thrown.expectMessage(CoreMatchers.containsString((String)"Delete operator is not supported with additional conditions after WHEN MATCHED."));
            this.query = IOUtils.toString((URL)Resources.getResource((String)"optimized-delete-in-merge-negative/not-supported-condition.sql"));
            BaseExplainTest.ReturnInfo rc = this.parseAndAnalyze(this.query);
            String result = this.explain((SemanticAnalyzer)rc.sem, rc.plan);
            LOG.info(result);
            Assert.assertFalse((boolean)result.contains("Deletion from MapR DB Json Table"));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testNonSupportedSource() throws Exception {
        try {
            this.thrown.expect(SemanticException.class);
            this.thrown.expectMessage(CoreMatchers.containsString((String)"Source table should be MapR DB JSON table when deletion is used in MERGE operator."));
            this.query = IOUtils.toString((URL)Resources.getResource((String)"optimized-delete-in-merge-negative/not-supported-source.sql"));
            BaseExplainTest.ReturnInfo rc = this.parseAndAnalyze(this.query);
            String result = this.explain((SemanticAnalyzer)rc.sem, rc.plan);
            LOG.info(result);
            Assert.assertFalse((boolean)result.contains("Deletion from MapR DB Json Table"));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testNonSupportedSubQuery() throws Exception {
        try {
            this.thrown.expect(SemanticException.class);
            this.thrown.expectMessage(CoreMatchers.containsString((String)"Sub queries are not supported as a source when DELETE is used."));
            this.query = IOUtils.toString((URL)Resources.getResource((String)"optimized-delete-in-merge-negative/not-supported-sub-query.sql"));
            BaseExplainTest.ReturnInfo rc = this.parseAndAnalyze(this.query);
            String result = this.explain((SemanticAnalyzer)rc.sem, rc.plan);
            LOG.info(result);
            Assert.assertFalse((boolean)result.contains("Deletion from MapR DB Json Table"));
        }
        finally {
            this.cleanupTables();
        }
    }
}

