/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.maprdb.json;

import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.maprdb.json.BaseExplainTest;
import org.apache.hadoop.hive.maprdb.json.MapRDBJsonStorageHandler;
import org.apache.hadoop.hive.maprdb.json.input.HiveMapRDBJsonInputFormat;
import org.apache.hadoop.hive.maprdb.json.output.HiveMapRDBJsonOutputFormat;
import org.apache.hadoop.hive.maprdb.json.serde.MapRDBSerDe;
import org.apache.hadoop.hive.ql.io.HiveBinaryOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class MapRDbJsonUpdateDeleteSemanticAnalyzerTest
extends BaseExplainTest {
    private static final Logger LOG = LoggerFactory.getLogger((String)MapRDbJsonUpdateDeleteSemanticAnalyzerTest.class.getName());
    private static final String CUSTOMER_DB_JSON_TARGET = "customer_db_json_target";
    private static final String CUSTOMER_DB_JSON_SOURCE = "customer_db_json_source";
    private static final String CUSTOMER_DB_JSON_ALL_TARGET = "customer_db_json_all_target";
    private static final String DEPARTMENT = "department";
    private static final String CUSTOMER_WEST = "customer_west";
    private static final String CUSTOMER_EAST = "customer_east";

    public MapRDbJsonUpdateDeleteSemanticAnalyzerTest(String query) {
        this.query = query;
    }

    @Parameterized.Parameters
    public static Collection queries() throws IOException, URISyntaxException {
        ArrayList<String> queries = new ArrayList<String>();
        URL url = Resources.getResource((String)"update-merge");
        File folder = new File(url.toURI());
        for (File file : folder.listFiles()) {
            queries.add(MapRDbJsonUpdateDeleteSemanticAnalyzerTest.readFile(file.getPath()));
        }
        ArrayList<String[]> arguments = new ArrayList<String[]>();
        for (String query : queries) {
            arguments.add(new String[]{query});
        }
        return arguments;
    }

    @Override
    @Before
    public void setup() throws HiveException {
        super.setup();
    }

    @Override
    void createTables() throws HiveException {
        HashMap<String, String> commonParams = new HashMap<String, String>();
        commonParams.put("maprdb.column.id", "id");
        commonParams.put("maprdb.is.in.test.mode", "true");
        commonParams.put("storage_handler", MapRDBJsonStorageHandler.class.getName());
        HashMap<String, String> sourceParams = new HashMap<String, String>(commonParams);
        sourceParams.put("maprdb.table.name", "/customer_db_json_source");
        HashMap<String, String> targetParams = new HashMap<String, String>(commonParams);
        targetParams.put("maprdb.table.name", "/customer_db_json_target");
        HashMap<String, String> targetAllParams = new HashMap<String, String>(commonParams);
        targetAllParams.put("maprdb.table.name", "/customer_db_json_all_target");
        this.cleanupTables();
        List<String> columns = Arrays.asList("id", "first_name", "last_name", "age");
        List<String> columnsAll = Arrays.asList("id", "first_name", "last_name", "age", DEPARTMENT);
        List<String> columnsCustomer = Arrays.asList("id", "first_name", "last_name", "age", "department_id");
        List<String> columnsDepartment = Arrays.asList("id", "name");
        this.db.createTable(CUSTOMER_DB_JSON_TARGET, columns, null, HiveMapRDBJsonInputFormat.class, HiveMapRDBJsonOutputFormat.class, -1, null, targetParams, MapRDBSerDe.class);
        this.db.createTable(CUSTOMER_DB_JSON_SOURCE, columns, null, HiveMapRDBJsonInputFormat.class, HiveMapRDBJsonOutputFormat.class, -1, null, sourceParams, MapRDBSerDe.class);
        this.db.createTable(CUSTOMER_DB_JSON_ALL_TARGET, columnsAll, null, HiveMapRDBJsonInputFormat.class, HiveMapRDBJsonOutputFormat.class, -1, null, targetAllParams, MapRDBSerDe.class);
        this.db.createTable(DEPARTMENT, columnsDepartment, null, HiveInputFormat.class, HiveBinaryOutputFormat.class);
        this.db.createTable(CUSTOMER_WEST, columnsCustomer, null, HiveInputFormat.class, HiveBinaryOutputFormat.class);
        this.db.createTable(CUSTOMER_EAST, columnsCustomer, null, HiveInputFormat.class, HiveBinaryOutputFormat.class);
    }

    @Test
    public void testPositive() throws Exception {
        try {
            BaseExplainTest.ReturnInfo rc = this.parseAndAnalyze(this.query);
            LOG.info(this.explain((SemanticAnalyzer)rc.sem, rc.plan));
        }
        finally {
            this.cleanupTables();
        }
    }

    private void cleanupTables() throws HiveException {
        if (this.db != null) {
            this.db.dropTable(CUSTOMER_DB_JSON_TARGET);
            this.db.dropTable(CUSTOMER_DB_JSON_SOURCE);
            this.db.dropTable(CUSTOMER_DB_JSON_ALL_TARGET);
            this.db.dropTable(DEPARTMENT);
            this.db.dropTable(CUSTOMER_WEST);
            this.db.dropTable(CUSTOMER_EAST);
        }
    }
}

