/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.lang.ref.Cleaner;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.BuddyAllocatorMXBean;
import org.apache.hadoop.hive.llap.cache.LlapAllocatorBuffer;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.io.api.impl.LlapIoImpl;
import org.apache.hadoop.util.CleanerUtil;

public final class SimpleAllocator
implements Allocator,
BuddyAllocatorMXBean {
    private final boolean isDirect;
    private static Field cleanerField;

    public SimpleAllocator(Configuration conf) {
        this.isDirect = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_DIRECT);
        if (LlapIoImpl.LOG.isInfoEnabled()) {
            LlapIoImpl.LOG.info("Simple allocator with " + (this.isDirect ? "direct" : "byte") + " buffers");
        }
    }

    @Deprecated
    public void allocateMultiple(MemoryBuffer[] dest, int size) {
        this.allocateMultiple(dest, size, null);
    }

    public void allocateMultiple(MemoryBuffer[] dest, int size, Allocator.BufferObjectFactory factory) {
        for (int i = 0; i < dest.length; ++i) {
            LlapAllocatorBuffer buf = null;
            if (dest[i] == null) {
                buf = factory != null ? (LlapAllocatorBuffer)factory.create() : this.createUnallocated();
                dest[i] = buf;
            } else {
                buf = (LlapAllocatorBuffer)dest[i];
            }
            ByteBuffer bb = this.isDirect ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
            buf.initialize(bb, 0, size);
        }
    }

    public void deallocate(MemoryBuffer buffer) {
        LlapAllocatorBuffer buf = (LlapAllocatorBuffer)buffer;
        ByteBuffer bb = buf.byteBuffer;
        buf.byteBuffer = null;
        if (!bb.isDirect()) {
            return;
        }
        Field field = cleanerField;
        if (field == null) {
            return;
        }
        if (CleanerUtil.UNMAP_SUPPORTED) {
            try {
                Cleaner cleaner = (Cleaner)field.get(bb);
                if (cleaner != null) {
                    CleanerUtil.getCleaner().freeBuffer(bb);
                } else {
                    LlapIoImpl.LOG.debug("Unable to clean a buffer using cleaner - no cleaner");
                }
            }
            catch (Throwable t) {
                LlapIoImpl.LOG.warn("Error using DirectByteBuffer cleaner; stopping its use", t);
                cleanerField = null;
            }
        }
    }

    public boolean isDirectAlloc() {
        return this.isDirect;
    }

    @Deprecated
    public LlapAllocatorBuffer createUnallocated() {
        return new LlapDataBuffer();
    }

    @Override
    public boolean getIsDirect() {
        return this.isDirect;
    }

    @Override
    public int getMinAllocation() {
        return 0;
    }

    @Override
    public int getMaxAllocation() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getArenaSize() {
        return -1;
    }

    @Override
    public long getMaxCacheSize() {
        return Integer.MAX_VALUE;
    }

    static {
        try {
            Class<?> dbClazz = Class.forName("java.nio.DirectByteBuffer");
            cleanerField = dbClazz.getDeclaredField("cleaner");
            cleanerField.setAccessible(true);
        }
        catch (Throwable t) {
            LlapIoImpl.LOG.warn("Cannot initialize DirectByteBuffer cleaner", t);
            cleanerField = null;
        }
    }
}

