/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapOomDebugDump;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;

public class CacheContentsTracker
implements LowLevelCachePolicy,
EvictionListener {
    private static final long CLEANUP_TIME_MS = 3600000L;
    private static final long MIN_TIME_MS = 300000L;
    private final ConcurrentSkipListMap<String, TagState> tagInfo = new ConcurrentSkipListMap();
    private EvictionListener evictionListener;
    private LowLevelCachePolicy realPolicy;
    private final Thread cleanupThread;

    public CacheContentsTracker(LowLevelCachePolicy realPolicy) {
        this.realPolicy = realPolicy;
        realPolicy.setEvictionListener(this);
        this.cleanupThread = new Thread(new CleanupRunnable());
        this.cleanupThread.start();
    }

    private void reportCached(LlapCacheableBuffer buffer) {
        TagState state;
        long size = buffer.getMemoryUsage();
        while (!this.reportCached(state = this.getTagState(buffer), size)) {
        }
        state = null;
        while ((state = this.getParentTagState(buffer)) != null && !this.reportCached(state, size)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reportCached(TagState state, long size) {
        TagState tagState = state;
        synchronized (tagState) {
            if (state.isRemoved) {
                return false;
            }
            ++state.bufferCount;
            state.totalSize += size;
            state.maxSize = Math.max(state.maxSize, state.totalSize);
            state.maxCount = Math.max(state.maxCount, state.bufferCount);
        }
        return true;
    }

    private void reportRemoved(LlapCacheableBuffer buffer) {
        TagState state;
        long size = buffer.getMemoryUsage();
        while (!this.reportRemoved(state = this.getTagState(buffer), size)) {
        }
        state = null;
        while ((state = this.getParentTagState(buffer)) != null && !this.reportRemoved(state, size)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reportRemoved(TagState state, long size) {
        TagState tagState = state;
        synchronized (tagState) {
            if (state.isRemoved) {
                return false;
            }
            --state.bufferCount;
            assert (state.bufferCount >= 0L);
            state.totalSize -= size;
            if (state.bufferCount == 0L) {
                state.emptyTimeNs = System.nanoTime();
            }
        }
        return true;
    }

    private TagState getTagState(LlapCacheableBuffer buffer) {
        return this.getTagState(buffer.getTag());
    }

    private TagState getParentTagState(LlapCacheableBuffer buffer) {
        String tag = buffer.getTag();
        int ix = tag.indexOf(47);
        if (ix <= 0) {
            return null;
        }
        return this.getTagState(tag.substring(0, ix));
    }

    private TagState getTagState(String tag) {
        TagState state = this.tagInfo.get(tag);
        if (state == null) {
            state = new TagState(tag);
            TagState old = this.tagInfo.putIfAbsent(tag, state);
            state = old == null ? state : old;
        }
        return state;
    }

    @Override
    public void cache(LlapCacheableBuffer buffer, LowLevelCache.Priority priority) {
        this.realPolicy.cache(buffer, priority);
        this.reportCached(buffer);
    }

    @Override
    public void notifyLock(LlapCacheableBuffer buffer) {
        this.realPolicy.notifyLock(buffer);
    }

    @Override
    public void notifyUnlock(LlapCacheableBuffer buffer) {
        this.realPolicy.notifyUnlock(buffer);
    }

    @Override
    public void setEvictionListener(EvictionListener listener) {
        this.evictionListener = listener;
    }

    @Override
    public void setParentDebugDumper(LlapOomDebugDump dumper) {
        this.realPolicy.setParentDebugDumper(dumper);
    }

    @Override
    public long purge() {
        return this.realPolicy.purge();
    }

    @Override
    public long evictSomeBlocks(long memoryToReserve) {
        return this.realPolicy.evictSomeBlocks(memoryToReserve);
    }

    @Override
    public String debugDumpForOom() {
        return this.realPolicy.debugDumpForOom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void debugDumpShort(StringBuilder sb) {
        sb.append("\nCache state: ");
        Iterator<TagState> iterator = this.tagInfo.values().iterator();
        while (iterator.hasNext()) {
            TagState state;
            TagState tagState = state = iterator.next();
            synchronized (tagState) {
                sb.append("\n").append(state.name).append(": ").append(state.bufferCount).append("/").append(state.maxCount).append(", ").append(state.totalSize).append("/").append(state.maxSize);
            }
        }
        this.realPolicy.debugDumpShort(sb);
    }

    @Override
    public void notifyEvicted(LlapCacheableBuffer buffer) {
        this.evictionListener.notifyEvicted(buffer);
        this.reportRemoved(buffer);
    }

    private static class TagState {
        public final String name;
        public long emptyTimeNs;
        public long bufferCount;
        public long totalSize;
        public long maxCount;
        public long maxSize;
        public boolean isRemoved = false;

        public TagState(String name) {
            this.name = name;
        }
    }

    private final class CleanupRunnable
    implements Runnable {
        private CleanupRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long cleanupTimeNs = 3600000000000L;
            long sleepTimeMs = 3600000L;
            try {
                while (true) {
                    Thread.sleep(sleepTimeMs);
                    long timeNs = System.nanoTime();
                    long nextCleanupInNs = 3600000000000L;
                    Iterator<TagState> iter = CacheContentsTracker.this.tagInfo.values().iterator();
                    while (iter.hasNext()) {
                        TagState v;
                        TagState tagState = v = iter.next();
                        synchronized (tagState) {
                            if (v.bufferCount > 0L) {
                                continue;
                            }
                            long deltaNs = timeNs - v.emptyTimeNs;
                            if (deltaNs < 3600000000000L) {
                                nextCleanupInNs = Math.min(nextCleanupInNs, deltaNs);
                                continue;
                            }
                            iter.remove();
                        }
                    }
                    sleepTimeMs = Math.max(300000L, nextCleanupInNs / 1000000L);
                }
            }
            catch (InterruptedException ex) {
                return;
            }
        }
    }
}

