/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.metrics;

import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.LlapDaemonInfo;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonJvmInfo;
import org.apache.hadoop.hive.llap.metrics.LlapMetricsSystem;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;

@Metrics(about="LlapDaemon JVM Metrics", context="jvm")
public class LlapDaemonJvmMetrics
implements MetricsSource {
    private final String name;
    private final String sessionId;
    private final MetricsRegistry registry;
    private final ResourceCalculatorProcessTree processTree;
    private final String daemonPid = LlapDaemonInfo.INSTANCE.getPID();
    private long maxOpenFdCountSoFar = 0L;

    private LlapDaemonJvmMetrics(String displayName, String sessionId, Configuration conf) {
        this.name = displayName;
        this.sessionId = sessionId;
        Class clazz = conf.getClass("yarn.nodemanager.container-monitor.process-tree.class", null, ResourceCalculatorProcessTree.class);
        this.processTree = ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)this.daemonPid, (Class)clazz, (Configuration)conf);
        if (this.processTree != null) {
            this.processTree.setConf(conf);
        }
        this.registry = new MetricsRegistry("LlapDaemonJvmRegistry");
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, "LlapDaemon").tag((MetricsInfo)MsInfo.SessionId, sessionId);
    }

    public static LlapDaemonJvmMetrics create(String displayName, String sessionId, Configuration conf) {
        MetricsSystem ms = LlapMetricsSystem.instance();
        return (LlapDaemonJvmMetrics)ms.register(displayName, "LlapDaemon JVM Metrics", (Object)new LlapDaemonJvmMetrics(displayName, sessionId, conf));
    }

    public void getMetrics(MetricsCollector collector, boolean b) {
        MetricsRecordBuilder rb = collector.addRecord((MetricsInfo)LlapDaemonJvmInfo.LlapDaemonJVMMetrics).setContext("jvm").tag((MetricsInfo)MsInfo.ProcessName, "LlapDaemon(PID: " + this.daemonPid + ")").tag((MetricsInfo)MsInfo.SessionId, this.sessionId);
        this.getJvmMetrics(rb);
    }

    private void getJvmMetrics(MetricsRecordBuilder rb) {
        List<BufferPoolMXBean> pools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
        long directBufferCount = 0L;
        long directBufferTotalCapacity = 0L;
        long directBufferMemoryUsed = 0L;
        long mappedBufferCount = 0L;
        long mappedBufferTotalCapacity = 0L;
        long mappedBufferMemoryUsed = 0L;
        for (BufferPoolMXBean pool : pools) {
            if (pool.getName().equals("direct")) {
                directBufferCount = pool.getCount();
                directBufferTotalCapacity = pool.getTotalCapacity();
                directBufferMemoryUsed = pool.getMemoryUsed();
                continue;
            }
            if (!pool.getName().equals("mapped")) continue;
            mappedBufferCount = pool.getCount();
            mappedBufferTotalCapacity = pool.getTotalCapacity();
            mappedBufferMemoryUsed = pool.getMemoryUsed();
        }
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        long openFileHandles = 0L;
        long maxFileHandles = 0L;
        if (os instanceof UnixOperatingSystemMXBean) {
            openFileHandles = ((UnixOperatingSystemMXBean)os).getOpenFileDescriptorCount();
            maxFileHandles = ((UnixOperatingSystemMXBean)os).getMaxFileDescriptorCount();
            this.maxOpenFdCountSoFar = openFileHandles > this.maxOpenFdCountSoFar ? openFileHandles : this.maxOpenFdCountSoFar;
        }
        long rss = 0L;
        long vmem = 0L;
        if (this.processTree != null) {
            rss = this.processTree.getRssMemorySize();
            vmem = this.processTree.getVirtualMemorySize();
        }
        rb.addGauge((MetricsInfo)LlapDaemonJvmInfo.LlapDaemonDirectBufferCount, directBufferCount).addGauge((MetricsInfo)LlapDaemonJvmInfo.LlapDaemonDirectBufferTotalCapacity, directBufferTotalCapacity).addGauge((MetricsInfo)LlapDaemonJvmInfo.LlapDaemonDirectBufferMemoryUsed, directBufferMemoryUsed).addGauge((MetricsInfo)LlapDaemonJvmInfo.LlapDaemonMappedBufferCount, mappedBufferCount).addGauge((MetricsInfo)LlapDaemonJvmInfo.LlapDaemonMappedBufferTotalCapacity, mappedBufferTotalCapacity).addGauge((MetricsInfo)LlapDaemonJvmInfo.LlapDaemonMappedBufferMemoryUsed, mappedBufferMemoryUsed).addGauge((MetricsInfo)LlapDaemonJvmInfo.LlapDaemonOpenFileDescriptorCount, openFileHandles).addGauge((MetricsInfo)LlapDaemonJvmInfo.LlapDaemonMaxFileDescriptorCount, this.maxOpenFdCountSoFar).addGauge((MetricsInfo)LlapDaemonJvmInfo.LlapDaemonLimitFileDescriptorCount, maxFileHandles).addGauge((MetricsInfo)LlapDaemonJvmInfo.LlapDaemonResidentSetSize, rss).addGauge((MetricsInfo)LlapDaemonJvmInfo.LlapDaemonVirtualMemorySize, vmem);
    }

    public String getName() {
        return this.name;
    }
}

