/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.daemon.impl.LlapDaemon;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniLlapCluster
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(MiniLlapCluster.class);
    private final File testWorkDir;
    private final String clusterNameTrimmed;
    private final long numInstances;
    private final long execBytesPerService;
    private final boolean llapIoEnabled;
    private final boolean ioIsDirect;
    private final long ioBytesPerService;
    private final int numExecutorsPerService;
    private final File zkWorkDir;
    private final String[] localDirs;
    private final Configuration clusterSpecificConfiguration = new Configuration(false);
    private final LlapDaemon[] llapDaemons;
    private MiniZooKeeperCluster miniZooKeeperCluster;
    private final boolean ownZkCluster;

    public static MiniLlapCluster create(String clusterName, @Nullable MiniZooKeeperCluster miniZkCluster, int numInstances, int numExecutorsPerService, long execBytePerService, boolean llapIoEnabled, boolean ioIsDirect, long ioBytesPerService, int numLocalDirs) {
        return new MiniLlapCluster(clusterName, miniZkCluster, numInstances, numExecutorsPerService, execBytePerService, llapIoEnabled, ioIsDirect, ioBytesPerService, numLocalDirs);
    }

    public static MiniLlapCluster create(String clusterName, @Nullable MiniZooKeeperCluster miniZkCluster, int numExecutorsPerService, long execBytePerService, boolean llapIoEnabled, boolean ioIsDirect, long ioBytesPerService, int numLocalDirs) {
        return MiniLlapCluster.create(clusterName, miniZkCluster, 1, numExecutorsPerService, execBytePerService, llapIoEnabled, ioIsDirect, ioBytesPerService, numLocalDirs);
    }

    private MiniLlapCluster(String clusterName, @Nullable MiniZooKeeperCluster miniZkCluster, int numInstances, int numExecutorsPerService, long execMemoryPerService, boolean llapIoEnabled, boolean ioIsDirect, long ioBytesPerService, int numLocalDirs) {
        super(clusterName + "_" + MiniLlapCluster.class.getSimpleName());
        Preconditions.checkArgument((numExecutorsPerService > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((execMemoryPerService > 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((numLocalDirs > 0 ? 1 : 0) != 0);
        this.numInstances = numInstances;
        this.clusterNameTrimmed = clusterName.replace("$", "") + "_" + MiniLlapCluster.class.getSimpleName();
        this.llapDaemons = new LlapDaemon[numInstances];
        File targetWorkDir = new File("target", this.clusterNameTrimmed);
        try {
            FileContext.getLocalFSFileContext().delete(new Path(targetWorkDir.getAbsolutePath()), true);
        }
        catch (Exception e) {
            LOG.warn("Could not cleanup test workDir: " + targetWorkDir, (Throwable)e);
            throw new RuntimeException("Could not cleanup test workDir: " + targetWorkDir, e);
        }
        targetWorkDir.mkdir();
        this.testWorkDir = targetWorkDir;
        if (miniZkCluster == null) {
            this.ownZkCluster = true;
            this.zkWorkDir = new File(this.testWorkDir, "mini-zk-cluster");
            this.zkWorkDir.mkdir();
        } else {
            this.miniZooKeeperCluster = miniZkCluster;
            this.ownZkCluster = false;
            this.zkWorkDir = null;
        }
        this.numExecutorsPerService = numExecutorsPerService;
        this.execBytesPerService = execMemoryPerService;
        this.ioIsDirect = ioIsDirect;
        this.llapIoEnabled = llapIoEnabled;
        this.ioBytesPerService = ioBytesPerService;
        this.localDirs = new String[numLocalDirs];
        for (int i = 0; i < numLocalDirs; ++i) {
            File f = new File(this.testWorkDir, "localDir");
            f.mkdirs();
            LOG.info("Created localDir: " + f.getAbsolutePath());
            this.localDirs[i] = f.getAbsolutePath();
        }
    }

    public void serviceInit(Configuration conf) throws IOException, InterruptedException {
        int rpcPort = 0;
        int mngPort = 0;
        int shufflePort = 0;
        int webPort = 0;
        int outputFormatServicePort = 0;
        boolean usePortsFromConf = conf.getBoolean("minillap.usePortsFromConf", false);
        LOG.info("MiniLlap configured to use ports from conf: {}", (Object)usePortsFromConf);
        if (usePortsFromConf) {
            rpcPort = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_RPC_PORT);
            mngPort = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_MANAGEMENT_RPC_PORT);
            shufflePort = conf.getInt("llap.shuffle.port", 15551);
            webPort = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_WEB_PORT);
            outputFormatServicePort = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_OUTPUT_SERVICE_PORT);
        }
        HiveConf.setIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_OUTPUT_SERVICE_PORT, (int)outputFormatServicePort);
        if (this.ownZkCluster) {
            this.miniZooKeeperCluster = new MiniZooKeeperCluster();
            this.miniZooKeeperCluster.startup(this.zkWorkDir);
        }
        conf.set(HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS.varname, "@" + this.clusterNameTrimmed);
        conf.set(HiveConf.ConfVars.HIVE_ZOOKEEPER_QUORUM.varname, "localhost");
        conf.setInt(HiveConf.ConfVars.HIVE_ZOOKEEPER_CLIENT_PORT.varname, this.miniZooKeeperCluster.getClientPort());
        this.clusterSpecificConfiguration.set(HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS.varname, "@" + this.clusterNameTrimmed);
        this.clusterSpecificConfiguration.set(HiveConf.ConfVars.HIVE_ZOOKEEPER_QUORUM.varname, "localhost");
        this.clusterSpecificConfiguration.setInt(HiveConf.ConfVars.HIVE_ZOOKEEPER_CLIENT_PORT.varname, this.miniZooKeeperCluster.getClientPort());
        LOG.info("Initializing {} llap instances for MiniLlapCluster with name={}", (Object)this.numInstances, (Object)this.clusterNameTrimmed);
        int i = 0;
        while ((long)i < this.numInstances) {
            this.llapDaemons[i] = new LlapDaemon(conf, this.numExecutorsPerService, this.execBytesPerService, this.llapIoEnabled, this.ioIsDirect, this.ioBytesPerService, this.localDirs, rpcPort, mngPort, shufflePort, webPort, this.clusterNameTrimmed);
            this.llapDaemons[i].init(new Configuration(conf));
            ++i;
        }
        LOG.info("Initialized {} llap instances for MiniLlapCluster with name={}", (Object)this.numInstances, (Object)this.clusterNameTrimmed);
    }

    public void serviceStart() {
        LOG.info("Starting {} llap instances for MiniLlapCluster with name={}", (Object)this.numInstances, (Object)this.clusterNameTrimmed);
        int i = 0;
        while ((long)i < this.numInstances) {
            this.llapDaemons[i].start();
            ++i;
        }
        LOG.info("Started {} llap instances for MiniLlapCluster with name={}", (Object)this.numInstances, (Object)this.clusterNameTrimmed);
        this.clusterSpecificConfiguration.setBoolean("tez.runtime.optimize.local.fetch", false);
    }

    public void serviceStop() throws IOException {
        int i = 0;
        while ((long)i < this.numInstances) {
            if (this.llapDaemons[i] != null) {
                this.llapDaemons[i].stop();
                this.llapDaemons[i] = null;
            }
            ++i;
        }
        if (this.ownZkCluster) {
            if (this.miniZooKeeperCluster != null) {
                LOG.info("Stopping MiniZooKeeper cluster");
                this.miniZooKeeperCluster.shutdown();
                this.miniZooKeeperCluster = null;
                LOG.info("Stopped MiniZooKeeper cluster");
            }
        } else {
            LOG.info("Not stopping MiniZK cluster since it is now owned by us");
        }
    }

    public Configuration getClusterSpecificConfiguration() {
        Preconditions.checkState((this.getServiceState() == Service.STATE.STARTED ? 1 : 0) != 0);
        return this.clusterSpecificConfiguration;
    }

    public long getNumSubmissions() {
        int numSubmissions = 0;
        int i = 0;
        while ((long)i < this.numInstances) {
            numSubmissions = (int)((long)numSubmissions + this.llapDaemons[i].getNumSubmissions());
            ++i;
        }
        return numSubmissions;
    }
}

