/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.daemon.FragmentCompletionHandler;
import org.apache.hadoop.hive.llap.daemon.KilledTaskHandler;
import org.apache.hadoop.hive.llap.daemon.SchedulerFragmentCompletingListener;
import org.apache.hadoop.hive.llap.daemon.impl.AMReporter;
import org.apache.hadoop.hive.llap.daemon.impl.QueryFragmentInfo;
import org.apache.hadoop.hive.llap.daemon.impl.QueryIdentifier;
import org.apache.hadoop.hive.llap.daemon.impl.QueryInfo;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorService;
import org.apache.hadoop.hive.llap.daemon.impl.TaskRunnerCallable;
import org.apache.hadoop.hive.llap.daemon.impl.TestTaskExecutorService;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonExecutorMetrics;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.hadoop.shim.DefaultHadoopShim;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.impl.ExecutionContextImpl;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.task.EndReason;
import org.apache.tez.runtime.task.TaskRunner2Result;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorTestHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(TestTaskExecutorService.class);

    public static MockRequest createMockRequest(int fragmentNum, int parallelism, long firstAttemptStartTime, long currentAttemptStartTime, boolean canFinish, long workTime) {
        LlapDaemonProtocolProtos.SubmitWorkRequestProto request = TaskExecutorTestHelpers.createSubmitWorkRequestProto(fragmentNum, parallelism, firstAttemptStartTime, currentAttemptStartTime);
        return TaskExecutorTestHelpers.createMockRequest(canFinish, canFinish, workTime, request);
    }

    public static MockRequest createMockRequest(int fragmentNum, int parallelism, int withinDagPriority, long firstAttemptStartTime, long currentAttemptStartTime, boolean canFinish, long workTime) {
        LlapDaemonProtocolProtos.SubmitWorkRequestProto request = TaskExecutorTestHelpers.createSubmitWorkRequestProto(fragmentNum, parallelism, 0, firstAttemptStartTime, currentAttemptStartTime, withinDagPriority);
        return TaskExecutorTestHelpers.createMockRequest(canFinish, canFinish, workTime, request);
    }

    private static MockRequest createMockRequest(boolean canFinish, boolean canFinishQueue, long workTime, LlapDaemonProtocolProtos.SubmitWorkRequestProto request) {
        QueryFragmentInfo queryFragmentInfo = TaskExecutorTestHelpers.createQueryFragmentInfo(request.getWorkSpec().getVertex(), request.getFragmentNumber());
        return new MockRequest(request, queryFragmentInfo, canFinish, canFinishQueue, workTime, null);
    }

    public static TaskExecutorService.TaskWrapper createTaskWrapper(LlapDaemonProtocolProtos.SubmitWorkRequestProto request, boolean canFinish, boolean canFinishQueue, int workTime) {
        return new TaskExecutorService.TaskWrapper((TaskRunnerCallable)TaskExecutorTestHelpers.createMockRequest(canFinish, canFinishQueue, workTime, request), null);
    }

    public static TaskExecutorService.TaskWrapper createTaskWrapper(LlapDaemonProtocolProtos.SubmitWorkRequestProto request, boolean canFinish, int workTime) {
        return TaskExecutorTestHelpers.createTaskWrapper(request, canFinish, canFinish, workTime);
    }

    public static QueryFragmentInfo createQueryFragmentInfo(LlapDaemonProtocolProtos.SignableVertexSpec vertex, int fragmentNum) {
        return new QueryFragmentInfo(TaskExecutorTestHelpers.createQueryInfo(), "fakeVertexName", fragmentNum, 0, vertex, "");
    }

    public static QueryInfo createQueryInfo() {
        QueryIdentifier queryIdentifier = new QueryIdentifier("fake_app_id_string", 1);
        QueryInfo queryInfo = new QueryInfo(queryIdentifier, "fake_app_id_string", "fake_dag_id_string", "fake_dag_name", "fakeHiveQueryId", 1, "fakeUser", new ConcurrentHashMap(), new String[0], null, "fakeUser", null, null);
        return queryInfo;
    }

    public static LlapDaemonProtocolProtos.SubmitWorkRequestProto createSubmitWorkRequestProto(int fragmentNumber, int selfAndUpstreamParallelism, long firstAttemptStartTime, long currentAttemptStartTime) {
        return TaskExecutorTestHelpers.createSubmitWorkRequestProto(fragmentNumber, selfAndUpstreamParallelism, 0, firstAttemptStartTime, currentAttemptStartTime, 1);
    }

    public static LlapDaemonProtocolProtos.SubmitWorkRequestProto createSubmitWorkRequestProto(int fragmentNumber, int selfAndUpstreamParallelism, long firstAttemptStartTime, long currentAttemptStartTime, String dagName) {
        return TaskExecutorTestHelpers.createSubmitWorkRequestProto(fragmentNumber, selfAndUpstreamParallelism, 0, firstAttemptStartTime, currentAttemptStartTime, 1, dagName);
    }

    public static LlapDaemonProtocolProtos.SubmitWorkRequestProto createSubmitWorkRequestProto(int fragmentNumber, int selfAndUpstreamParallelism, int selfAndUpstreamComplete, long firstAttemptStartTime, long currentAttemptStartTime, int withinDagPriority) {
        return TaskExecutorTestHelpers.createSubmitWorkRequestProto(fragmentNumber, selfAndUpstreamParallelism, 0, firstAttemptStartTime, currentAttemptStartTime, withinDagPriority, "MockDag");
    }

    public static LlapDaemonProtocolProtos.SubmitWorkRequestProto createSubmitWorkRequestProto(int fragmentNumber, int selfAndUpstreamParallelism, int selfAndUpstreamComplete, long firstAttemptStartTime, long currentAttemptStartTime, int withinDagPriority, String dagName) {
        ApplicationId appId = ApplicationId.newInstance((long)9999L, (int)72);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vId = TezVertexID.getInstance((TezDAGID)dagId, (int)35);
        return LlapDaemonProtocolProtos.SubmitWorkRequestProto.newBuilder().setAttemptNumber(0).setFragmentNumber(fragmentNumber).setWorkSpec(LlapDaemonProtocolProtos.VertexOrBinary.newBuilder().setVertex(LlapDaemonProtocolProtos.SignableVertexSpec.newBuilder().setDagName(dagName).setHiveQueryId(dagName).setUser("MockUser").setTokenIdentifier("MockToken_1").setQueryIdentifier(LlapDaemonProtocolProtos.QueryIdentifierProto.newBuilder().setApplicationIdString(appId.toString()).setAppAttemptNumber(0).setDagIndex(dagId.getId()).build()).setVertexIndex(vId.getId()).setVertexName("MockVertex").setProcessorDescriptor(LlapDaemonProtocolProtos.EntityDescriptorProto.newBuilder().setClassName("MockProcessor").build()).build()).build()).setAmHost("localhost").setAmPort(12345).setContainerIdString("MockContainer_1").setFragmentRuntimeInfo(LlapDaemonProtocolProtos.FragmentRuntimeInfo.newBuilder().setFirstAttemptStartTime(firstAttemptStartTime).setCurrentAttemptStartTime(currentAttemptStartTime).setNumSelfAndUpstreamTasks(selfAndUpstreamParallelism).setNumSelfAndUpstreamCompletedTasks(selfAndUpstreamComplete).setWithinDagPriority(withinDagPriority).build()).build();
    }

    private static void logInfo(String message, Throwable t) {
        LOG.info(message, t);
    }

    private static void logInfo(String message) {
        TaskExecutorTestHelpers.logInfo(message, null);
    }

    public static class MockRequest
    extends TaskRunnerCallable {
        private final long workTime;
        private final boolean canFinish;
        private final boolean canFinishQueue;
        private final AtomicBoolean isStarted = new AtomicBoolean(false);
        private final AtomicBoolean isFinished = new AtomicBoolean(false);
        private final AtomicBoolean wasKilled = new AtomicBoolean(false);
        private final AtomicBoolean wasInterrupted = new AtomicBoolean(false);
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition startedCondition = this.lock.newCondition();
        private final Condition sleepCondition = this.lock.newCondition();
        private boolean shouldSleep = true;
        private final Condition finishedCondition = this.lock.newCondition();
        private final Object killDelay = new Object();
        private boolean isOkToFinish = true;

        public MockRequest(LlapDaemonProtocolProtos.SubmitWorkRequestProto requestProto, QueryFragmentInfo fragmentInfo, boolean canFinish, boolean canFinishQueue, long workTime, TezEvent initialEvent) {
            super(requestProto, fragmentInfo, new Configuration(), (ExecutionContext)new ExecutionContextImpl("localhost"), null, new Credentials(), 0L, (AMReporter)Mockito.mock(AMReporter.class), null, (LlapDaemonExecutorMetrics)Mockito.mock(LlapDaemonExecutorMetrics.class), (KilledTaskHandler)Mockito.mock(KilledTaskHandler.class), (FragmentCompletionHandler)Mockito.mock(FragmentCompletionHandler.class), (HadoopShim)new DefaultHadoopShim(), null, requestProto.getWorkSpec().getVertex(), initialEvent, null, (SchedulerFragmentCompletingListener)Mockito.mock(SchedulerFragmentCompletingListener.class), (SocketFactory)Mockito.mock(SocketFactory.class));
            this.workTime = workTime;
            this.canFinish = canFinish;
            this.canFinishQueue = canFinishQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected TaskRunner2Result callInternal() {
            TaskExecutorTestHelpers.logInfo(super.getRequestId() + " is executing..", null);
            this.lock.lock();
            try {
                this.isStarted.set(true);
                this.startedCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
            this.lock.lock();
            try {
                if (this.shouldSleep) {
                    TaskExecutorTestHelpers.logInfo(super.getRequestId() + " is sleeping for " + this.workTime, null);
                    this.sleepCondition.await(this.workTime, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e) {
                this.wasInterrupted.set(true);
                TaskRunner2Result taskRunner2Result = this.handleKill();
                this.lock.lock();
                try {
                    this.isFinished.set(true);
                    this.finishedCondition.signal();
                }
                finally {
                    this.lock.unlock();
                }
                return taskRunner2Result;
            }
            finally {
                this.lock.unlock();
            }
            if (this.wasKilled.get()) {
                TaskRunner2Result taskRunner2Result = this.handleKill();
                return taskRunner2Result;
            }
            TaskExecutorTestHelpers.logInfo(super.getRequestId() + " succeeded", null);
            TaskRunner2Result taskRunner2Result = new TaskRunner2Result(EndReason.SUCCESS, null, null, false);
            return taskRunner2Result;
            finally {
                this.lock.lock();
                try {
                    this.isFinished.set(true);
                    this.finishedCondition.signal();
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TaskRunner2Result handleKill() {
            boolean hasLogged = false;
            while (true) {
                Object object = this.killDelay;
                synchronized (object) {
                    if (this.isOkToFinish) {
                        break;
                    }
                    if (!hasLogged) {
                        TaskExecutorTestHelpers.logInfo("Waiting after the kill: " + this.getRequestId());
                        hasLogged = true;
                    }
                    try {
                        this.killDelay.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            TaskExecutorTestHelpers.logInfo("Finished with the kill: " + this.getRequestId());
            return new TaskRunner2Result(EndReason.KILL_REQUESTED, null, null, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unblockKill() {
            Object object = this.killDelay;
            synchronized (object) {
                TaskExecutorTestHelpers.logInfo("Unblocking the kill: " + this.getRequestId());
                this.isOkToFinish = true;
                this.killDelay.notifyAll();
            }
        }

        public void killTask() {
            this.lock.lock();
            try {
                this.wasKilled.set(true);
                this.shouldSleep = false;
                this.sleepCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        boolean hasStarted() {
            return this.isStarted.get();
        }

        boolean hasFinished() {
            return this.isFinished.get();
        }

        boolean wasPreempted() {
            return this.wasKilled.get();
        }

        void complete() {
            this.lock.lock();
            try {
                this.shouldSleep = false;
                this.sleepCondition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        void awaitStart() throws InterruptedException {
            this.lock.lock();
            try {
                while (!this.isStarted.get()) {
                    this.startedCondition.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        void awaitEnd() throws InterruptedException {
            this.lock.lock();
            try {
                while (!this.isFinished.get()) {
                    this.finishedCondition.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public boolean canFinish() {
            return this.canFinish;
        }

        public boolean canFinishForPriority() {
            return this.canFinishQueue;
        }

        public void setSleepAfterKill() {
            this.isOkToFinish = false;
        }
    }
}

