/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.DiskRange;
import org.apache.hadoop.hive.common.io.DiskRangeList;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;
import org.apache.hadoop.hive.llap.cache.EvictionAwareAllocator;
import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.cache.LlapOomDebugDump;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheImpl;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hadoop.hive.ql.io.orc.encoded.CacheChunk;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLowLevelCacheImpl {
    private static final Logger LOG = LoggerFactory.getLogger(TestLowLevelCacheImpl.class);
    private static final DataCache.DiskRangeListFactory testFactory = new DataCache.DiskRangeListFactory(){

        public DiskRangeList createCacheChunk(MemoryBuffer buffer, long offset, long end) {
            CacheChunk cc = new CacheChunk();
            cc.init(buffer, offset, end);
            return cc;
        }
    };

    @Test
    public void testGetPut() {
        LowLevelCacheImpl cache = new LowLevelCacheImpl(LlapDaemonCacheMetrics.create((String)"test", (String)"1"), (LowLevelCachePolicy)new DummyCachePolicy(), (Allocator)new DummyAllocator(), true, -1L);
        long fn1 = 1L;
        long fn2 = 2L;
        MemoryBuffer[] fakes = new MemoryBuffer[]{this.fb(), this.fb(), this.fb(), this.fb(), this.fb(), this.fb()};
        this.verifyRefcount(fakes, 1, 1, 1, 1, 1, 1);
        Assert.assertNull((Object)cache.putFileData((Object)fn1, this.drs(1, 2), this.fbs(fakes, 0, 1), 0L, LowLevelCache.Priority.NORMAL, null));
        Assert.assertNull((Object)cache.putFileData((Object)fn2, this.drs(1, 2), this.fbs(fakes, 2, 3), 0L, LowLevelCache.Priority.NORMAL, null));
        this.verifyCacheGet(cache, fn1, 1, 3, fakes[0], fakes[1]);
        this.verifyCacheGet(cache, fn2, 1, 3, fakes[2], fakes[3]);
        this.verifyCacheGet(cache, fn1, 2, 4, fakes[1], this.dr(3, 4));
        this.verifyRefcount(fakes, 3, 4, 3, 3, 1, 1);
        MemoryBuffer[] bufsDiff = this.fbs(fakes, 4, 5);
        long[] mask = cache.putFileData((Object)fn1, this.drs(3, 1), bufsDiff, 0L, LowLevelCache.Priority.NORMAL, null);
        Assert.assertEquals((long)1L, (long)mask.length);
        Assert.assertEquals((long)2L, (long)mask[0]);
        Assert.assertSame((Object)fakes[0], (Object)bufsDiff[1]);
        this.verifyRefcount(fakes, 4, 4, 3, 3, 2, 1);
        this.verifyCacheGet(cache, fn1, 1, 4, fakes[0], fakes[1], fakes[4]);
        this.verifyRefcount(fakes, 5, 5, 3, 3, 3, 1);
    }

    private void verifyCacheGet(LowLevelCacheImpl cache, long fileId, Object ... stuff) {
        DiskRangeList.CreateHelper list = new DiskRangeList.CreateHelper();
        DiskRangeList iter = null;
        int intCount = 0;
        int lastInt = -1;
        int resultCount = stuff.length;
        for (Object obj : stuff) {
            if (obj instanceof Integer) {
                --resultCount;
                Assert.assertTrue((intCount >= 0 ? 1 : 0) != 0);
                if (intCount == 0) {
                    lastInt = (Integer)obj;
                    intCount = 1;
                    continue;
                }
                list.addOrMerge((long)lastInt, (long)((Integer)obj).intValue(), true, true);
                intCount = 0;
                continue;
            }
            if (intCount >= 0) {
                Assert.assertTrue((intCount == 0 ? 1 : 0) != 0);
                intCount = -1;
                iter = cache.getFileData((Object)fileId, list.get(), 0L, testFactory, null, null);
                Assert.assertEquals((long)resultCount, (long)iter.listSize());
            }
            Assert.assertTrue((iter != null ? 1 : 0) != 0);
            if (obj instanceof MemoryBuffer) {
                Assert.assertTrue((boolean)(iter instanceof CacheChunk));
                Assert.assertSame((Object)obj, (Object)((CacheChunk)iter).getBuffer());
            } else {
                Assert.assertTrue((boolean)iter.equals(obj));
            }
            iter = iter.next;
        }
    }

    @Test
    public void testMultiMatch() {
        LowLevelCacheImpl cache = new LowLevelCacheImpl(LlapDaemonCacheMetrics.create((String)"test", (String)"1"), (LowLevelCachePolicy)new DummyCachePolicy(), (Allocator)new DummyAllocator(), true, -1L);
        long fn = 1L;
        MemoryBuffer[] fakes = new MemoryBuffer[]{this.fb(), this.fb()};
        Assert.assertNull((Object)cache.putFileData((Object)fn, new DiskRange[]{this.dr(2, 4), this.dr(6, 8)}, fakes, 0L, LowLevelCache.Priority.NORMAL, null));
        this.verifyCacheGet(cache, fn, 1, 9, this.dr(1, 2), fakes[0], this.dr(4, 6), fakes[1], this.dr(8, 9));
        this.verifyCacheGet(cache, fn, 2, 8, fakes[0], this.dr(4, 6), fakes[1]);
        this.verifyCacheGet(cache, fn, 1, 5, this.dr(1, 2), fakes[0], this.dr(4, 5));
        this.verifyCacheGet(cache, fn, 1, 3, this.dr(1, 2), fakes[0]);
        this.verifyCacheGet(cache, fn, 3, 4, this.dr(3, 4));
        this.verifyCacheGet(cache, fn, 3, 7, this.dr(3, 6), fakes[1]);
        this.verifyCacheGet(cache, fn, 0, 2, 4, 6, this.dr(0, 2), this.dr(4, 6));
        this.verifyCacheGet(cache, fn, 2, 4, 6, 8, fakes[0], fakes[1]);
    }

    @Test
    public void testMultiMatchNonGranular() {
        LowLevelCacheImpl cache = new LowLevelCacheImpl(LlapDaemonCacheMetrics.create((String)"test", (String)"1"), (LowLevelCachePolicy)new DummyCachePolicy(), (Allocator)new DummyAllocator(), false, -1L);
        long fn = 1L;
        MemoryBuffer[] fakes = new MemoryBuffer[]{this.fb(), this.fb()};
        Assert.assertNull((Object)cache.putFileData((Object)fn, new DiskRange[]{this.dr(2, 4), this.dr(6, 8)}, fakes, 0L, LowLevelCache.Priority.NORMAL, null));
        this.verifyCacheGet(cache, fn, 3, 4, fakes[0]);
        this.verifyCacheGet(cache, fn, 3, 7, fakes[0], this.dr(4, 6), fakes[1]);
    }

    @Test
    public void testStaleValueGet() {
        LowLevelCacheImpl cache = new LowLevelCacheImpl(LlapDaemonCacheMetrics.create((String)"test", (String)"1"), (LowLevelCachePolicy)new DummyCachePolicy(), (Allocator)new DummyAllocator(), true, -1L);
        long fn1 = 1L;
        long fn2 = 2L;
        MemoryBuffer[] fakes = new MemoryBuffer[]{this.fb(), this.fb(), this.fb()};
        Assert.assertNull((Object)cache.putFileData((Object)fn1, this.drs(1, 2), this.fbs(fakes, 0, 1), 0L, LowLevelCache.Priority.NORMAL, null));
        Assert.assertNull((Object)cache.putFileData((Object)fn2, this.drs(1), this.fbs(fakes, 2), 0L, LowLevelCache.Priority.NORMAL, null));
        this.verifyCacheGet(cache, fn1, 1, 3, fakes[0], fakes[1]);
        this.verifyCacheGet(cache, fn2, 1, 2, fakes[2]);
        this.verifyRefcount(fakes, 3, 3, 3);
        this.evict(cache, fakes[0]);
        this.evict(cache, fakes[2]);
        this.verifyCacheGet(cache, fn1, 1, 3, this.dr(1, 2), fakes[1]);
        this.verifyCacheGet(cache, fn2, 1, 2, this.dr(1, 2));
        this.verifyRefcount(fakes, -1, 4, -1);
    }

    @Test
    public void testStaleValueReplace() {
        LowLevelCacheImpl cache = new LowLevelCacheImpl(LlapDaemonCacheMetrics.create((String)"test", (String)"1"), (LowLevelCachePolicy)new DummyCachePolicy(), (Allocator)new DummyAllocator(), true, -1L);
        long fn1 = 1L;
        long fn2 = 2L;
        MemoryBuffer[] fakes = new MemoryBuffer[]{this.fb(), this.fb(), this.fb(), this.fb(), this.fb(), this.fb(), this.fb(), this.fb(), this.fb()};
        Assert.assertNull((Object)cache.putFileData((Object)fn1, this.drs(1, 2, 3), this.fbs(fakes, 0, 1, 2), 0L, LowLevelCache.Priority.NORMAL, null));
        Assert.assertNull((Object)cache.putFileData((Object)fn2, this.drs(1), this.fbs(fakes, 3), 0L, LowLevelCache.Priority.NORMAL, null));
        this.evict(cache, fakes[0]);
        this.evict(cache, fakes[3]);
        long[] mask = cache.putFileData((Object)fn1, this.drs(1, 2, 3, 4), this.fbs(fakes, 4, 5, 6, 7), 0L, LowLevelCache.Priority.NORMAL, null);
        Assert.assertEquals((long)1L, (long)mask.length);
        Assert.assertEquals((long)6L, (long)mask[0]);
        Assert.assertNull((Object)cache.putFileData((Object)fn2, this.drs(1), this.fbs(fakes, 8), 0L, LowLevelCache.Priority.NORMAL, null));
        this.verifyCacheGet(cache, fn1, 1, 5, fakes[4], fakes[1], fakes[2], fakes[7]);
    }

    @Test
    public void testCacheMetrics() {
        DiskRangeList.CreateHelper list = new DiskRangeList.CreateHelper();
        list.addOrMerge(0L, 100L, true, false);
        list.addOrMerge(100L, 200L, true, false);
        list.addOrMerge(200L, 300L, true, false);
        list.addOrMerge(300L, 400L, true, false);
        list.addOrMerge(400L, 500L, true, false);
        Assert.assertEquals((long)1L, (long)list.get().listSize());
        Assert.assertEquals((long)500L, (long)list.get().getTotalLength());
        list = new DiskRangeList.CreateHelper();
        list.addOrMerge(0L, 100L, false, false);
        list.addOrMerge(100L, 200L, false, false);
        list.addOrMerge(200L, 300L, false, false);
        list.addOrMerge(300L, 400L, false, false);
        list.addOrMerge(400L, 500L, false, false);
        Assert.assertEquals((long)5L, (long)list.get().listSize());
        Assert.assertEquals((long)500L, (long)list.get().getTotalLength());
        list = new DiskRangeList.CreateHelper();
        list.addOrMerge(0L, 100L, true, false);
        list.addOrMerge(100L, 200L, true, false);
        list.addOrMerge(200L, 300L, false, false);
        list.addOrMerge(300L, 400L, true, false);
        list.addOrMerge(400L, 500L, true, false);
        Assert.assertEquals((long)2L, (long)list.get().listSize());
        Assert.assertEquals((long)500L, (long)list.get().getTotalLength());
        LlapDaemonCacheMetrics metrics = LlapDaemonCacheMetrics.create((String)"test", (String)"1");
        LowLevelCacheImpl cache = new LowLevelCacheImpl(metrics, (LowLevelCachePolicy)new DummyCachePolicy(), (Allocator)new DummyAllocator(), true, -1L);
        long fn = 1L;
        MemoryBuffer[] fakes = new MemoryBuffer[]{this.fb(), this.fb(), this.fb()};
        cache.putFileData((Object)fn, new DiskRange[]{this.dr(0, 100), this.dr(300, 500), this.dr(800, 1000)}, fakes, 0L, LowLevelCache.Priority.NORMAL, null);
        Assert.assertEquals((long)0L, (long)metrics.getCacheRequestedBytes());
        Assert.assertEquals((long)0L, (long)metrics.getCacheHitBytes());
        list = new DiskRangeList.CreateHelper();
        list.addOrMerge(0L, 1000L, true, false);
        cache.getFileData((Object)fn, list.get(), 0L, testFactory, null, null);
        Assert.assertEquals((long)1000L, (long)metrics.getCacheRequestedBytes());
        Assert.assertEquals((long)500L, (long)metrics.getCacheHitBytes());
        list = new DiskRangeList.CreateHelper();
        list.addOrMerge(0L, 100L, true, false);
        cache.getFileData((Object)fn, list.get(), 0L, testFactory, null, null);
        Assert.assertEquals((long)1100L, (long)metrics.getCacheRequestedBytes());
        Assert.assertEquals((long)600L, (long)metrics.getCacheHitBytes());
        list = new DiskRangeList.CreateHelper();
        list.addOrMerge(0L, 100L, true, false);
        list.addOrMerge(300L, 500L, true, false);
        list.addOrMerge(800L, 1000L, true, false);
        cache.getFileData((Object)fn, list.get(), 0L, testFactory, null, null);
        Assert.assertEquals((long)1600L, (long)metrics.getCacheRequestedBytes());
        Assert.assertEquals((long)1100L, (long)metrics.getCacheHitBytes());
        list = new DiskRangeList.CreateHelper();
        list.addOrMerge(300L, 500L, true, false);
        list.addOrMerge(1000L, 2000L, true, false);
        cache.getFileData((Object)fn, list.get(), 0L, testFactory, null, null);
        Assert.assertEquals((long)2800L, (long)metrics.getCacheRequestedBytes());
        Assert.assertEquals((long)1300L, (long)metrics.getCacheHitBytes());
    }

    @Test
    public void testMTTWithCleanup() {
        final LowLevelCacheImpl cache = new LowLevelCacheImpl(LlapDaemonCacheMetrics.create((String)"test", (String)"1"), (LowLevelCachePolicy)new DummyCachePolicy(), (Allocator)new DummyAllocator(), true, 1L);
        long fn1 = 1L;
        long fn2 = 2L;
        int offsetsToUse = 8;
        final CountDownLatch cdlIn = new CountDownLatch(4);
        final CountDownLatch cdlOut = new CountDownLatch(1);
        final AtomicInteger rdmsDone = new AtomicInteger(0);
        Callable<Long> rdmCall = new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() {
                int gets = 0;
                int puts = 0;
                try {
                    Random rdm = new Random(1234L + Thread.currentThread().getId());
                    TestLowLevelCacheImpl.this.syncThreadStart(cdlIn, cdlOut);
                    for (int i = 0; i < 20000; ++i) {
                        int j;
                        boolean isGet = rdm.nextBoolean();
                        boolean isFn1 = rdm.nextBoolean();
                        long fileName = isFn1 ? 1L : 2L;
                        int fileIndex = isFn1 ? 1 : 2;
                        int count = rdm.nextInt(8);
                        if (isGet) {
                            int[] offsets = new int[count];
                            count = TestLowLevelCacheImpl.this.generateOffsets(8, rdm, offsets);
                            DiskRangeList.CreateHelper list = new DiskRangeList.CreateHelper();
                            int j2 = 0;
                            while (i < count) {
                                list.addOrMerge((long)offsets[j2], (long)(offsets[j2] + 1), true, false);
                                ++i;
                            }
                            DiskRangeList iter = cache.getFileData((Object)fileName, list.get(), 0L, testFactory, null, null);
                            j = -1;
                            while (iter != null) {
                                ++j;
                                if (!(iter instanceof CacheChunk)) {
                                    iter = iter.next;
                                    continue;
                                }
                                ++gets;
                                LlapDataBuffer result = (LlapDataBuffer)((CacheChunk)iter).getBuffer();
                                Assert.assertEquals((long)this.makeFakeArenaIndex(fileIndex, offsets[j]), (long)result.arenaIndex);
                                cache.decRefBuffer((MemoryBuffer)result);
                                iter = iter.next;
                            }
                            continue;
                        }
                        DiskRange[] ranges = new DiskRange[count];
                        int[] offsets = new int[count];
                        for (int j3 = 0; j3 < count; ++j3) {
                            int next = rdm.nextInt(8);
                            ranges[j3] = TestLowLevelCacheImpl.this.dr(next, next + 1);
                            offsets[j3] = next;
                        }
                        MemoryBuffer[] buffers = new MemoryBuffer[count];
                        for (j = 0; j < offsets.length; ++j) {
                            LlapDataBuffer buf = LowLevelCacheImpl.allocateFake();
                            buf.arenaIndex = this.makeFakeArenaIndex(fileIndex, offsets[j]);
                            buffers[j] = buf;
                        }
                        long[] mask = cache.putFileData((Object)fileName, ranges, buffers, 0L, LowLevelCache.Priority.NORMAL, null);
                        puts += buffers.length;
                        long maskVal = 0L;
                        if (mask != null) {
                            Assert.assertEquals((long)1L, (long)mask.length);
                            maskVal = mask[0];
                        }
                        for (int j4 = 0; j4 < offsets.length; ++j4) {
                            LlapDataBuffer buf = (LlapDataBuffer)buffers[j4];
                            if ((maskVal & 1L) == 1L) {
                                Assert.assertEquals((long)this.makeFakeArenaIndex(fileIndex, offsets[j4]), (long)buf.arenaIndex);
                            }
                            maskVal >>= 1;
                            cache.decRefBuffer((MemoryBuffer)buf);
                        }
                    }
                }
                finally {
                    rdmsDone.incrementAndGet();
                }
                return (long)gets << 32 | (long)puts;
            }

            private int makeFakeArenaIndex(int fileIndex, long offset) {
                return (int)((long)(fileIndex << 16) + offset);
            }
        };
        FutureTask<Integer> evictionTask = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() {
                boolean isFirstFile = false;
                Random rdm = new Random(1234L + Thread.currentThread().getId());
                int evictions = 0;
                TestLowLevelCacheImpl.this.syncThreadStart(cdlIn, cdlOut);
                while (rdmsDone.get() < 3) {
                    int startIndex;
                    DiskRangeList head = new DiskRangeList(0L, 9L);
                    isFirstFile = !isFirstFile;
                    long fileId = isFirstFile ? 1L : 2L;
                    head = cache.getFileData((Object)fileId, head, 0L, testFactory, null, null);
                    DiskRangeList[] results = head.listToArray();
                    int index = startIndex = rdm.nextInt(results.length);
                    LlapDataBuffer victim = null;
                    do {
                        DiskRangeList r;
                        if ((r = results[index]) instanceof CacheChunk) {
                            LlapDataBuffer result = (LlapDataBuffer)((CacheChunk)r).getBuffer();
                            cache.decRefBuffer((MemoryBuffer)result);
                            if (victim == null && result.invalidate()) {
                                ++evictions;
                                victim = result;
                            }
                        }
                        if (++index != results.length) continue;
                        index = 0;
                    } while (index != startIndex);
                    if (victim == null) continue;
                    cache.notifyEvicted(victim);
                }
                return evictions;
            }
        });
        FutureTask<Long> rdmTask1 = new FutureTask<Long>(rdmCall);
        FutureTask<Long> rdmTask2 = new FutureTask<Long>(rdmCall);
        FutureTask<Long> rdmTask3 = new FutureTask<Long>(rdmCall);
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        threadPool.execute(rdmTask1);
        threadPool.execute(rdmTask2);
        threadPool.execute(rdmTask3);
        threadPool.execute(evictionTask);
        try {
            cdlIn.await();
            cdlOut.countDown();
            long result1 = rdmTask1.get();
            long result2 = rdmTask2.get();
            long result3 = rdmTask3.get();
            int evictions = evictionTask.get();
            LOG.info("MTT test: task 1: " + this.descRdmTask(result1) + ", task 2: " + this.descRdmTask(result2) + ", task 3: " + this.descRdmTask(result3) + "; " + evictions + " evictions");
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private String descRdmTask(long result) {
        return (result >>> 32) + " successful gets, " + (result & 0xFFFFFFFFL) + " puts";
    }

    private void syncThreadStart(CountDownLatch cdlIn, CountDownLatch cdlOut) {
        cdlIn.countDown();
        try {
            cdlOut.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void evict(LowLevelCacheImpl cache, MemoryBuffer fake) {
        LlapDataBuffer victimBuffer = (LlapDataBuffer)fake;
        int refCount = victimBuffer.getRefCount();
        for (int i = 0; i < refCount; ++i) {
            victimBuffer.decRef();
        }
        Assert.assertTrue((boolean)victimBuffer.invalidate());
        cache.notifyEvicted((MemoryBuffer)victimBuffer);
    }

    private void verifyRefcount(MemoryBuffer[] fakes, int ... refCounts) {
        for (int i = 0; i < refCounts.length; ++i) {
            Assert.assertEquals((String)("At " + i), (long)refCounts[i], (long)((LlapDataBuffer)fakes[i]).getRefCount());
        }
    }

    private MemoryBuffer[] fbs(MemoryBuffer[] fakes, int ... indexes) {
        MemoryBuffer[] rv = new MemoryBuffer[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            rv[i] = indexes[i] == -1 ? null : fakes[indexes[i]];
        }
        return rv;
    }

    private MemoryBuffer[] fbs(int count) {
        MemoryBuffer[] rv = new MemoryBuffer[count];
        for (int i = 0; i < count; ++i) {
            rv[i] = this.fb();
        }
        return rv;
    }

    private LlapDataBuffer fb() {
        LlapDataBuffer fake = LowLevelCacheImpl.allocateFake();
        fake.incRef();
        return fake;
    }

    private DiskRangeList dr(int from, int to) {
        return new DiskRangeList((long)from, (long)to);
    }

    private DiskRange[] drs(int ... offsets) {
        DiskRange[] result = new DiskRange[offsets.length];
        for (int i = 0; i < offsets.length; ++i) {
            result[i] = new DiskRange((long)offsets[i], (long)(offsets[i] + 1));
        }
        return result;
    }

    private DiskRange[] gaps(int ... offsets) {
        DiskRange[] result = new DiskRange[offsets.length - 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new DiskRange((long)offsets[i], (long)offsets[i + 1]);
        }
        return result;
    }

    private int generateOffsets(int offsetsToUse, Random rdm, int[] offsets) {
        for (int j = 0; j < offsets.length; ++j) {
            offsets[j] = rdm.nextInt(offsetsToUse);
        }
        Arrays.sort(offsets);
        int check = 0;
        int insert = 0;
        int count = offsets.length;
        while (check < offsets.length - 1) {
            if (offsets[check] == offsets[check + 1]) {
                --insert;
                --count;
            }
            offsets[++insert] = offsets[++check];
        }
        return count;
    }

    private static class DummyCachePolicy
    implements LowLevelCachePolicy {
        public void cache(LlapCacheableBuffer buffer, LowLevelCache.Priority pri) {
        }

        public void notifyLock(LlapCacheableBuffer buffer) {
        }

        public void notifyUnlock(LlapCacheableBuffer buffer) {
        }

        public long evictSomeBlocks(long memoryToReserve) {
            return memoryToReserve;
        }

        public void setEvictionListener(EvictionListener listener) {
        }

        public String debugDumpForOom() {
            return "";
        }

        public void setParentDebugDumper(LlapOomDebugDump dumper) {
        }

        public long tryEvictContiguousData(int allocationSize, int count) {
            return count * allocationSize;
        }
    }

    private static class DummyAllocator
    implements EvictionAwareAllocator {
        private DummyAllocator() {
        }

        public void allocateMultiple(MemoryBuffer[] dest, int size) {
            for (int i = 0; i < dest.length; ++i) {
                LlapDataBuffer buf = new LlapDataBuffer();
                buf.initialize(0, null, -1, size);
                dest[i] = buf;
            }
        }

        public void deallocate(MemoryBuffer buffer) {
        }

        public void deallocateEvicted(MemoryBuffer buffer) {
        }

        public boolean isDirectAlloc() {
            return false;
        }

        public int getMaxAllocation() {
            return 0;
        }

        public MemoryBuffer createUnallocated() {
            return new LlapDataBuffer();
        }
    }
}

