/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.io.BytesWritable;
import org.apache.spark.serializer.KryoRegistrator;

public class HiveKryoRegistrator
implements KryoRegistrator {
    public void registerClasses(Kryo kryo) {
        kryo.register(HiveKey.class, (Serializer)new HiveKeySerializer());
        kryo.register(BytesWritable.class, (Serializer)new BytesWritableSerializer());
    }

    private static class BytesWritableSerializer
    extends Serializer<BytesWritable> {
        private BytesWritableSerializer() {
        }

        public void write(Kryo kryo, Output output, BytesWritable object) {
            output.writeVarInt(object.getLength(), true);
            output.write(object.getBytes(), 0, object.getLength());
        }

        public BytesWritable read(Kryo kryo, Input input, Class<BytesWritable> type) {
            int len = input.readVarInt(true);
            byte[] bytes = new byte[len];
            input.readBytes(bytes);
            return new BytesWritable(bytes);
        }
    }

    private static class HiveKeySerializer
    extends Serializer<HiveKey> {
        private HiveKeySerializer() {
        }

        public void write(Kryo kryo, Output output, HiveKey object) {
            output.writeVarInt(object.getLength(), true);
            output.write(object.getBytes(), 0, object.getLength());
            output.writeVarInt(object.hashCode(), false);
        }

        public HiveKey read(Kryo kryo, Input input, Class<HiveKey> type) {
            int len = input.readVarInt(true);
            byte[] bytes = new byte[len];
            input.readBytes(bytes);
            return new HiveKey(bytes, input.readVarInt(false));
        }
    }
}

