/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.jdbc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.common.auth.HiveAuthUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.common.util.MapRKeystoreReader;
import org.apache.hive.jdbc.HiveDatabaseMetaData;
import org.apache.hive.jdbc.HivePreparedStatement;
import org.apache.hive.jdbc.HiveStatement;
import org.apache.hive.jdbc.HttpBasicAuthInterceptor;
import org.apache.hive.jdbc.HttpKerberosRequestInterceptor;
import org.apache.hive.jdbc.HttpRequestInterceptorBase;
import org.apache.hive.jdbc.HttpTokenAuthInterceptor;
import org.apache.hive.jdbc.Utils;
import org.apache.hive.jdbc.XsrfHttpRequestInterceptor;
import org.apache.hive.jdbc.ZooKeeperHiveClientException;
import org.apache.hive.jdbc.ZooKeeperHiveClientHelper;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.auth.KerberosSaslHelper;
import org.apache.hive.service.auth.MapRSecSaslHelper;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.auth.SaslQOP;
import org.apache.hive.service.cli.session.SessionUtils;
import org.apache.hive.service.cli.thrift.EmbeddedThriftBinaryCLIService;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.apache.hive.service.rpc.thrift.TCancelDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TCancelDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TCloseSessionReq;
import org.apache.hive.service.rpc.thrift.TGetDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TGetDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TOpenSessionReq;
import org.apache.hive.service.rpc.thrift.TOpenSessionResp;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.hive.service.rpc.thrift.TRenewDelegationTokenReq;
import org.apache.hive.service.rpc.thrift.TRenewDelegationTokenResp;
import org.apache.hive.service.rpc.thrift.TSessionHandle;
import org.apache.hive.service.rpc.thrift.TSetClientInfoReq;
import org.apache.hive.service.rpc.thrift.TSetClientInfoResp;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveConnection
implements Connection {
    public static final Logger LOG = LoggerFactory.getLogger((String)HiveConnection.class.getName());
    private String jdbcUriString;
    private String host;
    private int port;
    private final Map<String, String> sessConfMap;
    private Utils.JdbcConnectionParams connParams;
    private final boolean isEmbeddedMode;
    private TTransport transport;
    private boolean assumeSubject;
    private TCLIService.Iface client;
    private boolean isClosed = true;
    private SQLWarning warningChain = null;
    private TSessionHandle sessHandle = null;
    private final List<TProtocolVersion> supportedProtocols = new LinkedList<TProtocolVersion>();
    private int loginTimeout = 0;
    private TProtocolVersion protocol;
    private int fetchSize = 1000;
    private String initFile = null;
    private String wmPool = null;
    private String wmApp = null;
    private Properties clientInfo;
    private Subject loggedInSubject;

    public static List<Utils.JdbcConnectionParams> getAllUrls(String zookeeperBasedHS2Url) throws Exception {
        Utils.JdbcConnectionParams params = Utils.parseURL(zookeeperBasedHS2Url, new Properties());
        if (params.getZooKeeperEnsemble() == null || ZooKeeperHiveClientHelper.isZkHADynamicDiscoveryMode(params.getSessionVars())) {
            return Collections.singletonList(params);
        }
        return ZooKeeperHiveClientHelper.getDirectParamsList(params);
    }

    public HiveConnection(String uri, Properties info) throws SQLException {
        this.setupLoginTimeout();
        try {
            this.connParams = Utils.parseURL(uri, info);
        }
        catch (ZooKeeperHiveClientException e) {
            throw new SQLException(e);
        }
        this.jdbcUriString = this.connParams.getJdbcUriString();
        this.host = Utils.getCanonicalHostName(this.connParams.getHost());
        this.port = this.connParams.getPort();
        this.sessConfMap = this.connParams.getSessionVars();
        this.isEmbeddedMode = this.connParams.isEmbeddedMode();
        if (this.sessConfMap.containsKey("fetchSize")) {
            this.fetchSize = Integer.parseInt(this.sessConfMap.get("fetchSize"));
        }
        if (this.sessConfMap.containsKey("initFile")) {
            this.initFile = this.sessConfMap.get("initFile");
        }
        this.wmPool = this.sessConfMap.get("wmPool");
        for (String application : Utils.JdbcConnectionParams.APPLICATION) {
            this.wmApp = this.sessConfMap.get(application);
            if (this.wmApp != null) break;
        }
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V1);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V2);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V3);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V4);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V5);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V6);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V7);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V8);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V9);
        this.supportedProtocols.add(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V10);
        if (this.isEmbeddedMode) {
            EmbeddedThriftBinaryCLIService embeddedClient = new EmbeddedThriftBinaryCLIService();
            embeddedClient.init(null, this.connParams.getHiveConfs());
            this.client = embeddedClient;
            this.connParams.getHiveConfs().clear();
            this.openSession();
            this.executeInitSql();
        } else {
            int maxRetries = 1;
            try {
                String strRetries = this.sessConfMap.get("retries");
                if (StringUtils.isNotBlank((String)strRetries)) {
                    maxRetries = Integer.parseInt(strRetries);
                }
            }
            catch (NumberFormatException strRetries) {
                // empty catch block
            }
            int numRetries = 0;
            while (true) {
                try {
                    this.openTransport();
                    this.client = new TCLIService.Client((TProtocol)new TBinaryProtocol(this.transport));
                    this.openSession();
                    this.executeInitSql();
                }
                catch (Exception e) {
                    LOG.warn("Failed to connect to " + this.connParams.getHost() + ":" + this.connParams.getPort());
                    Object errMsg = null;
                    String warnMsg = "Could not open client transport with JDBC Uri: " + this.jdbcUriString + ": ";
                    if (ZooKeeperHiveClientHelper.isZkDynamicDiscoveryMode(this.sessConfMap)) {
                        errMsg = "Could not open client transport for any of the Server URI's in ZooKeeper: ";
                        while (!Utils.updateConnParamsFromZooKeeper(this.connParams) && ++numRetries < maxRetries) {
                            this.connParams.getRejectedHostZnodePaths().clear();
                        }
                        this.jdbcUriString = this.connParams.getJdbcUriString();
                        this.host = Utils.getCanonicalHostName(this.connParams.getHost());
                        this.port = this.connParams.getPort();
                    } else {
                        errMsg = warnMsg;
                        ++numRetries;
                    }
                    if (numRetries >= maxRetries) {
                        throw new SQLException((String)errMsg + e.getMessage(), " 08S01", e);
                    }
                    LOG.warn(warnMsg + e.getMessage() + " Retrying " + numRetries + " of " + maxRetries);
                    continue;
                }
                break;
            }
        }
        this.client = HiveConnection.newSynchronizedClient(this.client);
    }

    private void executeInitSql() throws SQLException {
        if (this.initFile != null) {
            try {
                List<String> sqlList = HiveConnection.parseInitFile(this.initFile);
                Statement st = this.createStatement();
                for (String sql : sqlList) {
                    boolean hasResult = st.execute(sql);
                    if (!hasResult) continue;
                    ResultSet rs = st.getResultSet();
                    while (rs.next()) {
                        System.out.println(rs.getString(1));
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Failed to execute initial SQL");
                throw new SQLException(e.getMessage());
            }
        }
    }

    public static List<String> parseInitFile(String initFile) throws IOException {
        File file = new File(initFile);
        List<String> initSqlList = null;
        try (BufferedReader br = null;){
            String line;
            FileInputStream input = new FileInputStream(file);
            br = new BufferedReader(new InputStreamReader((InputStream)input, "UTF-8"));
            StringBuilder sb = new StringBuilder("");
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || line.startsWith("--")) continue;
                line = line.concat(" ");
                sb.append(line);
            }
            initSqlList = HiveConnection.getInitSql(sb.toString());
        }
        return initSqlList;
    }

    private static List<String> getInitSql(String sbLine) {
        char[] sqlArray = sbLine.toCharArray();
        ArrayList<String> initSqlList = new ArrayList<String>();
        int beginIndex = 0;
        for (int index = 0; index < sqlArray.length; ++index) {
            if (sqlArray[index] != ';') continue;
            String sql = sbLine.substring(beginIndex, index).trim();
            initSqlList.add(sql);
            beginIndex = index + 1;
        }
        return initSqlList;
    }

    private void openTransport() throws Exception {
        this.assumeSubject = "fromSubject".equals(this.sessConfMap.get("kerberosAuthType"));
        TTransport tTransport = this.transport = this.isHttpTransportMode() ? this.createHttpTransport() : this.createBinaryTransport();
        if (!this.transport.isOpen()) {
            this.transport.open();
        }
        this.logZkDiscoveryMessage("Connected to " + this.connParams.getHost() + ":" + this.connParams.getPort());
    }

    public String getConnectedUrl() {
        return this.jdbcUriString;
    }

    private String getServerHttpUrl(boolean useSsl) {
        String schemeName = useSsl ? "https" : "http";
        Object httpPath = this.sessConfMap.get("httpPath");
        if (httpPath == null) {
            httpPath = "/";
        } else if (!((String)httpPath).startsWith("/")) {
            httpPath = "/" + (String)httpPath;
        }
        return schemeName + "://" + this.host + ":" + this.port + (String)httpPath;
    }

    private TTransport createHttpTransport() throws SQLException, TTransportException {
        boolean useSsl = this.isSslConnection();
        CloseableHttpClient httpClient = this.getHttpClient(useSsl);
        this.transport = new THttpClient(this.getServerHttpUrl(useSsl), (HttpClient)httpClient);
        HiveAuthUtils.configureThriftMaxMessageSize((TTransport)this.transport, (int)this.getMaxMessageSize());
        return this.transport;
    }

    private CloseableHttpClient getHttpClient(Boolean useSsl) throws SQLException {
        HttpRequestInterceptorBase requestInterceptor;
        boolean isCookieEnabled = this.sessConfMap.get("cookieAuth") == null || !"false".equalsIgnoreCase(this.sessConfMap.get("cookieAuth"));
        String cookieName = this.sessConfMap.get("cookieName") == null ? "hive.server2.auth" : this.sessConfMap.get("cookieName");
        BasicCookieStore cookieStore = isCookieEnabled ? new BasicCookieStore() : null;
        HashMap<String, String> additionalHttpHeaders = new HashMap<String, String>();
        HashMap<String, String> customCookies = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.sessConfMap.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("http.header.")) {
                additionalHttpHeaders.put(key.substring("http.header.".length()), entry.getValue());
            }
            if (!key.startsWith("http.cookie.")) continue;
            customCookies.put(key.substring("http.cookie.".length()), entry.getValue());
        }
        if (this.isKerberosAuthMode()) {
            if (this.assumeSubject) {
                AccessControlContext context = AccessController.getContext();
                this.loggedInSubject = Subject.getSubject(context);
                if (this.loggedInSubject == null) {
                    throw new SQLException("The Subject is not set");
                }
            }
            requestInterceptor = new HttpKerberosRequestInterceptor(this.sessConfMap.get("principal"), this.host, this.getServerHttpUrl(useSsl), this.loggedInSubject, (CookieStore)cookieStore, cookieName, useSsl, additionalHttpHeaders, customCookies);
        } else {
            String tokenStr = this.getClientDelegationToken(this.sessConfMap);
            requestInterceptor = tokenStr != null ? new HttpTokenAuthInterceptor(tokenStr, (CookieStore)cookieStore, cookieName, useSsl, additionalHttpHeaders, customCookies) : new HttpBasicAuthInterceptor(this.getUserName(), this.getPassword(), (CookieStore)cookieStore, cookieName, useSsl, additionalHttpHeaders, customCookies);
        }
        HttpClientBuilder httpClientBuilder = isCookieEnabled ? HttpClients.custom().setServiceUnavailableRetryStrategy(new ServiceUnavailableRetryStrategy(){

            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                boolean ret;
                int statusCode = response.getStatusLine().getStatusCode();
                boolean bl = ret = statusCode == 401 && executionCount <= 1;
                if (ret) {
                    context.setAttribute("hive.server2.retryserver", (Object)"true");
                }
                return ret;
            }

            public long getRetryInterval() {
                return 0L;
            }
        }) : HttpClientBuilder.create();
        httpClientBuilder.setRetryHandler(new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount > 1) {
                    LOG.info("Retry attempts to connect to server exceeded.");
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    LOG.info("Could not connect to the server. Retrying one more time.");
                    return true;
                }
                return false;
            }
        });
        httpClientBuilder.addInterceptorFirst((HttpRequestInterceptor)requestInterceptor);
        httpClientBuilder.addInterceptorLast((HttpRequestInterceptor)new XsrfHttpRequestInterceptor());
        if (useSsl.booleanValue()) {
            String useTwoWaySSL = this.sessConfMap.get("twoWay");
            String sslTrustStorePath = this.sessConfMap.get("sslTrustStore");
            String sslTrustStorePassword = this.sessConfMap.get("trustStorePassword");
            try {
                SSLConnectionSocketFactory socketFactory;
                if (useTwoWaySSL != null && useTwoWaySSL.equalsIgnoreCase("true")) {
                    socketFactory = this.getTwoWaySSLSocketFactory();
                } else if (sslTrustStorePath == null || sslTrustStorePath.isEmpty()) {
                    socketFactory = SSLConnectionSocketFactory.getSocketFactory();
                } else {
                    KeyStore sslTrustStore = KeyStore.getInstance("JKS");
                    try (FileInputStream fis = new FileInputStream(sslTrustStorePath);){
                        sslTrustStore.load(fis, sslTrustStorePassword.toCharArray());
                    }
                    SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(sslTrustStore, null).build();
                    socketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier(null));
                }
                Registry registry = RegistryBuilder.create().register("https", (Object)socketFactory).build();
                httpClientBuilder.setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager((Lookup)registry));
            }
            catch (Exception e) {
                String msg = "Could not create an https connection to " + this.jdbcUriString + ". " + e.getMessage();
                throw new SQLException(msg, " 08S01", e);
            }
        }
        return httpClientBuilder.build();
    }

    private TTransport createUnderlyingTransport() throws TTransportException, SQLException {
        int maxMessageSize = this.getMaxMessageSize();
        TTransport transport = null;
        if (this.isSslConnection()) {
            String sslTrustStore = this.sessConfMap.get("sslTrustStore");
            String sslTrustStorePassword = this.sessConfMap.get("trustStorePassword");
            String sslProtocolVersion = HiveAuthUtils.getSslProtocolVersion();
            if (sslTrustStore == null || sslTrustStore.isEmpty()) {
                sslTrustStore = MapRKeystoreReader.getClientTruststoreLocation();
                sslTrustStorePassword = MapRKeystoreReader.getClientTruststorePassword();
            }
            transport = HiveAuthUtils.getSSLSocket((String)this.host, (int)this.port, (int)this.loginTimeout, (String)sslTrustStore, (String)sslTrustStorePassword, (String)sslProtocolVersion, (int)maxMessageSize);
        } else {
            transport = HiveAuthUtils.getSocketTransport((String)this.host, (int)this.port, (int)this.loginTimeout);
        }
        return transport;
    }

    private int getMaxMessageSize() throws SQLException {
        String maxMessageSize = this.sessConfMap.get("thrift.client.max.message.size");
        if (maxMessageSize == null) {
            return -1;
        }
        try {
            return Integer.parseInt(maxMessageSize);
        }
        catch (Exception e) {
            String errFormat = "Invalid {} configuration of '{}'. Expected an integer specifying number of bytes. A configuration of <= 0 uses default max message size.";
            String errMsg = String.format(errFormat, "thrift.client.max.message.size", maxMessageSize);
            throw new SQLException(errMsg, "42000", e);
        }
    }

    private TTransport createBinaryTransport() throws SQLException, TTransportException {
        block13: {
            try {
                if (!"noSasl".equals(this.sessConfMap.get("auth"))) {
                    HashMap<String, String> saslProps = new HashMap<String, String>();
                    SaslQOP saslQOP = SaslQOP.AUTH_CONF;
                    if (this.sessConfMap.containsKey("saslQop")) {
                        try {
                            saslQOP = SaslQOP.fromString((String)this.sessConfMap.get("saslQop"));
                        }
                        catch (IllegalArgumentException e) {
                            throw new SQLException("Invalid saslQop parameter. " + e.getMessage(), "42000", e);
                        }
                        saslProps.put("javax.security.sasl.qop", saslQOP.toString());
                    } else {
                        saslProps.put("javax.security.sasl.qop", "auth-conf,auth-int,auth");
                    }
                    saslProps.put("javax.security.sasl.server.authentication", "true");
                    if ("maprsasl".equalsIgnoreCase(this.sessConfMap.get("auth"))) {
                        this.transport = "true".equalsIgnoreCase(this.sessConfMap.get("ssl")) ? MapRSecSaslHelper.getTransport((TTransport)HiveAuthUtils.getTrustAllSSLSocket((String)this.host, (int)this.port, (int)this.loginTimeout), saslProps) : MapRSecSaslHelper.getTransport((TTransport)HiveAuthFactory.getSocketTransport((String)this.host, (int)this.port, (int)this.loginTimeout), saslProps);
                    } else if (this.sessConfMap.containsKey("principal")) {
                        this.transport = KerberosSaslHelper.getKerberosTransport((String)this.sessConfMap.get("principal"), (String)this.host, (TTransport)this.createUnderlyingTransport(), saslProps, (boolean)this.assumeSubject);
                    } else {
                        String tokenStr = this.getClientDelegationToken(this.sessConfMap);
                        if (tokenStr != null) {
                            this.transport = KerberosSaslHelper.getTokenTransport((String)tokenStr, (String)this.host, (TTransport)this.createUnderlyingTransport(), saslProps);
                        } else {
                            String userName = this.getUserName();
                            String passwd = this.getPassword();
                            this.transport = PlainSaslHelper.getPlainTransport((String)userName, (String)passwd, (TTransport)this.createUnderlyingTransport());
                        }
                    }
                    break block13;
                }
                this.transport = this.createUnderlyingTransport();
            }
            catch (SaslException e) {
                throw new SQLException("Could not create secure connection to " + this.jdbcUriString + ": " + e.getMessage(), " 08S01", e);
            }
        }
        return this.transport;
    }

    SSLConnectionSocketFactory getTwoWaySSLSocketFactory() throws SQLException {
        SSLConnectionSocketFactory socketFactory = null;
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509", "SunJSSE");
            String keyStorePath = this.sessConfMap.get("sslKeyStore");
            String keyStorePassword = this.sessConfMap.get("keyStorePassword");
            KeyStore sslKeyStore = KeyStore.getInstance("JKS");
            if (keyStorePath == null || keyStorePath.isEmpty()) {
                throw new IllegalArgumentException("sslKeyStore Not configured for 2 way SSL connection, keyStorePath param is empty");
            }
            try (FileInputStream fis = new FileInputStream(keyStorePath);){
                sslKeyStore.load(fis, keyStorePassword.toCharArray());
            }
            keyManagerFactory.init(sslKeyStore, keyStorePassword.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            String trustStorePath = this.sessConfMap.get("sslTrustStore");
            String trustStorePassword = this.sessConfMap.get("trustStorePassword");
            KeyStore sslTrustStore = KeyStore.getInstance("JKS");
            if (trustStorePath == null || trustStorePath.isEmpty()) {
                throw new IllegalArgumentException("sslTrustStore Not configured for 2 way SSL connection");
            }
            try (FileInputStream fis = new FileInputStream(trustStorePath);){
                sslTrustStore.load(fis, trustStorePassword.toCharArray());
            }
            trustManagerFactory.init(sslTrustStore);
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            socketFactory = new SSLConnectionSocketFactory(context);
        }
        catch (Exception e) {
            throw new SQLException("Error while initializing 2 way ssl socket factory ", e);
        }
        return socketFactory;
    }

    private String getClientDelegationToken(Map<String, String> jdbcConnConf) throws SQLException {
        String tokenStr = null;
        if ("delegationToken".equalsIgnoreCase(jdbcConnConf.get("auth"))) {
            try {
                tokenStr = SessionUtils.getTokenStrForm((String)"hiveserver2ClientToken");
            }
            catch (IOException e) {
                throw new SQLException("Error reading token ", e);
            }
        }
        return tokenStr;
    }

    private void openSession() throws SQLException {
        Map<String, String> sessVars;
        TOpenSessionReq openReq = new TOpenSessionReq();
        HashMap<Object, String> openConf = new HashMap<Object, String>();
        for (Map.Entry<String, String> hiveConf : this.connParams.getHiveConfs().entrySet()) {
            openConf.put("set:hiveconf:" + hiveConf.getKey(), hiveConf.getValue());
        }
        for (Map.Entry<String, String> hiveVar : this.connParams.getHiveVars().entrySet()) {
            openConf.put("set:hivevar:" + hiveVar.getKey(), hiveVar.getValue());
        }
        openConf.put("use:database", this.connParams.getDbName());
        openConf.put("set:hiveconf:hive.server2.thrift.resultset.default.fetch.size", Integer.toString(this.fetchSize));
        if (this.wmPool != null) {
            openConf.put("set:hivevar:wmpool", this.wmPool);
        }
        if (this.wmApp != null) {
            openConf.put("set:hivevar:wmapp", this.wmApp);
        }
        if ((sessVars = this.connParams.getSessionVars()).containsKey("hive.server2.proxy.user")) {
            openConf.put("hive.server2.proxy.user", sessVars.get("hive.server2.proxy.user"));
        }
        openConf.put("set:hiveconf:" + HiveConf.ConfVars.HIVE_JDBC_CLIENT_AUTHENTICATION.varname, Utils.getAuthTypeFromJdbc(sessVars));
        openReq.setConfiguration(openConf);
        if ("noSasl".equals(this.sessConfMap.get("auth"))) {
            openReq.setUsername(this.sessConfMap.get("user"));
            openReq.setPassword(this.sessConfMap.get("password"));
        }
        try {
            TOpenSessionResp openResp = this.client.OpenSession(openReq);
            Utils.verifySuccess(openResp.getStatus());
            if (!this.supportedProtocols.contains(openResp.getServerProtocolVersion())) {
                throw new TException("Unsupported Hive2 protocol");
            }
            this.protocol = openResp.getServerProtocolVersion();
            this.sessHandle = openResp.getSessionHandle();
            String serverFetchSize = (String)openResp.getConfiguration().get("hive.server2.thrift.resultset.default.fetch.size");
            if (serverFetchSize != null) {
                this.fetchSize = Integer.parseInt(serverFetchSize);
            }
        }
        catch (TException e) {
            LOG.error("Error opening session", (Throwable)e);
            throw new SQLException("Could not establish connection to " + this.jdbcUriString + ": " + e.getMessage(), " 08S01", e);
        }
        this.isClosed = false;
    }

    private String getUserName() {
        return this.getSessionValue("user", "anonymous");
    }

    private String getPassword() {
        return this.getSessionValue("password", "anonymous");
    }

    private boolean isSslConnection() {
        return "true".equalsIgnoreCase(this.sessConfMap.get("ssl"));
    }

    private boolean isKerberosAuthMode() {
        return !"noSasl".equals(this.sessConfMap.get("auth")) && this.sessConfMap.containsKey("principal");
    }

    private boolean isHttpTransportMode() {
        String transportMode = this.sessConfMap.get("transportMode");
        return transportMode != null && transportMode.equalsIgnoreCase("http");
    }

    private void logZkDiscoveryMessage(String message) {
        if (ZooKeeperHiveClientHelper.isZkDynamicDiscoveryMode(this.sessConfMap)) {
            LOG.info(message);
        }
    }

    private String getSessionValue(String varName, String varDefault) {
        String varValue = this.sessConfMap.get(varName);
        if (varValue == null || varValue.isEmpty()) {
            varValue = varDefault;
        }
        return varValue;
    }

    private void setupLoginTimeout() {
        long timeOut = TimeUnit.SECONDS.toMillis(DriverManager.getLoginTimeout());
        this.loginTimeout = timeOut > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeOut;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    public String getDelegationToken(String owner, String renewer) throws SQLException {
        TGetDelegationTokenReq req = new TGetDelegationTokenReq(this.sessHandle, owner, renewer);
        try {
            TGetDelegationTokenResp tokenResp = this.client.GetDelegationToken(req);
            Utils.verifySuccess(tokenResp.getStatus());
            return tokenResp.getDelegationToken();
        }
        catch (TException e) {
            throw new SQLException("Could not retrieve token: " + e.getMessage(), " 08S01", e);
        }
    }

    public void cancelDelegationToken(String tokenStr) throws SQLException {
        TCancelDelegationTokenReq cancelReq = new TCancelDelegationTokenReq(this.sessHandle, tokenStr);
        try {
            TCancelDelegationTokenResp cancelResp = this.client.CancelDelegationToken(cancelReq);
            Utils.verifySuccess(cancelResp.getStatus());
            return;
        }
        catch (TException e) {
            throw new SQLException("Could not cancel token: " + e.getMessage(), " 08S01", e);
        }
    }

    public void renewDelegationToken(String tokenStr) throws SQLException {
        TRenewDelegationTokenReq cancelReq = new TRenewDelegationTokenReq(this.sessHandle, tokenStr);
        try {
            TRenewDelegationTokenResp renewResp = this.client.RenewDelegationToken(cancelReq);
            Utils.verifySuccess(renewResp.getStatus());
            return;
        }
        catch (TException e) {
            throw new SQLException("Could not renew token: " + e.getMessage(), " 08S01", e);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            TCloseSessionReq closeReq = new TCloseSessionReq(this.sessHandle);
            try {
                this.client.CloseSession(closeReq);
            }
            catch (TException e) {
                throw new SQLException("Error while cleaning up the server resources", e);
            }
            finally {
                this.isClosed = true;
                if (this.transport != null) {
                    this.transport.close();
                }
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Can't create Statement, connection is closed");
        }
        return new HiveStatement(this, this.client, this.sessHandle, this.fetchSize);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw new SQLException("Statement with resultset concurrency " + resultSetConcurrency + " is not supported", "HYC00");
        }
        if (resultSetType == 1005) {
            throw new SQLException("Statement with resultset type " + resultSetType + " is not supported", "HYC00");
        }
        return new HiveStatement(this, this.client, this.sessHandle, resultSetType == 1004, this.fetchSize);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public String getCatalog() throws SQLException {
        return "";
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfo == null ? new Properties() : this.clientInfo;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (this.clientInfo == null) {
            return null;
        }
        return this.clientInfo.getProperty(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        return new HiveDatabaseMetaData(this, this.client, this.sessHandle);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public String getSchema() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        try (Statement stmt = this.createStatement();){
            String string;
            block14: {
                ResultSet res = stmt.executeQuery("SELECT current_database()");
                try {
                    if (!res.next()) {
                        throw new SQLException("Failed to get schema information");
                    }
                    string = res.getString(1);
                    if (res == null) break block14;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return string;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("timeout value was negative");
        }
        boolean rc = false;
        try {
            String productName = new HiveDatabaseMetaData(this, this.client, this.sessHandle).getDatabaseProductName();
            rc = true;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return rc;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new HivePreparedStatement(this, this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new HivePreparedStatement(this, this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new HivePreparedStatement(this, this.client, this.sessHandle, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        if (!autoCommit) {
            LOG.warn("Request to set autoCommit to false; Hive does not support autoCommit=false.");
            SQLWarning warning = new SQLWarning("Hive does not support autoCommit=false");
            if (this.warningChain == null) {
                this.warningChain = warning;
            } else {
                this.warningChain.setNextWarning(warning);
            }
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.clientInfo = properties;
        this.sendClientInfo();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        this.clientInfo.put(name, value);
        this.sendClientInfo();
    }

    private void sendClientInfo() throws SQLClientInfoException {
        TSetClientInfoReq req = new TSetClientInfoReq(this.sessHandle);
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.clientInfo != null) {
            for (Map.Entry<Object, Object> e : this.clientInfo.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                map.put(e.getKey().toString(), e.getValue().toString());
            }
        }
        req.setConfiguration(map);
        try {
            TSetClientInfoResp openResp = this.client.SetClientInfo(req);
            Utils.verifySuccess(openResp.getStatus());
        }
        catch (SQLException | TException e) {
            LOG.error("Error sending client info", e);
            throw new SQLClientInfoException("Error sending client info", null, e);
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        if (readOnly) {
            throw new SQLException("Enabling read-only mode not supported");
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        if (schema == null || schema.isEmpty()) {
            throw new SQLException("Schema name is null or empty");
        }
        Statement stmt = this.createStatement();
        stmt.execute("use " + schema);
        stmt.close();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    public TProtocolVersion getProtocol() {
        return this.protocol;
    }

    public static TCLIService.Iface newSynchronizedClient(TCLIService.Iface client) {
        return (TCLIService.Iface)Proxy.newProxyInstance(HiveConnection.class.getClassLoader(), new Class[]{TCLIService.Iface.class}, (InvocationHandler)new SynchronizedHandler(client));
    }

    private static class SynchronizedHandler
    implements InvocationHandler {
        private final TCLIService.Iface client;
        private final ReentrantLock lock = new ReentrantLock(true);

        SynchronizedHandler(TCLIService.Iface client) {
            this.client = client;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                this.lock.lock();
                Object object = method.invoke((Object)this.client, args);
                return object;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof TException) {
                    throw (TException)e.getTargetException();
                }
                throw new TException("Error in calling method " + method.getName(), e.getTargetException());
            }
            catch (Exception e) {
                throw new TException("Error in calling method " + method.getName(), (Throwable)e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

