/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.zookeeper;

import org.apache.hive.com.google.common.base.Supplier;
import org.apache.hive.com.google.common.collect.ArrayListMultimap;
import org.apache.hive.com.google.common.collect.Multimap;
import org.apache.hive.com.google.common.util.concurrent.Service;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZooKeeper;
import org.apache.twill.internal.zookeeper.DefaultZKClientService;
import org.apache.twill.zookeeper.ZKClient;

public interface ZKClientService
extends ZKClient,
Service {
    public Supplier<ZooKeeper> getZooKeeperSupplier();

    public static final class Builder {
        private final String connectStr;
        private int timeout = 60000;
        private Watcher connectionWatcher;
        private Multimap<String, byte[]> auths = ArrayListMultimap.create();

        public static Builder of(String connectStr) {
            return new Builder(connectStr);
        }

        public Builder setSessionTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setConnectionWatcher(Watcher watcher) {
            this.connectionWatcher = watcher;
            return this;
        }

        public Builder addAuthInfo(String schema, byte[] auth) {
            this.auths.put(schema, auth);
            return this;
        }

        public ZKClientService build() {
            return new DefaultZKClientService(this.connectStr, this.timeout, this.connectionWatcher, this.auths);
        }

        private Builder(String connectStr) {
            this.connectStr = connectStr;
        }
    }
}

