/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.hive.com.google.common.reflect.TypeToken;
import org.apache.twill.api.TwillRunnableSpecification;
import org.apache.twill.internal.DefaultTwillRunnableSpecification;

final class TwillRunnableSpecificationCodec
implements JsonSerializer<TwillRunnableSpecification>,
JsonDeserializer<TwillRunnableSpecification> {
    TwillRunnableSpecificationCodec() {
    }

    public JsonElement serialize(TwillRunnableSpecification src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("classname", src.getClassName());
        json.addProperty("name", src.getName());
        json.add("arguments", context.serialize(src.getConfigs(), new TypeToken<Map<String, String>>(){}.getType()));
        return json;
    }

    public TwillRunnableSpecification deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = json.getAsJsonObject();
        String className = jsonObj.get("classname").getAsString();
        String name = jsonObj.get("name").getAsString();
        Map arguments = (Map)context.deserialize(jsonObj.get("arguments"), new TypeToken<Map<String, String>>(){}.getType());
        return new DefaultTwillRunnableSpecification(className, name, arguments);
    }
}

