/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.twill.api.TwillRunResources;
import org.apache.twill.api.logging.LogEntry;
import org.apache.twill.internal.DefaultTwillRunResources;

public final class TwillRunResourcesCodec
implements JsonSerializer<TwillRunResources>,
JsonDeserializer<TwillRunResources> {
    private final String CONTAINER_ID = "containerId";
    private final String INSTANCE_ID = "instanceId";
    private final String HOST = "host";
    private final String MEMORY_MB = "memoryMB";
    private final String VIRTUAL_CORES = "virtualCores";
    private final String DEBUG_PORT = "debugPort";
    private final String LOG_LEVEL = "logLevel";

    public JsonElement serialize(TwillRunResources src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject json = new JsonObject();
        json.addProperty("containerId", src.getContainerId());
        json.addProperty("instanceId", (Number)src.getInstanceId());
        json.addProperty("host", src.getHost());
        json.addProperty("memoryMB", (Number)src.getMemoryMB());
        json.addProperty("virtualCores", (Number)src.getVirtualCores());
        if (src.getDebugPort() != null) {
            json.addProperty("debugPort", (Number)src.getDebugPort());
        }
        if (src.getLogLevel() != null) {
            json.addProperty("logLevel", src.getLogLevel().toString());
        }
        return json;
    }

    public TwillRunResources deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObj = json.getAsJsonObject();
        return new DefaultTwillRunResources(jsonObj.get("instanceId").getAsInt(), jsonObj.get("containerId").getAsString(), jsonObj.get("virtualCores").getAsInt(), jsonObj.get("memoryMB").getAsInt(), jsonObj.get("host").getAsString(), jsonObj.has("debugPort") ? Integer.valueOf(jsonObj.get("debugPort").getAsInt()) : null, jsonObj.has("logLevel") ? LogEntry.Level.valueOf(jsonObj.get("logLevel").getAsString()) : LogEntry.Level.INFO);
    }
}

