/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static String getAsString(JsonObject json, String property) {
        JsonElement jsonElement = json.get(property);
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        if (jsonElement.isJsonPrimitive()) {
            return jsonElement.getAsString();
        }
        return jsonElement.toString();
    }

    public static long getAsLong(JsonObject json, String property, long defaultValue) {
        try {
            return json.get(property).getAsLong();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getAsInt(JsonObject json, String property, int defaultValue) {
        try {
            return json.get(property).getAsInt();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }
}

