/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.hive.com.google.common.util.concurrent.Futures;
import org.apache.hive.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.com.google.common.util.concurrent.Service;
import org.apache.hive.com.google.common.util.concurrent.SettableFuture;
import org.apache.twill.common.Threads;
import org.apache.twill.internal.ServiceListenerAdapter;

public final class Services {
    public static ListenableFuture<List<ListenableFuture<Service.State>>> chainStart(Service firstService, Service ... moreServices) {
        return Services.doChain(true, firstService, moreServices);
    }

    public static ListenableFuture<List<ListenableFuture<Service.State>>> chainStop(Service firstService, Service ... moreServices) {
        return Services.doChain(false, firstService, moreServices);
    }

    public static ListenableFuture<Service.State> getCompletionFuture(Service service) {
        final SettableFuture<Service.State> resultFuture = SettableFuture.create();
        service.addListener(new ServiceListenerAdapter(){

            @Override
            public void terminated(Service.State from) {
                resultFuture.set(Service.State.TERMINATED);
            }

            @Override
            public void failed(Service.State from, Throwable failure) {
                resultFuture.setException(failure);
            }
        }, Threads.SAME_THREAD_EXECUTOR);
        Service.State state = service.state();
        if (state == Service.State.TERMINATED) {
            return Futures.immediateFuture(state);
        }
        if (state == Service.State.FAILED) {
            return Futures.immediateFailedFuture(new IllegalStateException("Service failed with unknown exception."));
        }
        return resultFuture;
    }

    private static ListenableFuture<List<ListenableFuture<Service.State>>> doChain(boolean doStart, Service firstService, Service ... moreServices) {
        SettableFuture<List<ListenableFuture<Service.State>>> resultFuture = SettableFuture.create();
        ArrayList<ListenableFuture<Service.State>> result = Lists.newArrayListWithCapacity(moreServices.length + 1);
        ListenableFuture<Service.State> future = doStart ? firstService.start() : firstService.stop();
        future.addListener(Services.createChainListener(future, moreServices, new AtomicInteger(0), result, resultFuture, doStart), Threads.SAME_THREAD_EXECUTOR);
        return resultFuture;
    }

    private static Runnable createChainListener(final ListenableFuture<Service.State> future, final Service[] services, final AtomicInteger idx, final List<ListenableFuture<Service.State>> result, final SettableFuture<List<ListenableFuture<Service.State>>> resultFuture, final boolean doStart) {
        return new Runnable(){

            @Override
            public void run() {
                result.add(future);
                int nextIdx = idx.getAndIncrement();
                if (nextIdx == services.length) {
                    resultFuture.set(result);
                    return;
                }
                ListenableFuture<Service.State> actionFuture = doStart ? services[nextIdx].start() : services[nextIdx].stop();
                actionFuture.addListener(Services.createChainListener(actionFuture, services, idx, result, resultFuture, doStart), Threads.SAME_THREAD_EXECUTOR);
            }
        };
    }

    private Services() {
    }
}

