/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import java.util.concurrent.TimeUnit;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.apache.twill.api.EventHandler;

public final class LogOnlyEventHandler
extends EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LogOnlyEventHandler.class);

    @Override
    public EventHandler.TimeoutAction launchTimeout(Iterable<EventHandler.TimeoutEvent> timeoutEvents) {
        for (EventHandler.TimeoutEvent event : timeoutEvents) {
            LOG.info("Requested {} containers for runnable {}, only got {} after {} ms.", event.getExpectedInstances(), event.getRunnableName(), event.getActualInstances(), System.currentTimeMillis() - event.getRequestTime());
        }
        return EventHandler.TimeoutAction.recheck(30000L, TimeUnit.MILLISECONDS);
    }
}

