/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.com.google.common.collect.HashMultimap;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.apache.hive.com.google.common.collect.ImmutableMap;
import org.apache.hive.com.google.common.collect.Multimaps;
import org.apache.hive.com.google.common.collect.SetMultimap;
import org.apache.twill.api.ResourceReport;
import org.apache.twill.api.TwillRunResources;

public final class DefaultResourceReport
implements ResourceReport {
    private final SetMultimap<String, TwillRunResources> usedResources;
    private final TwillRunResources appMasterResources;
    private final String applicationId;
    private final AtomicReference<List<String>> services;

    public DefaultResourceReport(String applicationId, TwillRunResources masterResources) {
        this(applicationId, masterResources, ImmutableMap.of());
    }

    public DefaultResourceReport(String applicationId, TwillRunResources masterResources, Map<String, Collection<TwillRunResources>> resources) {
        this(applicationId, masterResources, resources, ImmutableList.of());
    }

    public DefaultResourceReport(String applicationId, TwillRunResources masterResources, Map<String, Collection<TwillRunResources>> resources, List<String> services) {
        this.applicationId = applicationId;
        this.appMasterResources = masterResources;
        this.usedResources = HashMultimap.create();
        for (Map.Entry<String, Collection<TwillRunResources>> entry : resources.entrySet()) {
            this.usedResources.putAll(entry.getKey(), (Iterable<TwillRunResources>)entry.getValue());
        }
        this.services = new AtomicReference<List<String>>(services);
    }

    public void addRunResources(String runnableName, TwillRunResources resources) {
        this.usedResources.put(runnableName, resources);
    }

    public void removeRunnableResources(String runnableName, String containerId) {
        TwillRunResources toRemove = null;
        for (TwillRunResources resources : this.usedResources.get(runnableName)) {
            if (!resources.getContainerId().equals(containerId)) continue;
            toRemove = resources;
            break;
        }
        this.usedResources.remove(runnableName, toRemove);
    }

    @Override
    public Collection<TwillRunResources> getRunnableResources(String runnableName) {
        return this.usedResources.get(runnableName);
    }

    @Override
    public Map<String, Collection<TwillRunResources>> getResources() {
        return Multimaps.unmodifiableSetMultimap(this.usedResources).asMap();
    }

    @Override
    public TwillRunResources getAppMasterResources() {
        return this.appMasterResources;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setServices(List<String> services) {
        this.services.set(ImmutableList.copyOf(services));
    }

    @Override
    public List<String> getServices() {
        return this.services.get();
    }
}

