/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.discovery;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hive.com.google.common.cache.CacheBuilder;
import org.apache.hive.com.google.common.cache.CacheLoader;
import org.apache.hive.com.google.common.cache.LoadingCache;
import org.apache.hive.com.google.common.collect.HashMultimap;
import org.apache.hive.com.google.common.collect.ImmutableSet;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.hive.com.google.common.collect.Multimap;
import org.apache.hive.com.google.common.hash.Hashing;
import org.apache.hive.com.google.common.util.concurrent.FutureCallback;
import org.apache.hive.com.google.common.util.concurrent.Futures;
import org.apache.hive.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.com.google.common.util.concurrent.SettableFuture;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.WatchedEvent;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.data.Stat;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.apache.twill.common.Cancellable;
import org.apache.twill.common.Threads;
import org.apache.twill.discovery.DefaultServiceDiscovered;
import org.apache.twill.discovery.Discoverable;
import org.apache.twill.discovery.DiscoverableAdapter;
import org.apache.twill.discovery.DiscoverableWrapper;
import org.apache.twill.discovery.DiscoveryService;
import org.apache.twill.discovery.DiscoveryServiceClient;
import org.apache.twill.discovery.ServiceDiscovered;
import org.apache.twill.zookeeper.NodeChildren;
import org.apache.twill.zookeeper.NodeData;
import org.apache.twill.zookeeper.OperationFuture;
import org.apache.twill.zookeeper.ZKClient;
import org.apache.twill.zookeeper.ZKClients;
import org.apache.twill.zookeeper.ZKOperations;

public class ZKDiscoveryService
implements DiscoveryService,
DiscoveryServiceClient {
    private static final Logger LOG = LoggerFactory.getLogger(ZKDiscoveryService.class);
    private static final String NAMESPACE = "/discoverable";
    private static final long RETRY_MILLIS = 1000L;
    private final Multimap<Discoverable, DiscoveryCancellable> discoverables = HashMultimap.create();
    private final Lock lock = new ReentrantLock();
    private final LoadingCache<String, ServiceDiscovered> services;
    private final ZKClient zkClient;
    private final ScheduledExecutorService retryExecutor = Executors.newSingleThreadScheduledExecutor(Threads.createDaemonThreadFactory("zk-discovery-retry"));

    public ZKDiscoveryService(ZKClient zkClient) {
        this(zkClient, NAMESPACE);
    }

    public ZKDiscoveryService(ZKClient zkClient, String namespace) {
        this.zkClient = namespace == null ? zkClient : ZKClients.namespace(zkClient, namespace);
        this.services = CacheBuilder.newBuilder().build(this.createServiceLoader());
        this.zkClient.addConnectionWatcher(this.createConnectionWatcher());
    }

    @Override
    public Cancellable register(final Discoverable discoverable) {
        final DiscoverableWrapper wrapper = new DiscoverableWrapper(discoverable);
        final SettableFuture future = SettableFuture.create();
        final DiscoveryCancellable cancellable = new DiscoveryCancellable(wrapper);
        Futures.addCallback(this.doRegister(wrapper), new FutureCallback<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(String result) {
                cancellable.setPath(result);
                ZKDiscoveryService.this.lock.lock();
                try {
                    ZKDiscoveryService.this.discoverables.put(wrapper, cancellable);
                }
                finally {
                    ZKDiscoveryService.this.lock.unlock();
                }
                LOG.debug("Service registered: {} {}", (Object)wrapper, (Object)result);
                future.set(result);
            }

            @Override
            public void onFailure(Throwable t) {
                if (t instanceof KeeperException.NodeExistsException) {
                    ZKDiscoveryService.this.handleRegisterFailure(discoverable, future, this, t);
                } else {
                    LOG.warn("Failed to register: {}", (Object)wrapper, (Object)t);
                    future.setException(t);
                }
            }
        }, Threads.SAME_THREAD_EXECUTOR);
        Futures.getUnchecked(future);
        return cancellable;
    }

    @Override
    public ServiceDiscovered discover(String service) {
        return this.services.getUnchecked(service);
    }

    private void handleRegisterFailure(final Discoverable discoverable, final SettableFuture<String> completion, final FutureCallback<String> creationCallback, final Throwable failureCause) {
        final String path = this.getNodePath(discoverable);
        Futures.addCallback(this.zkClient.exists(path), new FutureCallback<Stat>(){

            @Override
            public void onSuccess(Stat result) {
                if (result == null) {
                    LOG.info("Node {} is gone. Retry registration for {}.", (Object)path, (Object)discoverable);
                    ZKDiscoveryService.this.retryRegister(discoverable, creationCallback);
                    return;
                }
                long ephemeralOwner = result.getEphemeralOwner();
                if (ephemeralOwner == 0L) {
                    LOG.error("Node {} already exists and is not an ephemeral node. Discoverable registration failed: {}.", (Object)path, (Object)discoverable);
                    completion.setException(failureCause);
                    return;
                }
                Long sessionId = ZKDiscoveryService.this.zkClient.getSessionId();
                if (sessionId == null || ephemeralOwner != sessionId) {
                    LOG.info("Owner of {} is different. Retry registration for {}.", (Object)path, (Object)discoverable);
                    ZKDiscoveryService.this.retryRegister(discoverable, creationCallback);
                } else {
                    completion.set(path);
                }
            }

            @Override
            public void onFailure(Throwable t) {
                LOG.warn("Error when getting stats on {}. Retry registration for {}.", (Object)path, (Object)discoverable);
                ZKDiscoveryService.this.retryRegister(discoverable, creationCallback);
            }
        }, Threads.SAME_THREAD_EXECUTOR);
    }

    private OperationFuture<String> doRegister(Discoverable discoverable) {
        byte[] discoverableBytes = DiscoverableAdapter.encode(discoverable);
        return this.zkClient.create(this.getNodePath(discoverable), discoverableBytes, CreateMode.EPHEMERAL, true);
    }

    private void retryRegister(final Discoverable discoverable, final FutureCallback<String> creationCallback) {
        this.retryExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                Futures.addCallback(ZKDiscoveryService.this.doRegister(discoverable), creationCallback, Threads.SAME_THREAD_EXECUTOR);
            }
        }, 1000L, TimeUnit.MILLISECONDS);
    }

    private String getNodePath(Discoverable discoverable) {
        InetSocketAddress socketAddress = discoverable.getSocketAddress();
        String node = Hashing.md5().newHasher().putBytes(socketAddress.getAddress().getAddress()).putInt(socketAddress.getPort()).hash().toString();
        return String.format("/%s/%s", discoverable.getName(), node);
    }

    private Watcher createConnectionWatcher() {
        return new Watcher(){
            private boolean expired;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(WatchedEvent event) {
                if (event.getState() == Watcher.Event.KeeperState.Expired) {
                    LOG.warn("ZK Session expired: {}", (Object)ZKDiscoveryService.this.zkClient.getConnectString());
                    this.expired = true;
                } else if (event.getState() == Watcher.Event.KeeperState.SyncConnected && this.expired) {
                    LOG.info("Reconnected after expiration: {}", (Object)ZKDiscoveryService.this.zkClient.getConnectString());
                    this.expired = false;
                    ZKDiscoveryService.this.lock.lock();
                    try {
                        for (final Map.Entry entry : ZKDiscoveryService.this.discoverables.entries()) {
                            LOG.info("Re-registering service: {}", entry.getKey());
                            Futures.addCallback(ZKDiscoveryService.this.doRegister((Discoverable)entry.getKey()), new FutureCallback<String>(){

                                @Override
                                public void onSuccess(String result) {
                                    ((DiscoveryCancellable)entry.getValue()).setPath(result);
                                    LOG.debug("Service re-registered: {} {}", entry.getKey(), (Object)result);
                                }

                                @Override
                                public void onFailure(Throwable t) {
                                    ((DiscoveryCancellable)entry.getValue()).setPath(null);
                                    LOG.error("Failed to re-register service: {}", entry.getKey(), (Object)t);
                                }
                            }, Threads.SAME_THREAD_EXECUTOR);
                        }
                    }
                    finally {
                        ZKDiscoveryService.this.lock.unlock();
                    }
                }
            }
        };
    }

    private CacheLoader<String, ServiceDiscovered> createServiceLoader() {
        return new CacheLoader<String, ServiceDiscovered>(){

            @Override
            public ServiceDiscovered load(String service) throws Exception {
                final DefaultServiceDiscovered serviceDiscovered = new DefaultServiceDiscovered(service);
                final String serviceBase = "/" + service;
                ZKOperations.watchChildren(ZKDiscoveryService.this.zkClient, serviceBase, new ZKOperations.ChildrenCallback(){

                    @Override
                    public void updated(NodeChildren nodeChildren) {
                        List<String> children = nodeChildren.getChildren();
                        ArrayList<OperationFuture<NodeData>> dataFutures = Lists.newArrayListWithCapacity(children.size());
                        for (String child : children) {
                            dataFutures.add(ZKDiscoveryService.this.zkClient.getData(serviceBase + "/" + child));
                        }
                        final ListenableFuture fetchFuture = Futures.successfulAsList(dataFutures);
                        fetchFuture.addListener(new Runnable(){

                            @Override
                            public void run() {
                                ImmutableSet.Builder builder = ImmutableSet.builder();
                                for (NodeData nodeData : (List)Futures.getUnchecked(fetchFuture)) {
                                    Discoverable discoverable;
                                    if (nodeData == null || (discoverable = DiscoverableAdapter.decode(nodeData.getData())) == null) continue;
                                    builder.add(discoverable);
                                }
                                serviceDiscovered.setDiscoverables((Set<Discoverable>)((Object)builder.build()));
                            }
                        }, Threads.SAME_THREAD_EXECUTOR);
                    }
                });
                return serviceDiscovered;
            }
        };
    }

    private final class DiscoveryCancellable
    implements Cancellable {
        private final Discoverable discoverable;
        private final AtomicBoolean cancelled;
        private volatile String path;

        DiscoveryCancellable(Discoverable discoverable) {
            this.discoverable = discoverable;
            this.cancelled = new AtomicBoolean();
        }

        void setPath(String path) {
            this.path = path;
            if (this.cancelled.get() && path != null) {
                ZKDiscoveryService.this.zkClient.delete(path);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            if (!this.cancelled.compareAndSet(false, true)) {
                return;
            }
            String path = this.path;
            if (path == null) {
                return;
            }
            ZKDiscoveryService.this.lock.lock();
            try {
                ZKDiscoveryService.this.discoverables.remove(this.discoverable, this);
            }
            finally {
                ZKDiscoveryService.this.lock.unlock();
            }
            Futures.getUnchecked(ZKOperations.ignoreError(ZKDiscoveryService.this.zkClient.delete(path), KeeperException.NoNodeException.class, path));
            LOG.debug("Service unregistered: {} {}", (Object)this.discoverable, (Object)path);
        }
    }
}

