/*
 * Decompiled with CFR 0.152.
 */
package org.apache.twill.discovery;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import org.apache.hive.com.google.common.base.Charsets;
import org.apache.twill.discovery.Discoverable;
import org.apache.twill.discovery.DiscoverableWrapper;

final class DiscoverableAdapter {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(Discoverable.class, (Object)new DiscoverableCodec()).create();

    static byte[] encode(Discoverable discoverable) {
        return GSON.toJson((Object)discoverable, Discoverable.class).getBytes(Charsets.UTF_8);
    }

    static Discoverable decode(byte[] encoded) {
        if (encoded == null) {
            return null;
        }
        return (Discoverable)GSON.fromJson(new String(encoded, Charsets.UTF_8), Discoverable.class);
    }

    private DiscoverableAdapter() {
    }

    private static final class DiscoverableCodec
    implements JsonSerializer<Discoverable>,
    JsonDeserializer<Discoverable> {
        private DiscoverableCodec() {
        }

        public Discoverable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObj = json.getAsJsonObject();
            final String service = jsonObj.get("service").getAsString();
            String hostname = jsonObj.get("hostname").getAsString();
            int port = jsonObj.get("port").getAsInt();
            final InetSocketAddress address = new InetSocketAddress(hostname, port);
            return new DiscoverableWrapper(new Discoverable(){

                @Override
                public String getName() {
                    return service;
                }

                @Override
                public InetSocketAddress getSocketAddress() {
                    return address;
                }
            });
        }

        public JsonElement serialize(Discoverable src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("service", src.getName());
            jsonObj.addProperty("hostname", src.getSocketAddress().getHostName());
            jsonObj.addProperty("port", (Number)src.getSocketAddress().getPort());
            return jsonObj;
        }
    }
}

