/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.FileUtils;

public class FixCRLF
extends MatchingTask {
    private static final int UNDEF = -1;
    private static final int NOTJAVA = 0;
    private static final int LOOKING = 1;
    private static final int IN_CHAR_CONST = 2;
    private static final int IN_STR_CONST = 3;
    private static final int IN_SINGLE_COMMENT = 4;
    private static final int IN_MULTI_COMMENT = 5;
    private static final int ASIS = 0;
    private static final int CR = 1;
    private static final int LF = 2;
    private static final int CRLF = 3;
    private static final int ADD = 1;
    private static final int REMOVE = -1;
    private static final int SPACES = -1;
    private static final int TABS = 1;
    private static final int INBUFLEN = 8192;
    private static final int LINEBUFLEN = 200;
    private static final char CTRLZ = '\u001a';
    private int tablength = 8;
    private String spaces = "        ";
    private StringBuffer linebuf = new StringBuffer(1024);
    private StringBuffer linebuf2 = new StringBuffer(1024);
    private int eol;
    private String eolstr;
    private int ctrlz;
    private int tabs = 0;
    private boolean javafiles = false;
    private boolean fixlast = true;
    private File srcDir;
    private File destDir = null;
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private String encoding = null;

    public FixCRLF() {
        if (Os.isFamily("mac")) {
            this.ctrlz = -1;
            this.eol = 1;
            this.eolstr = "\r";
        } else if (Os.isFamily("dos")) {
            this.ctrlz = 0;
            this.eol = 3;
            this.eolstr = "\r\n";
        } else {
            this.ctrlz = -1;
            this.eol = 2;
            this.eolstr = "\n";
        }
    }

    public void setSrcdir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setJavafiles(boolean javafiles) {
        this.javafiles = javafiles;
    }

    public void setEol(CrLf attr) {
        String option = attr.getValue();
        if (option.equals("asis")) {
            this.eol = 0;
        } else if (option.equals("cr") || option.equals("mac")) {
            this.eol = 1;
            this.eolstr = "\r";
        } else if (option.equals("lf") || option.equals("unix")) {
            this.eol = 2;
            this.eolstr = "\n";
        } else {
            this.eol = 3;
            this.eolstr = "\r\n";
        }
    }

    public void setCr(AddAsisRemove attr) {
        this.log("DEPRECATED: The cr attribute has been deprecated,", 1);
        this.log("Please use the eol attribute instead", 1);
        String option = attr.getValue();
        CrLf c = new CrLf();
        if (option.equals("remove")) {
            c.setValue("lf");
        } else if (option.equals("asis")) {
            c.setValue("asis");
        } else {
            c.setValue("crlf");
        }
        this.setEol(c);
    }

    public void setTab(AddAsisRemove attr) {
        String option = attr.getValue();
        this.tabs = option.equals("remove") ? -1 : (option.equals("asis") ? 0 : 1);
    }

    public void setTablength(int tlength) throws BuildException {
        if (tlength < 2 || tlength > 80) {
            throw new BuildException("tablength must be between 2 and 80", this.getLocation());
        }
        this.tablength = tlength;
        StringBuffer sp = new StringBuffer();
        int i = 0;
        while (i < this.tablength) {
            sp.append(' ');
            ++i;
        }
        this.spaces = sp.toString();
    }

    public void setEof(AddAsisRemove attr) {
        String option = attr.getValue();
        this.ctrlz = option.equals("remove") ? -1 : (option.equals("asis") ? 0 : 1);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFixlast(boolean fixlast) {
        this.fixlast = fixlast;
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!");
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir does not exist!");
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException("srcdir is not a directory!");
        }
        if (this.destDir != null) {
            if (!this.destDir.exists()) {
                throw new BuildException("destdir does not exist!");
            }
            if (!this.destDir.isDirectory()) {
                throw new BuildException("destdir is not a directory!");
            }
        }
        this.log("options: eol=" + (this.eol == 0 ? "asis" : (this.eol == 1 ? "cr" : (this.eol == 2 ? "lf" : "crlf"))) + " tab=" + (this.tabs == 1 ? "add" : (this.tabs == 0 ? "asis" : "remove")) + " eof=" + (this.ctrlz == 1 ? "add" : (this.ctrlz == 0 ? "asis" : "remove")) + " tablength=" + this.tablength + " encoding=" + (this.encoding == null ? "default" : this.encoding), 3);
        DirectoryScanner ds = super.getDirectoryScanner(this.srcDir);
        String[] files = ds.getIncludedFiles();
        int i = 0;
        while (i < files.length) {
            this.processFile(files[i]);
            ++i;
        }
    }

    private Reader getReader(File f) throws IOException {
        return this.encoding == null ? new FileReader(f) : new InputStreamReader((InputStream)new FileInputStream(f), this.encoding);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void processFile(String file) throws BuildException {
        srcFile = new File(this.srcDir, file);
        destD = this.destDir == null ? this.srcDir : this.destDir;
        tmpFile = null;
        lines = new OneLiner(srcFile);
        try {
            block48: {
                try {
                    tmpFile = this.fileUtils.createTempFile("fixcrlf", "", null);
                    tmpFile.deleteOnExit();
                    writer /* !! */  = this.encoding == null ? new FileWriter(tmpFile) : new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), this.encoding);
                    outWriter = new BufferedWriter(writer /* !! */ );
                    if (true) ** GOTO lbl73
                }
                catch (IOException e) {
                    throw new BuildException(e);
                }
                do {
                    try {
                        line = (OneLiner.BufferLine)lines.nextElement();
                    }
                    catch (NoSuchElementException e) {
                        throw new BuildException(e);
                    }
                    lineString = line.getLineString();
                    linelen = line.length();
                    if (this.tabs != 0) ** GOTO lbl66
                    try {
                        outWriter.write(lineString);
                    }
                    catch (IOException e) {
                        throw new BuildException(e);
                    }
lbl-1000:
                    // 1 sources

                    {
                        switch (lines.getState()) {
                            case 0: {
                                this.notInConstant(line, line.length(), outWriter);
                                break;
                            }
                            case 5: {
                                endComment = lineString.indexOf("*/", line.getNext());
                                if (endComment >= 0) {
                                    endComment += 2;
                                    lines.setState(1);
                                } else {
                                    endComment = linelen;
                                }
                                this.notInConstant(line, endComment, outWriter);
                                break;
                            }
                            case 4: {
                                this.notInConstant(line, line.length(), outWriter);
                                lines.setState(1);
                                break;
                            }
                            case 2: 
                            case 3: {
                                begin = line.getNext();
                                terminator = lines.getState() == 3 ? '\"' : '\'';
                                this.endOfCharConst(line, terminator);
                                while (line.getNext() < line.getLookahead()) {
                                    if (line.getNextCharInc() == '\t') {
                                        line.setColumn(line.getColumn() + this.tablength - line.getColumn() % this.tablength);
                                        continue;
                                    }
                                    line.incColumn();
                                }
                                try {
                                    outWriter.write(line.substring(begin, line.getNext()));
                                }
                                catch (IOException e) {
                                    throw new BuildException(e);
                                }
                                lines.setState(1);
                                break;
                            }
                            case 1: {
                                this.nextStateChange(line);
                                this.notInConstant(line, line.getLookahead(), outWriter);
                            }
                        }
lbl66:
                        // 7 sources

                        ** while (line.getNext() < linelen)
                    }
lbl67:
                    // 2 sources

                    if ("".equals(line.getEol()) && !this.fixlast) continue;
                    try {
                        outWriter.write(this.eolstr);
                    }
                    catch (IOException e) {
                        throw new BuildException(e);
                    }
lbl73:
                    // 3 sources

                } while (lines.hasMoreElements());
                if (this.ctrlz == 0) {
                    outWriter.write(lines.getEofStr());
                    break block48;
                }
                if (this.ctrlz != 1) break block48;
                outWriter.write(26);
            }
            var15_24 = null;
            try {
                outWriter.close();
            }
            catch (IOException e) {
                throw new BuildException(e);
            }
            {
                catch (IOException e) {
                    throw new BuildException(e);
                }
            }
            catch (Throwable var14_28) {
                var15_25 = null;
                try {
                    outWriter.close();
                }
                catch (IOException e) {
                    throw new BuildException(e);
                }
                throw var14_28;
            }
            try {
                lines.close();
                lines = null;
            }
            catch (IOException e) {
                throw new BuildException("Unable to close source file " + srcFile);
            }
            destFile = new File(destD, file);
            destIsWrong = true;
            if (destFile.exists()) {
                this.log("destFile exists", 4);
                if (!this.fileUtils.contentEquals(destFile, tmpFile)) {
                    this.log(destFile + " is being written", 4);
                } else {
                    this.log(destFile + " is not written, as the contents " + "are identical", 4);
                    destIsWrong = false;
                }
            }
            if (destIsWrong) {
                this.fileUtils.rename(tmpFile, destFile);
                tmpFile = null;
            }
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
        finally {
            try {
                if (lines != null) {
                    lines.close();
                }
            }
            catch (IOException io) {
                this.log("Error closing " + srcFile, 0);
            }
            if (tmpFile != null) {
                tmpFile.delete();
            }
        }
    }

    private void nextStateChange(OneLiner.BufferLine bufline) throws BuildException {
        int eol = bufline.length();
        int ptr = bufline.getNext();
        while (ptr < eol) {
            switch (bufline.getChar(ptr++)) {
                case '\'': {
                    bufline.setState(2);
                    bufline.setLookahead(--ptr);
                    return;
                }
                case '\"': {
                    bufline.setState(3);
                    bufline.setLookahead(--ptr);
                    return;
                }
                case '/': {
                    if (ptr >= eol) break;
                    if (bufline.getChar(ptr) == '*') {
                        bufline.setState(5);
                        bufline.setLookahead(--ptr);
                        return;
                    }
                    if (bufline.getChar(ptr) != '/') break;
                    bufline.setState(4);
                    bufline.setLookahead(--ptr);
                    return;
                }
            }
        }
        bufline.setLookahead(ptr);
    }

    private void endOfCharConst(OneLiner.BufferLine bufline, char terminator) throws BuildException {
        int ptr = bufline.getNext();
        int eol = bufline.length();
        ++ptr;
        while (ptr < eol) {
            char c;
            if ((c = bufline.getChar(ptr++)) == '\\') {
                ++ptr;
                continue;
            }
            if (c != terminator) continue;
            bufline.setLookahead(ptr);
            return;
        }
        throw new BuildException("endOfCharConst: unterminated char constant");
    }

    /*
     * WARNING - void declaration
     */
    private void notInConstant(OneLiner.BufferLine bufline, int end, BufferedWriter outWriter) {
        int nextTab;
        String line = bufline.substring(bufline.getNext(), end);
        int place = 0;
        int col = bufline.getColumn();
        this.linebuf = new StringBuffer();
        while ((nextTab = line.indexOf(9, place)) >= 0) {
            void var7_7;
            this.linebuf.append(line.substring(place, (int)var7_7));
            int tabspaces = this.tablength - (col += var7_7 - place) % this.tablength;
            this.linebuf.append(this.spaces.substring(0, tabspaces));
            col += tabspaces;
            place = var7_7 + true;
        }
        this.linebuf.append(line.substring(place, line.length()));
        String linestring = new String(this.linebuf.substring(0));
        if (this.tabs == -1) {
            try {
                outWriter.write(linestring);
            }
            catch (IOException e) {
                throw new BuildException(e);
            }
        }
        this.linebuf2 = new StringBuffer();
        place = 0;
        col = bufline.getColumn();
        int placediff = col - 0;
        int nextStop = col + (this.tablength - col % this.tablength);
        if (nextStop - col < 2) {
            this.linebuf2.append(linestring.substring(place, nextStop - placediff));
            place = nextStop - placediff;
            nextStop += this.tablength;
        }
        while (nextStop - placediff <= linestring.length()) {
            int tabCol = nextStop;
            while (--tabCol - placediff >= place && linestring.charAt(tabCol - placediff) == ' ') {
            }
            if (nextStop - tabCol > 2) {
                this.linebuf2.append(linestring.substring(place, ++tabCol - placediff));
                this.linebuf2.append('\t');
            } else {
                this.linebuf2.append(linestring.substring(place, nextStop - placediff));
            }
            place = nextStop - placediff;
            nextStop += this.tablength;
        }
        this.linebuf2.append(linestring.substring(place, linestring.length()));
        try {
            outWriter.write(this.linebuf2.substring(0));
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
        bufline.setColumn(bufline.getColumn() + linestring.length());
        bufline.setNext(end);
    }

    public static class CrLf
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"asis", "cr", "lf", "crlf", "mac", "unix", "dos"};
        }
    }

    public static class AddAsisRemove
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"add", "asis", "remove"};
        }
    }

    class OneLiner
    implements Enumeration {
        private int state;
        private StringBuffer eolStr;
        private StringBuffer eofStr;
        private BufferedReader reader;
        private StringBuffer line;
        private boolean reachedEof;
        private File srcFile;

        public OneLiner(File srcFile) throws BuildException {
            this.state = FixCRLF.this.javafiles ? 1 : 0;
            this.eolStr = new StringBuffer(200);
            this.eofStr = new StringBuffer();
            this.line = new StringBuffer();
            this.reachedEof = false;
            this.srcFile = srcFile;
            try {
                this.reader = new BufferedReader(FixCRLF.this.getReader(srcFile), 8192);
                this.nextLine();
            }
            catch (IOException e) {
                throw new BuildException(srcFile + ": " + e.getMessage(), e, FixCRLF.this.getLocation());
            }
        }

        protected void nextLine() throws BuildException {
            int ch = -1;
            int eolcount = 0;
            this.eolStr = new StringBuffer();
            this.line = new StringBuffer();
            try {
                ch = this.reader.read();
                while (ch != -1 && ch != 13 && ch != 10) {
                    this.line.append((char)ch);
                    ch = this.reader.read();
                }
                if (ch == -1 && this.line.length() == 0) {
                    this.reachedEof = true;
                    return;
                }
                block1 : switch ((char)ch) {
                    case '\r': {
                        ++eolcount;
                        this.eolStr.append('\r');
                        this.reader.mark(2);
                        ch = this.reader.read();
                        switch (ch) {
                            case 13: {
                                ch = this.reader.read();
                                if ((char)ch == '\n') {
                                    eolcount += 2;
                                    this.eolStr.append("\r\n");
                                    break block1;
                                }
                                this.reader.reset();
                                break block1;
                            }
                            case 10: {
                                ++eolcount;
                                this.eolStr.append('\n');
                                break block1;
                            }
                            case -1: {
                                break block1;
                            }
                        }
                        this.reader.reset();
                        break;
                    }
                    case '\n': {
                        ++eolcount;
                        this.eolStr.append('\n');
                    }
                }
                if (eolcount == 0) {
                    int i = this.line.length();
                    while (--i >= 0 && this.line.charAt(i) == '\u001a') {
                    }
                    if (i < this.line.length() - 1) {
                        this.eofStr.append(this.line.toString().substring(i + 1));
                        if (i < 0) {
                            this.line.setLength(0);
                            this.reachedEof = true;
                        } else {
                            this.line.setLength(i + 1);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new BuildException(this.srcFile + ": " + e.getMessage(), e, FixCRLF.this.getLocation());
            }
        }

        public String getEofStr() {
            return this.eofStr.substring(0);
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
        }

        public boolean hasMoreElements() {
            return !this.reachedEof;
        }

        public Object nextElement() throws NoSuchElementException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("OneLiner");
            }
            BufferLine tmpLine = new BufferLine(this.line.toString(), this.eolStr.substring(0));
            this.nextLine();
            return tmpLine;
        }

        public void close() throws IOException {
            if (this.reader != null) {
                this.reader.close();
            }
        }

        class BufferLine {
            private int next = 0;
            private int column = 0;
            private int lookahead = -1;
            private String line;
            private String eolStr;

            public BufferLine(String line, String eolStr) throws BuildException {
                this.line = line;
                this.eolStr = eolStr;
            }

            public int getNext() {
                return this.next;
            }

            public void setNext(int next) {
                this.next = next;
            }

            public int getLookahead() {
                return this.lookahead;
            }

            public void setLookahead(int lookahead) {
                this.lookahead = lookahead;
            }

            public char getChar(int i) {
                return this.line.charAt(i);
            }

            public char getNextChar() {
                return this.getChar(this.next);
            }

            public char getNextCharInc() {
                return this.getChar(this.next++);
            }

            public int getColumn() {
                return this.column;
            }

            public void setColumn(int col) {
                this.column = col;
            }

            public int incColumn() {
                return this.column++;
            }

            public int length() {
                return this.line.length();
            }

            public int getEolLength() {
                return this.eolStr.length();
            }

            public String getLineString() {
                return this.line;
            }

            public String getEol() {
                return this.eolStr;
            }

            public String substring(int begin) {
                return this.line.substring(begin);
            }

            public String substring(int begin, int end) {
                return this.line.substring(begin, end);
            }

            public void setState(int state) {
                OneLiner.this.setState(state);
            }

            public int getState() {
                return OneLiner.this.getState();
            }
        }
    }
}

