/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.web;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.impl.ContextAnchor;
import org.apache.logging.log4j.web.Log4jWebInitializerImpl;
import org.apache.logging.log4j.web.Log4jWebLifeCycle;
import org.apache.logging.log4j.web.Log4jWebSupport;

public final class WebLoggerContextUtils {
    private static final Lock WEB_SUPPORT_LOOKUP = new ReentrantLock();

    private WebLoggerContextUtils() {
    }

    public static LoggerContext getWebLoggerContext(ServletContext servletContext) {
        return (LoggerContext)servletContext.getAttribute(Log4jWebSupport.CONTEXT_ATTRIBUTE);
    }

    public static LoggerContext getRequiredWebLoggerContext(ServletContext servletContext) {
        LoggerContext loggerContext = WebLoggerContextUtils.getWebLoggerContext(servletContext);
        if (loggerContext == null) {
            throw new IllegalStateException("No LoggerContext found in ServletContext attribute " + Log4jWebSupport.CONTEXT_ATTRIBUTE);
        }
        return loggerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log4jWebLifeCycle getWebLifeCycle(ServletContext servletContext) {
        WEB_SUPPORT_LOOKUP.lock();
        try {
            Log4jWebLifeCycle webLifeCycle = (Log4jWebLifeCycle)servletContext.getAttribute(Log4jWebSupport.SUPPORT_ATTRIBUTE);
            if (webLifeCycle == null) {
                webLifeCycle = Log4jWebInitializerImpl.initialize(servletContext);
            }
            Log4jWebLifeCycle log4jWebLifeCycle = webLifeCycle;
            return log4jWebLifeCycle;
        }
        finally {
            WEB_SUPPORT_LOOKUP.unlock();
        }
    }

    public static Runnable wrapExecutionContext(final ServletContext servletContext, final Runnable runnable) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log4jWebLifeCycle webSupport = WebLoggerContextUtils.getWebLifeCycle(servletContext);
                webSupport.setLoggerContext();
                try {
                    runnable.run();
                }
                finally {
                    webSupport.clearLoggerContext();
                }
            }
        };
    }

    public static ServletContext getServletContext() {
        org.apache.logging.log4j.spi.LoggerContext lc = ContextAnchor.THREAD_CONTEXT.get();
        if (lc == null) {
            lc = LogManager.getContext(false);
        }
        return lc == null ? null : (lc.getExternalContext() instanceof ServletContext ? (ServletContext)lc.getExternalContext() : null);
    }
}

