/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.WatchedEvent;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZKTestCase;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.ZooKeeper;
import org.apache.hive.org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.hive.org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.hive.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.apache.zookeeper.test.ClientTest;
import org.apache.hive.org.apache.zookeeper.test.QuorumBase;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ZkDatabaseCorruptionTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(ZkDatabaseCorruptionTest.class);
    public static final long CONNECTION_TIMEOUT = ClientTest.CONNECTION_TIMEOUT;
    private final QuorumBase qb = new QuorumBase();

    @Before
    public void setUp() throws Exception {
        LOG.info("STARTING quorum " + this.getClass().getName());
        this.qb.setUp();
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("STOPPING quorum " + this.getClass().getName());
    }

    private void corruptFile(File f) throws IOException {
        RandomAccessFile outFile = new RandomAccessFile(f, "rw");
        outFile.write("fail servers".getBytes());
        outFile.close();
    }

    private void corruptAllSnapshots(File snapDir) throws IOException {
        File[] listFiles;
        for (File f : listFiles = snapDir.listFiles()) {
            if (!f.getName().startsWith("snapshot")) continue;
            this.corruptFile(f);
        }
    }

    @Test
    public void testCorruption() throws Exception {
        int i;
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        ClientBase.waitForServerUp(this.qb.hostPort, 10000L);
        ZooKeeper zk = new ZooKeeper(this.qb.hostPort, 10000, new Watcher(){

            public void process(WatchedEvent event) {
            }
        });
        SyncRequestProcessor.setSnapCount((int)100);
        for (int i2 = 0; i2 < 2000; ++i2) {
            zk.create("/0-" + i2, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
        if (this.qb.s5.getPeerState() != QuorumPeer.ServerState.LEADING) {
            throw new Exception("the last server is not the leader");
        }
        QuorumPeer leader = this.qb.s5;
        FileTxnSnapLog snapLog = leader.getTxnFactory();
        File snapDir = snapLog.getSnapDir();
        this.corruptAllSnapshots(snapDir);
        this.qb.shutdownServers();
        this.qb.setupServers();
        this.qb.s1.start();
        this.qb.s2.start();
        this.qb.s3.start();
        this.qb.s4.start();
        try {
            this.qb.s5.start();
            Assert.assertTrue((boolean)false);
        }
        catch (RuntimeException re) {
            LOG.info("Got an error: expected", re);
        }
        String[] list = this.qb.hostPort.split(",");
        for (i = 0; i < 4; ++i) {
            String hp = list[i];
            Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(hp, CONNECTION_TIMEOUT));
            LOG.info(hp + " is accepting client connections");
        }
        zk = this.qb.createClient();
        SyncRequestProcessor.setSnapCount((int)100);
        for (i = 2000; i < 4000; ++i) {
            zk.create("/0-" + i, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
        QuorumBase.shutdown(this.qb.s1);
        QuorumBase.shutdown(this.qb.s2);
        QuorumBase.shutdown(this.qb.s3);
        QuorumBase.shutdown(this.qb.s4);
    }
}

