/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.login.Configuration;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.JaasConfiguration;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.TestableZooKeeper;
import org.apache.hive.org.apache.zookeeper.WatchedEvent;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.junit.Assert;
import org.junit.Test;

public class SaslAuthDesignatedServerTest
extends ClientBase {
    public static int AUTHENTICATION_TIMEOUT = 30000;
    private AtomicInteger authFailed = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuth() throws Exception {
        MyWatcher watcher = new MyWatcher();
        TestableZooKeeper zk = this.createClient(watcher);
        watcher.authCompleted.await(AUTHENTICATION_TIMEOUT, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)this.authFailed.get(), (long)0L);
        try {
            zk.create("/path1", null, ZooDefs.Ids.CREATOR_ALL_ACL, CreateMode.PERSISTENT);
        }
        catch (KeeperException e) {
            Assert.fail((String)("test failed :" + (Object)((Object)e)));
        }
        finally {
            zk.close();
        }
    }

    static {
        System.setProperty("zookeeper.authProvider.1", "org.apache.hive.org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        System.setProperty("zookeeper.sasl.serverconfig", "MyZookeeperServer");
        JaasConfiguration conf = new JaasConfiguration();
        conf.addSection("Server", "org.apache.hive.org.apache.zookeeper.server.auth.DigestLoginModule", "user_myuser", "wrongpassword");
        conf.addSection("MyZookeeperServer", "org.apache.hive.org.apache.zookeeper.server.auth.DigestLoginModule", "user_myuser", "mypassword");
        conf.addSection("Client", "org.apache.hive.org.apache.zookeeper.server.auth.DigestLoginModule", "username", "myuser", "password", "mypassword");
        Configuration.setConfiguration(conf);
    }

    private class MyWatcher
    extends ClientBase.CountdownWatcher {
        volatile CountDownLatch authCompleted;

        private MyWatcher() {
        }

        public synchronized void reset() {
            this.authCompleted = new CountDownLatch(1);
            super.reset();
        }

        public synchronized void process(WatchedEvent event) {
            if (event.getState() == Watcher.Event.KeeperState.AuthFailed) {
                SaslAuthDesignatedServerTest.this.authFailed.incrementAndGet();
                this.authCompleted.countDown();
            } else if (event.getState() == Watcher.Event.KeeperState.SaslAuthenticated) {
                this.authCompleted.countDown();
            } else {
                super.process(event);
            }
        }
    }
}

