/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import com.sun.management.UnixOperatingSystemMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.hive.org.apache.zookeeper.PortAssignment;
import org.apache.hive.org.apache.zookeeper.server.quorum.Election;
import org.apache.hive.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.apache.zookeeper.test.JMXEnv;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.junit.Assert;

public class QuorumUtil {
    private static final Logger LOG = LoggerFactory.getLogger(QuorumUtil.class);
    private final Map<Long, QuorumPeer.QuorumServer> peersView = new HashMap<Long, QuorumPeer.QuorumServer>();
    private final Map<Integer, PeerStruct> peers = new HashMap<Integer, PeerStruct>();
    public final int N;
    public final int ALL;
    private String hostPort;
    private int tickTime;
    private int initLimit;
    private int syncLimit;
    private int electionAlg;

    public QuorumUtil(int n) throws RuntimeException {
        try {
            PeerStruct ps;
            int i;
            ClientBase.setupTestEnv();
            JMXEnv.setUp();
            this.N = n;
            this.ALL = 2 * this.N + 1;
            this.tickTime = 2000;
            this.initLimit = 3;
            this.syncLimit = 3;
            this.electionAlg = 3;
            this.hostPort = "";
            for (i = 1; i <= this.ALL; ++i) {
                ps = new PeerStruct();
                ps.id = i;
                ps.dataDir = ClientBase.createTmpDir();
                ps.clientPort = PortAssignment.unique();
                this.peers.put(i, ps);
                this.peersView.put(Long.valueOf(i), new QuorumPeer.QuorumServer((long)i, new InetSocketAddress("127.0.0.1", ps.clientPort + 1000), new InetSocketAddress("127.0.0.1", PortAssignment.unique() + 1000), QuorumPeer.LearnerType.PARTICIPANT));
                this.hostPort = this.hostPort + "127.0.0.1:" + ps.clientPort + (i == this.ALL ? "" : ",");
            }
            for (i = 1; i <= this.ALL; ++i) {
                ps = this.peers.get(i);
                LOG.info("Creating QuorumPeer " + i + "; public port " + ps.clientPort);
                ps.peer = new QuorumPeer(this.peersView, ps.dataDir, ps.dataDir, ps.clientPort, this.electionAlg, (long)ps.id, this.tickTime, this.initLimit, this.syncLimit);
                Assert.assertEquals((long)ps.clientPort, (long)ps.peer.getClientPort());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PeerStruct getPeer(int id) {
        return this.peers.get(id);
    }

    public void startAll() throws IOException {
        this.shutdownAll();
        for (int i = 1; i <= this.ALL; ++i) {
            this.start(i);
            LOG.info("Started QuorumPeer " + i);
        }
        LOG.info("Checking ports " + this.hostPort);
        for (String hp : this.hostPort.split(",")) {
            Assert.assertTrue((String)"waiting for server up", (boolean)ClientBase.waitForServerUp(hp, ClientBase.CONNECTION_TIMEOUT));
            LOG.info(hp + " is accepting client connections");
        }
        try {
            int i;
            JMXEnv.dump();
            LinkedHashSet<String> ensureNames = new LinkedHashSet<String>();
            for (i = 1; i <= this.ALL; ++i) {
                ensureNames.add("InMemoryDataTree");
            }
            for (i = 1; i <= this.ALL; ++i) {
                ensureNames.add("name0=ReplicatedServer_id" + i + ",name1=replica." + i + ",name2=");
            }
            for (i = 1; i <= this.ALL; ++i) {
                for (int j = 1; j <= this.ALL; ++j) {
                    ensureNames.add("name0=ReplicatedServer_id" + i + ",name1=replica." + j);
                }
            }
            for (i = 1; i <= this.ALL; ++i) {
                ensureNames.add("name0=ReplicatedServer_id" + i);
            }
            JMXEnv.ensureAll(ensureNames.toArray(new String[ensureNames.size()]));
        }
        catch (IOException e) {
            LOG.warn("IOException during JMXEnv operation", e);
        }
    }

    public void startQuorum() throws IOException {
        int i;
        this.shutdownAll();
        for (i = 1; i <= this.N + 1; ++i) {
            this.start(i);
        }
        for (i = 1; i <= this.N + 1; ++i) {
            Assert.assertTrue((String)"Waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.getPeer((int)i).clientPort, ClientBase.CONNECTION_TIMEOUT));
        }
    }

    public void start(int id) throws IOException {
        PeerStruct ps = this.getPeer(id);
        LOG.info("Creating QuorumPeer " + ps.id + "; public port " + ps.clientPort);
        ps.peer = new QuorumPeer(this.peersView, ps.dataDir, ps.dataDir, ps.clientPort, this.electionAlg, (long)ps.id, this.tickTime, this.initLimit, this.syncLimit);
        Assert.assertEquals((long)ps.clientPort, (long)ps.peer.getClientPort());
        ps.peer.start();
    }

    public void restart(int id) throws IOException {
        this.start(id);
        Assert.assertTrue((String)"Waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.getPeer((int)id).clientPort, ClientBase.CONNECTION_TIMEOUT));
    }

    public void startThenShutdown(int id) throws IOException {
        PeerStruct ps = this.getPeer(id);
        LOG.info("Creating QuorumPeer " + ps.id + "; public port " + ps.clientPort);
        ps.peer = new QuorumPeer(this.peersView, ps.dataDir, ps.dataDir, ps.clientPort, this.electionAlg, (long)ps.id, this.tickTime, this.initLimit, this.syncLimit);
        Assert.assertEquals((long)ps.clientPort, (long)ps.peer.getClientPort());
        ps.peer.start();
        Assert.assertTrue((String)"Waiting for server up", (boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.getPeer((int)id).clientPort, ClientBase.CONNECTION_TIMEOUT));
        this.shutdown(id);
    }

    public void shutdownAll() {
        for (int i = 1; i <= this.ALL; ++i) {
            this.shutdown(i);
        }
        for (String hp : this.hostPort.split(",")) {
            Assert.assertTrue((String)"Waiting for server down", (boolean)ClientBase.waitForServerDown(hp, ClientBase.CONNECTION_TIMEOUT));
            LOG.info(hp + " is no longer accepting client connections");
        }
    }

    public void shutdown(int id) {
        QuorumPeer qp = this.getPeer((int)id).peer;
        try {
            LOG.info("Shutting down quorum peer " + qp.getName());
            qp.shutdown();
            Election e = qp.getElectionAlg();
            if (e != null) {
                LOG.info("Shutting down leader election " + qp.getName());
                e.shutdown();
            } else {
                LOG.info("No election available to shutdown " + qp.getName());
            }
            LOG.info("Waiting for " + qp.getName() + " to exit thread");
            qp.join(30000L);
            if (qp.isAlive()) {
                Assert.fail((String)("QP failed to shutdown in 30 seconds: " + qp.getName()));
            }
        }
        catch (InterruptedException e) {
            LOG.debug("QP interrupted: " + qp.getName(), e);
        }
    }

    public String getConnString() {
        return this.hostPort;
    }

    public void tearDown() throws Exception {
        LOG.info("TearDown started");
        OperatingSystemMXBean osMbean = ManagementFactory.getOperatingSystemMXBean();
        if (osMbean != null && osMbean instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unixos = (UnixOperatingSystemMXBean)osMbean;
            LOG.info("fdcount after test is: " + unixos.getOpenFileDescriptorCount());
        }
        this.shutdownAll();
        JMXEnv.tearDown();
    }

    public class PeerStruct {
        public int id;
        public QuorumPeer peer;
        public File dataDir;
        public int clientPort;
    }
}

