/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.util.Arrays;
import org.apache.hive.org.apache.zookeeper.ZKTestCase;
import org.apache.hive.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.apache.hive.org.apache.zookeeper.test.ClientTest;
import org.apache.hive.org.apache.zookeeper.test.QuorumBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ObserverLETest
extends ZKTestCase {
    final QuorumBase qb = new QuorumBase();
    final ClientTest ct = new ClientTest();

    @Before
    public void establishThreeParticipantOneObserverEnsemble() throws Exception {
        this.qb.setUp(true);
        this.ct.hostPort = this.qb.hostPort;
        this.ct.setUpAll();
        this.qb.s5.shutdown();
    }

    @After
    public void shutdownQuorum() throws Exception {
        this.ct.tearDownAll();
        this.qb.tearDown();
    }

    @Test
    public void testLEWithObserver() throws Exception {
        QuorumPeer leader = null;
        for (QuorumPeer server : Arrays.asList(this.qb.s1, this.qb.s2, this.qb.s3)) {
            if (server.getServerState().equals("following")) {
                server.shutdown();
                Assert.assertTrue((String)"Waiting for server down", (boolean)ClientBase.waitForServerDown("127.0.0.1:" + server.getClientPort(), ClientBase.CONNECTION_TIMEOUT));
                continue;
            }
            Assert.assertNull((String)"More than one leader found", leader);
            leader = server;
        }
        Assert.assertTrue((String)"Leader is not in Looking state", (boolean)ClientBase.waitForServerState(leader, ClientBase.CONNECTION_TIMEOUT, "leaderelection"));
    }
}

