/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.zookeeper.test;

import java.io.IOException;
import java.util.List;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.KeeperException;
import org.apache.hive.org.apache.zookeeper.WatchedEvent;
import org.apache.hive.org.apache.zookeeper.Watcher;
import org.apache.hive.org.apache.zookeeper.ZKTestCase;
import org.apache.hive.org.apache.zookeeper.ZooDefs;
import org.apache.hive.org.apache.zookeeper.ZooKeeper;
import org.apache.hive.org.apache.zookeeper.data.Stat;
import org.apache.hive.org.apache.zookeeper.test.ClientBase;
import org.junit.Test;

public class OOMTest
extends ZKTestCase
implements Watcher {
    @Test
    public void testOOM() throws IOException, InterruptedException, KeeperException {
    }

    private void utestExists(int port) throws IOException, InterruptedException, KeeperException {
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + port, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        for (int i = 0; i < 10000; ++i) {
            zk.exists("/this/path/doesnt_exist!", true);
        }
        zk.close();
    }

    private void utestPrep(int port) throws IOException, InterruptedException, KeeperException {
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + port, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        for (int i = 0; i < 10000; ++i) {
            zk.create("/" + i, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        zk.close();
    }

    private void utestGet(int port) throws IOException, InterruptedException, KeeperException {
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + port, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        for (int i = 0; i < 10000; ++i) {
            Stat stat = new Stat();
            zk.getData("/" + i, true, stat);
        }
        zk.close();
    }

    private void utestChildren(int port) throws IOException, InterruptedException, KeeperException {
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + port, ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        for (int i = 0; i < 10000; ++i) {
            zk.getChildren("/" + i, true);
        }
        zk.close();
    }

    public void process(WatchedEvent event) {
        System.err.println("Got event " + event.getType() + " " + event.getState() + " " + event.getPath());
    }
}

